# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model
from msrest.exceptions import HttpOperationError


class AzureFileVolume(Model):
    """The properties of the Azure File volume. Azure File shares are mounted as
    volumes.

    All required parameters must be populated in order to send to Azure.

    :param share_name: Required. The name of the Azure File share to be
     mounted as a volume.
    :type share_name: str
    :param read_only: The flag indicating whether the Azure File shared
     mounted as a volume is read-only.
    :type read_only: bool
    :param storage_account_name: Required. The name of the storage account
     that contains the Azure File share.
    :type storage_account_name: str
    :param storage_account_key: The storage account access key used to access
     the Azure File share.
    :type storage_account_key: str
    """

    _validation = {
        'share_name': {'required': True},
        'storage_account_name': {'required': True},
    }

    _attribute_map = {
        'share_name': {'key': 'shareName', 'type': 'str'},
        'read_only': {'key': 'readOnly', 'type': 'bool'},
        'storage_account_name': {'key': 'storageAccountName', 'type': 'str'},
        'storage_account_key': {'key': 'storageAccountKey', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(AzureFileVolume, self).__init__(**kwargs)
        self.share_name = kwargs.get('share_name', None)
        self.read_only = kwargs.get('read_only', None)
        self.storage_account_name = kwargs.get('storage_account_name', None)
        self.storage_account_key = kwargs.get('storage_account_key', None)


class CachedImages(Model):
    """The cached image and OS type.

    All required parameters must be populated in order to send to Azure.

    :param os_type: Required. The OS type of the cached image.
    :type os_type: str
    :param image: Required. The cached image name.
    :type image: str
    """

    _validation = {
        'os_type': {'required': True},
        'image': {'required': True},
    }

    _attribute_map = {
        'os_type': {'key': 'osType', 'type': 'str'},
        'image': {'key': 'image', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(CachedImages, self).__init__(**kwargs)
        self.os_type = kwargs.get('os_type', None)
        self.image = kwargs.get('image', None)


class Capabilities(Model):
    """The regional capabilities.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar resource_type: The resource type that this capability describes.
    :vartype resource_type: str
    :ivar os_type: The OS type that this capability describes.
    :vartype os_type: str
    :ivar location: The resource location.
    :vartype location: str
    :ivar ip_address_type: The ip address type that this capability describes.
    :vartype ip_address_type: str
    :ivar gpu: The GPU sku that this capability describes.
    :vartype gpu: str
    :ivar capabilities: The supported capabilities.
    :vartype capabilities:
     ~azure.mgmt.containerinstance.models.CapabilitiesCapabilities
    """

    _validation = {
        'resource_type': {'readonly': True},
        'os_type': {'readonly': True},
        'location': {'readonly': True},
        'ip_address_type': {'readonly': True},
        'gpu': {'readonly': True},
        'capabilities': {'readonly': True},
    }

    _attribute_map = {
        'resource_type': {'key': 'resourceType', 'type': 'str'},
        'os_type': {'key': 'osType', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'ip_address_type': {'key': 'ipAddressType', 'type': 'str'},
        'gpu': {'key': 'gpu', 'type': 'str'},
        'capabilities': {'key': 'capabilities', 'type': 'CapabilitiesCapabilities'},
    }

    def __init__(self, **kwargs):
        super(Capabilities, self).__init__(**kwargs)
        self.resource_type = None
        self.os_type = None
        self.location = None
        self.ip_address_type = None
        self.gpu = None
        self.capabilities = None


class CapabilitiesCapabilities(Model):
    """The supported capabilities.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar max_memory_in_gb: The maximum allowed memory request in GB.
    :vartype max_memory_in_gb: float
    :ivar max_cpu: The maximum allowed CPU request in cores.
    :vartype max_cpu: float
    :ivar max_gpu_count: The maximum allowed GPU count.
    :vartype max_gpu_count: float
    """

    _validation = {
        'max_memory_in_gb': {'readonly': True},
        'max_cpu': {'readonly': True},
        'max_gpu_count': {'readonly': True},
    }

    _attribute_map = {
        'max_memory_in_gb': {'key': 'maxMemoryInGB', 'type': 'float'},
        'max_cpu': {'key': 'maxCpu', 'type': 'float'},
        'max_gpu_count': {'key': 'maxGpuCount', 'type': 'float'},
    }

    def __init__(self, **kwargs):
        super(CapabilitiesCapabilities, self).__init__(**kwargs)
        self.max_memory_in_gb = None
        self.max_cpu = None
        self.max_gpu_count = None


class CloudError(Model):
    """An error response from the Container Instance service.

    :param error:
    :type error: ~azure.mgmt.containerinstance.models.CloudErrorBody
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'CloudErrorBody'},
    }

    def __init__(self, **kwargs):
        super(CloudError, self).__init__(**kwargs)
        self.error = kwargs.get('error', None)


class CloudErrorException(HttpOperationError):
    """Server responsed with exception of type: 'CloudError'.

    :param deserialize: A deserializer
    :param response: Server response to be deserialized.
    """

    def __init__(self, deserialize, response, *args):

        super(CloudErrorException, self).__init__(deserialize, response, 'CloudError', *args)


class CloudErrorBody(Model):
    """An error response from the Container Instance service.

    :param code: An identifier for the error. Codes are invariant and are
     intended to be consumed programmatically.
    :type code: str
    :param message: A message describing the error, intended to be suitable
     for display in a user interface.
    :type message: str
    :param target: The target of the particular error. For example, the name
     of the property in error.
    :type target: str
    :param details: A list of additional details about the error.
    :type details: list[~azure.mgmt.containerinstance.models.CloudErrorBody]
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[CloudErrorBody]'},
    }

    def __init__(self, **kwargs):
        super(CloudErrorBody, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.message = kwargs.get('message', None)
        self.target = kwargs.get('target', None)
        self.details = kwargs.get('details', None)


class Container(Model):
    """A container instance.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The user-provided name of the container instance.
    :type name: str
    :param image: Required. The name of the image used to create the container
     instance.
    :type image: str
    :param command: The commands to execute within the container instance in
     exec form.
    :type command: list[str]
    :param ports: The exposed ports on the container instance.
    :type ports: list[~azure.mgmt.containerinstance.models.ContainerPort]
    :param environment_variables: The environment variables to set in the
     container instance.
    :type environment_variables:
     list[~azure.mgmt.containerinstance.models.EnvironmentVariable]
    :ivar instance_view: The instance view of the container instance. Only
     valid in response.
    :vartype instance_view:
     ~azure.mgmt.containerinstance.models.ContainerPropertiesInstanceView
    :param resources: Required. The resource requirements of the container
     instance.
    :type resources: ~azure.mgmt.containerinstance.models.ResourceRequirements
    :param volume_mounts: The volume mounts available to the container
     instance.
    :type volume_mounts:
     list[~azure.mgmt.containerinstance.models.VolumeMount]
    :param liveness_probe: The liveness probe.
    :type liveness_probe: ~azure.mgmt.containerinstance.models.ContainerProbe
    :param readiness_probe: The readiness probe.
    :type readiness_probe: ~azure.mgmt.containerinstance.models.ContainerProbe
    """

    _validation = {
        'name': {'required': True},
        'image': {'required': True},
        'instance_view': {'readonly': True},
        'resources': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'image': {'key': 'properties.image', 'type': 'str'},
        'command': {'key': 'properties.command', 'type': '[str]'},
        'ports': {'key': 'properties.ports', 'type': '[ContainerPort]'},
        'environment_variables': {'key': 'properties.environmentVariables', 'type': '[EnvironmentVariable]'},
        'instance_view': {'key': 'properties.instanceView', 'type': 'ContainerPropertiesInstanceView'},
        'resources': {'key': 'properties.resources', 'type': 'ResourceRequirements'},
        'volume_mounts': {'key': 'properties.volumeMounts', 'type': '[VolumeMount]'},
        'liveness_probe': {'key': 'properties.livenessProbe', 'type': 'ContainerProbe'},
        'readiness_probe': {'key': 'properties.readinessProbe', 'type': 'ContainerProbe'},
    }

    def __init__(self, **kwargs):
        super(Container, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.image = kwargs.get('image', None)
        self.command = kwargs.get('command', None)
        self.ports = kwargs.get('ports', None)
        self.environment_variables = kwargs.get('environment_variables', None)
        self.instance_view = None
        self.resources = kwargs.get('resources', None)
        self.volume_mounts = kwargs.get('volume_mounts', None)
        self.liveness_probe = kwargs.get('liveness_probe', None)
        self.readiness_probe = kwargs.get('readiness_probe', None)


class ContainerAttachResponse(Model):
    """The information for the output stream from container attach.

    :param web_socket_uri: The uri for the output stream from the attach.
    :type web_socket_uri: str
    :param password: The password to the output stream from the attach. Send
     as an Authorization header value when connecting to the websocketUri.
    :type password: str
    """

    _attribute_map = {
        'web_socket_uri': {'key': 'webSocketUri', 'type': 'str'},
        'password': {'key': 'password', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ContainerAttachResponse, self).__init__(**kwargs)
        self.web_socket_uri = kwargs.get('web_socket_uri', None)
        self.password = kwargs.get('password', None)


class ContainerExec(Model):
    """The container execution command, for liveness or readiness probe.

    :param command: The commands to execute within the container.
    :type command: list[str]
    """

    _attribute_map = {
        'command': {'key': 'command', 'type': '[str]'},
    }

    def __init__(self, **kwargs):
        super(ContainerExec, self).__init__(**kwargs)
        self.command = kwargs.get('command', None)


class ContainerExecRequest(Model):
    """The container exec request.

    :param command: The command to be executed.
    :type command: str
    :param terminal_size: The size of the terminal.
    :type terminal_size:
     ~azure.mgmt.containerinstance.models.ContainerExecRequestTerminalSize
    """

    _attribute_map = {
        'command': {'key': 'command', 'type': 'str'},
        'terminal_size': {'key': 'terminalSize', 'type': 'ContainerExecRequestTerminalSize'},
    }

    def __init__(self, **kwargs):
        super(ContainerExecRequest, self).__init__(**kwargs)
        self.command = kwargs.get('command', None)
        self.terminal_size = kwargs.get('terminal_size', None)


class ContainerExecRequestTerminalSize(Model):
    """The size of the terminal.

    :param rows: The row size of the terminal
    :type rows: int
    :param cols: The column size of the terminal
    :type cols: int
    """

    _attribute_map = {
        'rows': {'key': 'rows', 'type': 'int'},
        'cols': {'key': 'cols', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(ContainerExecRequestTerminalSize, self).__init__(**kwargs)
        self.rows = kwargs.get('rows', None)
        self.cols = kwargs.get('cols', None)


class ContainerExecResponse(Model):
    """The information for the container exec command.

    :param web_socket_uri: The uri for the exec websocket.
    :type web_socket_uri: str
    :param password: The password to start the exec command.
    :type password: str
    """

    _attribute_map = {
        'web_socket_uri': {'key': 'webSocketUri', 'type': 'str'},
        'password': {'key': 'password', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ContainerExecResponse, self).__init__(**kwargs)
        self.web_socket_uri = kwargs.get('web_socket_uri', None)
        self.password = kwargs.get('password', None)


class Resource(Model):
    """The Resource model definition.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The resource id.
    :vartype id: str
    :ivar name: The resource name.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    :param location: The resource location.
    :type location: str
    :param tags: The resource tags.
    :type tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(self, **kwargs):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = kwargs.get('location', None)
        self.tags = kwargs.get('tags', None)


class ContainerGroup(Resource):
    """A container group.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource id.
    :vartype id: str
    :ivar name: The resource name.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    :param location: The resource location.
    :type location: str
    :param tags: The resource tags.
    :type tags: dict[str, str]
    :param identity: The identity of the container group, if configured.
    :type identity:
     ~azure.mgmt.containerinstance.models.ContainerGroupIdentity
    :ivar provisioning_state: The provisioning state of the container group.
     This only appears in the response.
    :vartype provisioning_state: str
    :param containers: Required. The containers within the container group.
    :type containers: list[~azure.mgmt.containerinstance.models.Container]
    :param image_registry_credentials: The image registry credentials by which
     the container group is created from.
    :type image_registry_credentials:
     list[~azure.mgmt.containerinstance.models.ImageRegistryCredential]
    :param restart_policy: Restart policy for all containers within the
     container group.
     - `Always` Always restart
     - `OnFailure` Restart on failure
     - `Never` Never restart
     . Possible values include: 'Always', 'OnFailure', 'Never'
    :type restart_policy: str or
     ~azure.mgmt.containerinstance.models.ContainerGroupRestartPolicy
    :param ip_address: The IP address type of the container group.
    :type ip_address: ~azure.mgmt.containerinstance.models.IpAddress
    :param os_type: Required. The operating system type required by the
     containers in the container group. Possible values include: 'Windows',
     'Linux'
    :type os_type: str or
     ~azure.mgmt.containerinstance.models.OperatingSystemTypes
    :param volumes: The list of volumes that can be mounted by containers in
     this container group.
    :type volumes: list[~azure.mgmt.containerinstance.models.Volume]
    :ivar instance_view: The instance view of the container group. Only valid
     in response.
    :vartype instance_view:
     ~azure.mgmt.containerinstance.models.ContainerGroupPropertiesInstanceView
    :param diagnostics: The diagnostic information for a container group.
    :type diagnostics:
     ~azure.mgmt.containerinstance.models.ContainerGroupDiagnostics
    :param network_profile: The network profile information for a container
     group.
    :type network_profile:
     ~azure.mgmt.containerinstance.models.ContainerGroupNetworkProfile
    :param dns_config: The DNS config information for a container group.
    :type dns_config: ~azure.mgmt.containerinstance.models.DnsConfiguration
    :param sku: The SKU for a container group. Possible values include:
     'Standard', 'Dedicated'
    :type sku: str or ~azure.mgmt.containerinstance.models.ContainerGroupSku
    :param encryption_properties: The encryption properties for a container
     group.
    :type encryption_properties:
     ~azure.mgmt.containerinstance.models.EncryptionProperties
    :param init_containers: The init containers for a container group.
    :type init_containers:
     list[~azure.mgmt.containerinstance.models.InitContainerDefinition]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'containers': {'required': True},
        'os_type': {'required': True},
        'instance_view': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'identity': {'key': 'identity', 'type': 'ContainerGroupIdentity'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'containers': {'key': 'properties.containers', 'type': '[Container]'},
        'image_registry_credentials': {'key': 'properties.imageRegistryCredentials', 'type': '[ImageRegistryCredential]'},
        'restart_policy': {'key': 'properties.restartPolicy', 'type': 'str'},
        'ip_address': {'key': 'properties.ipAddress', 'type': 'IpAddress'},
        'os_type': {'key': 'properties.osType', 'type': 'str'},
        'volumes': {'key': 'properties.volumes', 'type': '[Volume]'},
        'instance_view': {'key': 'properties.instanceView', 'type': 'ContainerGroupPropertiesInstanceView'},
        'diagnostics': {'key': 'properties.diagnostics', 'type': 'ContainerGroupDiagnostics'},
        'network_profile': {'key': 'properties.networkProfile', 'type': 'ContainerGroupNetworkProfile'},
        'dns_config': {'key': 'properties.dnsConfig', 'type': 'DnsConfiguration'},
        'sku': {'key': 'properties.sku', 'type': 'str'},
        'encryption_properties': {'key': 'properties.encryptionProperties', 'type': 'EncryptionProperties'},
        'init_containers': {'key': 'properties.initContainers', 'type': '[InitContainerDefinition]'},
    }

    def __init__(self, **kwargs):
        super(ContainerGroup, self).__init__(**kwargs)
        self.identity = kwargs.get('identity', None)
        self.provisioning_state = None
        self.containers = kwargs.get('containers', None)
        self.image_registry_credentials = kwargs.get('image_registry_credentials', None)
        self.restart_policy = kwargs.get('restart_policy', None)
        self.ip_address = kwargs.get('ip_address', None)
        self.os_type = kwargs.get('os_type', None)
        self.volumes = kwargs.get('volumes', None)
        self.instance_view = None
        self.diagnostics = kwargs.get('diagnostics', None)
        self.network_profile = kwargs.get('network_profile', None)
        self.dns_config = kwargs.get('dns_config', None)
        self.sku = kwargs.get('sku', None)
        self.encryption_properties = kwargs.get('encryption_properties', None)
        self.init_containers = kwargs.get('init_containers', None)


class ContainerGroupDiagnostics(Model):
    """Container group diagnostic information.

    :param log_analytics: Container group log analytics information.
    :type log_analytics: ~azure.mgmt.containerinstance.models.LogAnalytics
    """

    _attribute_map = {
        'log_analytics': {'key': 'logAnalytics', 'type': 'LogAnalytics'},
    }

    def __init__(self, **kwargs):
        super(ContainerGroupDiagnostics, self).__init__(**kwargs)
        self.log_analytics = kwargs.get('log_analytics', None)


class ContainerGroupIdentity(Model):
    """Identity for the container group.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar principal_id: The principal id of the container group identity. This
     property will only be provided for a system assigned identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant id associated with the container group. This
     property will only be provided for a system assigned identity.
    :vartype tenant_id: str
    :param type: The type of identity used for the container group. The type
     'SystemAssigned, UserAssigned' includes both an implicitly created
     identity and a set of user assigned identities. The type 'None' will
     remove any identities from the container group. Possible values include:
     'SystemAssigned', 'UserAssigned', 'SystemAssigned, UserAssigned', 'None'
    :type type: str or
     ~azure.mgmt.containerinstance.models.ResourceIdentityType
    :param user_assigned_identities: The list of user identities associated
     with the container group. The user identity dictionary key references will
     be ARM resource ids in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
    :type user_assigned_identities: dict[str,
     ~azure.mgmt.containerinstance.models.ContainerGroupIdentityUserAssignedIdentitiesValue]
    """

    _validation = {
        'principal_id': {'readonly': True},
        'tenant_id': {'readonly': True},
    }

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'type': {'key': 'type', 'type': 'ResourceIdentityType'},
        'user_assigned_identities': {'key': 'userAssignedIdentities', 'type': '{ContainerGroupIdentityUserAssignedIdentitiesValue}'},
    }

    def __init__(self, **kwargs):
        super(ContainerGroupIdentity, self).__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None
        self.type = kwargs.get('type', None)
        self.user_assigned_identities = kwargs.get('user_assigned_identities', None)


class ContainerGroupIdentityUserAssignedIdentitiesValue(Model):
    """ContainerGroupIdentityUserAssignedIdentitiesValue.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar principal_id: The principal id of user assigned identity.
    :vartype principal_id: str
    :ivar client_id: The client id of user assigned identity.
    :vartype client_id: str
    """

    _validation = {
        'principal_id': {'readonly': True},
        'client_id': {'readonly': True},
    }

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'client_id': {'key': 'clientId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ContainerGroupIdentityUserAssignedIdentitiesValue, self).__init__(**kwargs)
        self.principal_id = None
        self.client_id = None


class ContainerGroupNetworkProfile(Model):
    """Container group network profile information.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. The identifier for a network profile.
    :type id: str
    """

    _validation = {
        'id': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ContainerGroupNetworkProfile, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)


class ContainerGroupPropertiesInstanceView(Model):
    """The instance view of the container group. Only valid in response.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar events: The events of this container group.
    :vartype events: list[~azure.mgmt.containerinstance.models.Event]
    :ivar state: The state of the container group. Only valid in response.
    :vartype state: str
    """

    _validation = {
        'events': {'readonly': True},
        'state': {'readonly': True},
    }

    _attribute_map = {
        'events': {'key': 'events', 'type': '[Event]'},
        'state': {'key': 'state', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ContainerGroupPropertiesInstanceView, self).__init__(**kwargs)
        self.events = None
        self.state = None


class ContainerHttpGet(Model):
    """The container Http Get settings, for liveness or readiness probe.

    All required parameters must be populated in order to send to Azure.

    :param path: The path to probe.
    :type path: str
    :param port: Required. The port number to probe.
    :type port: int
    :param scheme: The scheme. Possible values include: 'http', 'https'
    :type scheme: str or ~azure.mgmt.containerinstance.models.Scheme
    :param http_headers: The HTTP headers.
    :type http_headers: ~azure.mgmt.containerinstance.models.HttpHeaders
    """

    _validation = {
        'port': {'required': True},
    }

    _attribute_map = {
        'path': {'key': 'path', 'type': 'str'},
        'port': {'key': 'port', 'type': 'int'},
        'scheme': {'key': 'scheme', 'type': 'str'},
        'http_headers': {'key': 'httpHeaders', 'type': 'HttpHeaders'},
    }

    def __init__(self, **kwargs):
        super(ContainerHttpGet, self).__init__(**kwargs)
        self.path = kwargs.get('path', None)
        self.port = kwargs.get('port', None)
        self.scheme = kwargs.get('scheme', None)
        self.http_headers = kwargs.get('http_headers', None)


class ContainerPort(Model):
    """The port exposed on the container instance.

    All required parameters must be populated in order to send to Azure.

    :param protocol: The protocol associated with the port. Possible values
     include: 'TCP', 'UDP'
    :type protocol: str or
     ~azure.mgmt.containerinstance.models.ContainerNetworkProtocol
    :param port: Required. The port number exposed within the container group.
    :type port: int
    """

    _validation = {
        'port': {'required': True},
    }

    _attribute_map = {
        'protocol': {'key': 'protocol', 'type': 'str'},
        'port': {'key': 'port', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(ContainerPort, self).__init__(**kwargs)
        self.protocol = kwargs.get('protocol', None)
        self.port = kwargs.get('port', None)


class ContainerProbe(Model):
    """The container probe, for liveness or readiness.

    :param exec_property: The execution command to probe
    :type exec_property: ~azure.mgmt.containerinstance.models.ContainerExec
    :param http_get: The Http Get settings to probe
    :type http_get: ~azure.mgmt.containerinstance.models.ContainerHttpGet
    :param initial_delay_seconds: The initial delay seconds.
    :type initial_delay_seconds: int
    :param period_seconds: The period seconds.
    :type period_seconds: int
    :param failure_threshold: The failure threshold.
    :type failure_threshold: int
    :param success_threshold: The success threshold.
    :type success_threshold: int
    :param timeout_seconds: The timeout seconds.
    :type timeout_seconds: int
    """

    _attribute_map = {
        'exec_property': {'key': 'exec', 'type': 'ContainerExec'},
        'http_get': {'key': 'httpGet', 'type': 'ContainerHttpGet'},
        'initial_delay_seconds': {'key': 'initialDelaySeconds', 'type': 'int'},
        'period_seconds': {'key': 'periodSeconds', 'type': 'int'},
        'failure_threshold': {'key': 'failureThreshold', 'type': 'int'},
        'success_threshold': {'key': 'successThreshold', 'type': 'int'},
        'timeout_seconds': {'key': 'timeoutSeconds', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(ContainerProbe, self).__init__(**kwargs)
        self.exec_property = kwargs.get('exec_property', None)
        self.http_get = kwargs.get('http_get', None)
        self.initial_delay_seconds = kwargs.get('initial_delay_seconds', None)
        self.period_seconds = kwargs.get('period_seconds', None)
        self.failure_threshold = kwargs.get('failure_threshold', None)
        self.success_threshold = kwargs.get('success_threshold', None)
        self.timeout_seconds = kwargs.get('timeout_seconds', None)


class ContainerPropertiesInstanceView(Model):
    """The instance view of the container instance. Only valid in response.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar restart_count: The number of times that the container instance has
     been restarted.
    :vartype restart_count: int
    :ivar current_state: Current container instance state.
    :vartype current_state:
     ~azure.mgmt.containerinstance.models.ContainerState
    :ivar previous_state: Previous container instance state.
    :vartype previous_state:
     ~azure.mgmt.containerinstance.models.ContainerState
    :ivar events: The events of the container instance.
    :vartype events: list[~azure.mgmt.containerinstance.models.Event]
    """

    _validation = {
        'restart_count': {'readonly': True},
        'current_state': {'readonly': True},
        'previous_state': {'readonly': True},
        'events': {'readonly': True},
    }

    _attribute_map = {
        'restart_count': {'key': 'restartCount', 'type': 'int'},
        'current_state': {'key': 'currentState', 'type': 'ContainerState'},
        'previous_state': {'key': 'previousState', 'type': 'ContainerState'},
        'events': {'key': 'events', 'type': '[Event]'},
    }

    def __init__(self, **kwargs):
        super(ContainerPropertiesInstanceView, self).__init__(**kwargs)
        self.restart_count = None
        self.current_state = None
        self.previous_state = None
        self.events = None


class ContainerState(Model):
    """The container instance state.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar state: The state of the container instance.
    :vartype state: str
    :ivar start_time: The date-time when the container instance state started.
    :vartype start_time: datetime
    :ivar exit_code: The container instance exit codes correspond to those
     from the `docker run` command.
    :vartype exit_code: int
    :ivar finish_time: The date-time when the container instance state
     finished.
    :vartype finish_time: datetime
    :ivar detail_status: The human-readable status of the container instance
     state.
    :vartype detail_status: str
    """

    _validation = {
        'state': {'readonly': True},
        'start_time': {'readonly': True},
        'exit_code': {'readonly': True},
        'finish_time': {'readonly': True},
        'detail_status': {'readonly': True},
    }

    _attribute_map = {
        'state': {'key': 'state', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'exit_code': {'key': 'exitCode', 'type': 'int'},
        'finish_time': {'key': 'finishTime', 'type': 'iso-8601'},
        'detail_status': {'key': 'detailStatus', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ContainerState, self).__init__(**kwargs)
        self.state = None
        self.start_time = None
        self.exit_code = None
        self.finish_time = None
        self.detail_status = None


class DnsConfiguration(Model):
    """DNS configuration for the container group.

    All required parameters must be populated in order to send to Azure.

    :param name_servers: Required. The DNS servers for the container group.
    :type name_servers: list[str]
    :param search_domains: The DNS search domains for hostname lookup in the
     container group.
    :type search_domains: str
    :param options: The DNS options for the container group.
    :type options: str
    """

    _validation = {
        'name_servers': {'required': True},
    }

    _attribute_map = {
        'name_servers': {'key': 'nameServers', 'type': '[str]'},
        'search_domains': {'key': 'searchDomains', 'type': 'str'},
        'options': {'key': 'options', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(DnsConfiguration, self).__init__(**kwargs)
        self.name_servers = kwargs.get('name_servers', None)
        self.search_domains = kwargs.get('search_domains', None)
        self.options = kwargs.get('options', None)


class EncryptionProperties(Model):
    """The container group encryption properties.

    All required parameters must be populated in order to send to Azure.

    :param vault_base_url: Required. The keyvault base url.
    :type vault_base_url: str
    :param key_name: Required. The encryption key name.
    :type key_name: str
    :param key_version: Required. The encryption key version.
    :type key_version: str
    """

    _validation = {
        'vault_base_url': {'required': True},
        'key_name': {'required': True},
        'key_version': {'required': True},
    }

    _attribute_map = {
        'vault_base_url': {'key': 'vaultBaseUrl', 'type': 'str'},
        'key_name': {'key': 'keyName', 'type': 'str'},
        'key_version': {'key': 'keyVersion', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(EncryptionProperties, self).__init__(**kwargs)
        self.vault_base_url = kwargs.get('vault_base_url', None)
        self.key_name = kwargs.get('key_name', None)
        self.key_version = kwargs.get('key_version', None)


class EnvironmentVariable(Model):
    """The environment variable to set within the container instance.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the environment variable.
    :type name: str
    :param value: The value of the environment variable.
    :type value: str
    :param secure_value: The value of the secure environment variable.
    :type secure_value: str
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
        'secure_value': {'key': 'secureValue', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(EnvironmentVariable, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.value = kwargs.get('value', None)
        self.secure_value = kwargs.get('secure_value', None)


class Event(Model):
    """A container group or container instance event.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar count: The count of the event.
    :vartype count: int
    :ivar first_timestamp: The date-time of the earliest logged event.
    :vartype first_timestamp: datetime
    :ivar last_timestamp: The date-time of the latest logged event.
    :vartype last_timestamp: datetime
    :ivar name: The event name.
    :vartype name: str
    :ivar message: The event message.
    :vartype message: str
    :ivar type: The event type.
    :vartype type: str
    """

    _validation = {
        'count': {'readonly': True},
        'first_timestamp': {'readonly': True},
        'last_timestamp': {'readonly': True},
        'name': {'readonly': True},
        'message': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'count': {'key': 'count', 'type': 'int'},
        'first_timestamp': {'key': 'firstTimestamp', 'type': 'iso-8601'},
        'last_timestamp': {'key': 'lastTimestamp', 'type': 'iso-8601'},
        'name': {'key': 'name', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(Event, self).__init__(**kwargs)
        self.count = None
        self.first_timestamp = None
        self.last_timestamp = None
        self.name = None
        self.message = None
        self.type = None


class GitRepoVolume(Model):
    """Represents a volume that is populated with the contents of a git
    repository.

    All required parameters must be populated in order to send to Azure.

    :param directory: Target directory name. Must not contain or start with
     '..'.  If '.' is supplied, the volume directory will be the git
     repository.  Otherwise, if specified, the volume will contain the git
     repository in the subdirectory with the given name.
    :type directory: str
    :param repository: Required. Repository URL
    :type repository: str
    :param revision: Commit hash for the specified revision.
    :type revision: str
    """

    _validation = {
        'repository': {'required': True},
    }

    _attribute_map = {
        'directory': {'key': 'directory', 'type': 'str'},
        'repository': {'key': 'repository', 'type': 'str'},
        'revision': {'key': 'revision', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(GitRepoVolume, self).__init__(**kwargs)
        self.directory = kwargs.get('directory', None)
        self.repository = kwargs.get('repository', None)
        self.revision = kwargs.get('revision', None)


class GpuResource(Model):
    """The GPU resource.

    All required parameters must be populated in order to send to Azure.

    :param count: Required. The count of the GPU resource.
    :type count: int
    :param sku: Required. The SKU of the GPU resource. Possible values
     include: 'K80', 'P100', 'V100'
    :type sku: str or ~azure.mgmt.containerinstance.models.GpuSku
    """

    _validation = {
        'count': {'required': True},
        'sku': {'required': True},
    }

    _attribute_map = {
        'count': {'key': 'count', 'type': 'int'},
        'sku': {'key': 'sku', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(GpuResource, self).__init__(**kwargs)
        self.count = kwargs.get('count', None)
        self.sku = kwargs.get('sku', None)


class HttpHeaders(Model):
    """The HTTP headers.

    :param name: The header name.
    :type name: str
    :param value: The header value.
    :type value: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(HttpHeaders, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.value = kwargs.get('value', None)


class ImageRegistryCredential(Model):
    """Image registry credential.

    All required parameters must be populated in order to send to Azure.

    :param server: Required. The Docker image registry server without a
     protocol such as "http" and "https".
    :type server: str
    :param username: Required. The username for the private registry.
    :type username: str
    :param password: The password for the private registry.
    :type password: str
    """

    _validation = {
        'server': {'required': True},
        'username': {'required': True},
    }

    _attribute_map = {
        'server': {'key': 'server', 'type': 'str'},
        'username': {'key': 'username', 'type': 'str'},
        'password': {'key': 'password', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ImageRegistryCredential, self).__init__(**kwargs)
        self.server = kwargs.get('server', None)
        self.username = kwargs.get('username', None)
        self.password = kwargs.get('password', None)


class InitContainerDefinition(Model):
    """The init container definition.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name for the init container.
    :type name: str
    :param image: The image of the init container.
    :type image: str
    :param command: The command to execute within the init container in exec
     form.
    :type command: list[str]
    :param environment_variables: The environment variables to set in the init
     container.
    :type environment_variables:
     list[~azure.mgmt.containerinstance.models.EnvironmentVariable]
    :ivar instance_view: The instance view of the init container. Only valid
     in response.
    :vartype instance_view:
     ~azure.mgmt.containerinstance.models.InitContainerPropertiesDefinitionInstanceView
    :param volume_mounts: The volume mounts available to the init container.
    :type volume_mounts:
     list[~azure.mgmt.containerinstance.models.VolumeMount]
    """

    _validation = {
        'name': {'required': True},
        'instance_view': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'image': {'key': 'properties.image', 'type': 'str'},
        'command': {'key': 'properties.command', 'type': '[str]'},
        'environment_variables': {'key': 'properties.environmentVariables', 'type': '[EnvironmentVariable]'},
        'instance_view': {'key': 'properties.instanceView', 'type': 'InitContainerPropertiesDefinitionInstanceView'},
        'volume_mounts': {'key': 'properties.volumeMounts', 'type': '[VolumeMount]'},
    }

    def __init__(self, **kwargs):
        super(InitContainerDefinition, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.image = kwargs.get('image', None)
        self.command = kwargs.get('command', None)
        self.environment_variables = kwargs.get('environment_variables', None)
        self.instance_view = None
        self.volume_mounts = kwargs.get('volume_mounts', None)


class InitContainerPropertiesDefinitionInstanceView(Model):
    """The instance view of the init container. Only valid in response.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar restart_count: The number of times that the init container has been
     restarted.
    :vartype restart_count: int
    :ivar current_state: The current state of the init container.
    :vartype current_state:
     ~azure.mgmt.containerinstance.models.ContainerState
    :ivar previous_state: The previous state of the init container.
    :vartype previous_state:
     ~azure.mgmt.containerinstance.models.ContainerState
    :ivar events: The events of the init container.
    :vartype events: list[~azure.mgmt.containerinstance.models.Event]
    """

    _validation = {
        'restart_count': {'readonly': True},
        'current_state': {'readonly': True},
        'previous_state': {'readonly': True},
        'events': {'readonly': True},
    }

    _attribute_map = {
        'restart_count': {'key': 'restartCount', 'type': 'int'},
        'current_state': {'key': 'currentState', 'type': 'ContainerState'},
        'previous_state': {'key': 'previousState', 'type': 'ContainerState'},
        'events': {'key': 'events', 'type': '[Event]'},
    }

    def __init__(self, **kwargs):
        super(InitContainerPropertiesDefinitionInstanceView, self).__init__(**kwargs)
        self.restart_count = None
        self.current_state = None
        self.previous_state = None
        self.events = None


class IpAddress(Model):
    """IP address for the container group.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param ports: Required. The list of ports exposed on the container group.
    :type ports: list[~azure.mgmt.containerinstance.models.Port]
    :param type: Required. Specifies if the IP is exposed to the public
     internet or private VNET. Possible values include: 'Public', 'Private'
    :type type: str or
     ~azure.mgmt.containerinstance.models.ContainerGroupIpAddressType
    :param ip: The IP exposed to the public internet.
    :type ip: str
    :param dns_name_label: The Dns name label for the IP.
    :type dns_name_label: str
    :ivar fqdn: The FQDN for the IP.
    :vartype fqdn: str
    """

    _validation = {
        'ports': {'required': True},
        'type': {'required': True},
        'fqdn': {'readonly': True},
    }

    _attribute_map = {
        'ports': {'key': 'ports', 'type': '[Port]'},
        'type': {'key': 'type', 'type': 'str'},
        'ip': {'key': 'ip', 'type': 'str'},
        'dns_name_label': {'key': 'dnsNameLabel', 'type': 'str'},
        'fqdn': {'key': 'fqdn', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(IpAddress, self).__init__(**kwargs)
        self.ports = kwargs.get('ports', None)
        self.type = kwargs.get('type', None)
        self.ip = kwargs.get('ip', None)
        self.dns_name_label = kwargs.get('dns_name_label', None)
        self.fqdn = None


class LogAnalytics(Model):
    """Container group log analytics information.

    All required parameters must be populated in order to send to Azure.

    :param workspace_id: Required. The workspace id for log analytics
    :type workspace_id: str
    :param workspace_key: Required. The workspace key for log analytics
    :type workspace_key: str
    :param log_type: The log type to be used. Possible values include:
     'ContainerInsights', 'ContainerInstanceLogs'
    :type log_type: str or
     ~azure.mgmt.containerinstance.models.LogAnalyticsLogType
    :param metadata: Metadata for log analytics.
    :type metadata: dict[str, str]
    :param workspace_resource_id: The workspace resource id for log analytics
    :type workspace_resource_id: dict[str, str]
    """

    _validation = {
        'workspace_id': {'required': True},
        'workspace_key': {'required': True},
    }

    _attribute_map = {
        'workspace_id': {'key': 'workspaceId', 'type': 'str'},
        'workspace_key': {'key': 'workspaceKey', 'type': 'str'},
        'log_type': {'key': 'logType', 'type': 'str'},
        'metadata': {'key': 'metadata', 'type': '{str}'},
        'workspace_resource_id': {'key': 'workspaceResourceId', 'type': '{str}'},
    }

    def __init__(self, **kwargs):
        super(LogAnalytics, self).__init__(**kwargs)
        self.workspace_id = kwargs.get('workspace_id', None)
        self.workspace_key = kwargs.get('workspace_key', None)
        self.log_type = kwargs.get('log_type', None)
        self.metadata = kwargs.get('metadata', None)
        self.workspace_resource_id = kwargs.get('workspace_resource_id', None)


class Logs(Model):
    """The logs.

    :param content: The content of the log.
    :type content: str
    """

    _attribute_map = {
        'content': {'key': 'content', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(Logs, self).__init__(**kwargs)
        self.content = kwargs.get('content', None)


class Operation(Model):
    """An operation for Azure Container Instance service.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the operation.
    :type name: str
    :param display: Required. The display information of the operation.
    :type display: ~azure.mgmt.containerinstance.models.OperationDisplay
    :param properties: The additional properties.
    :type properties: object
    :param origin: The intended executor of the operation. Possible values
     include: 'User', 'System'
    :type origin: str or
     ~azure.mgmt.containerinstance.models.ContainerInstanceOperationsOrigin
    """

    _validation = {
        'name': {'required': True},
        'display': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'OperationDisplay'},
        'properties': {'key': 'properties', 'type': 'object'},
        'origin': {'key': 'origin', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(Operation, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.display = kwargs.get('display', None)
        self.properties = kwargs.get('properties', None)
        self.origin = kwargs.get('origin', None)


class OperationDisplay(Model):
    """The display information of the operation.

    :param provider: The name of the provider of the operation.
    :type provider: str
    :param resource: The name of the resource type of the operation.
    :type resource: str
    :param operation: The friendly name of the operation.
    :type operation: str
    :param description: The description of the operation.
    :type description: str
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(OperationDisplay, self).__init__(**kwargs)
        self.provider = kwargs.get('provider', None)
        self.resource = kwargs.get('resource', None)
        self.operation = kwargs.get('operation', None)
        self.description = kwargs.get('description', None)


class Port(Model):
    """The port exposed on the container group.

    All required parameters must be populated in order to send to Azure.

    :param protocol: The protocol associated with the port. Possible values
     include: 'TCP', 'UDP'
    :type protocol: str or
     ~azure.mgmt.containerinstance.models.ContainerGroupNetworkProtocol
    :param port: Required. The port number.
    :type port: int
    """

    _validation = {
        'port': {'required': True},
    }

    _attribute_map = {
        'protocol': {'key': 'protocol', 'type': 'str'},
        'port': {'key': 'port', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(Port, self).__init__(**kwargs)
        self.protocol = kwargs.get('protocol', None)
        self.port = kwargs.get('port', None)


class ResourceLimits(Model):
    """The resource limits.

    :param memory_in_gb: The memory limit in GB of this container instance.
    :type memory_in_gb: float
    :param cpu: The CPU limit of this container instance.
    :type cpu: float
    :param gpu: The GPU limit of this container instance.
    :type gpu: ~azure.mgmt.containerinstance.models.GpuResource
    """

    _attribute_map = {
        'memory_in_gb': {'key': 'memoryInGB', 'type': 'float'},
        'cpu': {'key': 'cpu', 'type': 'float'},
        'gpu': {'key': 'gpu', 'type': 'GpuResource'},
    }

    def __init__(self, **kwargs):
        super(ResourceLimits, self).__init__(**kwargs)
        self.memory_in_gb = kwargs.get('memory_in_gb', None)
        self.cpu = kwargs.get('cpu', None)
        self.gpu = kwargs.get('gpu', None)


class ResourceRequests(Model):
    """The resource requests.

    All required parameters must be populated in order to send to Azure.

    :param memory_in_gb: Required. The memory request in GB of this container
     instance.
    :type memory_in_gb: float
    :param cpu: Required. The CPU request of this container instance.
    :type cpu: float
    :param gpu: The GPU request of this container instance.
    :type gpu: ~azure.mgmt.containerinstance.models.GpuResource
    """

    _validation = {
        'memory_in_gb': {'required': True},
        'cpu': {'required': True},
    }

    _attribute_map = {
        'memory_in_gb': {'key': 'memoryInGB', 'type': 'float'},
        'cpu': {'key': 'cpu', 'type': 'float'},
        'gpu': {'key': 'gpu', 'type': 'GpuResource'},
    }

    def __init__(self, **kwargs):
        super(ResourceRequests, self).__init__(**kwargs)
        self.memory_in_gb = kwargs.get('memory_in_gb', None)
        self.cpu = kwargs.get('cpu', None)
        self.gpu = kwargs.get('gpu', None)


class ResourceRequirements(Model):
    """The resource requirements.

    All required parameters must be populated in order to send to Azure.

    :param requests: Required. The resource requests of this container
     instance.
    :type requests: ~azure.mgmt.containerinstance.models.ResourceRequests
    :param limits: The resource limits of this container instance.
    :type limits: ~azure.mgmt.containerinstance.models.ResourceLimits
    """

    _validation = {
        'requests': {'required': True},
    }

    _attribute_map = {
        'requests': {'key': 'requests', 'type': 'ResourceRequests'},
        'limits': {'key': 'limits', 'type': 'ResourceLimits'},
    }

    def __init__(self, **kwargs):
        super(ResourceRequirements, self).__init__(**kwargs)
        self.requests = kwargs.get('requests', None)
        self.limits = kwargs.get('limits', None)


class Usage(Model):
    """A single usage result.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar unit: Unit of the usage result
    :vartype unit: str
    :ivar current_value: The current usage of the resource
    :vartype current_value: int
    :ivar limit: The maximum permitted usage of the resource.
    :vartype limit: int
    :ivar name: The name object of the resource
    :vartype name: ~azure.mgmt.containerinstance.models.UsageName
    """

    _validation = {
        'unit': {'readonly': True},
        'current_value': {'readonly': True},
        'limit': {'readonly': True},
        'name': {'readonly': True},
    }

    _attribute_map = {
        'unit': {'key': 'unit', 'type': 'str'},
        'current_value': {'key': 'currentValue', 'type': 'int'},
        'limit': {'key': 'limit', 'type': 'int'},
        'name': {'key': 'name', 'type': 'UsageName'},
    }

    def __init__(self, **kwargs):
        super(Usage, self).__init__(**kwargs)
        self.unit = None
        self.current_value = None
        self.limit = None
        self.name = None


class UsageName(Model):
    """The name object of the resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar value: The name of the resource
    :vartype value: str
    :ivar localized_value: The localized name of the resource
    :vartype localized_value: str
    """

    _validation = {
        'value': {'readonly': True},
        'localized_value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
        'localized_value': {'key': 'localizedValue', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(UsageName, self).__init__(**kwargs)
        self.value = None
        self.localized_value = None


class Volume(Model):
    """The properties of the volume.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the volume.
    :type name: str
    :param azure_file: The Azure File volume.
    :type azure_file: ~azure.mgmt.containerinstance.models.AzureFileVolume
    :param empty_dir: The empty directory volume.
    :type empty_dir: object
    :param secret: The secret volume.
    :type secret: dict[str, str]
    :param git_repo: The git repo volume.
    :type git_repo: ~azure.mgmt.containerinstance.models.GitRepoVolume
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'azure_file': {'key': 'azureFile', 'type': 'AzureFileVolume'},
        'empty_dir': {'key': 'emptyDir', 'type': 'object'},
        'secret': {'key': 'secret', 'type': '{str}'},
        'git_repo': {'key': 'gitRepo', 'type': 'GitRepoVolume'},
    }

    def __init__(self, **kwargs):
        super(Volume, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.azure_file = kwargs.get('azure_file', None)
        self.empty_dir = kwargs.get('empty_dir', None)
        self.secret = kwargs.get('secret', None)
        self.git_repo = kwargs.get('git_repo', None)


class VolumeMount(Model):
    """The properties of the volume mount.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the volume mount.
    :type name: str
    :param mount_path: Required. The path within the container where the
     volume should be mounted. Must not contain colon (:).
    :type mount_path: str
    :param read_only: The flag indicating whether the volume mount is
     read-only.
    :type read_only: bool
    """

    _validation = {
        'name': {'required': True},
        'mount_path': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'mount_path': {'key': 'mountPath', 'type': 'str'},
        'read_only': {'key': 'readOnly', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(VolumeMount, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.mount_path = kwargs.get('mount_path', None)
        self.read_only = kwargs.get('read_only', None)
