# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.service_client import SDKClient
from msrest import Serializer, Deserializer

from ._configuration import ContainerInstanceManagementClientConfiguration
from .operations import ContainerGroupsOperations
from .operations import Operations
from .operations import LocationOperations
from .operations import ContainersOperations
from . import models


class ContainerInstanceManagementClient(SDKClient):
    """ContainerInstanceManagementClient

    :ivar config: Configuration for client.
    :vartype config: ContainerInstanceManagementClientConfiguration

    :ivar container_groups: ContainerGroups operations
    :vartype container_groups: azure.mgmt.containerinstance.operations.ContainerGroupsOperations
    :ivar operations: Operations operations
    :vartype operations: azure.mgmt.containerinstance.operations.Operations
    :ivar location: Location operations
    :vartype location: azure.mgmt.containerinstance.operations.LocationOperations
    :ivar containers: Containers operations
    :vartype containers: azure.mgmt.containerinstance.operations.ContainersOperations

    :param credentials: Credentials needed for the client to connect to Azure.
    :type credentials: :mod:`A msrestazure Credentials
     object<msrestazure.azure_active_directory>`
    :param subscription_id: Subscription credentials which uniquely identify
     Microsoft Azure subscription. The subscription ID forms part of the URI
     for every service call.
    :type subscription_id: str
    :param str base_url: Service URL
    """

    def __init__(
            self, credentials, subscription_id, base_url=None):

        self.config = ContainerInstanceManagementClientConfiguration(credentials, subscription_id, base_url)
        super(ContainerInstanceManagementClient, self).__init__(self.config.credentials, self.config)

        client_models = {k: v for k, v in models.__dict__.items() if isinstance(v, type)}
        self.api_version = '2021-03-01'
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)

        self.container_groups = ContainerGroupsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.operations = Operations(
            self._client, self.config, self._serialize, self._deserialize)
        self.location = LocationOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.containers = ContainersOperations(
            self._client, self.config, self._serialize, self._deserialize)
