{ config, lib, pkgs, modulesPath, ... }:

with lib;

{
  options = {

    netboot.storeContents = mkOption {
      example = literalExample "[ pkgs.stdenv ]";
      description = ''
        This option lists additional derivations to be included in the
        Nix store in the generated netboot image.
      '';
    };

  };

  config = {
    # Don't build the GRUB menu builder script, since we don't need it
    # here and it causes a cyclic dependency.
    boot.loader.grub.enable = lib.mkDefault false;

    # fileSystems."/" = {
    #   fsType = "tmpfs";
    #   options = [ "mode=0755" ];
    # };

    # # In stage 1, mount a tmpfs on top of /nix/store (the squashfs
    # # image) to make this a live CD.
    # fileSystems."/nix/.ro-store" = {
    #   fsType = "squashfs";
    #   device = "../nix-store.squashfs";
    #   options = [ "loop" ];
    #   neededForBoot = true;
    # };

    fileSystems."/nix/.rw-store" = {
      fsType = "tmpfs";
      options = [ "mode=0755" ];
      neededForBoot = true;
    };

    fileSystems."/nix/store" = {
      fsType = "overlay";
      device = "overlay";
      options = [
        "lowerdir=/nix/.ro-store"
        "upperdir=/nix/.rw-store/store"
        "workdir=/nix/.rw-store/work"
      ];
    };

    boot.initrd.availableKernelModules = [ "squashfs" "overlay" "igb" "ixgbe" ];
    boot.initrd.kernelModules = [ "loop" "overlay" ];

    # Closures to be copied to the Nix store, namely the init
    # script and the top-level system configuration directory.
    netboot.storeContents = [ config.system.build.toplevel ];

    # Create the squashfs image that contains the Nix store.
    system.build.squashfsStore =
      pkgs.callPackage "${toString modulesPath}/../lib/make-squashfs.nix" {
        comp = "gzip -Xcompression-level 1";
        storeContents = config.netboot.storeContents;
      };

    # Create the initrd
    system.build.netbootRamdisk = pkgs.makeInitrd {
      inherit (config.boot.initrd) compressor;
      prepend = [ "${config.system.build.initialRamdisk}/initrd" ];

      contents = [{
        object = config.system.build.squashfsStore;
        symlink = "/nix-store.squashfs";
      }];
    };
  };
}
