import aerospike
from typing import Union
from aio_aerospike_python.exception import *
from aio_aerospike_python.aio_aerospike_client import AioAerospikeClient
from aio_aerospike_python.aio_aerospike_query import AioAerospikeQuery
from aio_aerospike_python.aio_aerospike_scan import AioAerospikeScan


def set_log_level(level:int):
    return aerospike.set_log_level(level)

def set_log_level(callback):
    return aerospike.set_log_handler(callback)

def calc_digest(ns:str, set:str, key:Union[str,int,bytearray]) -> bytearray:
    return aerospike.calc_digest(ns, set, key)



# Constants 
OPERATOR_READ = aerospike.OPERATOR_READ
OPERATOR_WRITE = aerospike.OPERATOR_WRITE
OPERATOR_INCR = aerospike.OPERATOR_INCR
OPERATOR_APPEND = aerospike.OPERATOR_APPEND
OPERATOR_PREPEND = aerospike.OPERATOR_PREPEND
OPERATOR_TOUCH = aerospike.OPERATOR_TOUCH
OPERATOR_DELETE = aerospike.OPERATOR_DELETE
AUTH_INTERNAL = aerospike.AUTH_INTERNAL
AUTH_EXTERNAL = aerospike.AUTH_EXTERNAL
AUTH_EXTERNAL_INSECURE = aerospike.AUTH_EXTERNAL_INSECURE
AUTH_PKI = aerospike.AUTH_PKI
POLICY_RETRY_NONE = aerospike.POLICY_RETRY_NONE
POLICY_RETRY_ONCE = aerospike.POLICY_RETRY_ONCE
POLICY_EXISTS_IGNORE = aerospike.POLICY_EXISTS_IGNORE
POLICY_EXISTS_CREATE = aerospike.POLICY_EXISTS_CREATE
POLICY_EXISTS_UPDATE = aerospike.POLICY_EXISTS_UPDATE
POLICY_EXISTS_REPLACE = aerospike.POLICY_EXISTS_REPLACE
POLICY_EXISTS_CREATE_OR_REPLACE = aerospike.POLICY_EXISTS_CREATE_OR_REPLACE
UDF_TYPE_LUA = aerospike.UDF_TYPE_LUA
POLICY_KEY_DIGEST = aerospike.POLICY_KEY_DIGEST
POLICY_KEY_SEND = aerospike.POLICY_KEY_SEND
POLICY_GEN_IGNORE = aerospike.POLICY_GEN_IGNORE
POLICY_GEN_EQ = aerospike.POLICY_GEN_EQ
POLICY_GEN_GT = aerospike.POLICY_GEN_GT
SCAN_STATUS_COMPLETED = aerospike.SCAN_STATUS_COMPLETED
SCAN_STATUS_ABORTED = aerospike.SCAN_STATUS_ABORTED
SCAN_STATUS_UNDEF = aerospike.SCAN_STATUS_UNDEF
SCAN_STATUS_INPROGRESS = aerospike.SCAN_STATUS_INPROGRESS
JOB_STATUS_COMPLETED = aerospike.JOB_STATUS_COMPLETED
JOB_STATUS_UNDEF = aerospike.JOB_STATUS_UNDEF
JOB_STATUS_INPROGRESS = aerospike.JOB_STATUS_INPROGRESS
POLICY_REPLICA_MASTER = aerospike.POLICY_REPLICA_MASTER
POLICY_REPLICA_ANY = aerospike.POLICY_REPLICA_ANY
POLICY_REPLICA_SEQUENCE = aerospike.POLICY_REPLICA_SEQUENCE
POLICY_REPLICA_PREFER_RACK = aerospike.POLICY_REPLICA_PREFER_RACK
POLICY_COMMIT_LEVEL_ALL = aerospike.POLICY_COMMIT_LEVEL_ALL
POLICY_COMMIT_LEVEL_MASTER = aerospike.POLICY_COMMIT_LEVEL_MASTER
SERIALIZER_PYTHON = aerospike.SERIALIZER_PYTHON
SERIALIZER_USER = aerospike.SERIALIZER_USER
SERIALIZER_JSON = aerospike.SERIALIZER_JSON
SERIALIZER_NONE = aerospike.SERIALIZER_NONE
PY_BYTES = aerospike.PY_BYTES
INTEGER = aerospike.INTEGER
AS_BOOL = aerospike.AS_BOOL
INDEX_STRING = aerospike.INDEX_STRING
INDEX_NUMERIC = aerospike.INDEX_NUMERIC
INDEX_GEO2DSPHERE = aerospike.INDEX_GEO2DSPHERE
INDEX_TYPE_DEFAULT = aerospike.INDEX_TYPE_DEFAULT
INDEX_TYPE_LIST = aerospike.INDEX_TYPE_LIST
INDEX_TYPE_MAPKEYS = aerospike.INDEX_TYPE_MAPKEYS
INDEX_TYPE_MAPVALUES = aerospike.INDEX_TYPE_MAPVALUES
PRIV_USER_ADMIN = aerospike.PRIV_USER_ADMIN
PRIV_SYS_ADMIN = aerospike.PRIV_SYS_ADMIN
PRIV_DATA_ADMIN = aerospike.PRIV_DATA_ADMIN
PRIV_READ = aerospike.PRIV_READ
PRIV_WRITE = aerospike.PRIV_WRITE
PRIV_READ_WRITE = aerospike.PRIV_READ_WRITE
PRIV_READ_WRITE_UDF = aerospike.PRIV_READ_WRITE_UDF
PRIV_TRUNCATE = aerospike.PRIV_TRUNCATE
PRIV_UDF_ADMIN = aerospike.PRIV_UDF_ADMIN
PRIV_SINDEX_ADMIN = aerospike.PRIV_SINDEX_ADMIN
OP_LIST_APPEND = aerospike.OP_LIST_APPEND
OP_LIST_APPEND_ITEMS = aerospike.OP_LIST_APPEND_ITEMS
OP_LIST_INSERT = aerospike.OP_LIST_INSERT
OP_LIST_INSERT_ITEMS = aerospike.OP_LIST_INSERT_ITEMS
OP_LIST_POP = aerospike.OP_LIST_POP
OP_LIST_POP_RANGE = aerospike.OP_LIST_POP_RANGE
OP_LIST_REMOVE = aerospike.OP_LIST_REMOVE
OP_LIST_REMOVE_RANGE = aerospike.OP_LIST_REMOVE_RANGE
OP_LIST_CLEAR = aerospike.OP_LIST_CLEAR
OP_LIST_SET = aerospike.OP_LIST_SET
OP_LIST_GET = aerospike.OP_LIST_GET
OP_LIST_GET_RANGE = aerospike.OP_LIST_GET_RANGE
OP_LIST_TRIM = aerospike.OP_LIST_TRIM
OP_LIST_SIZE = aerospike.OP_LIST_SIZE
OP_LIST_INCREMENT = aerospike.OP_LIST_INCREMENT
OP_MAP_SET_POLICY = aerospike.OP_MAP_SET_POLICY
OP_MAP_PUT = aerospike.OP_MAP_PUT
OP_MAP_PUT_ITEMS = aerospike.OP_MAP_PUT_ITEMS
OP_MAP_INCREMENT = aerospike.OP_MAP_INCREMENT
OP_MAP_DECREMENT = aerospike.OP_MAP_DECREMENT
OP_MAP_SIZE = aerospike.OP_MAP_SIZE
OP_MAP_CLEAR = aerospike.OP_MAP_CLEAR
OP_MAP_REMOVE_BY_KEY = aerospike.OP_MAP_REMOVE_BY_KEY
OP_MAP_REMOVE_BY_KEY_LIST = aerospike.OP_MAP_REMOVE_BY_KEY_LIST
OP_MAP_REMOVE_BY_KEY_RANGE = aerospike.OP_MAP_REMOVE_BY_KEY_RANGE
OP_MAP_REMOVE_BY_VALUE = aerospike.OP_MAP_REMOVE_BY_VALUE
OP_MAP_REMOVE_BY_VALUE_LIST = aerospike.OP_MAP_REMOVE_BY_VALUE_LIST
OP_MAP_REMOVE_BY_VALUE_RANGE = aerospike.OP_MAP_REMOVE_BY_VALUE_RANGE
OP_MAP_REMOVE_BY_INDEX = aerospike.OP_MAP_REMOVE_BY_INDEX
OP_MAP_REMOVE_BY_INDEX_RANGE = aerospike.OP_MAP_REMOVE_BY_INDEX_RANGE
OP_MAP_REMOVE_BY_RANK = aerospike.OP_MAP_REMOVE_BY_RANK
OP_MAP_REMOVE_BY_RANK_RANGE = aerospike.OP_MAP_REMOVE_BY_RANK_RANGE
OP_MAP_GET_BY_KEY = aerospike.OP_MAP_GET_BY_KEY
OP_MAP_GET_BY_KEY_RANGE = aerospike.OP_MAP_GET_BY_KEY_RANGE
OP_MAP_GET_BY_VALUE = aerospike.OP_MAP_GET_BY_VALUE
OP_MAP_GET_BY_VALUE_RANGE = aerospike.OP_MAP_GET_BY_VALUE_RANGE
OP_MAP_GET_BY_INDEX = aerospike.OP_MAP_GET_BY_INDEX
OP_MAP_GET_BY_INDEX_RANGE = aerospike.OP_MAP_GET_BY_INDEX_RANGE
OP_MAP_GET_BY_RANK = aerospike.OP_MAP_GET_BY_RANK
OP_MAP_GET_BY_RANK_RANGE = aerospike.OP_MAP_GET_BY_RANK_RANGE
OP_MAP_GET_BY_VALUE_LIST = aerospike.OP_MAP_GET_BY_VALUE_LIST
OP_MAP_GET_BY_KEY_LIST = aerospike.OP_MAP_GET_BY_KEY_LIST
MAP_UNORDERED = aerospike.MAP_UNORDERED
MAP_KEY_ORDERED = aerospike.MAP_KEY_ORDERED
MAP_KEY_VALUE_ORDERED = aerospike.MAP_KEY_VALUE_ORDERED
MAP_UPDATE = aerospike.MAP_UPDATE
MAP_UPDATE_ONLY = aerospike.MAP_UPDATE_ONLY
MAP_CREATE_ONLY = aerospike.MAP_CREATE_ONLY
MAP_RETURN_NONE = aerospike.MAP_RETURN_NONE
MAP_RETURN_INDEX = aerospike.MAP_RETURN_INDEX
MAP_RETURN_REVERSE_INDEX = aerospike.MAP_RETURN_REVERSE_INDEX
MAP_RETURN_RANK = aerospike.MAP_RETURN_RANK
MAP_RETURN_REVERSE_RANK = aerospike.MAP_RETURN_REVERSE_RANK
MAP_RETURN_COUNT = aerospike.MAP_RETURN_COUNT
MAP_RETURN_KEY = aerospike.MAP_RETURN_KEY
MAP_RETURN_VALUE = aerospike.MAP_RETURN_VALUE
MAP_RETURN_KEY_VALUE = aerospike.MAP_RETURN_KEY_VALUE
MAP_RETURN_EXISTS = aerospike.MAP_RETURN_EXISTS
TTL_NAMESPACE_DEFAULT = aerospike.TTL_NAMESPACE_DEFAULT
TTL_NEVER_EXPIRE = aerospike.TTL_NEVER_EXPIRE
TTL_DONT_UPDATE = aerospike.TTL_DONT_UPDATE
OP_LIST_GET_BY_INDEX = aerospike.OP_LIST_GET_BY_INDEX
OP_LIST_GET_BY_INDEX_RANGE = aerospike.OP_LIST_GET_BY_INDEX_RANGE
OP_LIST_GET_BY_RANK = aerospike.OP_LIST_GET_BY_RANK
OP_LIST_GET_BY_RANK_RANGE = aerospike.OP_LIST_GET_BY_RANK_RANGE
OP_LIST_GET_BY_VALUE = aerospike.OP_LIST_GET_BY_VALUE
OP_LIST_GET_BY_VALUE_LIST = aerospike.OP_LIST_GET_BY_VALUE_LIST
OP_LIST_GET_BY_VALUE_RANGE = aerospike.OP_LIST_GET_BY_VALUE_RANGE
OP_LIST_REMOVE_BY_INDEX = aerospike.OP_LIST_REMOVE_BY_INDEX
OP_LIST_REMOVE_BY_INDEX_RANGE = aerospike.OP_LIST_REMOVE_BY_INDEX_RANGE
OP_LIST_REMOVE_BY_RANK = aerospike.OP_LIST_REMOVE_BY_RANK
OP_LIST_REMOVE_BY_RANK_RANGE = aerospike.OP_LIST_REMOVE_BY_RANK_RANGE
OP_LIST_REMOVE_BY_VALUE = aerospike.OP_LIST_REMOVE_BY_VALUE
OP_LIST_REMOVE_BY_VALUE_LIST = aerospike.OP_LIST_REMOVE_BY_VALUE_LIST
OP_LIST_REMOVE_BY_VALUE_RANGE = aerospike.OP_LIST_REMOVE_BY_VALUE_RANGE
OP_LIST_SET_ORDER = aerospike.OP_LIST_SET_ORDER
OP_LIST_SORT = aerospike.OP_LIST_SORT
LIST_RETURN_NONE = aerospike.LIST_RETURN_NONE
LIST_RETURN_INDEX = aerospike.LIST_RETURN_INDEX
LIST_RETURN_REVERSE_INDEX = aerospike.LIST_RETURN_REVERSE_INDEX
LIST_RETURN_RANK = aerospike.LIST_RETURN_RANK
LIST_RETURN_REVERSE_RANK = aerospike.LIST_RETURN_REVERSE_RANK
LIST_RETURN_COUNT = aerospike.LIST_RETURN_COUNT
LIST_RETURN_VALUE = aerospike.LIST_RETURN_VALUE
LIST_RETURN_EXISTS = aerospike.LIST_RETURN_EXISTS
LIST_SORT_DROP_DUPLICATES = aerospike.LIST_SORT_DROP_DUPLICATES
LIST_SORT_DEFAULT = aerospike.LIST_SORT_DEFAULT
LIST_WRITE_ADD_UNIQUE = aerospike.LIST_WRITE_ADD_UNIQUE
LIST_WRITE_INSERT_BOUNDED = aerospike.LIST_WRITE_INSERT_BOUNDED
LIST_ORDERED = aerospike.LIST_ORDERED
LIST_UNORDERED = aerospike.LIST_UNORDERED
OP_LIST_REMOVE_BY_VALUE_RANK_RANGE_REL = aerospike.OP_LIST_REMOVE_BY_VALUE_RANK_RANGE_REL
OP_LIST_GET_BY_VALUE_RANK_RANGE_REL = aerospike.OP_LIST_GET_BY_VALUE_RANK_RANGE_REL
OP_MAP_REMOVE_BY_VALUE_RANK_RANGE_REL = aerospike.OP_MAP_REMOVE_BY_VALUE_RANK_RANGE_REL
OP_MAP_REMOVE_BY_KEY_INDEX_RANGE_REL = aerospike.OP_MAP_REMOVE_BY_KEY_INDEX_RANGE_REL
OP_MAP_GET_BY_VALUE_RANK_RANGE_REL = aerospike.OP_MAP_GET_BY_VALUE_RANK_RANGE_REL
OP_MAP_GET_BY_KEY_INDEX_RANGE_REL = aerospike.OP_MAP_GET_BY_KEY_INDEX_RANGE_REL
OP_LIST_GET_BY_VALUE_RANK_RANGE_REL_TO_END = aerospike.OP_LIST_GET_BY_VALUE_RANK_RANGE_REL_TO_END
OP_LIST_GET_BY_INDEX_RANGE_TO_END = aerospike.OP_LIST_GET_BY_INDEX_RANGE_TO_END
OP_LIST_GET_BY_RANK_RANGE_TO_END = aerospike.OP_LIST_GET_BY_RANK_RANGE_TO_END
OP_LIST_REMOVE_BY_REL_RANK_RANGE_TO_END = aerospike.OP_LIST_REMOVE_BY_REL_RANK_RANGE_TO_END
OP_LIST_REMOVE_BY_REL_RANK_RANGE = aerospike.OP_LIST_REMOVE_BY_REL_RANK_RANGE
OP_LIST_REMOVE_BY_INDEX_RANGE_TO_END = aerospike.OP_LIST_REMOVE_BY_INDEX_RANGE_TO_END
OP_LIST_REMOVE_BY_RANK_RANGE_TO_END = aerospike.OP_LIST_REMOVE_BY_RANK_RANGE_TO_END
MAP_WRITE_NO_FAIL = aerospike.MAP_WRITE_NO_FAIL
MAP_WRITE_PARTIAL = aerospike.MAP_WRITE_PARTIAL
LIST_WRITE_NO_FAIL = aerospike.LIST_WRITE_NO_FAIL
LIST_WRITE_PARTIAL = aerospike.LIST_WRITE_PARTIAL
MAP_WRITE_FLAGS_DEFAULT = aerospike.MAP_WRITE_FLAGS_DEFAULT
MAP_WRITE_FLAGS_CREATE_ONLY = aerospike.MAP_WRITE_FLAGS_CREATE_ONLY
MAP_WRITE_FLAGS_UPDATE_ONLY = aerospike.MAP_WRITE_FLAGS_UPDATE_ONLY
MAP_WRITE_FLAGS_NO_FAIL = aerospike.MAP_WRITE_FLAGS_NO_FAIL
MAP_WRITE_FLAGS_PARTIAL = aerospike.MAP_WRITE_FLAGS_PARTIAL
POLICY_READ_MODE_AP_ONE = aerospike.POLICY_READ_MODE_AP_ONE
POLICY_READ_MODE_AP_ALL = aerospike.POLICY_READ_MODE_AP_ALL
POLICY_READ_MODE_SC_SESSION = aerospike.POLICY_READ_MODE_SC_SESSION
POLICY_READ_MODE_SC_LINEARIZE = aerospike.POLICY_READ_MODE_SC_LINEARIZE
POLICY_READ_MODE_SC_ALLOW_REPLICA = aerospike.POLICY_READ_MODE_SC_ALLOW_REPLICA
POLICY_READ_MODE_SC_ALLOW_UNAVAILABLE = aerospike.POLICY_READ_MODE_SC_ALLOW_UNAVAILABLE
BIT_WRITE_DEFAULT = aerospike.BIT_WRITE_DEFAULT
BIT_WRITE_CREATE_ONLY = aerospike.BIT_WRITE_CREATE_ONLY
BIT_WRITE_UPDATE_ONLY = aerospike.BIT_WRITE_UPDATE_ONLY
BIT_WRITE_NO_FAIL = aerospike.BIT_WRITE_NO_FAIL
BIT_WRITE_PARTIAL = aerospike.BIT_WRITE_PARTIAL
BIT_RESIZE_DEFAULT = aerospike.BIT_RESIZE_DEFAULT
BIT_RESIZE_FROM_FRONT = aerospike.BIT_RESIZE_FROM_FRONT
BIT_RESIZE_GROW_ONLY = aerospike.BIT_RESIZE_GROW_ONLY
BIT_RESIZE_SHRINK_ONLY = aerospike.BIT_RESIZE_SHRINK_ONLY
BIT_OVERFLOW_FAIL = aerospike.BIT_OVERFLOW_FAIL
BIT_OVERFLOW_SATURATE = aerospike.BIT_OVERFLOW_SATURATE
BIT_OVERFLOW_WRAP = aerospike.BIT_OVERFLOW_WRAP
OP_BIT_INSERT = aerospike.OP_BIT_INSERT
OP_BIT_RESIZE = aerospike.OP_BIT_RESIZE
OP_BIT_REMOVE = aerospike.OP_BIT_REMOVE
OP_BIT_SET = aerospike.OP_BIT_SET
OP_BIT_OR = aerospike.OP_BIT_OR
OP_BIT_XOR = aerospike.OP_BIT_XOR
OP_BIT_AND = aerospike.OP_BIT_AND
OP_BIT_NOT = aerospike.OP_BIT_NOT
OP_BIT_LSHIFT = aerospike.OP_BIT_LSHIFT
OP_BIT_RSHIFT = aerospike.OP_BIT_RSHIFT
OP_BIT_ADD = aerospike.OP_BIT_ADD
OP_BIT_SUBTRACT = aerospike.OP_BIT_SUBTRACT
OP_BIT_GET_INT = aerospike.OP_BIT_GET_INT
OP_BIT_SET_INT = aerospike.OP_BIT_SET_INT
OP_BIT_GET = aerospike.OP_BIT_GET
OP_BIT_COUNT = aerospike.OP_BIT_COUNT
OP_BIT_LSCAN = aerospike.OP_BIT_LSCAN
OP_BIT_RSCAN = aerospike.OP_BIT_RSCAN
CDT_CTX_LIST_INDEX = aerospike.CDT_CTX_LIST_INDEX
CDT_CTX_LIST_RANK = aerospike.CDT_CTX_LIST_RANK
CDT_CTX_LIST_VALUE = aerospike.CDT_CTX_LIST_VALUE
CDT_CTX_LIST_INDEX_CREATE = aerospike.CDT_CTX_LIST_INDEX_CREATE
CDT_CTX_MAP_INDEX = aerospike.CDT_CTX_MAP_INDEX
CDT_CTX_MAP_RANK = aerospike.CDT_CTX_MAP_RANK
CDT_CTX_MAP_KEY = aerospike.CDT_CTX_MAP_KEY
CDT_CTX_MAP_VALUE = aerospike.CDT_CTX_MAP_VALUE
CDT_CTX_MAP_KEY_CREATE = aerospike.CDT_CTX_MAP_KEY_CREATE
OP_HLL_ADD = aerospike.OP_HLL_ADD
OP_HLL_DESCRIBE = aerospike.OP_HLL_DESCRIBE
OP_HLL_FOLD = aerospike.OP_HLL_FOLD
OP_HLL_GET_COUNT = aerospike.OP_HLL_GET_COUNT
OP_HLL_GET_INTERSECT_COUNT = aerospike.OP_HLL_GET_INTERSECT_COUNT
OP_HLL_GET_SIMILARITY = aerospike.OP_HLL_GET_SIMILARITY
OP_HLL_GET_UNION = aerospike.OP_HLL_GET_UNION
OP_HLL_GET_UNION_COUNT = aerospike.OP_HLL_GET_UNION_COUNT
OP_HLL_INIT = aerospike.OP_HLL_INIT
OP_HLL_REFRESH_COUNT = aerospike.OP_HLL_REFRESH_COUNT
OP_HLL_SET_UNION = aerospike.OP_HLL_SET_UNION
OP_HLL_MAY_CONTAIN = aerospike.OP_HLL_MAY_CONTAIN
HLL_WRITE_DEFAULT = aerospike.HLL_WRITE_DEFAULT
HLL_WRITE_CREATE_ONLY = aerospike.HLL_WRITE_CREATE_ONLY
HLL_WRITE_UPDATE_ONLY = aerospike.HLL_WRITE_UPDATE_ONLY
HLL_WRITE_NO_FAIL = aerospike.HLL_WRITE_NO_FAIL
HLL_WRITE_ALLOW_FOLD = aerospike.HLL_WRITE_ALLOW_FOLD
OP_MAP_REMOVE_BY_KEY_REL_INDEX_RANGE_TO_END = aerospike.OP_MAP_REMOVE_BY_KEY_REL_INDEX_RANGE_TO_END
OP_MAP_REMOVE_BY_VALUE_REL_RANK_RANGE_TO_END = aerospike.OP_MAP_REMOVE_BY_VALUE_REL_RANK_RANGE_TO_END
OP_MAP_REMOVE_BY_INDEX_RANGE_TO_END = aerospike.OP_MAP_REMOVE_BY_INDEX_RANGE_TO_END
OP_MAP_REMOVE_BY_RANK_RANGE_TO_END = aerospike.OP_MAP_REMOVE_BY_RANK_RANGE_TO_END
OP_MAP_GET_BY_KEY_REL_INDEX_RANGE_TO_END = aerospike.OP_MAP_GET_BY_KEY_REL_INDEX_RANGE_TO_END
OP_MAP_REMOVE_BY_KEY_REL_INDEX_RANGE = aerospike.OP_MAP_REMOVE_BY_KEY_REL_INDEX_RANGE
OP_MAP_REMOVE_BY_VALUE_REL_INDEX_RANGE = aerospike.OP_MAP_REMOVE_BY_VALUE_REL_INDEX_RANGE
OP_MAP_REMOVE_BY_VALUE_REL_RANK_RANGE = aerospike.OP_MAP_REMOVE_BY_VALUE_REL_RANK_RANGE
OP_MAP_GET_BY_KEY_REL_INDEX_RANGE = aerospike.OP_MAP_GET_BY_KEY_REL_INDEX_RANGE
OP_MAP_GET_BY_VALUE_RANK_RANGE_REL_TO_END = aerospike.OP_MAP_GET_BY_VALUE_RANK_RANGE_REL_TO_END
OP_MAP_GET_BY_INDEX_RANGE_TO_END = aerospike.OP_MAP_GET_BY_INDEX_RANGE_TO_END
OP_MAP_GET_BY_RANK_RANGE_TO_END = aerospike.OP_MAP_GET_BY_RANK_RANGE_TO_END
OP_EXPR_READ = aerospike.OP_EXPR_READ
OP_EXPR_WRITE = aerospike.OP_EXPR_WRITE
EXP_WRITE_DEFAULT = aerospike.EXP_WRITE_DEFAULT
EXP_WRITE_CREATE_ONLY = aerospike.EXP_WRITE_CREATE_ONLY
EXP_WRITE_UPDATE_ONLY = aerospike.EXP_WRITE_UPDATE_ONLY
EXP_WRITE_ALLOW_DELETE = aerospike.EXP_WRITE_ALLOW_DELETE
EXP_WRITE_POLICY_NO_FAIL = aerospike.EXP_WRITE_POLICY_NO_FAIL
EXP_WRITE_EVAL_NO_FAIL = aerospike.EXP_WRITE_EVAL_NO_FAIL
EXP_READ_DEFAULT = aerospike.EXP_READ_DEFAULT
EXP_READ_EVAL_NO_FAIL = aerospike.EXP_READ_EVAL_NO_FAIL
AS_BYTES_UNDEF = aerospike.AS_BYTES_UNDEF
AS_BYTES_INTEGER = aerospike.AS_BYTES_INTEGER
AS_BYTES_DOUBLE = aerospike.AS_BYTES_DOUBLE
AS_BYTES_STRING = aerospike.AS_BYTES_STRING
AS_BYTES_BLOB = aerospike.AS_BYTES_BLOB
AS_BYTES_JAVA = aerospike.AS_BYTES_JAVA
AS_BYTES_CSHARP = aerospike.AS_BYTES_CSHARP
AS_BYTES_PYTHON = aerospike.AS_BYTES_PYTHON
AS_BYTES_RUBY = aerospike.AS_BYTES_RUBY
AS_BYTES_PHP = aerospike.AS_BYTES_PHP
AS_BYTES_ERLANG = aerospike.AS_BYTES_ERLANG
AS_BYTES_HLL = aerospike.AS_BYTES_HLL
AS_BYTES_MAP = aerospike.AS_BYTES_MAP
AS_BYTES_LIST = aerospike.AS_BYTES_LIST
AS_BYTES_GEOJSON = aerospike.AS_BYTES_GEOJSON
AS_BYTES_TYPE_MAX = aerospike.AS_BYTES_TYPE_MAX
REGEX_NONE = aerospike.REGEX_NONE
REGEX_EXTENDED = aerospike.REGEX_EXTENDED
REGEX_ICASE = aerospike.REGEX_ICASE
REGEX_NOSUB = aerospike.REGEX_NOSUB
REGEX_NEWLINE = aerospike.REGEX_NEWLINE
JOB_SCAN = aerospike.JOB_SCAN
JOB_QUERY = aerospike.JOB_QUERY
LOG_LEVEL_OFF = aerospike.LOG_LEVEL_OFF
LOG_LEVEL_ERROR = aerospike.LOG_LEVEL_ERROR
LOG_LEVEL_WARN = aerospike.LOG_LEVEL_WARN
LOG_LEVEL_INFO = aerospike.LOG_LEVEL_INFO
LOG_LEVEL_DEBUG = aerospike.LOG_LEVEL_DEBUG
LOG_LEVEL_TRACE = aerospike.LOG_LEVEL_TRACE
