from .types import (
    Id, 
    SemVersion,
    MitreDomain,
    MitrePlatform
)
from .base import (
    BaseModel,
    List,
    AnyStr,
    define,
    field,
    validators
)


@define
class Malware(BaseModel):
    type: AnyStr = field(validator=validators.in_(['malware']))
    labels: List = field()
    description: AnyStr = field()
    x_mitre_attack_spec_version: SemVersion = field()
    x_mitre_modified_by_ref: Id = field()
    x_mitre_aliases: List = field()
    x_mitre_platforms: List[MitrePlatform] = field()
    x_mitre_contributors: List = field()
    x_mitre_domains: List[MitreDomain] = field()

    revoked: bool = field(factory=bool)
    created_by_ref: Id = field(factory=Id)
    x_mitre_deprecated: bool = field(factory=bool)

    @property
    def actors(self):
        return self._get_relationship_objects(
            parent_id=self.id,
            parent_type='intrusion-set'
        )

    @property
    def techniques(self):
        return self._get_relationship_objects(
            parent_id=self.id,
            parent_type='attack-pattern'
        )
