# coding: utf-8

"""
    Xero Finance API

    The Finance API is a collection of endpoints which customers can use in the course of a loan application, which may assist lenders to gain the confidence they need to provide capital.  # noqa: E501

    Contact: api@xero.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401

from xero_python.models import BaseModel


class UserResponse(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        "user_id": "str",
        "user_created_date_utc": "datetime",
        "last_login_date_utc": "datetime",
        "is_external_partner": "bool",
        "has_accountant_role": "bool",
        "month_period": "str",
        "number_of_logins": "int",
        "number_of_documents_created": "int",
        "net_value_documents_created": "float",
        "absolute_value_documents_created": "float",
        "attached_practices": "list[PracticeResponse]",
        "history_records": "list[HistoryRecordResponse]",
    }

    attribute_map = {
        "user_id": "userId",
        "user_created_date_utc": "userCreatedDateUtc",
        "last_login_date_utc": "lastLoginDateUtc",
        "is_external_partner": "isExternalPartner",
        "has_accountant_role": "hasAccountantRole",
        "month_period": "monthPeriod",
        "number_of_logins": "numberOfLogins",
        "number_of_documents_created": "numberOfDocumentsCreated",
        "net_value_documents_created": "netValueDocumentsCreated",
        "absolute_value_documents_created": "absoluteValueDocumentsCreated",
        "attached_practices": "attachedPractices",
        "history_records": "historyRecords",
    }

    def __init__(
        self,
        user_id=None,
        user_created_date_utc=None,
        last_login_date_utc=None,
        is_external_partner=None,
        has_accountant_role=None,
        month_period=None,
        number_of_logins=None,
        number_of_documents_created=None,
        net_value_documents_created=None,
        absolute_value_documents_created=None,
        attached_practices=None,
        history_records=None,
    ):  # noqa: E501
        """UserResponse - a model defined in OpenAPI"""  # noqa: E501

        self._user_id = None
        self._user_created_date_utc = None
        self._last_login_date_utc = None
        self._is_external_partner = None
        self._has_accountant_role = None
        self._month_period = None
        self._number_of_logins = None
        self._number_of_documents_created = None
        self._net_value_documents_created = None
        self._absolute_value_documents_created = None
        self._attached_practices = None
        self._history_records = None
        self.discriminator = None

        if user_id is not None:
            self.user_id = user_id
        if user_created_date_utc is not None:
            self.user_created_date_utc = user_created_date_utc
        if last_login_date_utc is not None:
            self.last_login_date_utc = last_login_date_utc
        if is_external_partner is not None:
            self.is_external_partner = is_external_partner
        if has_accountant_role is not None:
            self.has_accountant_role = has_accountant_role
        if month_period is not None:
            self.month_period = month_period
        if number_of_logins is not None:
            self.number_of_logins = number_of_logins
        if number_of_documents_created is not None:
            self.number_of_documents_created = number_of_documents_created
        if net_value_documents_created is not None:
            self.net_value_documents_created = net_value_documents_created
        if absolute_value_documents_created is not None:
            self.absolute_value_documents_created = absolute_value_documents_created
        if attached_practices is not None:
            self.attached_practices = attached_practices
        if history_records is not None:
            self.history_records = history_records

    @property
    def user_id(self):
        """Gets the user_id of this UserResponse.  # noqa: E501

        The Xero identifier for the user  # noqa: E501

        :return: The user_id of this UserResponse.  # noqa: E501
        :rtype: str
        """
        return self._user_id

    @user_id.setter
    def user_id(self, user_id):
        """Sets the user_id of this UserResponse.

        The Xero identifier for the user  # noqa: E501

        :param user_id: The user_id of this UserResponse.  # noqa: E501
        :type: str
        """

        self._user_id = user_id

    @property
    def user_created_date_utc(self):
        """Gets the user_created_date_utc of this UserResponse.  # noqa: E501

        Timestamp of user creation.  # noqa: E501

        :return: The user_created_date_utc of this UserResponse.  # noqa: E501
        :rtype: datetime
        """
        return self._user_created_date_utc

    @user_created_date_utc.setter
    def user_created_date_utc(self, user_created_date_utc):
        """Sets the user_created_date_utc of this UserResponse.

        Timestamp of user creation.  # noqa: E501

        :param user_created_date_utc: The user_created_date_utc of this UserResponse.  # noqa: E501
        :type: datetime
        """

        self._user_created_date_utc = user_created_date_utc

    @property
    def last_login_date_utc(self):
        """Gets the last_login_date_utc of this UserResponse.  # noqa: E501

        Timestamp of user last login  # noqa: E501

        :return: The last_login_date_utc of this UserResponse.  # noqa: E501
        :rtype: datetime
        """
        return self._last_login_date_utc

    @last_login_date_utc.setter
    def last_login_date_utc(self, last_login_date_utc):
        """Sets the last_login_date_utc of this UserResponse.

        Timestamp of user last login  # noqa: E501

        :param last_login_date_utc: The last_login_date_utc of this UserResponse.  # noqa: E501
        :type: datetime
        """

        self._last_login_date_utc = last_login_date_utc

    @property
    def is_external_partner(self):
        """Gets the is_external_partner of this UserResponse.  # noqa: E501

        User is external partner.  # noqa: E501

        :return: The is_external_partner of this UserResponse.  # noqa: E501
        :rtype: bool
        """
        return self._is_external_partner

    @is_external_partner.setter
    def is_external_partner(self, is_external_partner):
        """Sets the is_external_partner of this UserResponse.

        User is external partner.  # noqa: E501

        :param is_external_partner: The is_external_partner of this UserResponse.  # noqa: E501
        :type: bool
        """

        self._is_external_partner = is_external_partner

    @property
    def has_accountant_role(self):
        """Gets the has_accountant_role of this UserResponse.  # noqa: E501

        User has Accountant role.  # noqa: E501

        :return: The has_accountant_role of this UserResponse.  # noqa: E501
        :rtype: bool
        """
        return self._has_accountant_role

    @has_accountant_role.setter
    def has_accountant_role(self, has_accountant_role):
        """Sets the has_accountant_role of this UserResponse.

        User has Accountant role.  # noqa: E501

        :param has_accountant_role: The has_accountant_role of this UserResponse.  # noqa: E501
        :type: bool
        """

        self._has_accountant_role = has_accountant_role

    @property
    def month_period(self):
        """Gets the month_period of this UserResponse.  # noqa: E501

        Month period in format  yyyy-MM.  # noqa: E501

        :return: The month_period of this UserResponse.  # noqa: E501
        :rtype: str
        """
        return self._month_period

    @month_period.setter
    def month_period(self, month_period):
        """Sets the month_period of this UserResponse.

        Month period in format  yyyy-MM.  # noqa: E501

        :param month_period: The month_period of this UserResponse.  # noqa: E501
        :type: str
        """

        self._month_period = month_period

    @property
    def number_of_logins(self):
        """Gets the number_of_logins of this UserResponse.  # noqa: E501

        Number of times the user has logged in.  # noqa: E501

        :return: The number_of_logins of this UserResponse.  # noqa: E501
        :rtype: int
        """
        return self._number_of_logins

    @number_of_logins.setter
    def number_of_logins(self, number_of_logins):
        """Sets the number_of_logins of this UserResponse.

        Number of times the user has logged in.  # noqa: E501

        :param number_of_logins: The number_of_logins of this UserResponse.  # noqa: E501
        :type: int
        """

        self._number_of_logins = number_of_logins

    @property
    def number_of_documents_created(self):
        """Gets the number_of_documents_created of this UserResponse.  # noqa: E501

        Number of documents created.  # noqa: E501

        :return: The number_of_documents_created of this UserResponse.  # noqa: E501
        :rtype: int
        """
        return self._number_of_documents_created

    @number_of_documents_created.setter
    def number_of_documents_created(self, number_of_documents_created):
        """Sets the number_of_documents_created of this UserResponse.

        Number of documents created.  # noqa: E501

        :param number_of_documents_created: The number_of_documents_created of this UserResponse.  # noqa: E501
        :type: int
        """

        self._number_of_documents_created = number_of_documents_created

    @property
    def net_value_documents_created(self):
        """Gets the net_value_documents_created of this UserResponse.  # noqa: E501

        Net value of documents created.  # noqa: E501

        :return: The net_value_documents_created of this UserResponse.  # noqa: E501
        :rtype: float
        """
        return self._net_value_documents_created

    @net_value_documents_created.setter
    def net_value_documents_created(self, net_value_documents_created):
        """Sets the net_value_documents_created of this UserResponse.

        Net value of documents created.  # noqa: E501

        :param net_value_documents_created: The net_value_documents_created of this UserResponse.  # noqa: E501
        :type: float
        """

        self._net_value_documents_created = net_value_documents_created

    @property
    def absolute_value_documents_created(self):
        """Gets the absolute_value_documents_created of this UserResponse.  # noqa: E501

        Absolute value of documents created.  # noqa: E501

        :return: The absolute_value_documents_created of this UserResponse.  # noqa: E501
        :rtype: float
        """
        return self._absolute_value_documents_created

    @absolute_value_documents_created.setter
    def absolute_value_documents_created(self, absolute_value_documents_created):
        """Sets the absolute_value_documents_created of this UserResponse.

        Absolute value of documents created.  # noqa: E501

        :param absolute_value_documents_created: The absolute_value_documents_created of this UserResponse.  # noqa: E501
        :type: float
        """

        self._absolute_value_documents_created = absolute_value_documents_created

    @property
    def attached_practices(self):
        """Gets the attached_practices of this UserResponse.  # noqa: E501


        :return: The attached_practices of this UserResponse.  # noqa: E501
        :rtype: list[PracticeResponse]
        """
        return self._attached_practices

    @attached_practices.setter
    def attached_practices(self, attached_practices):
        """Sets the attached_practices of this UserResponse.


        :param attached_practices: The attached_practices of this UserResponse.  # noqa: E501
        :type: list[PracticeResponse]
        """

        self._attached_practices = attached_practices

    @property
    def history_records(self):
        """Gets the history_records of this UserResponse.  # noqa: E501


        :return: The history_records of this UserResponse.  # noqa: E501
        :rtype: list[HistoryRecordResponse]
        """
        return self._history_records

    @history_records.setter
    def history_records(self, history_records):
        """Sets the history_records of this UserResponse.


        :param history_records: The history_records of this UserResponse.  # noqa: E501
        :type: list[HistoryRecordResponse]
        """

        self._history_records = history_records
