# these notes are all upper-cased to allow for multiple reference styles:
# Eb-2 / eb-2, etc..
NOTE_TO_MIDI = {
    "C-2": 0,
    "DB-2": 1,
    "D-2": 2,
    "EB-2": 3,
    "E-2": 4,
    "F-2": 5,
    "GB-2": 6,
    "G-2": 7,
    "AB-2": 8,
    "A-2": 9,
    "BB-2": 10,
    "B-2": 11,
    "C-1": 12,
    "DB-1": 13,
    "D-1": 14,
    "EB-1": 15,
    "E-1": 16,
    "F-1": 17,
    "GB-1": 18,
    "G-1": 19,
    "AB-1": 20,
    "A-1": 21,
    "BB-1": 22,
    "B-1": 23,
    "C0": 24,
    "DB0": 25,
    "D0": 26,
    "EB0": 27,
    "E0": 28,
    "F0": 29,
    "GB0": 30,
    "G0": 31,
    "AB0": 32,
    "A0": 33,
    "BB0": 34,
    "B0": 35,
    "C1": 36,
    "DB1": 37,
    "D1": 38,
    "EB1": 39,
    "E1": 40,
    "F1": 41,
    "GB1": 42,
    "G1": 43,
    "AB1": 44,
    "A1": 45,
    "BB1": 46,
    "B1": 47,
    "C2": 48,
    "DB2": 49,
    "D2": 50,
    "EB2": 51,
    "E2": 52,
    "F2": 53,
    "GB2": 54,
    "G2": 55,
    "AB2": 56,
    "A2": 57,
    "BB2": 58,
    "B2": 59,
    "C3": 60,
    "DB3": 61,
    "D3": 62,
    "EB3": 63,
    "E3": 64,
    "F3": 65,
    "GB3": 66,
    "G3": 67,
    "AB3": 68,
    "A3": 69,
    "BB3": 70,
    "B3": 71,
    "C4": 72,
    "DB4": 73,
    "D4": 74,
    "EB4": 75,
    "E4": 76,
    "F4": 77,
    "GB4": 78,
    "G4": 79,
    "AB4": 80,
    "A4": 81,
    "BB4": 82,
    "B4": 83,
    "C5": 84,
    "DB5": 85,
    "D5": 86,
    "EB5": 87,
    "E5": 88,
    "F5": 89,
    "GB5": 90,
    "G5": 91,
    "AB5": 92,
    "A5": 93,
    "BB5": 94,
    "B5": 95,
    "C6": 96,
    "DB6": 97,
    "D6": 98,
    "EB6": 99,
    "E6": 100,
    "F6": 101,
    "GB6": 102,
    "G6": 103,
    "AB6": 104,
    "A6": 105,
    "BB6": 106,
    "B6": 107,
    "C7": 108,
    "DB7": 109,
    "D7": 110,
    "EB7": 111,
    "E7": 112,
    "F7": 113,
    "GB7": 114,
    "G7": 115,
    "AB7": 116,
    "A7": 117,
    "BB7": 118,
    "B7": 119,
    "C8": 120,
    "DB8": 121,
    "D8": 122,
    "EB8": 123,
    "E8": 124,
    "F8": 125,
    "GB8": 126,
    "G8": 127,
}

MIDI_TO_NOTE = {m: n for n, m in NOTE_TO_MIDI.items()}

NOTE_EQUIVALENTS = {"C#": "DB", "D#": "EB", "F#": "GB", "G#": "AB", "A#": "BB"}

ROOT_TO_MIDI = {
    "C": 0,
    "DB": 1,
    "D": 2,
    "EB": 3,
    "E": 4,
    "F": 5,
    "GB": 6,
    "G": 7,
    "AB": 8,
    "A": 9,
    "BB": 10,
    "B": 11,
}
MIDI_TO_ROOT = {m: n for n, m in ROOT_TO_MIDI.items()}

NOTE_TO_FREQ = {
    "C-2": 8.176,
    "DB-2": 8.662,
    "D-2": 9.177,
    "EB-2": 9.723,
    "E-2": 10.301,
    "F-2": 10.913,
    "GB-2": 11.562,
    "G-2": 12.25,
    "AB-2": 12.978,
    "A-2": 13.75,
    "BB-2": 14.568,
    "B-2": 15.434,
    "C-1": 16.35,
    "DB-1": 17.32,
    "D-1": 18.35,
    "EB-1": 19.45,
    "E-1": 20.6,
    "F-1": 21.83,
    "GB-1": 23.12,
    "G-1": 24.5,
    "AB-1": 25.96,
    "A-1": 27.5,
    "BB-1": 29.14,
    "B-1": 30.87,
    "C0": 32.7,
    "DB0": 34.65,
    "D0": 36.71,
    "EB0": 38.89,
    "E0": 41.2,
    "F0": 43.65,
    "GB0": 46.25,
    "G0": 49,
    "AB0": 51.91,
    "A0": 55,
    "BB0": 58.27,
    "B0": 61.74,
    "C1": 65.41,
    "DB1": 69.3,
    "D1": 73.42,
    "EB1": 77.78,
    "E1": 82.41,
    "F1": 87.31,
    "GB1": 92.5,
    "G1": 98,
    "AB1": 103.83,
    "A1": 110,
    "BB1": 116.54,
    "B1": 123.47,
    "C2": 130.81,
    "DB2": 138.59,
    "D2": 146.83,
    "EB2": 155.56,
    "E2": 164.81,
    "F2": 174.61,
    "GB2": 185,
    "G2": 196,
    "AB2": 207.65,
    "A2": 220,
    "BB2": 233.08,
    "B2": 246.94,
    "C3": 261.63,
    "DB3": 277.18,
    "D3": 293.66,
    "EB3": 311.13,
    "E3": 329.63,
    "F3": 349.23,
    "GB3": 369.99,
    "G3": 392,
    "AB3": 415.3,
    "A3": 440,
    "BB3": 466.16,
    "B3": 493.88,
    "C4": 523.25,
    "DB4": 554.37,
    "D4": 587.33,
    "EB4": 622.25,
    "E4": 659.25,
    "F4": 698.46,
    "GB4": 739.99,
    "G4": 783.99,
    "AB4": 830.61,
    "A4": 880,
    "BB4": 932.33,
    "B4": 987.77,
    "C5": 1046.5,
    "DB5": 1108.73,
    "D5": 1174.66,
    "EB5": 1244.51,
    "E5": 1318.51,
    "F5": 1396.91,
    "GB5": 1479.98,
    "G5": 1567.98,
    "AB5": 1661.22,
    "A5": 1760,
    "BB5": 1864.66,
    "B5": 1975.53,
    "C6": 2093,
    "DB6": 2217.46,
    "D6": 2349.32,
    "EB6": 2489.02,
    "E6": 2637.02,
    "F6": 2793.83,
    "GB6": 2959.96,
    "G6": 3135.96,
    "AB6": 3322.44,
    "A6": 3520,
    "BB6": 3729.31,
    "B6": 3951.07,
    "C7": 4186.01,
    "DB7": 4434.92,
    "D7": 4698.63,
    "EB7": 4978.03,
    "E7": 5274.04,
    "F7": 5587.65,
    "GB7": 5919.91,
    "G7": 6271.93,
    "AB7": 6644.88,
    "A7": 7040,
    "BB7": 7458.62,
    "B7": 7902.13,
    "C8": 8372.018,
    "DB8": 8869.844,
    "D8": 9397.273,
    "EB8": 9956.063,
    "E8": 10548.082,
    "F8": 11175.303,
    "GB8": 11839.822,
    "G8": 12543.854,
}

MIDI_TO_FREQ = {
    m: NOTE_TO_FREQ[n] for n, m in NOTE_TO_MIDI.items() if n in NOTE_TO_FREQ
}


CHORDS = {
    "MAJ_NO5": [0, 4],
    "POWER": [0, 7],
    "SUS": [0, 5, 7],
    "SUS2": [0, 2, 7],
    "7SUS": [0, 5, 11],
    "7SUS2": [0, 2, 11],
    "MAJ6": [0, 4, 7, 9],
    "MAJ6_NO5": [0, 4, 9],
    "MIN_NO5": [0, 3],
    "MIN6": [0, 3, 7, 9],
    "MIN6_NO5": [0, 3, 9],
    "MIN6_9": [0, 3, 9, 14],
    "DIM": [0, 3, 6],
    "AUG": [0, 4, 8],
    "MAJ7": [0, 4, 7, 11],
    "MAJ7_NO5": [0, 4, 11],
    "MIN7": [0, 3, 7, 10],
    "MIN7_NO5": [0, 3, 10],
    "MAJ": [0, 4, 7],
    "MAJ9": [0, 4, 7, 11, 21],
    "MAJ13": [0, 4, 7, 11, 21],
    "ADD6": [0, 4, 7, 9],
    "MAJ69": [0, 4, 7, 9, 14],
    "LYD": [0, 4, 7, 11, 15, 21],
    "MAJ7_FLAT6": [0, 4, 7, 11, 20],
    "DOM7": [0, 4, 7, 10],
    "DOM9": [0, 4, 7, 10, 21],
    "DOM13": [0, 4, 7, 10, 19],
    "LYD_DOM7": [0, 4, 7, 10, 15],
    "DOM_FLAT14": [0, 4, 7, 10, 20, 4, 9],
    "DOM_SHARP14": [0, 4, 7, 10, 17, 14, 19],
    "ALT7": [0, 4, 10, 20, 8],
    "SUS4": [0, 5, 7],
    "SUS2": [0, 2, 7],
    "7SUS4": [0, 4, 7, 10],
    "11": [0, 7, 10, 21, 16],
    "11SPEC": [0, 4, 7, 10, 21, 16],
    "PHRYG": [0, 5, 7, 20],
    "MAJ": [0, 4, 7],
    "MIN": [0, 3, 7],
    "MINAJ7": [0, 3, 7, 11, 14, 19],
    "MINAJ7_13": [0, 3, 7, 11, 14, 18],
    "MIN9": [0, 3, 7, 10, 14],
    "MIN11": [0, 3, 7, 10, 14, 16],
    "MIN13": [0, 3, 7, 10, 14, 16, 19],
    "DIM": [0, 3, 6],
    "DIM7": [0, 3, 6, 9],
    "HALF_DIM": [0, 3, 6, 9, 13],
}

SCALES = {
    "ACOUSTIC": [0, 2, 4, 6, 7, 9, 10],
    "ADONAI_MALAKH": [0, 2, 4, 5, 7, 8, 10],
    "AEOLIAN": [0, 2, 3, 5, 7, 8, 10],
    "ALGERIAN": [0, 2, 3, 6, 7, 8, 11],
    "ALTERED": [0, 1, 3, 4, 6, 8, 10],
    "AUGMENTED": [0, 3, 4, 7, 8, 11],
    "BEBOP_DOMINANT": [0, 2, 4, 5, 7, 9, 10, 11],
    "BLUES": [0, 3, 5, 6, 7, 10],
    "DORIAN": [0, 2, 3, 5, 7, 9, 10],
    "DOUBLE_HARMONIC": [0, 1, 4, 5, 7, 8, 11],
    "ENIGMATIC": [0, 1, 4, 6, 8, 10, 11],
    "FLAMENCO": [0, 1, 4, 5, 7, 8, 11],
    "GYPSY": [0, 2, 3, 6, 7, 8, 10],
    "HALF_DIMINISHED": [0, 2, 3, 5, 6, 8, 10],
    "HARMONIC_MAJOR": [0, 2, 4, 5, 7, 8, 11],
    "HARMONIC_MINOR": [0, 2, 3, 5, 7, 8, 11],
    "HIRAJOSHI": [0, 4, 6, 7, 11],
    "HUNGARIAN_GYPSY": [0, 2, 3, 6, 7, 8, 11],
    "INSEN": [0, 1, 5, 7, 10],
    "IONIAN": [0, 2, 4, 5, 7, 9, 11],
    "IWATO": [0, 1, 5, 6, 11],
    "LOCRIAN": [0, 1, 3, 5, 6, 8, 10],
    "LYDIAN_AUGMENTED": [0, 2, 4, 6, 8, 9, 11],
    "LYDIAN": [0, 2, 4, 6, 7, 9, 11],
    "MAJOR_LOCRIAN": [0, 2, 4, 5, 6, 8, 10],
    "MELODIC_MINOR": [0, 2, 3, 5, 7, 9, 11],
    "MIXOLYDIAN": [0, 2, 4, 5, 7, 9, 10],
    "NEAPOLITAN_MAJOR": [0, 1, 3, 5, 7, 9, 11],
    "NEAPOLITAN_MINOR": [0, 1, 3, 5, 7, 8, 11],
    "PERSIAN": [0, 1, 4, 5, 6, 8, 11],
    "PHRYGIAN": [0, 1, 3, 5, 7, 8, 10],
    "PROMETHEUS": [0, 2, 4, 6, 9, 10],
    "TRITONE": [0, 1, 4, 6, 7, 10],
    "UKRAINIAN_DORIAN": [0, 2, 3, 6, 7, 9, 10],
    "WHOLE_TONE": [0, 2, 4, 6, 8, 10],
    "MAJOR": [0, 2, 4, 5, 7, 9, 11],
    "MINOR": [0, 2, 3, 5, 7, 8, 10],
    "CHROMATIC": [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11],
    "OCTATONIC_WHOLE": [0, 2, 3, 5, 6, 8, 9, 11],
    "OCTATONIC_SEMI": [0, 1, 3, 4, 6, 7, 9, 10],
}
