img_norm_cfg = dict(
    mean=[123.675, 116.28, 103.53], std=[58.395, 57.12, 57.375], to_rgb=True
)

train_pipeline = [
    dict(type="LoadImageFromFile", color_type="color_ignore_orientation"),
    dict(type="LoadAnnotations", with_bbox=True, with_mask=True),
    dict(
        type="ScaleAspectJitter",
        img_scale=None,
        keep_ratio=False,
        resize_type="indep_sample_in_range",
        scale_range=(640, 2560),
    ),
    dict(type="RandomFlip", flip_ratio=0.5),
    dict(type="Normalize", **img_norm_cfg),
    dict(
        type="RandomCropInstances",
        target_size=(640, 640),
        mask_type="union_all",
        instance_key="gt_masks",
    ),
    dict(type="Pad", size_divisor=32),
    dict(type="DefaultFormatBundle"),
    dict(type="Collect", keys=["img", "gt_bboxes", "gt_labels", "gt_masks"]),
]

# for ctw1500
img_scale_ctw1500 = (1600, 1600)
test_pipeline_ctw1500 = [
    dict(type="LoadImageFromFile", color_type="color_ignore_orientation"),
    dict(
        type="MultiScaleFlipAug",
        img_scale=img_scale_ctw1500,  # used by Resize
        flip=False,
        transforms=[
            dict(type="Resize", keep_ratio=True),
            dict(type="RandomFlip"),
            dict(type="Normalize", **img_norm_cfg),
            dict(type="DefaultFormatBundle"),
            dict(type="Collect", keys=["img"]),
        ],
    ),
]

# for icdar2015
img_scale_icdar2015 = (1920, 1920)
test_pipeline_icdar2015 = [
    dict(type="LoadImageFromFile", color_type="color_ignore_orientation"),
    dict(
        type="MultiScaleFlipAug",
        img_scale=img_scale_icdar2015,  # used by Resize
        flip=False,
        transforms=[
            dict(type="Resize", keep_ratio=True),
            dict(type="RandomFlip"),
            dict(type="Normalize", **img_norm_cfg),
            dict(type="DefaultFormatBundle"),
            dict(type="Collect", keys=["img"]),
        ],
    ),
]
