# mypy-boto3-iotthingsgraph

[![PyPI - mypy-boto3-iotthingsgraph](https://img.shields.io/pypi/v/mypy-boto3-iotthingsgraph.svg?color=blue)](https://pypi.org/project/mypy-boto3-iotthingsgraph)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-iotthingsgraph.svg?color=blue)](https://pypi.org/project/mypy-boto3-iotthingsgraph)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

Type annotations for
[boto3.IoTThingsGraph 1.16.14](https://boto3.amazonaws.com/v1/documentation/api/1.16.14/reference/services/iotthingsgraph.html#IoTThingsGraph) service
compatible with
[VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright)
and other tools.

Generated by [mypy-boto3-buider 3.2.2](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

- [mypy-boto3-iotthingsgraph](#mypy-boto3-iotthingsgraph)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Waiters annotations](#waiters-annotations)
    - [Service Resource annotations](#service-resource-annotations)
    - [Other resources annotations](#other-resources-annotations)
    - [Collections annotations](#collections-annotations)
    - [Typed dictionations](#typed-dictionations)

## How to install

Install `boto3-stubs` for `IoTThingsGraph` service.

```bash
python -m pip install boto3-stubs[iotthingsgraph]
```

## Usage

### VSCode

- Install [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[iotthingsgraph]` in your environment: `python -m pip install 'boto3-stubs[iotthingsgraph]'`

Both type checking and auto-complete should work for `IoTThingsGraph` service.
No explicit type annotations required, write your `boto3` code as usual.

### PyCharm

- Install `boto-stubs[iotthingsgraph]` in your environment: `python -m pip install 'boto3-stubs[iotthingsgraph]'`

Both type checking and auto-complete should work for `IoTThingsGraph` service.
No explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed `boto3-stubs` submodules.

### Other IDEs

Not tested, but as long as your IDE support `mypy` or `pyright`, everything should work.

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[iotthingsgraph]` in your environment: `python -m pip install 'boto3-stubs[iotthingsgraph]'`
- Run `mypy` as usual

Type checking should work for `IoTThingsGraph` service.
No explicit type annotations required, write your `boto3` code as usual.

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[iotthingsgraph]` in your environment: `python -m pip install 'boto3-stubs[iotthingsgraph]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `IoTThingsGraph` service.
No explicit type annotations required, write your `boto3` code as usual.

## Explicit type annotations

### Client annotations

`IoTThingsGraphClient` provides annotations for `boto3.client("iotthingsgraph")`.

```python
import boto3

from mypy_boto3_iotthingsgraph import IoTThingsGraphClient

client: IoTThingsGraphClient = boto3.client("iotthingsgraph")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: IoTThingsGraphClient = session.client("iotthingsgraph")
```

### Paginators annotations

`mypy_boto3_iotthingsgraph.paginator` module contains type annotations for all paginators.

```python
from mypy_boto3_iotthingsgraph import IoTThingsGraphClient
from mypy_boto3_iotthingsgraph.paginator import (
    GetFlowTemplateRevisionsPaginator,
    GetSystemTemplateRevisionsPaginator,
    ListFlowExecutionMessagesPaginator,
    ListTagsForResourcePaginator,
    SearchEntitiesPaginator,
    SearchFlowExecutionsPaginator,
    SearchFlowTemplatesPaginator,
    SearchSystemInstancesPaginator,
    SearchSystemTemplatesPaginator,
    SearchThingsPaginator,
)

client: IoTThingsGraphClient = boto3.client("iotthingsgraph")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
get_flow_template_revisions_paginator: GetFlowTemplateRevisionsPaginator = client.get_paginator("get_flow_template_revisions")
get_system_template_revisions_paginator: GetSystemTemplateRevisionsPaginator = client.get_paginator("get_system_template_revisions")
list_flow_execution_messages_paginator: ListFlowExecutionMessagesPaginator = client.get_paginator("list_flow_execution_messages")
list_tags_for_resource_paginator: ListTagsForResourcePaginator = client.get_paginator("list_tags_for_resource")
search_entities_paginator: SearchEntitiesPaginator = client.get_paginator("search_entities")
search_flow_executions_paginator: SearchFlowExecutionsPaginator = client.get_paginator("search_flow_executions")
search_flow_templates_paginator: SearchFlowTemplatesPaginator = client.get_paginator("search_flow_templates")
search_system_instances_paginator: SearchSystemInstancesPaginator = client.get_paginator("search_system_instances")
search_system_templates_paginator: SearchSystemTemplatesPaginator = client.get_paginator("search_system_templates")
search_things_paginator: SearchThingsPaginator = client.get_paginator("search_things")
```







### Typed dictionations

`mypy_boto3_iotthingsgraph.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python
from mypy_boto3_iotthingsgraph.type_defs import (
    CreateFlowTemplateResponseTypeDef,
    CreateSystemInstanceResponseTypeDef,
    CreateSystemTemplateResponseTypeDef,
    DefinitionDocumentTypeDef,
    DeleteNamespaceResponseTypeDef,
    DependencyRevisionTypeDef,
    DeploySystemInstanceResponseTypeDef,
    DescribeNamespaceResponseTypeDef,
    EntityDescriptionTypeDef,
    EntityFilterTypeDef,
    FlowExecutionMessageTypeDef,
    FlowExecutionSummaryTypeDef,
    FlowTemplateDescriptionTypeDef,
    FlowTemplateFilterTypeDef,
    FlowTemplateSummaryTypeDef,
    GetEntitiesResponseTypeDef,
    GetFlowTemplateResponseTypeDef,
    GetFlowTemplateRevisionsResponseTypeDef,
    GetNamespaceDeletionStatusResponseTypeDef,
    GetSystemInstanceResponseTypeDef,
    GetSystemTemplateResponseTypeDef,
    GetSystemTemplateRevisionsResponseTypeDef,
    GetUploadStatusResponseTypeDef,
    ListFlowExecutionMessagesResponseTypeDef,
    ListTagsForResourceResponseTypeDef,
    MetricsConfigurationTypeDef,
    PaginatorConfigTypeDef,
    SearchEntitiesResponseTypeDef,
    SearchFlowExecutionsResponseTypeDef,
    SearchFlowTemplatesResponseTypeDef,
    SearchSystemInstancesResponseTypeDef,
    SearchSystemTemplatesResponseTypeDef,
    SearchThingsResponseTypeDef,
    SystemInstanceDescriptionTypeDef,
    SystemInstanceFilterTypeDef,
    SystemInstanceSummaryTypeDef,
    SystemTemplateDescriptionTypeDef,
    SystemTemplateFilterTypeDef,
    SystemTemplateSummaryTypeDef,
    TagTypeDef,
    ThingTypeDef,
    UndeploySystemInstanceResponseTypeDef,
    UpdateFlowTemplateResponseTypeDef,
    UpdateSystemTemplateResponseTypeDef,
    UploadEntityDefinitionsResponseTypeDef,
)

def get_structure() -> DefinitionDocumentTypeDef:
    return {
      ...
    }
```
