/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config;

import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import oracle.pgx.common.util.ConfigJsonUtil;
import oracle.pgx.config.FrontierRedactedVerticesConfig;
import oracle.pgx.config.FrontierRedactedVerticesConfigBuilder;
import oracle.pgx.config.PgxRedactionRuleConfig;

public final class PgxRedactionRuleConfigBuilder {
    private final Map<PgxRedactionRuleConfig.Field, Object> values = new HashMap<PgxRedactionRuleConfig.Field, Object>();

    public static PgxRedactionRuleConfig buildPgxRedactionRuleConfig(Consumer<PgxRedactionRuleConfigBuilder> builderSetup) {
        PgxRedactionRuleConfigBuilder builder = new PgxRedactionRuleConfigBuilder();
        builderSetup.accept(builder);
        return builder.build();
    }

    public PgxRedactionRuleConfigBuilder() {
    }

    public PgxRedactionRuleConfigBuilder(Map<PgxRedactionRuleConfig.Field, Object> values) {
        this.putAll(values);
    }

    public PgxRedactionRuleConfigBuilder(PgxRedactionRuleConfig config) {
        this.putAll(config);
    }

    public PgxRedactionRuleConfigBuilder(PgxRedactionRuleConfigBuilder builder) {
        this.putAll(builder.values);
    }

    public PgxRedactionRuleConfigBuilder putAll(Map<PgxRedactionRuleConfig.Field, Object> values) {
        this.values.putAll(values);
        return this;
    }

    public PgxRedactionRuleConfigBuilder putAll(PgxRedactionRuleConfig config) {
        this.putAll(config.getValuesWithoutDefaults());
        return this;
    }

    public PgxRedactionRuleConfigBuilder clear() {
        this.values.clear();
        return this;
    }

    public PgxRedactionRuleConfig build(String parentPath) {
        try {
            return PgxRedactionRuleConfig.parse(this.toInputStream(), true, parentPath);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    public PgxRedactionRuleConfig build() {
        return this.build(null);
    }

    public InputStream toInputStream() {
        try {
            return ConfigJsonUtil.toJsonInputStream(this.values);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    public Map<PgxRedactionRuleConfig.Field, Object> getValues() {
        return Collections.unmodifiableMap(this.values);
    }

    public String toString() {
        return "PgxRedactionRuleConfigBuilder" + this.values;
    }

    public PgxRedactionRuleConfigBuilder setRuleName(String ruleName) {
        this.values.put(PgxRedactionRuleConfig.Field.RULE_NAME, ruleName);
        return this;
    }

    public PgxRedactionRuleConfigBuilder setRedactVertex(String redactVertex) {
        this.values.put(PgxRedactionRuleConfig.Field.REDACT_VERTEX, redactVertex);
        return this;
    }

    public PgxRedactionRuleConfigBuilder setShowFrontierVertex(FrontierRedactedVerticesConfig showFrontierVertex) {
        this.values.put(PgxRedactionRuleConfig.Field.SHOW_FRONTIER_VERTEX, showFrontierVertex);
        return this;
    }

    public PgxRedactionRuleConfigBuilder setShowFrontierVertex(Consumer<FrontierRedactedVerticesConfigBuilder> showFrontierVertexBuilderSetup) {
        FrontierRedactedVerticesConfigBuilder builder = new FrontierRedactedVerticesConfigBuilder();
        showFrontierVertexBuilderSetup.accept(builder);
        this.setShowFrontierVertex(builder.build());
        return this;
    }

    public PgxRedactionRuleConfigBuilder setRedactEdge(String redactEdge) {
        this.values.put(PgxRedactionRuleConfig.Field.REDACT_EDGE, redactEdge);
        return this;
    }

    public PgxRedactionRuleConfigBuilder setRedactVertexProperties(Object ... redactVertexProperties) {
        this.values.put(PgxRedactionRuleConfig.Field.REDACT_VERTEX_PROPERTIES, redactVertexProperties);
        return this;
    }

    public PgxRedactionRuleConfigBuilder setRedactEdgeProperties(Object ... redactEdgeProperties) {
        this.values.put(PgxRedactionRuleConfig.Field.REDACT_EDGE_PROPERTIES, redactEdgeProperties);
        return this;
    }

    public PgxRedactionRuleConfigBuilder setRedactVertexProperties(List<?> redactVertexProperties) {
        this.values.put(PgxRedactionRuleConfig.Field.REDACT_VERTEX_PROPERTIES, redactVertexProperties);
        return this;
    }

    public PgxRedactionRuleConfigBuilder setRedactEdgeProperties(List<?> redactEdgeProperties) {
        this.values.put(PgxRedactionRuleConfig.Field.REDACT_EDGE_PROPERTIES, redactEdgeProperties);
        return this;
    }

    public PgxRedactionRuleConfigBuilder setLabel(String label) {
        this.values.put(PgxRedactionRuleConfig.Field.LABEL, label);
        return this;
    }

    public PgxRedactionRuleConfigBuilder setProperties(String ... properties) {
        this.values.put(PgxRedactionRuleConfig.Field.PROPERTIES, properties);
        return this;
    }

    public PgxRedactionRuleConfigBuilder setRuleTrigger(String ruleTrigger) {
        this.values.put(PgxRedactionRuleConfig.Field.RULE_TRIGGER, ruleTrigger);
        return this;
    }

    public PgxRedactionRuleConfigBuilder setWithVisibleProperties(String ... withVisibleProperties) {
        this.values.put(PgxRedactionRuleConfig.Field.WITH_VISIBLE_PROPERTIES, withVisibleProperties);
        return this;
    }
}

