/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config;

import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import oracle.pgx.common.types.IdType;
import oracle.pgx.common.util.ConfigJsonUtil;
import oracle.pgx.config.KeyColumnConfig;

public final class KeyColumnConfigBuilder {
    private final Map<KeyColumnConfig.Field, Object> values = new HashMap<KeyColumnConfig.Field, Object>();

    public static KeyColumnConfig buildKeyColumnConfig(Consumer<KeyColumnConfigBuilder> builderSetup) {
        KeyColumnConfigBuilder builder = new KeyColumnConfigBuilder();
        builderSetup.accept(builder);
        return builder.build();
    }

    public KeyColumnConfigBuilder() {
    }

    public KeyColumnConfigBuilder(Map<KeyColumnConfig.Field, Object> values) {
        this.putAll(values);
    }

    public KeyColumnConfigBuilder(KeyColumnConfig config) {
        this.putAll(config);
    }

    public KeyColumnConfigBuilder(KeyColumnConfigBuilder builder) {
        this.putAll(builder.values);
    }

    public KeyColumnConfigBuilder putAll(Map<KeyColumnConfig.Field, Object> values) {
        this.values.putAll(values);
        return this;
    }

    public KeyColumnConfigBuilder putAll(KeyColumnConfig config) {
        this.putAll(config.getValuesWithoutDefaults());
        return this;
    }

    public KeyColumnConfigBuilder clear() {
        this.values.clear();
        return this;
    }

    public KeyColumnConfig build(String parentPath) {
        try {
            return KeyColumnConfig.parse(this.toInputStream(), true, parentPath);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    public KeyColumnConfig build() {
        return this.build(null);
    }

    public InputStream toInputStream() {
        try {
            return ConfigJsonUtil.toJsonInputStream(this.values);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    public Map<KeyColumnConfig.Field, Object> getValues() {
        return Collections.unmodifiableMap(this.values);
    }

    public String toString() {
        return "KeyColumnConfigBuilder" + this.values;
    }

    public KeyColumnConfigBuilder setName(String name) {
        this.values.put(KeyColumnConfig.Field.NAME, name);
        return this;
    }

    public KeyColumnConfigBuilder setType(IdType type) {
        this.values.put(KeyColumnConfig.Field.TYPE, type);
        return this;
    }
}

