/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import oracle.pgx.api.beta.annotation.BetaApi;
import oracle.pgx.api.keys.ForeignKeyColumnDescriptor;
import oracle.pgx.common.types.IdType;
import oracle.pgx.config.AbstractEntityProviderConfigBuilder;
import oracle.pgx.config.FileEntityProviderConfig;
import oracle.pgx.config.FileGraphStoringConfig;
import oracle.pgx.config.ProviderFormat;
import oracle.pgx.config.ProviderLoadingConfig;
import oracle.pgx.config.internal.ConfigUtils;

public class FileEntityProviderConfigBuilder
extends AbstractEntityProviderConfigBuilder<FileEntityProviderConfigBuilder, FileEntityProviderConfig> {
    private final List<String> uriList = new ArrayList<String>();

    public FileEntityProviderConfigBuilder() {
        this.values.put(FileEntityProviderConfig.Field.URIS.toKey(), this.uriList);
    }

    public FileEntityProviderConfigBuilder(ProviderFormat format) {
        this();
        this.setFormat(format);
    }

    @Override
    public FileEntityProviderConfigBuilder toEntityProviderConfigBuilder() {
        return this;
    }

    @Override
    protected void addDefaultIdTypeIfMissing(Map<String, Object> raw) {
        Function<String, Object> valGetter = raw::get;
        if (!this.hasValue(FileEntityProviderConfig.Field.KEY_TYPE, valGetter)) {
            boolean isEdgeTable = this.hasValue(FileEntityProviderConfig.Field.SOURCE_VERTEX_PROVIDER, valGetter) && this.hasValue(FileEntityProviderConfig.Field.DESTINATION_VERTEX_PROVIDER, valGetter);
            IdType defaultKeyType = isEdgeTable ? IdType.LONG : IdType.INTEGER;
            raw.put(FileEntityProviderConfig.Field.KEY_TYPE.toKey(), defaultKeyType);
        }
    }

    @Override
    protected void addDefaultCreateIndexMappingIfMissing(Map<String, Object> raw) {
        boolean createIndexMapping;
        Function<String, Object> valGetter = raw::get;
        boolean isEdgeTable = this.hasValue(FileEntityProviderConfig.Field.SOURCE_VERTEX_PROVIDER, valGetter) && this.hasValue(FileEntityProviderConfig.Field.DESTINATION_VERTEX_PROVIDER, valGetter);
        boolean bl = createIndexMapping = !isEdgeTable;
        if (!this.hasValue(FileEntityProviderConfig.Field.LOADING, valGetter)) {
            raw.put(FileEntityProviderConfig.Field.LOADING.toKey(), new LinkedHashMap());
        }
        Object loadingSectionObject = valGetter.apply(FileEntityProviderConfig.Field.LOADING.toKey());
        Map loadingSection = (Map)loadingSectionObject;
        loadingSection.putIfAbsent(ProviderLoadingConfig.Field.CREATE_KEY_MAPPING.toKey(), createIndexMapping);
    }

    @Override
    protected FileEntityProviderConfig parseTableConfig(InputStream is) throws IOException {
        return FileEntityProviderConfig.parse(is, true, null, true);
    }

    @Override
    public FileEntityProviderConfigBuilder copyFrom(FileEntityProviderConfig tableConfig) {
        super.copyFrom(tableConfig);
        this.setSeparator(tableConfig.getSeparator());
        this.hasHeader(tableConfig.isHeader());
        this.setUris(tableConfig.getUris());
        this.setStoring(tableConfig.getStoring());
        this.setHasKeys(tableConfig.hasKeys());
        if (!tableConfig.hasDefaultValue(FileEntityProviderConfig.Field.KEY_COLUMN)) {
            this.setKeyColumn(tableConfig.getKeyColumn());
        }
        if (!tableConfig.hasDefaultValue(FileEntityProviderConfig.Field.SOURCE_COLUMN)) {
            this.setSourceColumn(tableConfig.getSourceColumn());
        }
        if (!tableConfig.hasDefaultValue(FileEntityProviderConfig.Field.DESTINATION_COLUMN)) {
            this.setDestinationColumn(tableConfig.getDestinationColumn());
        }
        if (!tableConfig.hasDefaultValue(FileEntityProviderConfig.Field.SOURCE_KEY_COLUMNS)) {
            this.setSourceKeyColumns(tableConfig.getSourceKeyColumns());
        }
        if (!tableConfig.hasDefaultValue(FileEntityProviderConfig.Field.DESTINATION_KEY_COLUMNS)) {
            this.setDestinationKeyColumns(tableConfig.getDestinationKeyColumns());
        }
        return (FileEntityProviderConfigBuilder)this.getThis();
    }

    public FileEntityProviderConfigBuilder setFormat(ProviderFormat format) {
        this.values.put(FileEntityProviderConfig.Field.FORMAT.toKey(), format.toString());
        return (FileEntityProviderConfigBuilder)this.getThis();
    }

    public FileEntityProviderConfigBuilder setSeparator(String separator) {
        this.values.put(FileEntityProviderConfig.Field.SEPARATOR.toKey(), separator);
        return (FileEntityProviderConfigBuilder)this.getThis();
    }

    public FileEntityProviderConfigBuilder hasHeader(boolean hasHeader) {
        this.values.put(FileEntityProviderConfig.Field.HEADER.toKey(), hasHeader);
        return (FileEntityProviderConfigBuilder)this.getThis();
    }

    public FileEntityProviderConfigBuilder detectGzip(boolean detectGzip) {
        this.values.put(FileEntityProviderConfig.Field.DETECT_GZIP.toKey(), detectGzip);
        return (FileEntityProviderConfigBuilder)this.getThis();
    }

    public FileEntityProviderConfigBuilder addUri(String uri) {
        this.uriList.add(uri);
        return (FileEntityProviderConfigBuilder)this.getThis();
    }

    public FileEntityProviderConfigBuilder setUris(Iterable<String> uris) {
        this.uriList.clear();
        uris.forEach(this.uriList::add);
        return (FileEntityProviderConfigBuilder)this.getThis();
    }

    public FileEntityProviderConfigBuilder setUris(String ... uris) {
        this.uriList.clear();
        Arrays.stream(uris).forEach(this.uriList::add);
        return (FileEntityProviderConfigBuilder)this.getThis();
    }

    public FileEntityProviderConfigBuilder setVectorComponentDelimiter(Character delimiter) {
        this.values.put(FileEntityProviderConfig.Field.VECTOR_COMPONENT_DELIMITER.toKey(), delimiter);
        return (FileEntityProviderConfigBuilder)this.getThis();
    }

    public FileEntityProviderConfigBuilder setStoringOptions(FileGraphStoringConfig storing) {
        this.values.put(FileEntityProviderConfig.Field.STORING.toKey(), storing);
        return (FileEntityProviderConfigBuilder)this.getThis();
    }

    @Deprecated
    public FileEntityProviderConfigBuilder setStoring(FileGraphStoringConfig storing) {
        return this.setStoringOptions(storing);
    }

    public FileEntityProviderConfigBuilder setKeyColumn(Object column) {
        this.values.put(FileEntityProviderConfig.Field.KEY_COLUMN.toKey(), column);
        return (FileEntityProviderConfigBuilder)this.getThis();
    }

    public FileEntityProviderConfigBuilder setSourceColumn(Object column) {
        this.values.put(FileEntityProviderConfig.Field.SOURCE_COLUMN.toKey(), column);
        return (FileEntityProviderConfigBuilder)this.getThis();
    }

    @BetaApi
    public FileEntityProviderConfigBuilder setSourceKeyColumns(List<? extends ForeignKeyColumnDescriptor> sourceKeyColumns) {
        this.values.put(FileEntityProviderConfig.Field.SOURCE_KEY_COLUMNS.toKey(), ConfigUtils.asForeignKeyColumnConfigs(sourceKeyColumns));
        return this;
    }

    public FileEntityProviderConfigBuilder setDestinationColumn(Object column) {
        this.values.put(FileEntityProviderConfig.Field.DESTINATION_COLUMN.toKey(), column);
        return (FileEntityProviderConfigBuilder)this.getThis();
    }

    @BetaApi
    public FileEntityProviderConfigBuilder setDestinationKeyColumns(List<? extends ForeignKeyColumnDescriptor> destinationKeyColumns) {
        this.values.put(FileEntityProviderConfig.Field.DESTINATION_KEY_COLUMNS.toKey(), ConfigUtils.asForeignKeyColumnConfigs(destinationKeyColumns));
        return this;
    }
}

