/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.mllib;

import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import oracle.pgx.api.PgxFuture;
import oracle.pgx.api.PgxSession;
import oracle.pgx.api.internal.Core;
import oracle.pgx.api.mllib.Model;
import oracle.pgx.config.internal.ConfigUtils;
import oracle.pgx.config.mllib.ModelKind;
import oracle.pgx.config.mllib.ModelStoringConfiguration;

public abstract class ModelStorer<StoredModelType extends Model<StoredModelType>, ModelStorerType extends ModelStorer<StoredModelType, ?>> {
    protected final PgxSession session;
    protected final Core core;
    protected final Supplier<String> keystorePathSupplier;
    protected final Supplier<char[]> keystorePasswordSupplier;
    protected final ModelKind modelKind;
    protected final StoredModelType model;
    protected boolean overwrite;

    public ModelStorer(PgxSession session, Core core, StoredModelType model, Supplier<String> keystorePathSupplier, Supplier<char[]> keystorePasswordSupplier) {
        this.session = session;
        this.core = core;
        this.keystorePathSupplier = keystorePathSupplier;
        this.keystorePasswordSupplier = keystorePasswordSupplier;
        this.model = model;
        this.modelKind = ((Model)model).getModelKind();
    }

    protected abstract ModelStorerType getThis();

    public ModelStorerType overwrite(boolean overwrite) {
        this.overwrite = overwrite;
        return this.getThis();
    }

    public abstract PgxFuture<Void> storeAsync();

    public void store() throws ExecutionException, InterruptedException {
        this.storeAsync().get();
    }

    protected final PgxFuture<Void> triggerStoreAsync(ModelStoringConfiguration config) {
        config.setOverwrite(this.overwrite);
        try {
            if (this.keystorePathSupplier != null && this.keystorePasswordSupplier != null) {
                ConfigUtils.modifyModelStoringConfigWithCredentials((String)this.keystorePathSupplier.get(), (char[])this.keystorePasswordSupplier.get(), (ModelStoringConfiguration)config);
            }
        }
        catch (Exception e) {
            return PgxFuture.exceptionallyCompletedFuture(e);
        }
        return this.core.storeModel(this.session.getSessionContext(), ((Model)this.model).getModelName(), config);
    }
}

