/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Arrays;
import oracle.pgx.api.internal.ApiObject;
import oracle.pgx.common.types.PropertyType;
import oracle.pgx.common.util.ErrorMessages;
import oracle.pgx.common.util.vector.Vect;

public final class PgxVect<E>
extends ApiObject
implements Comparable<PgxVect<E>>,
Vect<E> {
    @JsonSerialize
    private E[] vect;
    private final PropertyType type;

    public PgxVect(E[] vector) {
        if (vector.length == 0) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"INVALID_VECTOR_DIMENSION", (Object[])new Object[0]));
        }
        Class<?> clazz = vector.getClass().getComponentType();
        try {
            this.type = PropertyType.getTypeFor(clazz);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"INVALID_VECTOR_TYPE", (Object[])new Object[]{clazz}), e);
        }
        if (!this.type.isNumericType()) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"INVALID_VECTOR_TYPE", (Object[])new Object[]{this.type}));
        }
        for (E aVector : vector) {
            if (aVector != null) continue;
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"NULL_VECTOR_VALUE", (Object[])new Object[0]));
        }
        this.vect = Arrays.copyOf(vector, vector.length);
    }

    @JsonCreator
    public PgxVect(@JsonProperty(value="vect") E[] vector, @JsonProperty(value="type") PropertyType type) {
        if (vector.length == 0) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"INVALID_VECTOR_DIMENSION", (Object[])new Object[0]));
        }
        if (!type.isNumericType()) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"INVALID_VECTOR_TYPE", (Object[])new Object[]{type}));
        }
        this.type = type;
        this.setInnerArray(vector);
    }

    private void setInnerArray(E[] vector) {
        switch (this.type) {
            case INTEGER: {
                this.vect = new Integer[vector.length];
                for (int i = 0; i < vector.length; ++i) {
                    if (vector[i] == null) {
                        throw new IllegalArgumentException(ErrorMessages.getMessage((String)"NULL_VECTOR_VALUE", (Object[])new Object[0]));
                    }
                    if (!(vector[i] instanceof Number)) {
                        throw new IllegalArgumentException(ErrorMessages.getMessage((String)"INVALID_VECTOR_TYPE", (Object[])new Object[]{vector[i].getClass()}));
                    }
                    this.set(i, ((Number)vector[i]).intValue());
                }
                break;
            }
            case DOUBLE: {
                this.vect = new Double[vector.length];
                for (int i = 0; i < vector.length; ++i) {
                    if (vector[i] == null) {
                        throw new IllegalArgumentException(ErrorMessages.getMessage((String)"NULL_VECTOR_VALUE", (Object[])new Object[0]));
                    }
                    if (!(vector[i] instanceof Number)) {
                        throw new IllegalArgumentException(ErrorMessages.getMessage((String)"INVALID_VECTOR_TYPE", (Object[])new Object[]{vector[i].getClass()}));
                    }
                    this.set(i, ((Number)vector[i]).doubleValue());
                }
                break;
            }
            case FLOAT: {
                this.vect = new Float[vector.length];
                for (int i = 0; i < vector.length; ++i) {
                    if (vector[i] == null) {
                        throw new IllegalArgumentException(ErrorMessages.getMessage((String)"NULL_VECTOR_VALUE", (Object[])new Object[0]));
                    }
                    if (!(vector[i] instanceof Number)) {
                        throw new IllegalArgumentException(ErrorMessages.getMessage((String)"INVALID_VECTOR_TYPE", (Object[])new Object[]{vector[i].getClass()}));
                    }
                    this.set(i, Float.valueOf(((Number)vector[i]).floatValue()));
                }
                break;
            }
            case LONG: {
                this.vect = new Long[vector.length];
                for (int i = 0; i < vector.length; ++i) {
                    if (vector[i] == null) {
                        throw new IllegalArgumentException(ErrorMessages.getMessage((String)"NULL_VECTOR_VALUE", (Object[])new Object[0]));
                    }
                    if (!(vector[i] instanceof Number)) {
                        throw new IllegalArgumentException(ErrorMessages.getMessage((String)"INVALID_VECTOR_TYPE", (Object[])new Object[]{vector[i].getClass()}));
                    }
                    this.set(i, ((Number)vector[i]).longValue());
                }
                break;
            }
            default: {
                throw new IllegalArgumentException(ErrorMessages.getMessage((String)"INVALID_VECTOR_TYPE", (Object[])new Object[]{this.type}));
            }
        }
    }

    @JsonIgnore
    public int getDimension() {
        return this.vect.length;
    }

    public E[] toArray() {
        return Arrays.copyOf(this.vect, this.vect.length);
    }

    public E get(int index) {
        if (index < 0 || index >= this.getDimension()) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"INVALID_VECTOR_INDEX", (Object[])new Object[0]));
        }
        return this.vect[index];
    }

    public void set(int index, E value) {
        if (value == null) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"NULL_VECTOR_VALUE", (Object[])new Object[0]));
        }
        if (index < 0 || index >= this.getDimension()) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"INVALID_VECTOR_INDEX", (Object[])new Object[0]));
        }
        this.vect[index] = value;
    }

    @Override
    public int compareTo(PgxVect<E> other) {
        throw new UnsupportedOperationException(ErrorMessages.getMessage((String)"INVALID_VECTOR_COMPARISON", (Object[])new Object[0]));
    }

    public PropertyType getType() {
        return this.type;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PgxVect)) {
            return false;
        }
        PgxVect that = (PgxVect)obj;
        return Arrays.equals(this.vect, that.vect);
    }

    public int hashCode() {
        return Arrays.hashCode(this.vect);
    }

    public String toString() {
        return this.toString(PgxVect.entry("type", this.getType().toKey()), PgxVect.entry("dimension", this.getDimension()));
    }
}

