/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.jdbc.compat;

import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import oracle.pgx.jdbc.Util;
import oracle.pgx.jdbc.compat.CompatMode;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPTZ;

public class OracleJdbc19CompatMode
extends CompatMode {
    @Override
    protected Object convertBoolean(Boolean b) {
        return BigDecimal.valueOf(b != false ? 1L : 0L);
    }

    @Override
    protected Object convertInteger(Integer i) {
        return BigDecimal.valueOf(i.longValue());
    }

    @Override
    protected Object convertFloat(Float f) {
        return new BigDecimal(f.toString());
    }

    @Override
    protected Object convertLong(Long l) {
        return BigDecimal.valueOf(l);
    }

    @Override
    protected Object convertDouble(Double d) {
        return BigDecimal.valueOf(d);
    }

    @Override
    protected Object convertDate(LocalDate date) {
        return Timestamp.valueOf(date.atStartOfDay());
    }

    @Override
    protected Object convertTime(LocalTime time) throws SQLException {
        throw new SQLFeatureNotSupportedException("retrieving LocalTime via getObject() not supported in Oracle JDBC compatibility mode");
    }

    @Override
    protected Object convertTimeWithTimezone(OffsetTime time) throws SQLException {
        throw new SQLFeatureNotSupportedException("retrieving OffsetTime via getObject() not supported in Oracle JDBC compatibility mode");
    }

    @Override
    protected Object convertTimestamp(LocalDateTime dateTime) {
        return new TIMESTAMP(Timestamp.valueOf(dateTime));
    }

    @Override
    protected Object convertTimestampWithTimezone(OffsetDateTime dateTime) throws SQLException {
        return new TIMESTAMPTZ(Util.toBytes(dateTime));
    }
}

