/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms.pgql;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import oracle.pg.rdbms.pgql.GraphType;
import oracle.pg.rdbms.pgql.PgqlConnection;
import oracle.pg.rdbms.pgql.PgqlSqlTrans;
import oracle.pg.rdbms.pgql.PgqlToSqlException;
import oracle.pg.rdbms.pgql.PgqlUtils;
import oracle.pgql.lang.ddl.CallStatement;
import oracle.pgql.lang.ir.QueryExpression;
import oracle.pgql.lang.ir.SchemaQualifiedName;

public class PgqlExecuteCallStatement
implements PgqlSqlTrans {
    private PgqlConnection pgqlConn;
    private CallStatement callStatement;

    public PgqlExecuteCallStatement(PgqlConnection pgqlConn, CallStatement callStatement) {
        this.pgqlConn = pgqlConn;
        this.callStatement = callStatement;
    }

    public void execute() {
        block3 : switch (this.callStatement.getPackageName()) {
            case "PG": {
                switch (this.callStatement.getRoutineName()) {
                    case "VALIDATE": {
                        SchemaQualifiedName schemaQualifiedName = this.verifyValidateParams();
                        this.executeValidate(schemaQualifiedName);
                        break block3;
                    }
                    case "MIGRATE_PGQL_TO_SQL": {
                        this.executeMigratePgqlToSql();
                        break block3;
                    }
                }
                throw new PgqlToSqlException("Function " + this.callStatement.getPackageName() + "." + this.callStatement.getRoutineName() + " does not exist");
            }
            default: {
                throw new PgqlToSqlException("Package " + this.callStatement.getPackageName() + " does not exist");
            }
        }
    }

    private void executeMigratePgqlToSql() {
        String newGraphName;
        int size = this.callStatement.getArgumentList().size();
        if (size != 2 && size != 4) {
            throw new PgqlToSqlException("Invalid number of parameters for " + this.callStatement.getPackageName() + "." + this.callStatement.getRoutineName());
        }
        String owner = (String)((QueryExpression.Constant.ConstString)this.callStatement.getArgumentList().get(0)).getValue();
        String graphName = (String)((QueryExpression.Constant.ConstString)this.callStatement.getArgumentList().get(1)).getValue();
        String newOwner = size == 4 ? (String)((QueryExpression.Constant.ConstString)this.callStatement.getArgumentList().get(2)).getValue() : "";
        String string = newGraphName = size == 4 ? (String)((QueryExpression.Constant.ConstString)this.callStatement.getArgumentList().get(3)).getValue() : "";
        if (newGraphName.length() > 128) {
            throw new PgqlToSqlException("The provided graph name " + newGraphName + " exceeds the maximum length of 128 bytes.");
        }
        if (newOwner.equals(owner) && newGraphName.equals(graphName)) {
            throw new PgqlToSqlException("The new graph name and original graph name cannot be the same.");
        }
        try (PreparedStatement ps = this.pgqlConn.getJdbcConnection().prepareStatement(this.migratePgqlToSql());){
            ps.setString(1, graphName);
            ps.setString(2, owner);
            ps.setString(3, newGraphName);
            ps.setString(4, newOwner);
            ps.execute();
        }
        catch (SQLException ex) {
            throw new PgqlToSqlException(ex.getMessage());
        }
    }

    private SchemaQualifiedName verifyValidateParams() {
        String graphName;
        String graphSchema = this.pgqlConn.getSchema();
        switch (this.callStatement.getArgumentList().size()) {
            case 1: {
                graphName = (String)((QueryExpression.Constant.ConstString)this.callStatement.getArgumentList().get(0)).getValue();
                break;
            }
            case 2: {
                graphSchema = (String)((QueryExpression.Constant.ConstString)this.callStatement.getArgumentList().get(0)).getValue();
                graphName = (String)((QueryExpression.Constant.ConstString)this.callStatement.getArgumentList().get(1)).getValue();
                break;
            }
            default: {
                throw new PgqlToSqlException("Invalid number of parameters for " + this.callStatement.getPackageName() + "." + this.callStatement.getRoutineName());
            }
        }
        GraphType graphType = PgqlUtils.getGraphType(this.pgqlConn.getJdbcConnection(), graphSchema, graphName, true, false, false);
        SchemaQualifiedName schemaQualifiedName = new SchemaQualifiedName(graphSchema, graphName);
        if (graphType == null) {
            throw new PgqlToSqlException("Graph " + schemaQualifiedName + " does not exist");
        }
        if (graphType != GraphType.PG_VIEWS) {
            throw new PgqlToSqlException("Graph " + schemaQualifiedName + " is a " + (Object)((Object)graphType) + " graph, only PG_PGQL graphs are allowed for PG.VALIDATE() CALL");
        }
        return schemaQualifiedName;
    }

    private void executeValidate(SchemaQualifiedName schemaQualifiedName) {
        block2: {
            try {
                PreparedStatement ps = this.pgqlConn.getJdbcConnection().prepareStatement(this.validatePlSql());
                ps.setString(1, schemaQualifiedName.getSchemaName());
                ps.setString(2, schemaQualifiedName.getName());
                ps.execute();
            }
            catch (SQLException ex) {
                if (ex.getErrorCode() != 20001) break block2;
                String message = ex.getMessage();
                throw new PgqlToSqlException(ex.getMessage().substring(message.indexOf("ORA-20001: ") + "ORA-20001: ".length(), message.indexOf("\n")));
            }
        }
    }

    private String migratePgqlToSql() {
        return "DECLARE\n    graphname         VARCHAR2(128) := ?;\n    owner             VARCHAR2(128) := ?;\n    newgraphname      VARCHAR2(128) := ?;\n    newowner          VARCHAR2(128) := ?;\n    \n    invalid_identifier EXCEPTION;\n    PRAGMA EXCEPTION_INIT(invalid_identifier, -904);\n    -- key table\n    TYPE keyrowtype IS RECORD (\n        column_name VARCHAR2(128)\n    );\n    TYPE keytabletype IS\n        TABLE OF keyrowtype;\n    my_key_table      keytabletype := keytabletype();\n    \n    -- src dst key for edges\n    TYPE srcdstkeyrowtype IS RECORD (\n            vt_name        VARCHAR(128),\n            et_column_name VARCHAR(128),\n            vt_column_name VARCHAR(128) DEFAULT NULL\n    );\n    TYPE srcdstkeytabletype IS\n        TABLE OF srcdstkeyrowtype;\n    my_srckey_table   srcdstkeytabletype := srcdstkeytabletype();\n    my_dstkey_table   srcdstkeytabletype := srcdstkeytabletype();\n    \n    -- labels\n    my_label          VARCHAR(128);\n    \n    -- properties\n    TYPE propertyrowtype IS RECORD (\n            property_name VARCHAR(128),\n            column_name   VARCHAR(128)\n    );\n    TYPE propertytabletype IS\n        TABLE OF propertyrowtype;\n    my_property_table propertytabletype := propertytabletype();\n    \n    -- Element tables\n    TYPE elemrowtype IS RECORD (\n            et_name     VARCHAR(128),\n            schema_name VARCHAR(128),\n            table_name  VARCHAR(128)\n    );\n    TYPE elemtabletype IS\n        TABLE OF elemrowtype;\n    my_element_table  elemtabletype := elemtabletype();   \n    \n    -- Metadata tables\n    TYPE metadatarowtype IS RECORD (\n            owner      VARCHAR(128),\n            table_name VARCHAR(128)\n    );\n    TYPE metadatatabletype IS\n        TABLE OF metadatarowtype;\n    my_metadata_table metadatatabletype := metadatatabletype();\n    my_type           VARCHAR(10);\n    v_sql_tmp         CLOB := '';\n    v_num_views       NUMBER := 0;\n    v_owner           VARCHAR(128);\n    v_key_tmp         CLOB := '';\nBEGIN\n    EXECUTE IMMEDIATE 'SELECT OWNER, TABLE_NAME FROM ALL_TABLES WHERE OWNER=:1 AND TABLE_NAME IN ( :2, :3, :4, :5, :6)'\n    BULK COLLECT\n    INTO my_metadata_table\n        USING owner, graphname || '_PGQL_ELEM_TABLE$', graphname || '_PGQL_KEY$', graphname || '_PGQL_LABEL$', graphname || '_PGQL_SRC_DST_KEY$'\n        , graphname || '_PGQL_PROPERTY$';\n\n    IF my_metadata_table.count <> 5 THEN\n        FOR z IN 1..my_metadata_table.count LOOP\n            EXECUTE IMMEDIATE 'ALTER TABLE  '\n                              || sys.dbms_assert.enquote_name(my_metadata_table(z).owner, FALSE)\n                              || '.'\n                              || sys.dbms_assert.enquote_name(my_metadata_table(z).table_name, FALSE)\n                              || ' RENAME TO '\n                              || sys.dbms_assert.enquote_name(graphname\n                                                              || substr(my_metadata_table(z).table_name, instr(my_metadata_table(z).table_name\n                                                              , '_PGQL', -1, 1) + 5), FALSE);\n        END LOOP;\n\n    END IF;\n    v_owner := sys.dbms_assert.enquote_name(owner, FALSE);\n    FOR j IN 1..2 LOOP\n        IF j = 1 THEN\n            my_type := 'VERTEX';\n        END IF;\n        IF j = 2 THEN\n            EXECUTE IMMEDIATE 'SELECT count(*) FROM '\n                              || v_owner\n                              || '.'\n                              || sys.dbms_assert.enquote_name(graphname || '_ELEM_TABLE$', FALSE)\n                              || ' WHERE et_type=''EDGE'''\n            INTO v_num_views;\n\n            IF v_num_views = 0 THEN\n                EXIT;\n            END IF;\n            my_type := 'EDGE';\n        END IF;\n\n        v_sql_tmp := v_sql_tmp\n                     || '  '\n                     || my_type\n                     || ' TABLES ('\n                     || chr(10);\n\n        BEGIN\n            EXECUTE IMMEDIATE 'SELECT COUNT(*) FROM ALL_TABLES WHERE owner=:1 AND table_name=:2'\n            INTO v_num_views\n                USING owner, graphname || '_ELEM_TABLE$';\n            IF v_num_views = 0 THEN\n                raise_application_error(-20002, 'Graph '\n                                                || v_owner\n                                                || '.'\n                                                || sys.dbms_assert.enquote_name(graphname, FALSE)\n                                                || ' does not exist.');\n\n            END IF;\n\n        END;\n\n        EXECUTE IMMEDIATE 'SELECT et_name, schema_name, table_name FROM '\n                          || v_owner\n                          || '.'\n                          || sys.dbms_assert.enquote_name(graphname || '_ELEM_TABLE$', FALSE)\n                          || ' WHERE et_type=:1'\n        BULK COLLECT\n        INTO my_element_table\n            USING my_type;\n\n        FOR k IN 1..my_element_table.count LOOP\n            EXECUTE IMMEDIATE 'SELECT COUNT(*) FROM SYS.ALL_VIEWS WHERE owner=:1 AND view_name=:2'\n            INTO v_num_views\n                USING my_element_table(k).schema_name, my_element_table(k).table_name;\n\n            IF v_num_views <> 0 THEN\n                -- add element table in the errror message\n                raise_application_error(-20001, 'Element table '\n                                                || my_element_table(k).schema_name\n                                                || '.'\n                                                || my_element_table(k).table_name\n                                                || ' is a view but views cannot be used underneath SQL property graphs.'\n                                                || ' Consider materializing the view before migrating to SQL.');\n\n            END IF;\n\n        END LOOP;\n\n        FOR k IN 1..my_element_table.count LOOP\n            v_sql_tmp := v_sql_tmp\n                         || '   '\n                         || sys.dbms_assert.enquote_name(my_element_table(k).schema_name, FALSE)\n                         || '.'\n                         || sys.dbms_assert.enquote_name(my_element_table(k).table_name, FALSE)\n                         || ' AS '\n                         || sys.dbms_assert.enquote_name(my_element_table(k).et_name, FALSE)\n                         || chr(10);\n\n            v_sql_tmp := v_sql_tmp || '    KEY(';\n        -- get keys\n            EXECUTE IMMEDIATE 'SELECT COLUMN_NAME FROM '\n                              || v_owner\n                              || '.'\n                              || sys.dbms_assert.enquote_name(graphname || '_KEY$', FALSE)\n                              || ' WHERE KEY_TYPE=:1 AND ET_NAME=:2 ORDER BY COLUMN_NUMBER ASC'\n            BULK COLLECT\n            INTO my_key_table\n                USING my_type, my_element_table(k).et_name;\n\n            FOR i IN 1..my_key_table.count LOOP\n                v_sql_tmp := v_sql_tmp\n                             || sys.dbms_assert.enquote_name(my_key_table(i).column_name, FALSE);\n\n                IF i <> my_key_table.count THEN\n                    v_sql_tmp := v_sql_tmp || ', ';\n                END IF;\n\n            END LOOP;\n\n            v_sql_tmp := v_sql_tmp\n                         || ')'\n                         || chr(10);\n        \n        -- get source and destination when working with edges\n            IF my_type = 'EDGE' THEN\n            \n            --source\n            BEGIN                EXECUTE IMMEDIATE 'SELECT vt_name, et_column_name, vt_column_name FROM '\n                                  || v_owner\n                                  || '.'\n                                  || sys.dbms_assert.enquote_name(graphname || '_SRC_DST_KEY$', FALSE)\n                                  || ' WHERE ET_NAME=:1 AND KEY_TYPE=''EDGE_SOURCE'' ORDER BY et_column_number ASC'\n                BULK COLLECT\n                INTO my_srckey_table\n                    USING my_element_table(k).et_name;\n\n                v_sql_tmp := v_sql_tmp || '    SOURCE KEY(';\n                FOR i IN 1..my_srckey_table.count LOOP\n                    v_sql_tmp := v_sql_tmp\n                                 || sys.dbms_assert.enquote_name(my_srckey_table(i).et_column_name, FALSE);\n\n                    v_key_tmp := v_key_tmp\n                                 || sys.dbms_assert.enquote_name(my_srckey_table(i).vt_column_name, FALSE);\n\n                    IF i <> my_srckey_table.count THEN\n                        v_sql_tmp := v_sql_tmp || ', ';\n                        v_key_tmp := v_key_tmp || ', ';\n                    END IF;\n\n                END LOOP;\n\n                v_sql_tmp := v_sql_tmp\n                             || ') REFERENCES '\n                             || sys.dbms_assert.enquote_name(my_srckey_table(1).vt_name, FALSE)\n                             || ' ('\n                             || v_key_tmp\n                             || ')'\n                             || chr(10);\n                v_key_tmp := '';\n            EXCEPTION                 WHEN invalid_identifier THEN                 EXECUTE IMMEDIATE 'SELECT vt_name, et_column_name, NULL as vt_column_name FROM '\n                                  || v_owner\n                                  || '.'\n                                  || sys.dbms_assert.enquote_name(graphname || '_SRC_DST_KEY$', FALSE)\n                                  || ' WHERE ET_NAME=:1 AND KEY_TYPE=''EDGE_SOURCE'' ORDER BY et_column_number ASC'\n                BULK COLLECT\n                INTO my_srckey_table\n                    USING my_element_table(k).et_name;\n\n                v_sql_tmp := v_sql_tmp || '    SOURCE KEY(';\n                FOR i IN 1..my_srckey_table.count LOOP\n                    v_sql_tmp := v_sql_tmp\n                                 || sys.dbms_assert.enquote_name(my_srckey_table(i).et_column_name, FALSE);\n\n                    IF i <> my_srckey_table.count THEN\n                        v_sql_tmp := v_sql_tmp || ', ';\n                    END IF;\n\n                END LOOP;\n\n                v_sql_tmp := v_sql_tmp\n                             || ') REFERENCES '\n                             || sys.dbms_assert.enquote_name(my_srckey_table(1).vt_name, FALSE)\n                             || ' (';\n\n                EXECUTE IMMEDIATE 'SELECT COLUMN_NAME FROM '\n                                  || v_owner\n                                  || '.'\n                                  || sys.dbms_assert.enquote_name(graphname || '_KEY$', FALSE)\n                                  || ' WHERE KEY_TYPE=''VERTEX'' AND ET_NAME=:1 ORDER BY COLUMN_NUMBER ASC'\n                BULK COLLECT\n                INTO my_key_table\n                    USING my_srckey_table(1).vt_name;\n\n                FOR i IN 1..my_key_table.count LOOP\n                    v_sql_tmp := v_sql_tmp\n                                 || sys.dbms_assert.enquote_name(my_key_table(i).column_name, FALSE);\n\n                    IF i <> my_key_table.count THEN\n                        v_sql_tmp := v_sql_tmp || ', ';\n                    END IF;\n\n                END LOOP;\n\n                v_sql_tmp := v_sql_tmp\n                             || ')'\n                             || chr(10);\n            \n            END;             \n            \n            --destination\n            BEGIN                EXECUTE IMMEDIATE 'SELECT vt_name, et_column_name, vt_column_name FROM '\n                                  || v_owner\n                                  || '.'\n                                  || sys.dbms_assert.enquote_name(graphname || '_SRC_DST_KEY$', FALSE)\n                                  || ' WHERE ET_NAME=:1 AND KEY_TYPE=''EDGE_DESTINATION'' ORDER BY et_column_number ASC'\n                BULK COLLECT\n                INTO my_dstkey_table\n                    USING my_element_table(k).et_name;\n\n                v_sql_tmp := v_sql_tmp || '    DESTINATION KEY(';\n                FOR i IN 1..my_dstkey_table.count LOOP\n                    v_sql_tmp := v_sql_tmp\n                                 || sys.dbms_assert.enquote_name(my_dstkey_table(i).et_column_name, FALSE);\n\n                    v_key_tmp := v_key_tmp\n                                 || sys.dbms_assert.enquote_name(my_dstkey_table(i).vt_column_name, FALSE);\n\n                    IF i <> my_dstkey_table.count THEN\n                        v_sql_tmp := v_sql_tmp || ', ';\n                        v_key_tmp := v_key_tmp || ', ';\n                    END IF;\n\n                END LOOP;\n\n                v_sql_tmp := v_sql_tmp\n                             || ') REFERENCES '\n                             || sys.dbms_assert.enquote_name(my_dstkey_table(1).vt_name, FALSE)\n                             || ' ('\n                             || v_key_tmp\n                             || ')'\n                             || chr(10);\n                v_key_tmp :='';\n            EXCEPTION                 WHEN invalid_identifier THEN                 EXECUTE IMMEDIATE 'SELECT vt_name, et_column_name, NULL as vt_column_name FROM '\n                                  || v_owner\n                                  || '.'\n                                  || sys.dbms_assert.enquote_name(graphname || '_SRC_DST_KEY$', FALSE)\n                                  || ' WHERE ET_NAME=:1 AND KEY_TYPE=''EDGE_DESTINATION'' ORDER BY et_column_number ASC'\n                BULK COLLECT\n                INTO my_dstkey_table\n                    USING my_element_table(k).et_name;\n\n                v_sql_tmp := v_sql_tmp || '    DESTINATION KEY(';\n                FOR i IN 1..my_dstkey_table.count LOOP\n                    v_sql_tmp := v_sql_tmp\n                                 || sys.dbms_assert.enquote_name(my_dstkey_table(i).et_column_name, FALSE);\n\n                    IF i <> my_dstkey_table.count THEN\n                        v_sql_tmp := v_sql_tmp || ', ';\n                    END IF;\n\n                END LOOP;\n\n                v_sql_tmp := v_sql_tmp\n                             || ') REFERENCES '\n                             || sys.dbms_assert.enquote_name(my_dstkey_table(1).vt_name, FALSE)\n                             || ' (';\n\n                EXECUTE IMMEDIATE 'SELECT COLUMN_NAME FROM '\n                                  || v_owner\n                                  || '.'\n                                  || sys.dbms_assert.enquote_name(graphname || '_KEY$', FALSE)\n                                  || ' WHERE KEY_TYPE=''VERTEX'' AND ET_NAME=:1 ORDER BY COLUMN_NUMBER ASC'\n                BULK COLLECT\n                INTO my_key_table\n                    USING my_dstkey_table(1).vt_name;\n\n                FOR i IN 1..my_key_table.count LOOP\n                    v_sql_tmp := v_sql_tmp\n                                 || sys.dbms_assert.enquote_name(my_key_table(i).column_name, FALSE);\n\n                    IF i <> my_key_table.count THEN\n                        v_sql_tmp := v_sql_tmp || ', ';\n                    END IF;\n\n                END LOOP;\n\n                v_sql_tmp := v_sql_tmp\n                             || ')'\n                             || chr(10);\n            END;            END IF;\n        \n        -- get labels\n            EXECUTE IMMEDIATE 'SELECT label_name FROM '\n                              || v_owner\n                              || '.'\n                              || sys.dbms_assert.enquote_name(graphname || '_LABEL$', FALSE)\n                              || ' WHERE ET_NAME=:1 AND ET_TYPE=:2'\n            INTO my_label\n                USING my_element_table(k).et_name, my_type;\n\n            v_sql_tmp := v_sql_tmp\n                         || '    LABEL '\n                         || sys.dbms_assert.enquote_name(my_label, FALSE)\n                         || chr(10);\n          \n        -- get properties\n\n            EXECUTE IMMEDIATE 'SELECT PROPERTY_NAME, COLUMN_NAME FROM '\n                              || v_owner\n                              || '.'\n                              || sys.dbms_assert.enquote_name(graphname || '_PROPERTY$', FALSE)\n                              || ' WHERE ET_NAME=:1 AND ET_TYPE=:2 AND LABEL_NAME=:3'\n            BULK COLLECT\n            INTO my_property_table\n                USING my_element_table(k).et_name, my_type, my_label;\n\n            IF my_property_table.count = 0 THEN\n                v_sql_tmp := v_sql_tmp || '    NO PROPERTIES';\n            ELSE\n                v_sql_tmp := v_sql_tmp || '    PROPERTIES (';\n                FOR i IN 1..my_property_table.count LOOP\n                    v_sql_tmp := v_sql_tmp\n                                 || sys.dbms_assert.enquote_name(my_property_table(i).column_name, FALSE)\n                                 || ' AS '\n                                 || sys.dbms_assert.enquote_name(my_property_table(i).property_name, FALSE);\n\n                    IF i <> my_property_table.count THEN\n                        v_sql_tmp := v_sql_tmp || ', ';\n                    END IF;\n\n                END LOOP;\n\n                v_sql_tmp := v_sql_tmp || ')';\n            END IF;\n\n            IF k <> my_element_table.count THEN\n                v_sql_tmp := v_sql_tmp || ', ';\n            END IF;\n\n            v_sql_tmp := v_sql_tmp || chr(10);\n        END LOOP;\n\n        v_sql_tmp := v_sql_tmp\n                     || '  )'\n                     || chr(10);\n    END LOOP;\n\n    IF newgraphname IS NULL THEN\n        EXECUTE IMMEDIATE 'CREATE PROPERTY GRAPH '\n                          || v_owner\n                          || '.'\n                          || sys.dbms_assert.enquote_name(graphname, FALSE)\n                          || chr(10)\n                          || v_sql_tmp;\n                             \n        -- replace with variable                     \n        EXECUTE IMMEDIATE 'ALTER TABLE  '\n                          || v_owner\n                          || '.'\n                          || sys.dbms_assert.enquote_name(graphname || '_SRC_DST_KEY$', FALSE)\n                          || ' RENAME TO '\n                          || sys.dbms_assert.enquote_name(graphname || '_PGQL_SRC_DST_KEY$', FALSE);\n\n        EXECUTE IMMEDIATE 'ALTER TABLE  '\n                          || v_owner\n                          || '.'\n                          || sys.dbms_assert.enquote_name(graphname || '_ELEM_TABLE$', FALSE)\n                          || ' RENAME TO '\n                          || sys.dbms_assert.enquote_name(graphname || '_PGQL_ELEM_TABLE$', FALSE);\n\n        EXECUTE IMMEDIATE 'ALTER TABLE  '\n                          || v_owner\n                          || '.'\n                          || sys.dbms_assert.enquote_name(graphname || '_KEY$', FALSE)\n                          || ' RENAME TO '\n                          || sys.dbms_assert.enquote_name(graphname || '_PGQL_KEY$', FALSE);\n\n        EXECUTE IMMEDIATE 'ALTER TABLE  '\n                          || v_owner\n                          || '.'\n                          || sys.dbms_assert.enquote_name(graphname || '_LABEL$', FALSE)\n                          || ' RENAME TO '\n                          || sys.dbms_assert.enquote_name(graphname || '_PGQL_LABEL$', FALSE);\n\n        EXECUTE IMMEDIATE 'ALTER TABLE  '\n                          || v_owner\n                          || '.'\n                          || sys.dbms_assert.enquote_name(graphname || '_PROPERTY$', FALSE)\n                          || ' RENAME TO '\n                          || sys.dbms_assert.enquote_name(graphname || '_PGQL_PROPERTY$', FALSE);\n\n    ELSE\n        BEGIN\n            EXECUTE IMMEDIATE 'CREATE PROPERTY GRAPH '\n                              || sys.dbms_assert.enquote_name(newowner, FALSE)\n                              || '.'\n                              || sys.dbms_assert.enquote_name(newgraphname, FALSE)\n                              || chr(10)\n                              || v_sql_tmp;\n\n        EXCEPTION\n            WHEN OTHERS THEN\n                IF sqlcode = -972 THEN\n                    raise_application_error(-20972, 'The provided graph name exceeds the maximum length of 128 bytes.');\n                ELSE\n                    RAISE;\n                END IF;\n        END;\n    END IF;\n\n    COMMIT;\nEXCEPTION\n    WHEN OTHERS THEN\n        IF sqlcode = -972 THEN\n            EXECUTE IMMEDIATE 'DROP PROPERTY GRAPH '\n                              || newowner\n                              || '.'\n                              || newgraphname;\n            raise_application_error(-20972, 'The original PGQL graph name is too long');\n        ELSIF sqlcode = -942 THEN\n            raise_application_error(-20942, 'Table does not exist, make sure your destination schema owner has access to the graph underlying element tables');\n        ELSE\n            RAISE;\n        END IF;\nEND;\n";
    }

    private String validatePlSql() {
        return "DECLARE\n  graph_schema                VARCHAR2(128) := ?;\n  graph_name                  VARCHAR2(128) := ?;\n  v_elem_table_join_key       VARCHAR2(2048);\n  v_cursor                    SYS_REFCURSOR;\n  v_elem_schema               VARCHAR2(128);\n  v_elem_table                VARCHAR2(128);\n  v_elem_name                 VARCHAR2(128);\n  v_elem_type                 VARCHAR2(8);\n  v_columns                   sys.odcivarchar2list;\n  v_columns_comma_sep         VARCHAR2(2048);\n  v_columns_concat            VARCHAR2(2048);\n  v_count_unique_match        INTEGER;\n  v_duplicate_value           VARCHAR2(2048);\n  v_edge_src_dst_key          VARCHAR2(2048);\n  v_edge_cursor               SYS_REFCURSOR;\n  v_edge_vt_name              VARCHAR2(128);\n  v_edge_vt_type              VARCHAR2(16);\n  v_edge_vt_columns           sys.odcivarchar2list;\n  v_edge_vt_columns_comma_sep VARCHAR2(2048);\n  v_edge_vt_columns_concat    VARCHAR2(2048);\n  v_vertex_sql                VARCHAR2(2048);\n  v_vertex_schema_name        VARCHAR2(128);\n  v_vertex_table_name         VARCHAR2(128);\n  v_vertex_columns            sys.odcivarchar2list;\n  v_vertex_columns_comma_sep  VARCHAR2(2048);\n  v_count_fk_cons             INTEGER;\n  v_join_condition            VARCHAR2(2048);\n  v_condition                 VARCHAR2(2048);\n  v_edge_key_values           VARCHAR2(2048);\n  v_mismatched_value          VARCHAR2(2048);\nBEGIN\n   -- Retrieve element table information (vertices or edges) and associated keys\n  v_elem_table_join_key := 'SELECT et.SCHEMA_NAME, et.TABLE_NAME, et.ET_NAME, et.ET_TYPE, CAST(COLLECT(k.COLUMN_NAME ORDER BY k.column_number) AS sys.odcivarchar2list) '\n                           || 'FROM '\n                           || sys.dbms_assert.enquote_name(graph_schema, false)\n                           || '.'\n                           || sys.dbms_assert.enquote_name(graph_name || '_ELEM_TABLE$', false)\n                           || ' et '\n                           || 'JOIN '\n                           || sys.dbms_assert.enquote_name(graph_schema, false)\n                           || '.'\n                           || sys.dbms_assert.enquote_name(graph_name || '_KEY$', false)\n                           || ' k '\n                           || 'ON et.ET_NAME = k.ET_NAME AND et.ET_TYPE = k.KEY_TYPE '\n                           || 'GROUP BY et.ET_TYPE, et.ET_NAME, et.SCHEMA_NAME, et.TABLE_NAME';\n\n  OPEN v_cursor FOR v_elem_table_join_key;\n\n  LOOP\n    FETCH v_cursor INTO\n      v_elem_schema,\n      v_elem_table,\n      v_elem_name,\n      v_elem_type,\n      v_columns;\n    EXIT WHEN v_cursor%notfound;\n    v_columns_comma_sep := '';\n    v_columns_concat := '';\n    FOR i IN 1..v_columns.count LOOP\n      v_columns_comma_sep := v_columns_comma_sep || sys.dbms_assert.enquote_name(v_columns(i), false);\n      v_columns_concat := v_columns_concat || sys.dbms_assert.enquote_name(v_columns(i), false);\n      IF i <> v_columns.count THEN\n        v_columns_comma_sep := v_columns_comma_sep || ', ';\n        v_columns_concat := v_columns_concat || ' ||'', ''|| ';\n      END IF;\n    END LOOP;\n    -- Count unique matches of column names as constraints (UNIQUE or PRIMARY KEY)\n    SELECT\n      COUNT(*)\n    INTO v_count_unique_match\n    FROM\n      (\n        SELECT\n          ac.constraint_type AS constraint_type,\n          LISTAGG(acc.column_name, ', ') WITHIN GROUP(\n          ORDER BY\n            acc.position\n          )                  AS list_columns\n        FROM\n          sys.all_constraints ac\n          JOIN sys.all_cons_columns acc ON ac.owner = acc.owner\n                                       AND ac.table_name = acc.table_name\n                                       AND ac.constraint_name = acc.constraint_name\n        WHERE\n          ac.owner = v_elem_schema\n          AND ac.table_name = v_elem_table\n          AND ac.status = 'ENABLED'\n          AND ac.validated = 'VALIDATED'\n          AND ( ac.constraint_type = 'U'\n                OR ac.constraint_type = 'P' )\n        GROUP BY\n          ac.owner,\n          ac.table_name,\n          ac.constraint_name,\n          ac.constraint_type\n      ) sub\n    WHERE\n      sub.list_columns = v_columns_comma_sep;\n    IF ( v_count_unique_match = 0 ) THEN\n      BEGIN\n        -- Check for duplicate values in the element table(vertex or edge)\n        EXECUTE IMMEDIATE 'SELECT '\n                          || v_columns_concat\n                          || ' FROM '\n                          || sys.dbms_assert.enquote_name(v_elem_schema, false)\n                          || '.'\n                          || sys.dbms_assert.enquote_name(v_elem_table, false)\n                          || ' GROUP BY '\n                          || v_columns_comma_sep\n                          || ' HAVING COUNT(*) > 1 FETCH FIRST 1 ROWS ONLY'\n        INTO v_duplicate_value;\n      EXCEPTION\n        WHEN no_data_found THEN\n          v_duplicate_value := NULL;\n      END;\n      IF v_duplicate_value IS NOT NULL THEN\n        raise_application_error(\n                               -20001,\n                               'Duplicate '\n                               || lower(v_elem_type)\n                               || ' key '\n                               || v_duplicate_value\n                               || ' for '\n                               || v_elem_name\n                               || ' (column(s): '\n                               || v_columns_comma_sep\n                               || ')'\n        );\n      END IF;\n    END IF;\n    IF v_elem_type = 'EDGE' THEN\n     -- Query to retrieve source and destination keys for edges\n      v_edge_src_dst_key := 'SELECT VT_NAME, KEY_TYPE, CAST(COLLECT(ET_COLUMN_NAME ORDER BY ET_COLUMN_NUMBER) AS sys.odcivarchar2list) AS LIST_COLUMNS '\n                            || 'FROM '\n                            || sys.dbms_assert.enquote_name(graph_schema, false)\n                            || '.'\n                            || sys.dbms_assert.enquote_name(graph_name || '_SRC_DST_KEY$', false)\n                            || ' WHERE ET_NAME = :1 '\n                            || 'GROUP BY ET_NAME, VT_NAME, KEY_TYPE';\n      OPEN v_edge_cursor FOR v_edge_src_dst_key\n        USING v_elem_name;\n      LOOP\n        FETCH v_edge_cursor INTO\n          v_edge_vt_name,\n          v_edge_vt_type,\n          v_edge_vt_columns;\n        EXIT WHEN v_edge_cursor%notfound;\n        -- Query to retrieve vertex information (schema, table, and columns)\n        v_vertex_sql := 'SELECT et.SCHEMA_NAME, et.TABLE_NAME, CAST(COLLECT(k.COLUMN_NAME) AS sys.odcivarchar2list) '\n                        || 'FROM '\n                        || sys.dbms_assert.enquote_name(graph_schema, false)\n                        || '.'\n                        || sys.dbms_assert.enquote_name(graph_name || '_ELEM_TABLE$', false)\n                        || ' et '\n                        || 'JOIN '\n                        || sys.dbms_assert.enquote_name(graph_schema, false)\n                        || '.'\n                        || sys.dbms_assert.enquote_name(graph_name || '_KEY$', false)\n                        || ' k '\n                        || 'ON et.ET_NAME = k.ET_NAME AND et.ET_TYPE = k.KEY_TYPE '\n                        || 'WHERE et.ET_NAME = :1 AND et.ET_TYPE = :2 '\n                        || 'GROUP BY et.SCHEMA_NAME, et.TABLE_NAME';\n        EXECUTE IMMEDIATE v_vertex_sql\n        INTO\n          v_vertex_schema_name,\n          v_vertex_table_name,\n          v_vertex_columns\n          USING v_edge_vt_name, 'VERTEX';\n        v_vertex_columns_comma_sep := '';\n        FOR i IN 1..v_vertex_columns.count LOOP\n          v_vertex_columns_comma_sep := v_vertex_columns_comma_sep || sys.dbms_assert.enquote_name(v_vertex_columns(i), false);\n          IF i <> v_vertex_columns.count THEN\n            v_vertex_columns_comma_sep := v_vertex_columns_comma_sep || ', ';\n          END IF;\n        END LOOP;\n        v_edge_vt_columns_comma_sep := '';\n        v_edge_vt_columns_concat := '';\n        FOR i IN 1..v_edge_vt_columns.count LOOP\n          v_edge_vt_columns_comma_sep := v_edge_vt_columns_comma_sep || sys.dbms_assert.enquote_name(v_edge_vt_columns(i), false);\n          IF i <> v_edge_vt_columns.count THEN\n            v_edge_vt_columns_comma_sep := v_edge_vt_columns_comma_sep || ', ';\n          END IF;\n        END LOOP;\n        IF\n          v_elem_schema = v_vertex_schema_name\n          AND v_elem_table = v_vertex_table_name\n          AND v_columns_comma_sep = v_vertex_columns_comma_sep\n        THEN\n          CONTINUE;\n        END IF;\n        -- Check foreign key constraints between edge and vertex\n        SELECT\n          COUNT(*)\n        INTO v_count_fk_cons\n        FROM\n          (\n            SELECT\n              ac.constraint_type AS constraint_type,\n              LISTAGG(acc.column_name, ', ') WITHIN GROUP(\n              ORDER BY\n                acc.position\n              )                  AS list_columns,\n              r_owner,\n              r_constraint_name\n            FROM\n              sys.all_constraints ac\n              JOIN sys.all_cons_columns acc ON ac.owner = acc.owner\n                                           AND ac.table_name = acc.table_name\n                                           AND ac.constraint_name = acc.constraint_name\n            WHERE\n              ac.owner = v_elem_schema\n              AND ac.table_name = v_elem_table\n              AND ac.status = 'ENABLED'\n              AND ac.validated = 'VALIDATED'\n              AND ac.constraint_type = 'R'\n            GROUP BY\n              ac.constraint_type,\n              ac.owner,\n              ac.table_name,\n              ac.constraint_name,\n              r_owner,\n              r_constraint_name\n          ) ref\n          JOIN (\n            SELECT\n              LISTAGG(acc.column_name, ', ') WITHIN GROUP(\n              ORDER BY\n                acc.position\n              ) AS list_columns,\n              ac.owner,\n              ac.constraint_name\n            FROM\n              sys.all_constraints ac\n              JOIN sys.all_cons_columns acc ON ac.owner = acc.owner\n                                           AND ac.table_name = acc.table_name\n                                           AND ac.constraint_name = acc.constraint_name\n            WHERE\n              ac.owner = v_vertex_schema_name\n              AND ac.table_name = v_vertex_table_name\n            GROUP BY\n              ac.owner,\n              ac.table_name,\n              ac.constraint_name\n          ) org ON ref.r_owner = org.owner\n                   AND ref.r_constraint_name = org.constraint_name\n        WHERE\n          ref.list_columns = v_edge_vt_columns_comma_sep\n          AND org.list_columns = v_vertex_columns_comma_sep;\n        -- If no foreign key constraints are found, continue to the next iteration\n        IF v_count_fk_cons = 0 THEN\n          v_join_condition := '';\n          v_condition := '';\n          v_edge_vt_columns_concat := '';\n          FOR i IN 1..v_edge_vt_columns.count LOOP\n            v_join_condition := v_join_condition\n                                || 't1.'\n                                || sys.dbms_assert.enquote_name(v_edge_vt_columns(i), false)\n                                || ' = t2.'\n                                || sys.dbms_assert.enquote_name(v_vertex_columns(i), false);\n            v_condition := v_condition\n                           || 't2.'\n                           || sys.dbms_assert.enquote_name(v_vertex_columns(i), false)\n                           || ' IS NULL';\n            v_edge_vt_columns_concat := v_edge_vt_columns_concat\n                                        || 't1.'\n                                        || sys.dbms_assert.enquote_name(v_edge_vt_columns(i), false);\n            IF i <> v_edge_vt_columns.count THEN\n              v_join_condition := v_join_condition || ' AND ';\n              v_condition := v_condition || ' AND ';\n              v_edge_vt_columns_concat := v_edge_vt_columns_concat || ' ||'', ''|| ';\n            END IF;\n\n          END LOOP;\n\n          v_columns_concat := '';\n          FOR i IN 1..v_columns.count LOOP\n            v_columns_concat := v_columns_concat\n                                || 't1.'\n                                || sys.dbms_assert.enquote_name(v_columns(i), false);\n            IF i <> v_columns.count THEN\n              v_columns_concat := v_columns_concat || ' ||'', ''|| ';\n            END IF;\n          END LOOP;\n          BEGIN\n            -- Execute a dynamic SQL query to check for invalid vertex keys in the edge table\n            EXECUTE IMMEDIATE 'SELECT '\n                              || v_columns_concat\n                              || ', '\n                              || v_edge_vt_columns_concat\n                              || ' FROM '\n                              || sys.dbms_assert.enquote_name(v_elem_schema, false)\n                              || '.'\n                              || sys.dbms_assert.enquote_name(v_elem_table, false)\n                              || ' t1 LEFT JOIN '\n                              || sys.dbms_assert.enquote_name(v_vertex_schema_name, false)\n                              || '.'\n                              || sys.dbms_assert.enquote_name(v_vertex_table_name, false)\n                              || ' t2 ON '\n                              || v_join_condition\n                              || ' WHERE '\n                              || v_condition\n                              || ' FETCH FIRST 1 ROWS ONLY'\n            INTO\n              v_edge_key_values,\n              v_mismatched_value;\n          EXCEPTION\n            WHEN no_data_found THEN\n              v_edge_key_values := NULL;\n          END;\n          IF v_edge_key_values IS NOT NULL THEN\n            raise_application_error(\n                                   -20001,\n                                   'Invalid vertex key '\n                                   || v_mismatched_value\n                                   || ' for edge '\n                                   || v_edge_key_values\n                                   || ' in edge table '\n                                   || v_elem_name\n                                   || ' with '\n                                   ||(\n                                     CASE v_edge_vt_type\n                                       WHEN 'EDGE_SOURCE' THEN\n                                         'source'\n                                       WHEN 'EDGE_DESTINATION' THEN\n                                         'destination'\n                                     END\n                                   )\n                                   || ' key column(s) '\n                                   || v_edge_vt_columns_comma_sep\n                                   || ' referencing '\n                                   || v_edge_vt_name\n                                   || ' ( '\n                                   || v_vertex_columns_comma_sep\n                                   || ' )'\n            );\n          END IF;\n        END IF;\n      END LOOP;\n      CLOSE v_edge_cursor;\n    END IF;\n  END LOOP;\n  CLOSE v_cursor;\nEND;";
    }

    @Override
    public PgqlSqlTrans.TranslationType getTranslationType() {
        return PgqlSqlTrans.TranslationType.CALL;
    }
}

