/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.graphviz.driver;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import oracle.pgx.api.EdgeProviderMetaData;
import oracle.pgx.api.PgxGraph;
import oracle.pgx.api.VertexProviderMetaData;
import oracle.pgx.common.types.PropertyType;
import oracle.pgx.graphviz.driver.GraphInformation;
import oracle.pgx.graphviz.driver.PgxGraphProperty;
import oracle.pgx.graphviz.driver.Property;

class PgxGraphInformation
implements GraphInformation {
    private final String name;
    private final boolean verticesLabeled;
    private final boolean edgesLabeled;
    private final Map<Set<String>, Set<String>> vertexPropertiesPerLabel = new HashMap<Set<String>, Set<String>>();
    private final Map<Set<String>, Set<String>> edgePropertiesPerLabel = new HashMap<Set<String>, Set<String>>();

    PgxGraphInformation(@Nonnull PgxGraph graph) {
        this.name = graph.getName();
        this.verticesLabeled = graph.hasVertexLabels();
        this.edgesLabeled = graph.hasEdgeLabel();
        this.getVertexPropertiesPerLabel(graph);
        this.getEdgePropertiesPerLabel(graph);
    }

    private void getVertexPropertiesPerLabel(PgxGraph graph) {
        Map vertexProvidersMetaData = graph.getMetaData().getVertexProvidersMetaData();
        Set providers = vertexProvidersMetaData.keySet();
        for (String provider : providers) {
            Set labels = ((VertexProviderMetaData)vertexProvidersMetaData.get(provider)).getLabels();
            List propertyMetaData = ((VertexProviderMetaData)vertexProvidersMetaData.get(provider)).getProperties();
            Set properties = propertyMetaData.stream().filter(p -> p.getPropertyType() != PropertyType.VERTEX && p.getPropertyType() != PropertyType.EDGE).map(p -> p.getName()).collect(Collectors.toSet());
            this.vertexPropertiesPerLabel.putIfAbsent(labels, properties);
        }
    }

    private void getEdgePropertiesPerLabel(PgxGraph graph) {
        Map edgeProvidersMetaData = graph.getMetaData().getEdgeProvidersMetaData();
        Set providers = edgeProvidersMetaData.keySet();
        for (String provider : providers) {
            Set labels = ((EdgeProviderMetaData)edgeProvidersMetaData.get(provider)).getLabels();
            List propertyMetaData = ((EdgeProviderMetaData)edgeProvidersMetaData.get(provider)).getProperties();
            Set properties = propertyMetaData.stream().filter(p -> p.getPropertyType() != PropertyType.VERTEX && p.getPropertyType() != PropertyType.EDGE).map(p -> p.getName()).collect(Collectors.toSet());
            this.edgePropertiesPerLabel.putIfAbsent(labels, properties);
        }
    }

    @Nullable
    public String getSchema() {
        return null;
    }

    public String getGraphName() {
        return this.name;
    }

    public boolean hasVertexLabels() {
        return this.verticesLabeled;
    }

    public boolean hasEdgeLabels() {
        return this.edgesLabeled;
    }

    @Nonnull
    public Set<Property> getVertexProperties() {
        Set vertexProperties = this.vertexPropertiesPerLabel.values().stream().flatMap(Collection::stream).map(p -> new PgxGraphProperty((String)p, true)).collect(Collectors.toSet());
        return Collections.unmodifiableSet(vertexProperties);
    }

    @Nonnull
    public Set<Property> getEdgeProperties() {
        Set edgeProperties = this.edgePropertiesPerLabel.values().stream().flatMap(Collection::stream).map(p -> new PgxGraphProperty((String)p, true)).collect(Collectors.toSet());
        return Collections.unmodifiableSet(edgeProperties);
    }

    public Set<String> getVertexLabels() {
        return Collections.unmodifiableSet(this.vertexPropertiesPerLabel.keySet().stream().flatMap(Collection::stream).collect(Collectors.toSet()));
    }

    public Set<String> getVertexProperties(Set<String> labels) {
        return this.vertexPropertiesPerLabel.get(labels);
    }

    public Set<String> getEdgeProperties(Set<String> labels) {
        return this.edgePropertiesPerLabel.get(labels);
    }

    public Set<String> getEdgeLabels() {
        return Collections.unmodifiableSet(this.edgePropertiesPerLabel.keySet().stream().flatMap(Collection::stream).collect(Collectors.toSet()));
    }
}

