/*
 * Decompiled with CFR 0.152.
 */
package oracle.gvt.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import oracle.gvt.models.OperationType;
import oracle.gvt.models.Resources;
import oracle.gvt.models.WorkRequestStatus;

@ApiModel(description="Object that is returned when getting a work request")
@JsonTypeName(value="WorkRequest")
public class WorkRequest {
    private OperationType operationType = OperationType.RUN_QUERY;
    private WorkRequestStatus status;
    private String id;
    private List<Resources> resources = new ArrayList<Resources>();
    private Date timeAccepted;
    private Date timeFinished;
    private Date timeStarted;
    private Integer percentComplete;

    public WorkRequest operationType(OperationType operationType) {
        this.operationType = operationType;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="operationType")
    public OperationType getOperationType() {
        return this.operationType;
    }

    @JsonProperty(value="operationType")
    public void setOperationType(OperationType operationType) {
        this.operationType = operationType;
    }

    public WorkRequest status(WorkRequestStatus status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="status")
    public WorkRequestStatus getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    public void setStatus(WorkRequestStatus status) {
        this.status = status;
    }

    public WorkRequest id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(required=true, value="identifier of the work request")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    public void setId(String id) {
        this.id = id;
    }

    public WorkRequest resources(List<Resources> resources) {
        this.resources = resources;
        return this;
    }

    @ApiModelProperty(required=true, value="array with the resources affected by the work request")
    @JsonProperty(value="resources")
    public List<Resources> getResources() {
        return this.resources;
    }

    @JsonProperty(value="resources")
    public void setResources(List<Resources> resources) {
        this.resources = resources;
    }

    public WorkRequest addResourcesItem(Resources resourcesItem) {
        if (this.resources == null) {
            this.resources = new ArrayList<Resources>();
        }
        this.resources.add(resourcesItem);
        return this;
    }

    public WorkRequest removeResourcesItem(Resources resourcesItem) {
        if (resourcesItem != null && this.resources != null) {
            this.resources.remove(resourcesItem);
        }
        return this;
    }

    public WorkRequest timeAccepted(Date timeAccepted) {
        this.timeAccepted = timeAccepted;
        return this;
    }

    @ApiModelProperty(example="2023-11-07T23:17:42.512Z", required=true, value="When the work request was created")
    @JsonProperty(value="timeAccepted")
    public Date getTimeAccepted() {
        return this.timeAccepted;
    }

    @JsonProperty(value="timeAccepted")
    public void setTimeAccepted(Date timeAccepted) {
        this.timeAccepted = timeAccepted;
    }

    public WorkRequest timeFinished(Date timeFinished) {
        this.timeFinished = timeFinished;
        return this;
    }

    @ApiModelProperty(example="2023-11-07T23:17:42.512Z", required=true, value="When the work request reached a terminal state")
    @JsonProperty(value="timeFinished")
    public Date getTimeFinished() {
        return this.timeFinished;
    }

    @JsonProperty(value="timeFinished")
    public void setTimeFinished(Date timeFinished) {
        this.timeFinished = timeFinished;
    }

    public WorkRequest timeStarted(Date timeStarted) {
        this.timeStarted = timeStarted;
        return this;
    }

    @ApiModelProperty(example="2023-11-07T23:17:42.512Z", required=true, value="When the rowk request moved from ACCEPTED to IN_PROGRESS state")
    @JsonProperty(value="timeStarted")
    public Date getTimeStarted() {
        return this.timeStarted;
    }

    @JsonProperty(value="timeStarted")
    public void setTimeStarted(Date timeStarted) {
        this.timeStarted = timeStarted;
    }

    public WorkRequest percentComplete(Integer percentComplete) {
        this.percentComplete = percentComplete;
        return this;
    }

    @ApiModelProperty(example="0", value="How much progress the operation has made, vs the total amount of work that must be performed")
    @JsonProperty(value="percentComplete")
    public Integer getPercentComplete() {
        return this.percentComplete;
    }

    @JsonProperty(value="percentComplete")
    public void setPercentComplete(Integer percentComplete) {
        this.percentComplete = percentComplete;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkRequest workRequest = (WorkRequest)o;
        return Objects.equals((Object)this.operationType, (Object)workRequest.operationType) && Objects.equals((Object)this.status, (Object)workRequest.status) && Objects.equals(this.id, workRequest.id) && Objects.equals(this.resources, workRequest.resources) && Objects.equals(this.timeAccepted, workRequest.timeAccepted) && Objects.equals(this.timeFinished, workRequest.timeFinished) && Objects.equals(this.timeStarted, workRequest.timeStarted) && Objects.equals(this.percentComplete, workRequest.percentComplete);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.operationType, this.status, this.id, this.resources, this.timeAccepted, this.timeFinished, this.timeStarted, this.percentComplete});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WorkRequest {\n");
        sb.append("    operationType: ").append(this.toIndentedString((Object)this.operationType)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    resources: ").append(this.toIndentedString(this.resources)).append("\n");
        sb.append("    timeAccepted: ").append(this.toIndentedString(this.timeAccepted)).append("\n");
        sb.append("    timeFinished: ").append(this.toIndentedString(this.timeFinished)).append("\n");
        sb.append("    timeStarted: ").append(this.toIndentedString(this.timeStarted)).append("\n");
        sb.append("    percentComplete: ").append(this.toIndentedString(this.percentComplete)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

