/*
 * Decompiled with CFR 0.152.
 */
package oracle.gvt.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Server parameters to modify some properties during execution")
@JsonTypeName(value="ServerOptions")
public class ServerOptions {
    private Map<String, String> map = new HashMap<String, String>();

    public ServerOptions map(Map<String, String> map) {
        this.map = map;
        return this;
    }

    @ApiModelProperty(value="Map that allows the modification of some server configurations")
    @JsonProperty(value="map")
    public Map<String, String> getMap() {
        return this.map;
    }

    @JsonProperty(value="map")
    public void setMap(Map<String, String> map) {
        this.map = map;
    }

    public ServerOptions putMapItem(String key, String mapItem) {
        if (this.map == null) {
            this.map = new HashMap<String, String>();
        }
        this.map.put(key, mapItem);
        return this;
    }

    public ServerOptions removeMapItem(String mapItem) {
        if (mapItem != null && this.map != null) {
            this.map.remove(mapItem);
        }
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServerOptions serverOptions = (ServerOptions)o;
        return Objects.equals(this.map, serverOptions.map);
    }

    public int hashCode() {
        return Objects.hash(this.map);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ServerOptions {\n");
        sb.append("    map: ").append(this.toIndentedString(this.map)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

