/*
 * Decompiled with CFR 0.152.
 */
package oracle.gvt.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import oracle.gvt.models.PropertySchema;

@ApiModel(description="object to abstract the attributes of a vertex/edge")
@JsonTypeName(value="SchemaEntity")
public class SchemaEntity {
    private List<String> labels = new ArrayList<String>();
    private List<PropertySchema> properties = new ArrayList<PropertySchema>();

    public SchemaEntity labels(List<String> labels) {
        this.labels = labels;
        return this;
    }

    @ApiModelProperty(example="[\"EMPLOYEE\",\"PERSON\"]", required=true, value="array containing the lables of the given vertex")
    @JsonProperty(value="labels")
    public List<String> getLabels() {
        return this.labels;
    }

    @JsonProperty(value="labels")
    public void setLabels(List<String> labels) {
        this.labels = labels;
    }

    public SchemaEntity addLabelsItem(String labelsItem) {
        if (this.labels == null) {
            this.labels = new ArrayList<String>();
        }
        this.labels.add(labelsItem);
        return this;
    }

    public SchemaEntity removeLabelsItem(String labelsItem) {
        if (labelsItem != null && this.labels != null) {
            this.labels.remove(labelsItem);
        }
        return this;
    }

    public SchemaEntity properties(List<PropertySchema> properties) {
        this.properties = properties;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="properties")
    public List<PropertySchema> getProperties() {
        return this.properties;
    }

    @JsonProperty(value="properties")
    public void setProperties(List<PropertySchema> properties) {
        this.properties = properties;
    }

    public SchemaEntity addPropertiesItem(PropertySchema propertiesItem) {
        if (this.properties == null) {
            this.properties = new ArrayList<PropertySchema>();
        }
        this.properties.add(propertiesItem);
        return this;
    }

    public SchemaEntity removePropertiesItem(PropertySchema propertiesItem) {
        if (propertiesItem != null && this.properties != null) {
            this.properties.remove(propertiesItem);
        }
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SchemaEntity schemaEntity = (SchemaEntity)o;
        return Objects.equals(this.labels, schemaEntity.labels) && Objects.equals(this.properties, schemaEntity.properties);
    }

    public int hashCode() {
        return Objects.hash(this.labels, this.properties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SchemaEntity {\n");
        sb.append("    labels: ").append(this.toIndentedString(this.labels)).append("\n");
        sb.append("    properties: ").append(this.toIndentedString(this.properties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

