/*
 * Decompiled with CFR 0.152.
 */
package oracle.gvt.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import oracle.gvt.models.Parameters;
import oracle.gvt.models.ResultType;
import oracle.gvt.models.ServerOptions;

@ApiModel(description="Abstract object to describe the request body of a query execution request")
@JsonTypeName(value="RunQuery")
public class RunQuery {
    private List<String> statements;
    private ResultType resultType;
    private ServerOptions serverOptions;
    private Parameters parameters;

    public RunQuery statements(List<String> statements) {
        this.statements = statements;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="statements")
    public List<String> getStatements() {
        return this.statements;
    }

    @JsonProperty(value="statements")
    public void setStatements(List<String> statements) {
        this.statements = statements;
    }

    public RunQuery addStatementsItem(String statementsItem) {
        if (this.statements == null) {
            this.statements = new ArrayList<String>();
        }
        this.statements.add(statementsItem);
        return this;
    }

    public RunQuery removeStatementsItem(String statementsItem) {
        if (statementsItem != null && this.statements != null) {
            this.statements.remove(statementsItem);
        }
        return this;
    }

    public RunQuery resultType(ResultType resultType) {
        this.resultType = resultType;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="resultType")
    public ResultType getResultType() {
        return this.resultType;
    }

    @JsonProperty(value="resultType")
    public void setResultType(ResultType resultType) {
        this.resultType = resultType;
    }

    public RunQuery serverOptions(ServerOptions serverOptions) {
        this.serverOptions = serverOptions;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="serverOptions")
    public ServerOptions getServerOptions() {
        return this.serverOptions;
    }

    @JsonProperty(value="serverOptions")
    public void setServerOptions(ServerOptions serverOptions) {
        this.serverOptions = serverOptions;
    }

    public RunQuery parameters(Parameters parameters) {
        this.parameters = parameters;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="parameters")
    public Parameters getParameters() {
        return this.parameters;
    }

    @JsonProperty(value="parameters")
    public void setParameters(Parameters parameters) {
        this.parameters = parameters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RunQuery runQuery = (RunQuery)o;
        return Objects.equals(this.statements, runQuery.statements) && Objects.equals((Object)this.resultType, (Object)runQuery.resultType) && Objects.equals(this.serverOptions, runQuery.serverOptions) && Objects.equals(this.parameters, runQuery.parameters);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.statements, this.resultType, this.serverOptions, this.parameters});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RunQuery {\n");
        sb.append("    statements: ").append(this.toIndentedString(this.statements)).append("\n");
        sb.append("    resultType: ").append(this.toIndentedString((Object)this.resultType)).append("\n");
        sb.append("    serverOptions: ").append(this.toIndentedString(this.serverOptions)).append("\n");
        sb.append("    parameters: ").append(this.toIndentedString(this.parameters)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

