/*
 * Decompiled with CFR 0.152.
 */
package oracle.gvt.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import java.util.Objects;
import oracle.gvt.models.ResultData;

@ApiModel(description="Object that describes the result of a run statement request")
@JsonTypeName(value="Result")
public class Result {
    private String statement;
    private ResultData data;
    private Date timeStarted;
    private Date timeEnded;

    public Result statement(String statement) {
        this.statement = statement;
        return this;
    }

    @ApiModelProperty(example="SELECT e FROM MATCH ()-[e]->() LIMIT 100", required=true, value="PGQL/SQL statement executed")
    @JsonProperty(value="statement")
    public String getStatement() {
        return this.statement;
    }

    @JsonProperty(value="statement")
    public void setStatement(String statement) {
        this.statement = statement;
    }

    public Result data(ResultData data) {
        this.data = data;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="data")
    public ResultData getData() {
        return this.data;
    }

    @JsonProperty(value="data")
    public void setData(ResultData data) {
        this.data = data;
    }

    public Result timeStarted(Date timeStarted) {
        this.timeStarted = timeStarted;
        return this;
    }

    @ApiModelProperty(required=true, value="time when execution started")
    @JsonProperty(value="timeStarted")
    public Date getTimeStarted() {
        return this.timeStarted;
    }

    @JsonProperty(value="timeStarted")
    public void setTimeStarted(Date timeStarted) {
        this.timeStarted = timeStarted;
    }

    public Result timeEnded(Date timeEnded) {
        this.timeEnded = timeEnded;
        return this;
    }

    @ApiModelProperty(required=true, value="time when execution ended")
    @JsonProperty(value="timeEnded")
    public Date getTimeEnded() {
        return this.timeEnded;
    }

    @JsonProperty(value="timeEnded")
    public void setTimeEnded(Date timeEnded) {
        this.timeEnded = timeEnded;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Result result = (Result)o;
        return Objects.equals(this.statement, result.statement) && Objects.equals(this.data, result.data) && Objects.equals(this.timeStarted, result.timeStarted) && Objects.equals(this.timeEnded, result.timeEnded);
    }

    public int hashCode() {
        return Objects.hash(this.statement, this.data, this.timeStarted, this.timeEnded);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Result {\n");
        sb.append("    statement: ").append(this.toIndentedString(this.statement)).append("\n");
        sb.append("    data: ").append(this.toIndentedString(this.data)).append("\n");
        sb.append("    timeStarted: ").append(this.toIndentedString(this.timeStarted)).append("\n");
        sb.append("    timeEnded: ").append(this.toIndentedString(this.timeEnded)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

