/*
 * Decompiled with CFR 0.152.
 */
package oracle.gvt.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Object to describe structure of a proper error response")
@JsonTypeName(value="ObjectError")
public class ObjectError {
    private String code;
    private String message;

    public ObjectError code(String code) {
        this.code = code;
        return this;
    }

    @ApiModelProperty(example="InvalidParameter", required=true, value="Code that describes what the issue was")
    @JsonProperty(value="code")
    public String getCode() {
        return this.code;
    }

    @JsonProperty(value="code")
    public void setCode(String code) {
        this.code = code;
    }

    public ObjectError message(String message) {
        this.message = message;
        return this;
    }

    @ApiModelProperty(example="The parameter given was not valid", required=true, value="Message with a clear explanation of what was wrong")
    @JsonProperty(value="message")
    public String getMessage() {
        return this.message;
    }

    @JsonProperty(value="message")
    public void setMessage(String message) {
        this.message = message;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ObjectError objectError = (ObjectError)o;
        return Objects.equals(this.code, objectError.code) && Objects.equals(this.message, objectError.message);
    }

    public int hashCode() {
        return Objects.hash(this.code, this.message);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ObjectError {\n");
        sb.append("    code: ").append(this.toIndentedString(this.code)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

