/*
 * Decompiled with CFR 0.152.
 */
package oracle.gvt.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import oracle.gvt.models.GraphState;

@ApiModel(description="Object to describe general information of the graph")
@JsonTypeName(value="GraphInformation")
public class GraphInformation {
    private GraphState state;
    private List<String> vertexLabels;
    private List<String> edgeLabels;
    private List<String> vertexProperties;
    private List<String> edgeProperties;

    public GraphInformation state(GraphState state) {
        this.state = state;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="state")
    public GraphState getState() {
        return this.state;
    }

    @JsonProperty(value="state")
    public void setState(GraphState state) {
        this.state = state;
    }

    public GraphInformation vertexLabels(List<String> vertexLabels) {
        this.vertexLabels = vertexLabels;
        return this;
    }

    @ApiModelProperty(example="[\"EMPLOYEE\",\"COUNTRY\",\"CITY\"]", value="String array with the vertex labels in the graph")
    @JsonProperty(value="vertexLabels")
    public List<String> getVertexLabels() {
        return this.vertexLabels;
    }

    @JsonProperty(value="vertexLabels")
    public void setVertexLabels(List<String> vertexLabels) {
        this.vertexLabels = vertexLabels;
    }

    public GraphInformation addVertexLabelsItem(String vertexLabelsItem) {
        if (this.vertexLabels == null) {
            this.vertexLabels = new ArrayList<String>();
        }
        this.vertexLabels.add(vertexLabelsItem);
        return this;
    }

    public GraphInformation removeVertexLabelsItem(String vertexLabelsItem) {
        if (vertexLabelsItem != null && this.vertexLabels != null) {
            this.vertexLabels.remove(vertexLabelsItem);
        }
        return this;
    }

    public GraphInformation edgeLabels(List<String> edgeLabels) {
        this.edgeLabels = edgeLabels;
        return this;
    }

    @ApiModelProperty(example="[\"WORKS_FOR\",\"WORKS_IN\"]", value="String array with the edge labels in the graph")
    @JsonProperty(value="edgeLabels")
    public List<String> getEdgeLabels() {
        return this.edgeLabels;
    }

    @JsonProperty(value="edgeLabels")
    public void setEdgeLabels(List<String> edgeLabels) {
        this.edgeLabels = edgeLabels;
    }

    public GraphInformation addEdgeLabelsItem(String edgeLabelsItem) {
        if (this.edgeLabels == null) {
            this.edgeLabels = new ArrayList<String>();
        }
        this.edgeLabels.add(edgeLabelsItem);
        return this;
    }

    public GraphInformation removeEdgeLabelsItem(String edgeLabelsItem) {
        if (edgeLabelsItem != null && this.edgeLabels != null) {
            this.edgeLabels.remove(edgeLabelsItem);
        }
        return this;
    }

    public GraphInformation vertexProperties(List<String> vertexProperties) {
        this.vertexProperties = vertexProperties;
        return this;
    }

    @ApiModelProperty(example="[\"NAME\",\"AGE\",\"EMAIL\"]", value="String array with the vertex properties in the graph")
    @JsonProperty(value="vertexProperties")
    public List<String> getVertexProperties() {
        return this.vertexProperties;
    }

    @JsonProperty(value="vertexProperties")
    public void setVertexProperties(List<String> vertexProperties) {
        this.vertexProperties = vertexProperties;
    }

    public GraphInformation addVertexPropertiesItem(String vertexPropertiesItem) {
        if (this.vertexProperties == null) {
            this.vertexProperties = new ArrayList<String>();
        }
        this.vertexProperties.add(vertexPropertiesItem);
        return this;
    }

    public GraphInformation removeVertexPropertiesItem(String vertexPropertiesItem) {
        if (vertexPropertiesItem != null && this.vertexProperties != null) {
            this.vertexProperties.remove(vertexPropertiesItem);
        }
        return this;
    }

    public GraphInformation edgeProperties(List<String> edgeProperties) {
        this.edgeProperties = edgeProperties;
        return this;
    }

    @ApiModelProperty(example="[\"AMOUNT\"]", value="String array with the edge properties in the graph")
    @JsonProperty(value="edgeProperties")
    public List<String> getEdgeProperties() {
        return this.edgeProperties;
    }

    @JsonProperty(value="edgeProperties")
    public void setEdgeProperties(List<String> edgeProperties) {
        this.edgeProperties = edgeProperties;
    }

    public GraphInformation addEdgePropertiesItem(String edgePropertiesItem) {
        if (this.edgeProperties == null) {
            this.edgeProperties = new ArrayList<String>();
        }
        this.edgeProperties.add(edgePropertiesItem);
        return this;
    }

    public GraphInformation removeEdgePropertiesItem(String edgePropertiesItem) {
        if (edgePropertiesItem != null && this.edgeProperties != null) {
            this.edgeProperties.remove(edgePropertiesItem);
        }
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GraphInformation graphInformation = (GraphInformation)o;
        return Objects.equals((Object)this.state, (Object)graphInformation.state) && Objects.equals(this.vertexLabels, graphInformation.vertexLabels) && Objects.equals(this.edgeLabels, graphInformation.edgeLabels) && Objects.equals(this.vertexProperties, graphInformation.vertexProperties) && Objects.equals(this.edgeProperties, graphInformation.edgeProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.state, this.vertexLabels, this.edgeLabels, this.vertexProperties, this.edgeProperties});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GraphInformation {\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    vertexLabels: ").append(this.toIndentedString(this.vertexLabels)).append("\n");
        sb.append("    edgeLabels: ").append(this.toIndentedString(this.edgeLabels)).append("\n");
        sb.append("    vertexProperties: ").append(this.toIndentedString(this.vertexProperties)).append("\n");
        sb.append("    edgeProperties: ").append(this.toIndentedString(this.edgeProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

