/*
 * Decompiled with CFR 0.152.
 */
package oracle.gvt.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import oracle.gvt.models.Edge;
import oracle.gvt.models.Vertex;

@ApiModel(description="Object to describe the Graph on GVT format")
@JsonTypeName(value="Graph")
public class Graph {
    private List<Edge> edges = new ArrayList<Edge>();
    private List<Vertex> vertices = new ArrayList<Vertex>();
    private Integer numResults;
    private String graphOwner;
    private String graphName;
    private Boolean isLastResultSet;

    public Graph edges(List<Edge> edges) {
        this.edges = edges;
        return this;
    }

    @ApiModelProperty(required=true, value="array with the edges")
    @JsonProperty(value="edges")
    public List<Edge> getEdges() {
        return this.edges;
    }

    @JsonProperty(value="edges")
    public void setEdges(List<Edge> edges) {
        this.edges = edges;
    }

    public Graph addEdgesItem(Edge edgesItem) {
        if (this.edges == null) {
            this.edges = new ArrayList<Edge>();
        }
        this.edges.add(edgesItem);
        return this;
    }

    public Graph removeEdgesItem(Edge edgesItem) {
        if (edgesItem != null && this.edges != null) {
            this.edges.remove(edgesItem);
        }
        return this;
    }

    public Graph vertices(List<Vertex> vertices) {
        this.vertices = vertices;
        return this;
    }

    @ApiModelProperty(required=true, value="array with the vertices")
    @JsonProperty(value="vertices")
    public List<Vertex> getVertices() {
        return this.vertices;
    }

    @JsonProperty(value="vertices")
    public void setVertices(List<Vertex> vertices) {
        this.vertices = vertices;
    }

    public Graph addVerticesItem(Vertex verticesItem) {
        if (this.vertices == null) {
            this.vertices = new ArrayList<Vertex>();
        }
        this.vertices.add(verticesItem);
        return this;
    }

    public Graph removeVerticesItem(Vertex verticesItem) {
        if (verticesItem != null && this.vertices != null) {
            this.vertices.remove(verticesItem);
        }
        return this;
    }

    public Graph numResults(Integer numResults) {
        this.numResults = numResults;
        return this;
    }

    @ApiModelProperty(required=true, value="number of results that the graph contains")
    @JsonProperty(value="numResults")
    public Integer getNumResults() {
        return this.numResults;
    }

    @JsonProperty(value="numResults")
    public void setNumResults(Integer numResults) {
        this.numResults = numResults;
    }

    public Graph graphOwner(String graphOwner) {
        this.graphOwner = graphOwner;
        return this;
    }

    @ApiModelProperty(value="username that owns the graph")
    @JsonProperty(value="graphOwner")
    public String getGraphOwner() {
        return this.graphOwner;
    }

    @JsonProperty(value="graphOwner")
    public void setGraphOwner(String graphOwner) {
        this.graphOwner = graphOwner;
    }

    public Graph graphName(String graphName) {
        this.graphName = graphName;
        return this;
    }

    @ApiModelProperty(value="name of the graph")
    @JsonProperty(value="graphName")
    public String getGraphName() {
        return this.graphName;
    }

    @JsonProperty(value="graphName")
    public void setGraphName(String graphName) {
        this.graphName = graphName;
    }

    public Graph isLastResultSet(Boolean isLastResultSet) {
        this.isLastResultSet = isLastResultSet;
        return this;
    }

    @ApiModelProperty(value="flag to know if already reached last result")
    @JsonProperty(value="isLastResultSet")
    public Boolean getIsLastResultSet() {
        return this.isLastResultSet;
    }

    @JsonProperty(value="isLastResultSet")
    public void setIsLastResultSet(Boolean isLastResultSet) {
        this.isLastResultSet = isLastResultSet;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Graph graph = (Graph)o;
        return Objects.equals(this.edges, graph.edges) && Objects.equals(this.vertices, graph.vertices) && Objects.equals(this.numResults, graph.numResults) && Objects.equals(this.graphOwner, graph.graphOwner) && Objects.equals(this.graphName, graph.graphName) && Objects.equals(this.isLastResultSet, graph.isLastResultSet);
    }

    public int hashCode() {
        return Objects.hash(this.edges, this.vertices, this.numResults, this.graphOwner, this.graphName, this.isLastResultSet);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Graph {\n");
        sb.append("    edges: ").append(this.toIndentedString(this.edges)).append("\n");
        sb.append("    vertices: ").append(this.toIndentedString(this.vertices)).append("\n");
        sb.append("    numResults: ").append(this.toIndentedString(this.numResults)).append("\n");
        sb.append("    graphOwner: ").append(this.toIndentedString(this.graphOwner)).append("\n");
        sb.append("    graphName: ").append(this.toIndentedString(this.graphName)).append("\n");
        sb.append("    isLastResultSet: ").append(this.toIndentedString(this.isLastResultSet)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

