/*
 * Decompiled with CFR 0.152.
 */
package oracle.gvt.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Object to describe a condition, it needs a property, operator and value")
@JsonTypeName(value="ExpandCondition")
public class ExpandCondition {
    private String component;
    private String property;
    private String operator;
    private String value;

    public ExpandCondition component(String component) {
        this.component = component;
        return this;
    }

    @ApiModelProperty(example="VERTEX", required=true, value="to which object will apply")
    @JsonProperty(value="component")
    public String getComponent() {
        return this.component;
    }

    @JsonProperty(value="component")
    public void setComponent(String component) {
        this.component = component;
    }

    public ExpandCondition property(String property) {
        this.property = property;
        return this;
    }

    @ApiModelProperty(example="COUNTRY_NAME", required=true, value="the property to compare")
    @JsonProperty(value="property")
    public String getProperty() {
        return this.property;
    }

    @JsonProperty(value="property")
    public void setProperty(String property) {
        this.property = property;
    }

    public ExpandCondition operator(String operator) {
        this.operator = operator;
        return this;
    }

    @ApiModelProperty(example="=", required=true, value="operator to be used for comparition")
    @JsonProperty(value="operator")
    public String getOperator() {
        return this.operator;
    }

    @JsonProperty(value="operator")
    public void setOperator(String operator) {
        this.operator = operator;
    }

    public ExpandCondition value(String value) {
        this.value = value;
        return this;
    }

    @ApiModelProperty(example="MEXICO", required=true, value="the value to compare against the property")
    @JsonProperty(value="value")
    public String getValue() {
        return this.value;
    }

    @JsonProperty(value="value")
    public void setValue(String value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExpandCondition expandCondition = (ExpandCondition)o;
        return Objects.equals(this.component, expandCondition.component) && Objects.equals(this.property, expandCondition.property) && Objects.equals(this.operator, expandCondition.operator) && Objects.equals(this.value, expandCondition.value);
    }

    public int hashCode() {
        return Objects.hash(this.component, this.property, this.operator, this.value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ExpandCondition {\n");
        sb.append("    component: ").append(this.toIndentedString(this.component)).append("\n");
        sb.append("    property: ").append(this.toIndentedString(this.property)).append("\n");
        sb.append("    operator: ").append(this.toIndentedString(this.operator)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

