/*
 * Decompiled with CFR 0.152.
 */
package oracle.gvt.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import oracle.gvt.models.DynamicForms;

@ApiModel(description="expand object that is passed as part of the expand request")
@JsonTypeName(value="Expand")
public class Expand {
    private List<String> verticesIds = new ArrayList<String>();
    private Integer numberOfHops = 1;
    private DynamicForms dynamicFormParams;

    public Expand verticesIds(List<String> verticesIds) {
        this.verticesIds = verticesIds;
        return this;
    }

    @ApiModelProperty(example="[\"PERSON(100)\",\"COMPANY(1)\"]", required=true, value="array with the vertex IDs to expand")
    @JsonProperty(value="verticesIds")
    public List<String> getVerticesIds() {
        return this.verticesIds;
    }

    @JsonProperty(value="verticesIds")
    public void setVerticesIds(List<String> verticesIds) {
        this.verticesIds = verticesIds;
    }

    public Expand addVerticesIdsItem(String verticesIdsItem) {
        if (this.verticesIds == null) {
            this.verticesIds = new ArrayList<String>();
        }
        this.verticesIds.add(verticesIdsItem);
        return this;
    }

    public Expand removeVerticesIdsItem(String verticesIdsItem) {
        if (verticesIdsItem != null && this.verticesIds != null) {
            this.verticesIds.remove(verticesIdsItem);
        }
        return this;
    }

    public Expand numberOfHops(Integer numberOfHops) {
        this.numberOfHops = numberOfHops;
        return this;
    }

    @ApiModelProperty(required=true, value="Number of hops to find the expanded vertices")
    @JsonProperty(value="numberOfHops")
    public Integer getNumberOfHops() {
        return this.numberOfHops;
    }

    @JsonProperty(value="numberOfHops")
    public void setNumberOfHops(Integer numberOfHops) {
        this.numberOfHops = numberOfHops;
    }

    public Expand dynamicFormParams(DynamicForms dynamicFormParams) {
        this.dynamicFormParams = dynamicFormParams;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="dynamicFormParams")
    public DynamicForms getDynamicFormParams() {
        return this.dynamicFormParams;
    }

    @JsonProperty(value="dynamicFormParams")
    public void setDynamicFormParams(DynamicForms dynamicFormParams) {
        this.dynamicFormParams = dynamicFormParams;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Expand expand = (Expand)o;
        return Objects.equals(this.verticesIds, expand.verticesIds) && Objects.equals(this.numberOfHops, expand.numberOfHops) && Objects.equals(this.dynamicFormParams, expand.dynamicFormParams);
    }

    public int hashCode() {
        return Objects.hash(this.verticesIds, this.numberOfHops, this.dynamicFormParams);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Expand {\n");
        sb.append("    verticesIds: ").append(this.toIndentedString(this.verticesIds)).append("\n");
        sb.append("    numberOfHops: ").append(this.toIndentedString(this.numberOfHops)).append("\n");
        sb.append("    dynamicFormParams: ").append(this.toIndentedString(this.dynamicFormParams)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

