/*
 * Decompiled with CFR 0.152.
 */
package oracle.gvt.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Object to describe attributes of an edge object on GVT format")
@JsonTypeName(value="Edge")
public class Edge {
    private String source;
    private String target;
    private String id;
    private List<String> labels = new ArrayList<String>();
    private Map<String, Object> properties = new HashMap<String, Object>();

    public Edge source(String source) {
        this.source = source;
        return this;
    }

    @ApiModelProperty(example="VERTEX(1)", required=true, value="Identifier of the source vertex entity")
    @JsonProperty(value="source")
    public String getSource() {
        return this.source;
    }

    @JsonProperty(value="source")
    public void setSource(String source) {
        this.source = source;
    }

    public Edge target(String target) {
        this.target = target;
        return this;
    }

    @ApiModelProperty(example="VERTEX(2)", required=true, value="Identifier of the target vertex entity")
    @JsonProperty(value="target")
    public String getTarget() {
        return this.target;
    }

    @JsonProperty(value="target")
    public void setTarget(String target) {
        this.target = target;
    }

    public Edge id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(required=true, value="Identifier of the vertex/edge")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    public void setId(String id) {
        this.id = id;
    }

    public Edge labels(List<String> labels) {
        this.labels = labels;
        return this;
    }

    @ApiModelProperty(required=true, value="Array with the edge labels")
    @JsonProperty(value="labels")
    public List<String> getLabels() {
        return this.labels;
    }

    @JsonProperty(value="labels")
    public void setLabels(List<String> labels) {
        this.labels = labels;
    }

    public Edge addLabelsItem(String labelsItem) {
        if (this.labels == null) {
            this.labels = new ArrayList<String>();
        }
        this.labels.add(labelsItem);
        return this;
    }

    public Edge removeLabelsItem(String labelsItem) {
        if (labelsItem != null && this.labels != null) {
            this.labels.remove(labelsItem);
        }
        return this;
    }

    public Edge properties(Map<String, Object> properties) {
        this.properties = properties;
        return this;
    }

    @ApiModelProperty(required=true, value="Object to describe the properties of the vertex/edge")
    @JsonProperty(value="properties")
    public Map<String, Object> getProperties() {
        return this.properties;
    }

    @JsonProperty(value="properties")
    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public Edge putPropertiesItem(String key, Object propertiesItem) {
        if (this.properties == null) {
            this.properties = new HashMap<String, Object>();
        }
        this.properties.put(key, propertiesItem);
        return this;
    }

    public Edge removePropertiesItem(Object propertiesItem) {
        if (propertiesItem != null && this.properties != null) {
            this.properties.remove(propertiesItem);
        }
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Edge edge = (Edge)o;
        return Objects.equals(this.source, edge.source) && Objects.equals(this.target, edge.target) && Objects.equals(this.id, edge.id) && Objects.equals(this.labels, edge.labels) && Objects.equals(this.properties, edge.properties);
    }

    public int hashCode() {
        return Objects.hash(this.source, this.target, this.id, this.labels, this.properties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Edge {\n");
        sb.append("    source: ").append(this.toIndentedString(this.source)).append("\n");
        sb.append("    target: ").append(this.toIndentedString(this.target)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    labels: ").append(this.toIndentedString(this.labels)).append("\n");
        sb.append("    properties: ").append(this.toIndentedString(this.properties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

