/*
 * Decompiled with CFR 0.152.
 */
package oracle.gvt.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import oracle.gvt.models.GraphInformation;

@ApiModel(description="Information that is returned for a graph stored on the database")
@JsonTypeName(value="DatabaseGraphInformation")
public class DatabaseGraphInformation
extends GraphInformation {
    private String schema;

    public DatabaseGraphInformation schema(String schema) {
        this.schema = schema;
        return this;
    }

    @ApiModelProperty(value="Database schema where the graph is stored")
    @JsonProperty(value="schema")
    public String getSchema() {
        return this.schema;
    }

    @JsonProperty(value="schema")
    public void setSchema(String schema) {
        this.schema = schema;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DatabaseGraphInformation databaseGraphInformation = (DatabaseGraphInformation)o;
        return Objects.equals(this.schema, databaseGraphInformation.schema) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.schema, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DatabaseGraphInformation {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    schema: ").append(this.toIndentedString(this.schema)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

