/*
 * Decompiled with CFR 0.152.
 */
package oracle.datastudio.graphviz.gvt.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableMultiset;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import oracle.datastudio.graphviz.ResultGraphCreator;
import oracle.datastudio.graphviz.gvt.json.Edge;
import oracle.datastudio.graphviz.gvt.json.Vertex;
import oracle.pgx.graphviz.formatter.EnhancedResultSet;
import oracle.pgx.graphviz.formatter.Graph;
import oracle.pgx.graphviz.formatter.Property;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ResultGraph
implements ResultGraphCreator {
    @JsonProperty(value="vertices")
    public List<Vertex> vertices;
    @JsonProperty(value="edges")
    public List<Edge> edges;
    @JsonProperty(value="numResults")
    public long numResults;
    @JsonProperty(value="graphOwner")
    public String graphOwner;
    @JsonProperty(value="graphName")
    public String graphName;
    @Nullable
    @JsonProperty(value="isLastResultSet")
    public Boolean isLastResultSet;

    public ResultGraph() {
    }

    private ResultGraph(@Nonnull List<Vertex> vertices, @Nonnull List<Edge> edges, long numResults, String graphOwner, String graphName, @Nullable Boolean isLastResultSet) {
        this.vertices = vertices;
        this.edges = edges;
        this.numResults = numResults;
        this.graphOwner = graphOwner;
        this.graphName = graphName;
        this.isLastResultSet = isLastResultSet;
    }

    @Nullable
    public ResultGraph fromEnhancedResultSet(@Nonnull EnhancedResultSet enhancedResultSet, int start, int size, String graphOwner, String graphName) {
        return ResultGraph.staticfromEnhancedResultSet(enhancedResultSet, start, size, graphOwner, graphName);
    }

    @Nullable
    public static ResultGraph staticfromEnhancedResultSet(@Nonnull EnhancedResultSet enhancedResultSet, int start, int size, String graphOwner, String graphName) {
        Graph graph = enhancedResultSet.createGraphRepresentation(start, size);
        if (graph != null) {
            List<Vertex> vertices = graph.getVertices().stream().map(ResultGraph::mapVertex).collect(Collectors.toList());
            List<Edge> edges = graph.getEdges().stream().map(ResultGraph::mapEdge).collect(Collectors.toList());
            return new ResultGraph(vertices, edges, enhancedResultSet.getNumResults(), graphOwner, graphName, null);
        }
        return null;
    }

    @Nonnull
    private static Edge mapEdge(@Nonnull oracle.pgx.graphviz.formatter.Edge edge) {
        Edge ret = new Edge(edge.getId(), edge.getSourceId(), edge.getDestId(), ResultGraph.mapProperty(edge.getProperties()), edge.getLabels());
        return ret;
    }

    @Nonnull
    private static Vertex mapVertex(@Nonnull oracle.pgx.graphviz.formatter.Vertex vertex) {
        Vertex ret = new Vertex(vertex.getId(), ResultGraph.mapProperty(vertex.getProperties()), vertex.getLabels());
        return ret;
    }

    @Nonnull
    private static Map<String, Object> mapProperty(@Nonnull Collection<Property> propertyList) {
        HashMap<String, Object> mappedProperties = new HashMap<String, Object>();
        for (Property property : propertyList) {
            String propertyName = property.getName();
            Object value = property.getValue();
            if (value == null) {
                mappedProperties.put(propertyName, value);
                continue;
            }
            if (value instanceof Integer) {
                mappedProperties.put(propertyName, (Integer)value);
                continue;
            }
            if (value instanceof Boolean) {
                mappedProperties.put(propertyName, (Boolean)value);
                continue;
            }
            if (value instanceof Long) {
                mappedProperties.put(propertyName, (Long)value);
                continue;
            }
            if (value instanceof Double) {
                mappedProperties.put(propertyName, (Double)value);
                continue;
            }
            if (value instanceof BigDecimal) {
                mappedProperties.put(propertyName, (BigDecimal)value);
                continue;
            }
            mappedProperties.put(propertyName, String.valueOf(value));
        }
        return mappedProperties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResultGraph that = (ResultGraph)o;
        return ImmutableMultiset.copyOf(this.vertices).equals((Object)ImmutableMultiset.copyOf(that.vertices)) && ImmutableMultiset.copyOf(this.edges).equals((Object)ImmutableMultiset.copyOf(that.edges)) && this.numResults == that.numResults;
    }

    public int hashCode() {
        return Objects.hash(ImmutableMultiset.copyOf(this.vertices), ImmutableMultiset.copyOf(this.edges), this.numResults);
    }
}

