/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.terms;

import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;
import org.spoofax.interpreter.terms.TermType;

public abstract class TermTransformer {
    private final ITermFactory factory;
    private final boolean keepAttachments;

    public TermTransformer(ITermFactory factory, boolean keepAttachments) {
        this.factory = factory;
        this.keepAttachments = keepAttachments;
    }

    public final IStrategoTerm transform(IStrategoTerm term) {
        return (term = this.preTransform(term)) == null ? null : this.postTransform(this.simpleAll(term));
    }

    public abstract IStrategoTerm preTransform(IStrategoTerm var1);

    public IStrategoTerm postTransform(IStrategoTerm term) {
        return term;
    }

    public IStrategoTerm simpleAll(IStrategoTerm current) {
        IStrategoTerm result;
        TermType termType = current.getType();
        if (termType == TermType.LIST) {
            result = this.simpleMapIgnoreAnnos((IStrategoList)current);
        } else {
            IStrategoTerm[] inputs = current.getAllSubterms();
            IStrategoTerm[] results = null;
            int i = 0;
            while (i < inputs.length) {
                IStrategoTerm arg = inputs[i];
                IStrategoTerm arg2 = this.transform(arg);
                if (arg2 != arg) {
                    if (arg2 == null) {
                        return null;
                    }
                    if (results == null) {
                        results = (IStrategoTerm[])inputs.clone();
                    }
                    results[i] = this.keepAttachments ? this.factory.copyAttachments(arg, arg2) : arg2;
                }
                ++i;
            }
            if (results == null) {
                return current;
            }
            switch (termType) {
                case APPL: {
                    result = this.factory.makeAppl(((IStrategoAppl)current).getConstructor(), results, current.getAnnotations());
                    break;
                }
                case TUPLE: {
                    result = this.factory.makeTuple(results, current.getAnnotations());
                    break;
                }
                default: {
                    throw new IllegalStateException("unexpected term type: " + (Object)((Object)termType) + " - " + current);
                }
            }
        }
        return this.keepAttachments ? this.factory.copyAttachments(current, result) : result;
    }

    private IStrategoList simpleMapIgnoreAnnos(IStrategoList list) {
        IStrategoTerm[] inputs = list.getAllSubterms();
        IStrategoTerm[] results = null;
        int i = 0;
        while (i < inputs.length) {
            IStrategoTerm arg = inputs[i];
            IStrategoTerm arg2 = this.transform(arg);
            if (arg2 != arg) {
                if (arg2 == null) {
                    return null;
                }
                if (results == null) {
                    results = (IStrategoTerm[])inputs.clone();
                }
                results[i] = this.keepAttachments ? this.factory.copyAttachments(arg, arg2) : arg2;
            }
            ++i;
        }
        return results == null ? list : this.factory.makeList(results, list.getAnnotations());
    }
}

