/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.jsglr2.messages;

import jakarta.annotation.Nullable;
import java.io.Serializable;
import mb.jsglr.shared.IToken;
import org.spoofax.jsglr2.parser.Position;

public class SourceRegion
implements Serializable {
    public final int startOffset;
    public final int startRow;
    public final int startColumn;
    public final int endOffset;
    public final int endRow;
    public final int endColumn;

    public SourceRegion(int startOffset, int startRow, int startColumn, int endOffset, int endRow, int endColumn) {
        this.startOffset = startOffset;
        this.startRow = startRow;
        this.startColumn = startColumn;
        this.endOffset = endOffset;
        this.endRow = endRow;
        this.endColumn = endColumn;
    }

    public SourceRegion(Position start, Position end) {
        this.startOffset = start.offset;
        this.startRow = start.line;
        this.startColumn = start.column;
        this.endOffset = end.offset;
        this.endRow = end.line;
        this.endColumn = end.column;
    }

    public SourceRegion(Position position) {
        this(position, position);
    }

    public Position position() {
        return new Position(this.startOffset, this.startRow, this.startColumn);
    }

    public String toString() {
        return "[" + this.startOffset + "," + this.startRow + "," + this.startColumn + "," + this.endOffset + "," + this.endRow + "," + this.endColumn + ']';
    }

    public static SourceRegion fromToken(IToken token) {
        return new SourceRegion(token.getStartOffset(), token.getLine(), token.getColumn(), token.getEndOffset(), token.getEndLine(), token.getEndColumn());
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SourceRegion that = (SourceRegion)o;
        if (this.startOffset != that.startOffset) {
            return false;
        }
        if (this.startRow != that.startRow) {
            return false;
        }
        if (this.startColumn != that.startColumn) {
            return false;
        }
        if (this.endOffset != that.endOffset) {
            return false;
        }
        if (this.endRow != that.endRow) {
            return false;
        }
        return this.endColumn == that.endColumn;
    }

    public int hashCode() {
        int result = this.startOffset;
        result = 31 * result + this.startRow;
        result = 31 * result + this.startColumn;
        result = 31 * result + this.endOffset;
        result = 31 * result + this.endRow;
        result = 31 * result + this.endColumn;
        return result;
    }
}

