/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.jsglr.client.imploder;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import mb.jsglr.shared.ImploderAttachment;
import org.metaborg.util.collection.ImList;
import org.metaborg.util.functions.PartialFunction2;
import org.metaborg.util.iterators.ReverseListIterator;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoConstructor;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.IStrategoTuple;
import org.spoofax.interpreter.terms.ITermFactory;
import org.spoofax.terms.attachments.OriginAttachment;

public class Injections {
    private static final String INJ_ANNO = "inj";

    public static IStrategoTerm explicate(IStrategoTerm term, PartialFunction2<String, String, String> injName, ITermFactory factory) {
        String sort;
        IStrategoTerm result;
        ImList.Immutable<String> injections = ImList.Immutable.copyOf(Injections.getInjections(term));
        switch (term.getType()) {
            case APPL: {
                IStrategoAppl appl = (IStrategoAppl)term;
                IStrategoTerm[] subterms = Arrays.stream(appl.getAllSubterms()).map(subterm -> Injections.explicate(subterm, injName, factory)).collect(Collectors.toList()).toArray(new IStrategoTerm[appl.getSubtermCount()]);
                result = factory.makeAppl(appl.getConstructor(), subterms, appl.getAnnotations());
                sort = Injections.getImploderAttachment(term).getSort();
                break;
            }
            case TUPLE: {
                IStrategoTuple tuple = (IStrategoTuple)term;
                IStrategoTerm[] subterms = Arrays.stream(tuple.getAllSubterms()).map(subterm -> Injections.explicate(subterm, injName, factory)).collect(Collectors.toList()).toArray(new IStrategoTerm[tuple.getSubtermCount()]);
                result = factory.makeTuple(subterms, tuple.getAnnotations());
                List componentSorts = Arrays.stream(term.getAllSubterms()).map(t -> Injections.getImploderAttachment(t).getSort()).collect(Collectors.toList());
                sort = "Tuple_" + String.join((CharSequence)"_", componentSorts) + "_";
                break;
            }
            case LIST: {
                IStrategoList list = (IStrategoList)term;
                IStrategoTerm[] subterms = Arrays.stream(list.getAllSubterms()).map(subterm -> Injections.explicate(subterm, injName, factory)).collect(Collectors.toList()).toArray(new IStrategoTerm[list.getSubtermCount()]);
                result = factory.makeList(subterms, list.getAnnotations());
                String elementSort = Injections.getImploderAttachment(term).getElementSort();
                sort = "List_" + elementSort + "_";
                break;
            }
            default: {
                result = term;
                sort = Injections.getImploderAttachment(term).getSort();
            }
        }
        result = factory.copyAttachments(term, result);
        Injections.getImploderAttachment(result).clearInjections();
        for (String injection : ReverseListIterator.reverse(injections)) {
            Optional name = (Optional)injName.apply(sort, injection);
            if (!name.isPresent()) continue;
            IStrategoConstructor cons = factory.makeConstructor((String)name.get(), 1);
            IStrategoAppl anno = factory.makeAppl(INJ_ANNO, factory.makeString(sort), factory.makeString(injection));
            ImploderAttachment ia = Injections.getImploderAttachment(result);
            result = factory.makeAppl(cons, new IStrategoTerm[]{result}, factory.makeList(anno));
            sort = injection;
            if (ia == null) continue;
            ImploderAttachment.putImploderAttachment(result, false, sort, ia.getLeftToken(), ia.getRightToken(), false, false, false, false);
        }
        return result;
    }

    private static List<String> getInjections(IStrategoTerm term) {
        ImploderAttachment ia = Injections.getImploderAttachment(term);
        return ia == null ? Collections.emptyList() : ia.getInjections();
    }

    private static ImploderAttachment getImploderAttachment(IStrategoTerm term) {
        IStrategoTerm origin = OriginAttachment.tryGetOrigin(term);
        return ImploderAttachment.get(origin);
    }
}

