/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.interpreter.stratego;

import org.spoofax.interpreter.core.IConstruct;
import org.spoofax.interpreter.core.IContext;
import org.spoofax.interpreter.core.InterpreterException;
import org.spoofax.interpreter.stratego.All;
import org.spoofax.interpreter.stratego.Hook;
import org.spoofax.interpreter.stratego.Strategy;
import org.spoofax.interpreter.stratego.StupidFormatter;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.IStrategoTuple;

public class Some
extends Strategy {
    protected Strategy body;

    public Some(Strategy body) {
        this.body = body;
    }

    @Override
    public IConstruct eval(IContext env) throws InterpreterException {
        Some.debug("Some.eval() - ", env.current());
        IStrategoTerm t = env.current();
        switch (t.getType()) {
            case INT: 
            case REAL: 
            case STRING: {
                return this.getHook().pop().onFailure(env);
            }
            case APPL: {
                return this.eval(env, 0, false, (IStrategoTerm[])t.getAllSubterms().clone());
            }
            case LIST: 
            case TUPLE: {
                IStrategoTerm[] subterms = t.getAllSubterms();
                assert (All.isCopy(t, subterms));
                return this.eval(env, 0, false, subterms);
            }
            case BLOB: {
                return this.getHook().pop().onFailure(env);
            }
        }
        throw new InterpreterException("Unknown ATerm type " + (Object)((Object)t.getType()));
    }

    protected IConstruct eval(IContext env, final int n, final boolean hadsome, final IStrategoTerm[] list) throws InterpreterException {
        final IStrategoTerm old = env.current();
        if (n >= old.getSubtermCount()) {
            if (hadsome) {
                switch (old.getType()) {
                    case APPL: {
                        env.setCurrent(env.getFactory().replaceAppl(((IStrategoAppl)old).getConstructor(), list, (IStrategoAppl)old));
                        break;
                    }
                    case LIST: {
                        env.setCurrent(env.getFactory().replaceList(list, (IStrategoList)old));
                        break;
                    }
                    case TUPLE: {
                        env.setCurrent(env.getFactory().replaceTuple(list, (IStrategoTuple)old));
                    }
                }
                return this.getHook().pop().onSuccess(env);
            }
            return this.getHook().pop().onFailure(env);
        }
        env.setCurrent(list[n]);
        this.body.getHook().push(new Hook(){

            @Override
            public IConstruct onFailure(IContext env) throws InterpreterException {
                env.setCurrent(old);
                return Some.this.eval(env, n + 1, hadsome, list);
            }

            @Override
            public IConstruct onSuccess(IContext env) throws InterpreterException {
                list[n] = env.current();
                env.setCurrent(old);
                return Some.this.eval(env, n + 1, true, list);
            }
        });
        return this.body;
    }

    @Override
    public void prettyPrint(StupidFormatter sf) {
        sf.append("Some(");
        this.body.prettyPrint(sf);
        sf.append(")");
    }
}

