/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.sdf2table.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.metaborg.sdf2table.grammar.IProduction;
import org.metaborg.sdf2table.grammar.ISymbol;
import org.metaborg.sdf2table.grammar.Sort;
import org.metaborg.sdf2table.grammar.Symbol;
import org.metaborg.sdf2table.util.SCCNodes;
import org.metaborg.util.collection.SetMultimap;

public class CheckOverlap {
    private final SCCNodes<ISymbol> scc;
    private final Set<IProduction> p;
    private final Set<IProduction> q;
    private final int maxDepth;
    private final Map<Integer, Set<Node>> depthToTreesP = new HashMap<Integer, Set<Node>>();
    private final Map<Integer, Set<Node>> depthToTreesQ = new HashMap<Integer, Set<Node>>();
    private final SetMultimap<String, Node> yieldsP = new SetMultimap();
    private final SetMultimap<String, Node> yieldsQ = new SetMultimap();

    public CheckOverlap(Set<IProduction> p, Set<IProduction> q, int maxDepth, SCCNodes<ISymbol> scc) {
        this.p = p;
        this.q = q;
        this.maxDepth = maxDepth;
        this.scc = scc;
    }

    public String checkHarmfulOverlap() {
        Node node;
        int depth = 0;
        Set<Node> treesP = new HashSet<Node>();
        Set<Node> treesQ = new HashSet<Node>();
        for (IProduction prod : this.p) {
            node = new Node(prod);
            this.yieldsP.put(node.getYield(), node);
            node.productions.add(prod);
            treesP.add(node);
        }
        for (IProduction prod : this.q) {
            node = new Node(prod);
            this.yieldsQ.put(node.getYield(), node);
            treesQ.add(node);
        }
        this.depthToTreesP.put(depth, treesP);
        this.depthToTreesQ.put(depth, treesQ);
        while (depth < 2) {
            HashSet intersectingYields = new HashSet(this.yieldsP.keySet());
            intersectingYields.retainAll(this.yieldsQ.keySet());
            for (String yield : intersectingYields) {
                Set nodesQ;
                Set nodesP = (Set)this.yieldsP.get(yield);
                if (nodesP.equals(nodesQ = (Set)this.yieldsQ.get(yield))) continue;
                HashSet<IProduction> prodsP = new HashSet<IProduction>();
                HashSet<IProduction> prodsQ = new HashSet<IProduction>();
                for (Node n : nodesP) {
                    prodsP.addAll(n.productions);
                }
                for (Node n : nodesQ) {
                    prodsQ.addAll(n.productions);
                }
                if (prodsP.equals(prodsQ)) continue;
                return yield;
            }
            treesP = this.getNewTrees('p', ++depth);
            treesQ = this.getNewTrees('q', depth);
        }
        return null;
    }

    private Set<Node> getNewTrees(char set, int depth) {
        HashSet<Node> newTrees = new HashSet<Node>();
        if (set == 'p') {
            Set<Node> oldTrees = this.depthToTreesP.get(depth - 1);
            for (Node n : oldTrees) {
                int i = 0;
                while (i < n.leaves.size()) {
                    Node leaf = (Node)n.leaves.get(i);
                    if (n.symbol.equals(leaf.symbol)) {
                        for (IProduction prod : this.p) {
                            Node newTree = new Node(n);
                            newTree.productions.add(prod);
                            Node leafNewTree = (Node)newTree.leaves.get(i);
                            newTree.leaves.remove(i);
                            int j = 0;
                            while (j < prod.arity()) {
                                Node newLeaf = new Node(prod.rightHand().get(j));
                                newTree.leaves.add(i + j, newLeaf);
                                leafNewTree.children.add(newLeaf);
                                ++j;
                            }
                            String yield = newTree.getYield();
                            if (this.yieldsP.containsKey(yield)) {
                                this.yieldsP.put(yield, newTree);
                                continue;
                            }
                            this.yieldsP.put(yield, newTree);
                            newTrees.add(newTree);
                        }
                    }
                    ++i;
                }
            }
            this.depthToTreesP.put(depth, newTrees);
        } else {
            Set<Node> oldTrees = this.depthToTreesQ.get(depth - 1);
            for (Node n : oldTrees) {
                int i = 0;
                while (i < n.leaves.size()) {
                    Node leaf = (Node)n.leaves.get(i);
                    if (n.symbol.equals(leaf.symbol)) {
                        for (IProduction prod : this.q) {
                            Node newTree = new Node(n);
                            newTree.productions.add(prod);
                            Node leafNewTree = (Node)newTree.leaves.get(i);
                            newTree.leaves.remove(i);
                            int j = 0;
                            while (j < prod.arity()) {
                                Node newLeaf = new Node(prod.rightHand().get(j));
                                newTree.leaves.add(i + j, newLeaf);
                                leafNewTree.children.add(newLeaf);
                                ++j;
                            }
                            String yield = newTree.getYield();
                            if (this.yieldsQ.containsKey(yield)) {
                                this.yieldsQ.put(yield, newTree);
                                continue;
                            }
                            this.yieldsQ.put(yield, newTree);
                            newTrees.add(newTree);
                        }
                    }
                    ++i;
                }
            }
            this.depthToTreesQ.put(depth, newTrees);
        }
        return newTrees;
    }

    public int getMaxDepth() {
        return this.maxDepth;
    }

    public Set<IProduction> getQ() {
        return this.q;
    }

    public Set<IProduction> getP() {
        return this.p;
    }

    private class Node {
        private final ISymbol symbol;
        private final List<Node> children;
        private final List<Node> leaves;
        public final Set<IProduction> productions;

        public Node(ISymbol s) {
            this.symbol = s;
            this.leaves = new ArrayList<Node>();
            this.children = new ArrayList<Node>();
            this.productions = new HashSet<IProduction>();
        }

        public Node(IProduction p) {
            this.symbol = p.leftHand();
            this.leaves = new ArrayList<Node>();
            this.children = new ArrayList<Node>();
            this.productions = new HashSet<IProduction>(Arrays.asList(p));
            for (ISymbol symb_rhs : p.rightHand()) {
                Node child = new Node(symb_rhs);
                this.children.add(child);
                this.leaves.add(child);
            }
        }

        public Node(Node n) {
            this.symbol = n.symbol;
            this.leaves = new ArrayList<Node>();
            this.children = new ArrayList<Node>();
            this.productions = new HashSet<IProduction>(n.productions);
            for (Node child : n.children) {
                Node newChild = new Node(child);
                this.children.add(newChild);
                if (newChild.leaves.isEmpty()) {
                    this.leaves.add(newChild);
                    continue;
                }
                this.leaves.addAll(newChild.leaves);
            }
        }

        public String getYield() {
            String result = "";
            if (this.leaves.isEmpty()) {
                return this.symbol.toString();
            }
            for (Node leaf : this.leaves) {
                ISymbol leafSymb = leaf.symbol;
                if (leafSymb.toString().equals("LAYOUT?-CF")) {
                    result = String.valueOf(result) + " ";
                    continue;
                }
                if (leafSymb instanceof Sort && ((Sort)leafSymb).getType() != null) {
                    result = String.valueOf(result) + ((Sort)leafSymb).getSortName();
                    continue;
                }
                if (((CheckOverlap)CheckOverlap.this).scc.nodeSCCNodesMapping.get(leafSymb) != null) {
                    result = String.valueOf(result) + "[";
                    ArrayList sccNode = new ArrayList(((CheckOverlap)CheckOverlap.this).scc.nodeSCCNodesMapping.get(leafSymb));
                    int i = 0;
                    while (i < sccNode.size() - 1) {
                        result = String.valueOf(result) + Symbol.getSort((ISymbol)sccNode.get(i)) + ", ";
                        ++i;
                    }
                    result = String.valueOf(result) + Symbol.getSort((ISymbol)sccNode.get(sccNode.size() - 1)) + "]";
                    ((CheckOverlap)CheckOverlap.this).scc.nodeSCCNodesMapping.get(leafSymb).toString();
                    continue;
                }
                result = String.valueOf(result) + Symbol.getSort(leafSymb).toString();
            }
            return result;
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Node other = (Node)obj;
            return this.toString().equals(other.toString());
        }

        public String toString() {
            if (this.children.isEmpty()) {
                return this.symbol.toString();
            }
            String result = "[" + this.symbol + " = ";
            int i = 0;
            while (i < this.children.size() - 1) {
                result = String.valueOf(result) + this.children.get(i).toString() + " ";
                ++i;
            }
            result = String.valueOf(result) + this.children.get(this.children.size() - 1).toString() + "]";
            return result;
        }
    }
}

