/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms.pgql;

import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import oracle.pg.rdbms.ExpandQueryBuilderUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PgqlExpandQueryBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(PgqlExpandQueryBuilder.class);
    private static final String BASE_PATTERN = "(x) ->{,%d} (y)";
    private static final String ONE_HOP_QUERY = "SELECT e1 FROM MATCH (x) - [e1] -> () ON %s WHERE id(x) IN (%s)";
    private static final String BASE_QUERY = "SELECT e1 FROM MATCH ANY %s ON %s, MATCH (y) - [e1] -> () ON %s WHERE id(x) IN (%s)";

    private static String getPattern(int hops) {
        return String.format(BASE_PATTERN, hops - 1);
    }

    private static String getFormattedIds(Statement statement, String[] verticesIds) {
        return Arrays.stream(verticesIds).map(p -> {
            try {
                return statement.enquoteLiteral((String)p);
            }
            catch (SQLException e) {
                throw new IllegalArgumentException("Could not enquote this literal: " + p, e);
            }
        }).collect(Collectors.joining(", "));
    }

    public static String generateExpandQuery(Statement statement, @Nullable String schema, String graphName, String[] verticesIds, int hops) {
        String enquotedName = ExpandQueryBuilderUtils.enquotedGraphName(statement, schema, graphName);
        String matchPattern = PgqlExpandQueryBuilder.getPattern(hops);
        String formattedIds = PgqlExpandQueryBuilder.getFormattedIds(statement, verticesIds);
        String query = String.format(ONE_HOP_QUERY, enquotedName, formattedIds);
        if (hops > 1) {
            query = String.format(BASE_QUERY, matchPattern, enquotedName, enquotedName, formattedIds);
        }
        LOG.info("Generated following query for expand action {}", (Object)query);
        return query;
    }
}

