/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Map;
import javax.annotation.Nullable;
import javax.sql.DataSource;
import javax.ws.rs.NotSupportedException;
import oracle.graphviz.pgql.AbstractPgqlDriver;
import oracle.gvt.models.DynamicForms;
import oracle.gvt.models.ExpandTemplate;
import oracle.pgx.graphviz.driver.exception.VisualizationException;

public abstract class RdbmsDriver
extends AbstractPgqlDriver {
    public static final String DATASOURCE_ATTRIBUTE = "datasource";
    public static final String MAX_POOL_SIZE_ATTRIBUTE = "graphviz.driver.rdbms.max_pool_size";

    public RdbmsDriver(Map<String, Object> properties) {
        super(properties);
    }

    public String getVersion(Map<String, Object> properties) throws SQLException {
        DataSource ods = (DataSource)properties.get(DATASOURCE_ATTRIBUTE);
        try (Connection conn = ods.getConnection();){
            DatabaseMetaData metaData = conn.getMetaData();
            String string = String.valueOf(metaData.getDatabaseMajorVersion() + "." + metaData.getDatabaseMinorVersion());
            return string;
        }
    }

    public String smartExpandGraph(@Nullable String schema, String graphName, String[] selectedVertices, ExpandTemplate expandTemplate, DynamicForms dynamicFormsParams, Map<String, Object> properties) throws VisualizationException {
        throw new NotSupportedException("Smart expand graph action is only supported for PGX Graphs");
    }
}

