/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms;

import java.sql.SQLException;
import java.sql.Statement;
import javax.annotation.Nullable;

public class ExpandQueryBuilderUtils {
    private static final String ENQUOTED_SCHEMA_AND_GRAPH_NAME = "%s.%s";

    public static String enquotedGraphName(Statement statement, @Nullable String schemaName, String graphName) {
        String enquotedGraphName = "";
        try {
            enquotedGraphName = statement.enquoteIdentifier(graphName, true);
            if (schemaName != null) {
                String enquotedSchema = statement.enquoteIdentifier(schemaName, true);
                return String.format(ENQUOTED_SCHEMA_AND_GRAPH_NAME, enquotedSchema, enquotedGraphName);
            }
        }
        catch (SQLException e) {
            throw new IllegalArgumentException("Could not enquote this schema or graph name.", e);
        }
        return enquotedGraphName;
    }
}

