/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.common.util;

import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Spliterators;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import oracle.pgx.common.util.function.BiConsumerWithException;

public final class PairIterators {
    private PairIterators() {
    }

    public static <A, B> Optional<Iterator<?>> forEachPairIndexed(Iterable<A> iterableA, Iterable<B> iterableB, IndexedBiConsumer<A, B> consumer) {
        return PairIterators.forEachPairIndexed(iterableA.iterator(), iterableB.iterator(), consumer);
    }

    public static <A, B> Optional<Iterator<?>> forEachPairIndexed(Iterator<A> iteratorA, Iterator<B> iteratorB, IndexedBiConsumer<A, B> consumer) {
        long i = 0L;
        while (iteratorA.hasNext() && iteratorB.hasNext()) {
            consumer.accept(i++, iteratorA.next(), iteratorB.next());
        }
        if (iteratorA.hasNext() == iteratorB.hasNext()) {
            return Optional.empty();
        }
        return iteratorA.hasNext() ? Optional.of(iteratorA) : Optional.of(iteratorB);
    }

    public static <A, B> Optional<Iterator<?>> forEachPair(Iterable<A> iterableA, Iterable<B> iterableB, BiConsumer<A, B> consumer) {
        return PairIterators.forEachPair(iterableA.iterator(), iterableB.iterator(), consumer);
    }

    public static <A, B> Optional<Iterator<?>> forEachPair(Iterator<A> iteratorA, Iterator<B> iteratorB, BiConsumer<A, B> consumer) {
        while (iteratorA.hasNext() && iteratorB.hasNext()) {
            consumer.accept(iteratorA.next(), iteratorB.next());
        }
        if (iteratorA.hasNext() == iteratorB.hasNext()) {
            return Optional.empty();
        }
        return iteratorA.hasNext() ? Optional.of(iteratorA) : Optional.of(iteratorB);
    }

    public static <A, B> Optional<Iterator<?>> forEachPair(Stream<A> streamA, Stream<B> streamB, BiConsumer<A, B> consumer) {
        return PairIterators.forEachPair(streamA.iterator(), streamB.iterator(), consumer);
    }

    public static <A, B> void forEachCombination(Iterable<A> iterableA, Iterable<B> iterableB, BiConsumerWithException<A, B, ? extends Throwable> consumer) {
        iterableA.forEach(a -> iterableB.forEach(b -> consumer.accept(a, b)));
    }

    public static <A, B> void forEachCombination(Stream<A> streamA, Supplier<Stream<B>> streamBSupplier, BiConsumerWithException<A, B, ? extends Throwable> consumer) {
        PairIterators.forEachCombination(streamA::iterator, () -> ((Stream)streamBSupplier.get()).iterator(), consumer);
    }

    public static <A, B, R> Stream<R> mapEachCombination(List<A> listA, List<B> listB, BiFunction<A, B, R> mapper) {
        int[] indices = new int[]{0, 0};
        UnaryOperator incrementIndex = index -> {
            index[0] = index[0] + 1;
            if (index[0] == listA.size()) {
                index[0] = 0;
                index[1] = index[1] + 1;
            }
            return index;
        };
        return Stream.iterate(indices, incrementIndex).limit(listA.size() * listB.size()).map(index -> mapper.apply(listA.get(index[0]), listB.get(index[1])));
    }

    public static <A, B, C> Iterator<C> mapPair(final Iterator<A> iteratorA, final Iterator<B> iteratorB, final BiFunction<A, B, C> function) {
        return new Iterator<C>(){

            @Override
            public boolean hasNext() {
                return iteratorA.hasNext() && iteratorB.hasNext();
            }

            @Override
            public C next() {
                return function.apply(iteratorA.next(), iteratorB.next());
            }
        };
    }

    public static <A, B, C> Iterable<C> mapPair(Iterable<A> iterableA, Iterable<B> iterableB, BiFunction<A, B, C> function) {
        return () -> PairIterators.mapPair(iterableA.iterator(), iterableB.iterator(), function);
    }

    public static <A, B, C> Stream<C> mapPair(Stream<A> streamA, Stream<B> streamB, BiFunction<A, B, C> function) {
        Iterator<C> iterator = PairIterators.mapPair(streamA.iterator(), streamB.iterator(), function);
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 1024), false);
    }

    public static interface IndexedBiConsumer<A, B> {
        public void accept(long var1, A var3, B var4);
    }
}

