/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.keys;

import oracle.pgx.api.beta.annotation.BetaApi;
import oracle.pgx.common.types.IdType;
import oracle.pgx.common.util.ErrorMessages;

@BetaApi
public final class KeyTypeUtils {
    public static Object tryConvert(Object value, IdType destinationType) {
        switch (destinationType) {
            case INTEGER: {
                if (!(value instanceof Integer)) break;
                return value;
            }
            case LONG: {
                if (value instanceof Long) {
                    return value;
                }
                if (!(value instanceof Integer)) break;
                return ((Integer)value).longValue();
            }
            case STRING: {
                if (!(value instanceof Integer) && !(value instanceof Long) && !(value instanceof String)) break;
                return String.valueOf(value);
            }
        }
        throw new IllegalArgumentException(ErrorMessages.getMessage("KEY_COLUMN_CANNOT_BE_CONVERTED", destinationType));
    }
}

