# A Book and a Library

This repository hosts both the book, **A First Course on Data Structures in Python** and the python package **ds2** that is extracted from that book.

The book covers fundamentals of data structures in Python and the library contains fully-tested implementations of the data structures in the book.

The book is a literate program.
The code is woven into the text.
As such, there are few inline comments.
The comments are the book.
Moreover, the code files are automatically generated from the markdown files that define the book.

# A First Course on Data Structures in Python

## by Don Sheehy

## Overview

*This book is designed to cover a lot of ground quickly, without taking shortcuts.*

**What does that mean?**
It means that concepts are motivated and start with simple examples.
The ideas follow the problems.
The abstractions follow the concrete instances.

**What does it not mean?**
The book is not meant to be comprehensive, covering all of data structures,
nor is it a complete introduction to all the details of python.
Introducing the minimum necessary knowledge to make interesting programs and learn useful concepts is not taking shortcuts, it's just being directed.

There are many books that will teach idiomatic python programming, and many others that will teach problem solving, data structures, or algorithms.
There are many books for learning design patterns, testing, and many of the other important practices of software engineering.
The aim of this book is cover many of these topics as part of an integrated course.

Towards that aim, the organization is both *simple* and *complex*.
The *simple* part is that the overall sequencing of the main topics is motivated by the data structuring problems, as is evident from the chapter titles.
The *complex* part is that many other concepts including problem solving strategies, more advanced python, object-oriented design principles, and testing methodologies are introduced bit by bit throughout the text in a logical, incremental way.

As a result, the book is not meant to be a reference.
It is meant to be worked through from beginning to end.
Many topics dear to my heart were left out to make it possible to work through the whole book in a single semester course.

# The full book as a pdf can be found <a href="https://donsheehy.github.io/datastructures/">here</a>.
