# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.core.exceptions import HttpResponseError
import msrest.serialization


class Activity(msrest.serialization.Model):
    """A pipeline activity.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AppendVariableActivity, ControlActivity, ExecutePipelineActivity, ExecutionActivity, FilterActivity, ForEachActivity, IfConditionActivity, SetVariableActivity, SynapseSparkJobDefinitionActivity, SqlPoolStoredProcedureActivity, SwitchActivity, SynapseNotebookActivity, UntilActivity, ValidationActivity, WaitActivity, WebHookActivity.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param name: Required. Activity name.
    :type name: str
    :param type: Required. Type of activity.Constant filled by server.
    :type type: str
    :param description: Activity description.
    :type description: str
    :param depends_on: Activity depends on condition.
    :type depends_on: list[~azure.synapse.artifacts.models.ActivityDependency]
    :param user_properties: Activity user properties.
    :type user_properties: list[~azure.synapse.artifacts.models.UserProperty]
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'depends_on': {'key': 'dependsOn', 'type': '[ActivityDependency]'},
        'user_properties': {'key': 'userProperties', 'type': '[UserProperty]'},
    }

    _subtype_map = {
        'type': {'AppendVariable': 'AppendVariableActivity', 'Container': 'ControlActivity', 'ExecutePipeline': 'ExecutePipelineActivity', 'Execution': 'ExecutionActivity', 'Filter': 'FilterActivity', 'ForEach': 'ForEachActivity', 'IfCondition': 'IfConditionActivity', 'SetVariable': 'SetVariableActivity', 'SparkJob': 'SynapseSparkJobDefinitionActivity', 'SqlPoolStoredProcedure': 'SqlPoolStoredProcedureActivity', 'Switch': 'SwitchActivity', 'SynapseNotebook': 'SynapseNotebookActivity', 'Until': 'UntilActivity', 'Validation': 'ValidationActivity', 'Wait': 'WaitActivity', 'WebHook': 'WebHookActivity'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Activity, self).__init__(**kwargs)
        self.additional_properties = kwargs.get('additional_properties', None)
        self.name = kwargs['name']
        self.type = 'Activity'  # type: str
        self.description = kwargs.get('description', None)
        self.depends_on = kwargs.get('depends_on', None)
        self.user_properties = kwargs.get('user_properties', None)


class ActivityDependency(msrest.serialization.Model):
    """Activity dependency information.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param activity: Required. Activity name.
    :type activity: str
    :param dependency_conditions: Required. Match-Condition for the dependency.
    :type dependency_conditions: list[str or ~azure.synapse.artifacts.models.DependencyCondition]
    """

    _validation = {
        'activity': {'required': True},
        'dependency_conditions': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'activity': {'key': 'activity', 'type': 'str'},
        'dependency_conditions': {'key': 'dependencyConditions', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ActivityDependency, self).__init__(**kwargs)
        self.additional_properties = kwargs.get('additional_properties', None)
        self.activity = kwargs['activity']
        self.dependency_conditions = kwargs['dependency_conditions']


class ActivityPolicy(msrest.serialization.Model):
    """Execution policy for an activity.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param timeout: Specifies the timeout for the activity to run. The default timeout is 7 days.
     Type: string (or Expression with resultType string), pattern:
     ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type timeout: object
    :param retry: Maximum ordinary retry attempts. Default is 0. Type: integer (or Expression with
     resultType integer), minimum: 0.
    :type retry: object
    :param retry_interval_in_seconds: Interval between each retry attempt (in seconds). The default
     is 30 sec.
    :type retry_interval_in_seconds: int
    :param secure_input: When set to true, Input from activity is considered as secure and will not
     be logged to monitoring.
    :type secure_input: bool
    :param secure_output: When set to true, Output from activity is considered as secure and will
     not be logged to monitoring.
    :type secure_output: bool
    """

    _validation = {
        'retry_interval_in_seconds': {'maximum': 86400, 'minimum': 30},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'timeout': {'key': 'timeout', 'type': 'object'},
        'retry': {'key': 'retry', 'type': 'object'},
        'retry_interval_in_seconds': {'key': 'retryIntervalInSeconds', 'type': 'int'},
        'secure_input': {'key': 'secureInput', 'type': 'bool'},
        'secure_output': {'key': 'secureOutput', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ActivityPolicy, self).__init__(**kwargs)
        self.additional_properties = kwargs.get('additional_properties', None)
        self.timeout = kwargs.get('timeout', None)
        self.retry = kwargs.get('retry', None)
        self.retry_interval_in_seconds = kwargs.get('retry_interval_in_seconds', None)
        self.secure_input = kwargs.get('secure_input', None)
        self.secure_output = kwargs.get('secure_output', None)


class ActivityRun(msrest.serialization.Model):
    """Information about an activity run in a pipeline.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :ivar pipeline_name: The name of the pipeline.
    :vartype pipeline_name: str
    :ivar pipeline_run_id: The id of the pipeline run.
    :vartype pipeline_run_id: str
    :ivar activity_name: The name of the activity.
    :vartype activity_name: str
    :ivar activity_type: The type of the activity.
    :vartype activity_type: str
    :ivar activity_run_id: The id of the activity run.
    :vartype activity_run_id: str
    :ivar linked_service_name: The name of the compute linked service.
    :vartype linked_service_name: str
    :ivar status: The status of the activity run.
    :vartype status: str
    :ivar activity_run_start: The start time of the activity run in 'ISO 8601' format.
    :vartype activity_run_start: ~datetime.datetime
    :ivar activity_run_end: The end time of the activity run in 'ISO 8601' format.
    :vartype activity_run_end: ~datetime.datetime
    :ivar duration_in_ms: The duration of the activity run.
    :vartype duration_in_ms: int
    :ivar input: The input for the activity.
    :vartype input: object
    :ivar output: The output for the activity.
    :vartype output: object
    :ivar error: The error if any from the activity run.
    :vartype error: object
    """

    _validation = {
        'pipeline_name': {'readonly': True},
        'pipeline_run_id': {'readonly': True},
        'activity_name': {'readonly': True},
        'activity_type': {'readonly': True},
        'activity_run_id': {'readonly': True},
        'linked_service_name': {'readonly': True},
        'status': {'readonly': True},
        'activity_run_start': {'readonly': True},
        'activity_run_end': {'readonly': True},
        'duration_in_ms': {'readonly': True},
        'input': {'readonly': True},
        'output': {'readonly': True},
        'error': {'readonly': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'pipeline_name': {'key': 'pipelineName', 'type': 'str'},
        'pipeline_run_id': {'key': 'pipelineRunId', 'type': 'str'},
        'activity_name': {'key': 'activityName', 'type': 'str'},
        'activity_type': {'key': 'activityType', 'type': 'str'},
        'activity_run_id': {'key': 'activityRunId', 'type': 'str'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'activity_run_start': {'key': 'activityRunStart', 'type': 'iso-8601'},
        'activity_run_end': {'key': 'activityRunEnd', 'type': 'iso-8601'},
        'duration_in_ms': {'key': 'durationInMs', 'type': 'int'},
        'input': {'key': 'input', 'type': 'object'},
        'output': {'key': 'output', 'type': 'object'},
        'error': {'key': 'error', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ActivityRun, self).__init__(**kwargs)
        self.additional_properties = kwargs.get('additional_properties', None)
        self.pipeline_name = None
        self.pipeline_run_id = None
        self.activity_name = None
        self.activity_type = None
        self.activity_run_id = None
        self.linked_service_name = None
        self.status = None
        self.activity_run_start = None
        self.activity_run_end = None
        self.duration_in_ms = None
        self.input = None
        self.output = None
        self.error = None


class ActivityRunsQueryResponse(msrest.serialization.Model):
    """A list activity runs.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. List of activity runs.
    :type value: list[~azure.synapse.artifacts.models.ActivityRun]
    :param continuation_token: The continuation token for getting the next page of results, if any
     remaining results exist, null otherwise.
    :type continuation_token: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ActivityRun]'},
        'continuation_token': {'key': 'continuationToken', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ActivityRunsQueryResponse, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.continuation_token = kwargs.get('continuation_token', None)


class AddDataFlowToDebugSessionResponse(msrest.serialization.Model):
    """Response body structure for starting data flow debug session.

    :param job_version: The ID of data flow debug job version.
    :type job_version: str
    """

    _attribute_map = {
        'job_version': {'key': 'jobVersion', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AddDataFlowToDebugSessionResponse, self).__init__(**kwargs)
        self.job_version = kwargs.get('job_version', None)


class LinkedService(msrest.serialization.Model):
    """The Azure Synapse nested object which contains the information and credential which can be used to connect with related store or compute resource.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AmazonMWSLinkedService, AmazonRedshiftLinkedService, AmazonS3LinkedService, AzureBatchLinkedService, AzureBlobFSLinkedService, AzureBlobStorageLinkedService, AzureDataExplorerLinkedService, AzureDataLakeAnalyticsLinkedService, AzureDataLakeStoreLinkedService, AzureDatabricksLinkedService, AzureFileStorageLinkedService, AzureFunctionLinkedService, AzureKeyVaultLinkedService, AzureMLLinkedService, AzureMLServiceLinkedService, AzureMariaDBLinkedService, AzureMySqlLinkedService, AzurePostgreSqlLinkedService, AzureSearchLinkedService, AzureSqlDWLinkedService, AzureSqlDatabaseLinkedService, AzureSqlMILinkedService, AzureStorageLinkedService, AzureTableStorageLinkedService, CassandraLinkedService, CommonDataServiceForAppsLinkedService, ConcurLinkedService, CosmosDbLinkedService, CosmosDbMongoDbApiLinkedService, CouchbaseLinkedService, CustomDataSourceLinkedService, Db2LinkedService, DrillLinkedService, DynamicsLinkedService, DynamicsAXLinkedService, DynamicsCrmLinkedService, EloquaLinkedService, FileServerLinkedService, FtpServerLinkedService, GoogleAdWordsLinkedService, GoogleBigQueryLinkedService, GoogleCloudStorageLinkedService, GreenplumLinkedService, HBaseLinkedService, HDInsightLinkedService, HDInsightOnDemandLinkedService, HdfsLinkedService, HiveLinkedService, HttpLinkedService, HubspotLinkedService, ImpalaLinkedService, InformixLinkedService, JiraLinkedService, MagentoLinkedService, MariaDBLinkedService, MarketoLinkedService, MicrosoftAccessLinkedService, MongoDbLinkedService, MongoDbV2LinkedService, MySqlLinkedService, NetezzaLinkedService, ODataLinkedService, OdbcLinkedService, Office365LinkedService, OracleLinkedService, OracleServiceCloudLinkedService, PaypalLinkedService, PhoenixLinkedService, PostgreSqlLinkedService, PrestoLinkedService, QuickBooksLinkedService, ResponsysLinkedService, RestServiceLinkedService, SalesforceLinkedService, SalesforceMarketingCloudLinkedService, SalesforceServiceCloudLinkedService, SapBWLinkedService, SapCloudForCustomerLinkedService, SapEccLinkedService, SapHanaLinkedService, SapOpenHubLinkedService, SapTableLinkedService, ServiceNowLinkedService, SftpServerLinkedService, ShopifyLinkedService, SparkLinkedService, SqlServerLinkedService, SquareLinkedService, SybaseLinkedService, TeradataLinkedService, VerticaLinkedService, WebLinkedService, XeroLinkedService, ZohoLinkedService.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
    }

    _subtype_map = {
        'type': {'AmazonMWS': 'AmazonMWSLinkedService', 'AmazonRedshift': 'AmazonRedshiftLinkedService', 'AmazonS3': 'AmazonS3LinkedService', 'AzureBatch': 'AzureBatchLinkedService', 'AzureBlobFS': 'AzureBlobFSLinkedService', 'AzureBlobStorage': 'AzureBlobStorageLinkedService', 'AzureDataExplorer': 'AzureDataExplorerLinkedService', 'AzureDataLakeAnalytics': 'AzureDataLakeAnalyticsLinkedService', 'AzureDataLakeStore': 'AzureDataLakeStoreLinkedService', 'AzureDatabricks': 'AzureDatabricksLinkedService', 'AzureFileStorage': 'AzureFileStorageLinkedService', 'AzureFunction': 'AzureFunctionLinkedService', 'AzureKeyVault': 'AzureKeyVaultLinkedService', 'AzureML': 'AzureMLLinkedService', 'AzureMLService': 'AzureMLServiceLinkedService', 'AzureMariaDB': 'AzureMariaDBLinkedService', 'AzureMySql': 'AzureMySqlLinkedService', 'AzurePostgreSql': 'AzurePostgreSqlLinkedService', 'AzureSearch': 'AzureSearchLinkedService', 'AzureSqlDW': 'AzureSqlDWLinkedService', 'AzureSqlDatabase': 'AzureSqlDatabaseLinkedService', 'AzureSqlMI': 'AzureSqlMILinkedService', 'AzureStorage': 'AzureStorageLinkedService', 'AzureTableStorage': 'AzureTableStorageLinkedService', 'Cassandra': 'CassandraLinkedService', 'CommonDataServiceForApps': 'CommonDataServiceForAppsLinkedService', 'Concur': 'ConcurLinkedService', 'CosmosDb': 'CosmosDbLinkedService', 'CosmosDbMongoDbApi': 'CosmosDbMongoDbApiLinkedService', 'Couchbase': 'CouchbaseLinkedService', 'CustomDataSource': 'CustomDataSourceLinkedService', 'Db2': 'Db2LinkedService', 'Drill': 'DrillLinkedService', 'Dynamics': 'DynamicsLinkedService', 'DynamicsAX': 'DynamicsAXLinkedService', 'DynamicsCrm': 'DynamicsCrmLinkedService', 'Eloqua': 'EloquaLinkedService', 'FileServer': 'FileServerLinkedService', 'FtpServer': 'FtpServerLinkedService', 'GoogleAdWords': 'GoogleAdWordsLinkedService', 'GoogleBigQuery': 'GoogleBigQueryLinkedService', 'GoogleCloudStorage': 'GoogleCloudStorageLinkedService', 'Greenplum': 'GreenplumLinkedService', 'HBase': 'HBaseLinkedService', 'HDInsight': 'HDInsightLinkedService', 'HDInsightOnDemand': 'HDInsightOnDemandLinkedService', 'Hdfs': 'HdfsLinkedService', 'Hive': 'HiveLinkedService', 'HttpServer': 'HttpLinkedService', 'Hubspot': 'HubspotLinkedService', 'Impala': 'ImpalaLinkedService', 'Informix': 'InformixLinkedService', 'Jira': 'JiraLinkedService', 'Magento': 'MagentoLinkedService', 'MariaDB': 'MariaDBLinkedService', 'Marketo': 'MarketoLinkedService', 'MicrosoftAccess': 'MicrosoftAccessLinkedService', 'MongoDb': 'MongoDbLinkedService', 'MongoDbV2': 'MongoDbV2LinkedService', 'MySql': 'MySqlLinkedService', 'Netezza': 'NetezzaLinkedService', 'OData': 'ODataLinkedService', 'Odbc': 'OdbcLinkedService', 'Office365': 'Office365LinkedService', 'Oracle': 'OracleLinkedService', 'OracleServiceCloud': 'OracleServiceCloudLinkedService', 'Paypal': 'PaypalLinkedService', 'Phoenix': 'PhoenixLinkedService', 'PostgreSql': 'PostgreSqlLinkedService', 'Presto': 'PrestoLinkedService', 'QuickBooks': 'QuickBooksLinkedService', 'Responsys': 'ResponsysLinkedService', 'RestService': 'RestServiceLinkedService', 'Salesforce': 'SalesforceLinkedService', 'SalesforceMarketingCloud': 'SalesforceMarketingCloudLinkedService', 'SalesforceServiceCloud': 'SalesforceServiceCloudLinkedService', 'SapBW': 'SapBWLinkedService', 'SapCloudForCustomer': 'SapCloudForCustomerLinkedService', 'SapEcc': 'SapEccLinkedService', 'SapHana': 'SapHanaLinkedService', 'SapOpenHub': 'SapOpenHubLinkedService', 'SapTable': 'SapTableLinkedService', 'ServiceNow': 'ServiceNowLinkedService', 'Sftp': 'SftpServerLinkedService', 'Shopify': 'ShopifyLinkedService', 'Spark': 'SparkLinkedService', 'SqlServer': 'SqlServerLinkedService', 'Square': 'SquareLinkedService', 'Sybase': 'SybaseLinkedService', 'Teradata': 'TeradataLinkedService', 'Vertica': 'VerticaLinkedService', 'Web': 'WebLinkedService', 'Xero': 'XeroLinkedService', 'Zoho': 'ZohoLinkedService'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LinkedService, self).__init__(**kwargs)
        self.additional_properties = kwargs.get('additional_properties', None)
        self.type = 'LinkedService'  # type: str
        self.connect_via = kwargs.get('connect_via', None)
        self.description = kwargs.get('description', None)
        self.parameters = kwargs.get('parameters', None)
        self.annotations = kwargs.get('annotations', None)


class AmazonMWSLinkedService(LinkedService):
    """Amazon Marketplace Web Service linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param endpoint: Required. The endpoint of the Amazon MWS server, (i.e.
     mws.amazonservices.com).
    :type endpoint: object
    :param marketplace_id: Required. The Amazon Marketplace ID you want to retrieve data from. To
     retrieve data from multiple Marketplace IDs, separate them with a comma (,). (i.e.
     A2EUQ1WTGCTBG2).
    :type marketplace_id: object
    :param seller_id: Required. The Amazon seller ID.
    :type seller_id: object
    :param mws_auth_token: The Amazon MWS authentication token.
    :type mws_auth_token: ~azure.synapse.artifacts.models.SecretBase
    :param access_key_id: Required. The access key id used to access data.
    :type access_key_id: object
    :param secret_key: The secret key used to access data.
    :type secret_key: ~azure.synapse.artifacts.models.SecretBase
    :param use_encrypted_endpoints: Specifies whether the data source endpoints are encrypted using
     HTTPS. The default value is true.
    :type use_encrypted_endpoints: object
    :param use_host_verification: Specifies whether to require the host name in the server's
     certificate to match the host name of the server when connecting over SSL. The default value is
     true.
    :type use_host_verification: object
    :param use_peer_verification: Specifies whether to verify the identity of the server when
     connecting over SSL. The default value is true.
    :type use_peer_verification: object
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'endpoint': {'required': True},
        'marketplace_id': {'required': True},
        'seller_id': {'required': True},
        'access_key_id': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'endpoint': {'key': 'typeProperties.endpoint', 'type': 'object'},
        'marketplace_id': {'key': 'typeProperties.marketplaceID', 'type': 'object'},
        'seller_id': {'key': 'typeProperties.sellerID', 'type': 'object'},
        'mws_auth_token': {'key': 'typeProperties.mwsAuthToken', 'type': 'SecretBase'},
        'access_key_id': {'key': 'typeProperties.accessKeyId', 'type': 'object'},
        'secret_key': {'key': 'typeProperties.secretKey', 'type': 'SecretBase'},
        'use_encrypted_endpoints': {'key': 'typeProperties.useEncryptedEndpoints', 'type': 'object'},
        'use_host_verification': {'key': 'typeProperties.useHostVerification', 'type': 'object'},
        'use_peer_verification': {'key': 'typeProperties.usePeerVerification', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AmazonMWSLinkedService, self).__init__(**kwargs)
        self.type = 'AmazonMWS'  # type: str
        self.endpoint = kwargs['endpoint']
        self.marketplace_id = kwargs['marketplace_id']
        self.seller_id = kwargs['seller_id']
        self.mws_auth_token = kwargs.get('mws_auth_token', None)
        self.access_key_id = kwargs['access_key_id']
        self.secret_key = kwargs.get('secret_key', None)
        self.use_encrypted_endpoints = kwargs.get('use_encrypted_endpoints', None)
        self.use_host_verification = kwargs.get('use_host_verification', None)
        self.use_peer_verification = kwargs.get('use_peer_verification', None)
        self.encrypted_credential = kwargs.get('encrypted_credential', None)


class Dataset(msrest.serialization.Model):
    """The Azure Data Factory nested object which identifies data within different data stores, such as tables, files, folders, and documents.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AmazonMWSObjectDataset, AmazonRedshiftTableDataset, AvroDataset, AzureDataExplorerTableDataset, AzureMariaDBTableDataset, AzureMySqlTableDataset, AzurePostgreSqlTableDataset, AzureSearchIndexDataset, AzureSqlDWTableDataset, AzureSqlMITableDataset, AzureSqlTableDataset, AzureTableDataset, BinaryDataset, CassandraTableDataset, CommonDataServiceForAppsEntityDataset, ConcurObjectDataset, CosmosDbMongoDbApiCollectionDataset, CosmosDbSqlApiCollectionDataset, CouchbaseTableDataset, CustomDataset, Db2TableDataset, DelimitedTextDataset, DocumentDbCollectionDataset, DrillTableDataset, DynamicsAXResourceDataset, DynamicsCrmEntityDataset, DynamicsEntityDataset, EloquaObjectDataset, GoogleAdWordsObjectDataset, GoogleBigQueryObjectDataset, GreenplumTableDataset, HBaseObjectDataset, HiveObjectDataset, HubspotObjectDataset, ImpalaObjectDataset, InformixTableDataset, JiraObjectDataset, JsonDataset, MagentoObjectDataset, MariaDBTableDataset, MarketoObjectDataset, MicrosoftAccessTableDataset, MongoDbCollectionDataset, MongoDbV2CollectionDataset, MySqlTableDataset, NetezzaTableDataset, ODataResourceDataset, OdbcTableDataset, Office365Dataset, OracleServiceCloudObjectDataset, OracleTableDataset, OrcDataset, ParquetDataset, PaypalObjectDataset, PhoenixObjectDataset, PostgreSqlTableDataset, PrestoObjectDataset, QuickBooksObjectDataset, RelationalTableDataset, ResponsysObjectDataset, RestResourceDataset, SalesforceMarketingCloudObjectDataset, SalesforceObjectDataset, SalesforceServiceCloudObjectDataset, SapBwCubeDataset, SapCloudForCustomerResourceDataset, SapEccResourceDataset, SapHanaTableDataset, SapOpenHubTableDataset, SapTableResourceDataset, ServiceNowObjectDataset, ShopifyObjectDataset, SparkObjectDataset, SqlServerTableDataset, SquareObjectDataset, SybaseTableDataset, TeradataTableDataset, VerticaTableDataset, WebTableDataset, XeroObjectDataset, ZohoObjectDataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
    }

    _subtype_map = {
        'type': {'AmazonMWSObject': 'AmazonMWSObjectDataset', 'AmazonRedshiftTable': 'AmazonRedshiftTableDataset', 'Avro': 'AvroDataset', 'AzureDataExplorerTable': 'AzureDataExplorerTableDataset', 'AzureMariaDBTable': 'AzureMariaDBTableDataset', 'AzureMySqlTable': 'AzureMySqlTableDataset', 'AzurePostgreSqlTable': 'AzurePostgreSqlTableDataset', 'AzureSearchIndex': 'AzureSearchIndexDataset', 'AzureSqlDWTable': 'AzureSqlDWTableDataset', 'AzureSqlMITable': 'AzureSqlMITableDataset', 'AzureSqlTable': 'AzureSqlTableDataset', 'AzureTable': 'AzureTableDataset', 'Binary': 'BinaryDataset', 'CassandraTable': 'CassandraTableDataset', 'CommonDataServiceForAppsEntity': 'CommonDataServiceForAppsEntityDataset', 'ConcurObject': 'ConcurObjectDataset', 'CosmosDbMongoDbApiCollection': 'CosmosDbMongoDbApiCollectionDataset', 'CosmosDbSqlApiCollection': 'CosmosDbSqlApiCollectionDataset', 'CouchbaseTable': 'CouchbaseTableDataset', 'CustomDataset': 'CustomDataset', 'Db2Table': 'Db2TableDataset', 'DelimitedText': 'DelimitedTextDataset', 'DocumentDbCollection': 'DocumentDbCollectionDataset', 'DrillTable': 'DrillTableDataset', 'DynamicsAXResource': 'DynamicsAXResourceDataset', 'DynamicsCrmEntity': 'DynamicsCrmEntityDataset', 'DynamicsEntity': 'DynamicsEntityDataset', 'EloquaObject': 'EloquaObjectDataset', 'GoogleAdWordsObject': 'GoogleAdWordsObjectDataset', 'GoogleBigQueryObject': 'GoogleBigQueryObjectDataset', 'GreenplumTable': 'GreenplumTableDataset', 'HBaseObject': 'HBaseObjectDataset', 'HiveObject': 'HiveObjectDataset', 'HubspotObject': 'HubspotObjectDataset', 'ImpalaObject': 'ImpalaObjectDataset', 'InformixTable': 'InformixTableDataset', 'JiraObject': 'JiraObjectDataset', 'Json': 'JsonDataset', 'MagentoObject': 'MagentoObjectDataset', 'MariaDBTable': 'MariaDBTableDataset', 'MarketoObject': 'MarketoObjectDataset', 'MicrosoftAccessTable': 'MicrosoftAccessTableDataset', 'MongoDbCollection': 'MongoDbCollectionDataset', 'MongoDbV2Collection': 'MongoDbV2CollectionDataset', 'MySqlTable': 'MySqlTableDataset', 'NetezzaTable': 'NetezzaTableDataset', 'ODataResource': 'ODataResourceDataset', 'OdbcTable': 'OdbcTableDataset', 'Office365Table': 'Office365Dataset', 'OracleServiceCloudObject': 'OracleServiceCloudObjectDataset', 'OracleTable': 'OracleTableDataset', 'Orc': 'OrcDataset', 'Parquet': 'ParquetDataset', 'PaypalObject': 'PaypalObjectDataset', 'PhoenixObject': 'PhoenixObjectDataset', 'PostgreSqlTable': 'PostgreSqlTableDataset', 'PrestoObject': 'PrestoObjectDataset', 'QuickBooksObject': 'QuickBooksObjectDataset', 'RelationalTable': 'RelationalTableDataset', 'ResponsysObject': 'ResponsysObjectDataset', 'RestResource': 'RestResourceDataset', 'SalesforceMarketingCloudObject': 'SalesforceMarketingCloudObjectDataset', 'SalesforceObject': 'SalesforceObjectDataset', 'SalesforceServiceCloudObject': 'SalesforceServiceCloudObjectDataset', 'SapBwCube': 'SapBwCubeDataset', 'SapCloudForCustomerResource': 'SapCloudForCustomerResourceDataset', 'SapEccResource': 'SapEccResourceDataset', 'SapHanaTable': 'SapHanaTableDataset', 'SapOpenHubTable': 'SapOpenHubTableDataset', 'SapTableResource': 'SapTableResourceDataset', 'ServiceNowObject': 'ServiceNowObjectDataset', 'ShopifyObject': 'ShopifyObjectDataset', 'SparkObject': 'SparkObjectDataset', 'SqlServerTable': 'SqlServerTableDataset', 'SquareObject': 'SquareObjectDataset', 'SybaseTable': 'SybaseTableDataset', 'TeradataTable': 'TeradataTableDataset', 'VerticaTable': 'VerticaTableDataset', 'WebTable': 'WebTableDataset', 'XeroObject': 'XeroObjectDataset', 'ZohoObject': 'ZohoObjectDataset'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Dataset, self).__init__(**kwargs)
        self.additional_properties = kwargs.get('additional_properties', None)
        self.type = 'Dataset'  # type: str
        self.description = kwargs.get('description', None)
        self.structure = kwargs.get('structure', None)
        self.schema = kwargs.get('schema', None)
        self.linked_service_name = kwargs['linked_service_name']
        self.parameters = kwargs.get('parameters', None)
        self.annotations = kwargs.get('annotations', None)
        self.folder = kwargs.get('folder', None)


class AmazonMWSObjectDataset(Dataset):
    """Amazon Marketplace Web Service dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param table_name: The table name. Type: string (or Expression with resultType string).
    :type table_name: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table_name': {'key': 'typeProperties.tableName', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AmazonMWSObjectDataset, self).__init__(**kwargs)
        self.type = 'AmazonMWSObject'  # type: str
        self.table_name = kwargs.get('table_name', None)


class CopySource(msrest.serialization.Model):
    """A copy activity source.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AvroSource, AzureBlobFSSource, AzureDataExplorerSource, AzureDataLakeStoreSource, BinarySource, BlobSource, CommonDataServiceForAppsSource, CosmosDbMongoDbApiSource, CosmosDbSqlApiSource, DelimitedTextSource, DocumentDbCollectionSource, DynamicsCrmSource, DynamicsSource, FileSystemSource, HdfsSource, HttpSource, JsonSource, MicrosoftAccessSource, MongoDbSource, MongoDbV2Source, ODataSource, Office365Source, OracleSource, OrcSource, ParquetSource, RelationalSource, RestSource, SalesforceServiceCloudSource, TabularSource, WebSource.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: object
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
    }

    _subtype_map = {
        'type': {'AvroSource': 'AvroSource', 'AzureBlobFSSource': 'AzureBlobFSSource', 'AzureDataExplorerSource': 'AzureDataExplorerSource', 'AzureDataLakeStoreSource': 'AzureDataLakeStoreSource', 'BinarySource': 'BinarySource', 'BlobSource': 'BlobSource', 'CommonDataServiceForAppsSource': 'CommonDataServiceForAppsSource', 'CosmosDbMongoDbApiSource': 'CosmosDbMongoDbApiSource', 'CosmosDbSqlApiSource': 'CosmosDbSqlApiSource', 'DelimitedTextSource': 'DelimitedTextSource', 'DocumentDbCollectionSource': 'DocumentDbCollectionSource', 'DynamicsCrmSource': 'DynamicsCrmSource', 'DynamicsSource': 'DynamicsSource', 'FileSystemSource': 'FileSystemSource', 'HdfsSource': 'HdfsSource', 'HttpSource': 'HttpSource', 'JsonSource': 'JsonSource', 'MicrosoftAccessSource': 'MicrosoftAccessSource', 'MongoDbSource': 'MongoDbSource', 'MongoDbV2Source': 'MongoDbV2Source', 'ODataSource': 'ODataSource', 'Office365Source': 'Office365Source', 'OracleSource': 'OracleSource', 'OrcSource': 'OrcSource', 'ParquetSource': 'ParquetSource', 'RelationalSource': 'RelationalSource', 'RestSource': 'RestSource', 'SalesforceServiceCloudSource': 'SalesforceServiceCloudSource', 'TabularSource': 'TabularSource', 'WebSource': 'WebSource'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CopySource, self).__init__(**kwargs)
        self.additional_properties = kwargs.get('additional_properties', None)
        self.type = 'CopySource'  # type: str
        self.source_retry_count = kwargs.get('source_retry_count', None)
        self.source_retry_wait = kwargs.get('source_retry_wait', None)
        self.max_concurrent_connections = kwargs.get('max_concurrent_connections', None)


class TabularSource(CopySource):
    """Copy activity sources of tabular type.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AmazonMWSSource, AmazonRedshiftSource, AzureMariaDBSource, AzureMySqlSource, AzurePostgreSqlSource, AzureSqlSource, AzureTableSource, CassandraSource, ConcurSource, CouchbaseSource, Db2Source, DrillSource, DynamicsAXSource, EloquaSource, GoogleAdWordsSource, GoogleBigQuerySource, GreenplumSource, HBaseSource, HiveSource, HubspotSource, ImpalaSource, InformixSource, JiraSource, MagentoSource, MariaDBSource, MarketoSource, MySqlSource, NetezzaSource, OdbcSource, OracleServiceCloudSource, PaypalSource, PhoenixSource, PostgreSqlSource, PrestoSource, QuickBooksSource, ResponsysSource, SalesforceMarketingCloudSource, SalesforceSource, SapBwSource, SapCloudForCustomerSource, SapEccSource, SapHanaSource, SapOpenHubSource, SapTableSource, ServiceNowSource, ShopifySource, SparkSource, SqlDWSource, SqlMISource, SqlServerSource, SqlSource, SquareSource, SybaseSource, TeradataSource, VerticaSource, XeroSource, ZohoSource.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: object
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param query_timeout: Query timeout. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type query_timeout: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'query_timeout': {'key': 'queryTimeout', 'type': 'object'},
    }

    _subtype_map = {
        'type': {'AmazonMWSSource': 'AmazonMWSSource', 'AmazonRedshiftSource': 'AmazonRedshiftSource', 'AzureMariaDBSource': 'AzureMariaDBSource', 'AzureMySqlSource': 'AzureMySqlSource', 'AzurePostgreSqlSource': 'AzurePostgreSqlSource', 'AzureSqlSource': 'AzureSqlSource', 'AzureTableSource': 'AzureTableSource', 'CassandraSource': 'CassandraSource', 'ConcurSource': 'ConcurSource', 'CouchbaseSource': 'CouchbaseSource', 'Db2Source': 'Db2Source', 'DrillSource': 'DrillSource', 'DynamicsAXSource': 'DynamicsAXSource', 'EloquaSource': 'EloquaSource', 'GoogleAdWordsSource': 'GoogleAdWordsSource', 'GoogleBigQuerySource': 'GoogleBigQuerySource', 'GreenplumSource': 'GreenplumSource', 'HBaseSource': 'HBaseSource', 'HiveSource': 'HiveSource', 'HubspotSource': 'HubspotSource', 'ImpalaSource': 'ImpalaSource', 'InformixSource': 'InformixSource', 'JiraSource': 'JiraSource', 'MagentoSource': 'MagentoSource', 'MariaDBSource': 'MariaDBSource', 'MarketoSource': 'MarketoSource', 'MySqlSource': 'MySqlSource', 'NetezzaSource': 'NetezzaSource', 'OdbcSource': 'OdbcSource', 'OracleServiceCloudSource': 'OracleServiceCloudSource', 'PaypalSource': 'PaypalSource', 'PhoenixSource': 'PhoenixSource', 'PostgreSqlSource': 'PostgreSqlSource', 'PrestoSource': 'PrestoSource', 'QuickBooksSource': 'QuickBooksSource', 'ResponsysSource': 'ResponsysSource', 'SalesforceMarketingCloudSource': 'SalesforceMarketingCloudSource', 'SalesforceSource': 'SalesforceSource', 'SapBwSource': 'SapBwSource', 'SapCloudForCustomerSource': 'SapCloudForCustomerSource', 'SapEccSource': 'SapEccSource', 'SapHanaSource': 'SapHanaSource', 'SapOpenHubSource': 'SapOpenHubSource', 'SapTableSource': 'SapTableSource', 'ServiceNowSource': 'ServiceNowSource', 'ShopifySource': 'ShopifySource', 'SparkSource': 'SparkSource', 'SqlDWSource': 'SqlDWSource', 'SqlMISource': 'SqlMISource', 'SqlServerSource': 'SqlServerSource', 'SqlSource': 'SqlSource', 'SquareSource': 'SquareSource', 'SybaseSource': 'SybaseSource', 'TeradataSource': 'TeradataSource', 'VerticaSource': 'VerticaSource', 'XeroSource': 'XeroSource', 'ZohoSource': 'ZohoSource'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TabularSource, self).__init__(**kwargs)
        self.type = 'TabularSource'  # type: str
        self.query_timeout = kwargs.get('query_timeout', None)


class AmazonMWSSource(TabularSource):
    """A copy activity Amazon Marketplace Web Service source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: object
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param query_timeout: Query timeout. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type query_timeout: object
    :param query: A query to retrieve data from source. Type: string (or Expression with resultType
     string).
    :type query: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'query_timeout': {'key': 'queryTimeout', 'type': 'object'},
        'query': {'key': 'query', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AmazonMWSSource, self).__init__(**kwargs)
        self.type = 'AmazonMWSSource'  # type: str
        self.query = kwargs.get('query', None)


class AmazonRedshiftLinkedService(LinkedService):
    """Linked service for Amazon Redshift.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param server: Required. The name of the Amazon Redshift server. Type: string (or Expression
     with resultType string).
    :type server: object
    :param username: The username of the Amazon Redshift source. Type: string (or Expression with
     resultType string).
    :type username: object
    :param password: The password of the Amazon Redshift source.
    :type password: ~azure.synapse.artifacts.models.SecretBase
    :param database: Required. The database name of the Amazon Redshift source. Type: string (or
     Expression with resultType string).
    :type database: object
    :param port: The TCP port number that the Amazon Redshift server uses to listen for client
     connections. The default value is 5439. Type: integer (or Expression with resultType integer).
    :type port: object
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'server': {'required': True},
        'database': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'server': {'key': 'typeProperties.server', 'type': 'object'},
        'username': {'key': 'typeProperties.username', 'type': 'object'},
        'password': {'key': 'typeProperties.password', 'type': 'SecretBase'},
        'database': {'key': 'typeProperties.database', 'type': 'object'},
        'port': {'key': 'typeProperties.port', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AmazonRedshiftLinkedService, self).__init__(**kwargs)
        self.type = 'AmazonRedshift'  # type: str
        self.server = kwargs['server']
        self.username = kwargs.get('username', None)
        self.password = kwargs.get('password', None)
        self.database = kwargs['database']
        self.port = kwargs.get('port', None)
        self.encrypted_credential = kwargs.get('encrypted_credential', None)


class AmazonRedshiftSource(TabularSource):
    """A copy activity source for Amazon Redshift Source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: object
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param query_timeout: Query timeout. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type query_timeout: object
    :param query: Database query. Type: string (or Expression with resultType string).
    :type query: object
    :param redshift_unload_settings: The Amazon S3 settings needed for the interim Amazon S3 when
     copying from Amazon Redshift with unload. With this, data from Amazon Redshift source will be
     unloaded into S3 first and then copied into the targeted sink from the interim S3.
    :type redshift_unload_settings: ~azure.synapse.artifacts.models.RedshiftUnloadSettings
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'query_timeout': {'key': 'queryTimeout', 'type': 'object'},
        'query': {'key': 'query', 'type': 'object'},
        'redshift_unload_settings': {'key': 'redshiftUnloadSettings', 'type': 'RedshiftUnloadSettings'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AmazonRedshiftSource, self).__init__(**kwargs)
        self.type = 'AmazonRedshiftSource'  # type: str
        self.query = kwargs.get('query', None)
        self.redshift_unload_settings = kwargs.get('redshift_unload_settings', None)


class AmazonRedshiftTableDataset(Dataset):
    """The Amazon Redshift table dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param table_name: This property will be retired. Please consider using schema + table
     properties instead.
    :type table_name: object
    :param table: The Amazon Redshift table name. Type: string (or Expression with resultType
     string).
    :type table: object
    :param schema_type_properties_schema: The Amazon Redshift schema name. Type: string (or
     Expression with resultType string).
    :type schema_type_properties_schema: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table_name': {'key': 'typeProperties.tableName', 'type': 'object'},
        'table': {'key': 'typeProperties.table', 'type': 'object'},
        'schema_type_properties_schema': {'key': 'typeProperties.schema', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AmazonRedshiftTableDataset, self).__init__(**kwargs)
        self.type = 'AmazonRedshiftTable'  # type: str
        self.table_name = kwargs.get('table_name', None)
        self.table = kwargs.get('table', None)
        self.schema_type_properties_schema = kwargs.get('schema_type_properties_schema', None)


class AmazonS3LinkedService(LinkedService):
    """Linked service for Amazon S3.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param access_key_id: The access key identifier of the Amazon S3 Identity and Access Management
     (IAM) user. Type: string (or Expression with resultType string).
    :type access_key_id: object
    :param secret_access_key: The secret access key of the Amazon S3 Identity and Access Management
     (IAM) user.
    :type secret_access_key: ~azure.synapse.artifacts.models.SecretBase
    :param service_url: This value specifies the endpoint to access with the S3 Connector. This is
     an optional property; change it only if you want to try a different service endpoint or want to
     switch between https and http. Type: string (or Expression with resultType string).
    :type service_url: object
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'access_key_id': {'key': 'typeProperties.accessKeyId', 'type': 'object'},
        'secret_access_key': {'key': 'typeProperties.secretAccessKey', 'type': 'SecretBase'},
        'service_url': {'key': 'typeProperties.serviceUrl', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AmazonS3LinkedService, self).__init__(**kwargs)
        self.type = 'AmazonS3'  # type: str
        self.access_key_id = kwargs.get('access_key_id', None)
        self.secret_access_key = kwargs.get('secret_access_key', None)
        self.service_url = kwargs.get('service_url', None)
        self.encrypted_credential = kwargs.get('encrypted_credential', None)


class DatasetLocation(msrest.serialization.Model):
    """Dataset location.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AmazonS3Location, AzureBlobFSLocation, AzureBlobStorageLocation, AzureDataLakeStoreLocation, AzureFileStorageLocation, FileServerLocation, FtpServerLocation, GoogleCloudStorageLocation, HdfsLocation, HttpServerLocation, SftpLocation.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset storage location.Constant filled by server.
    :type type: str
    :param folder_path: Specify the folder path of dataset. Type: string (or Expression with
     resultType string).
    :type folder_path: object
    :param file_name: Specify the file name of dataset. Type: string (or Expression with resultType
     string).
    :type file_name: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'folder_path': {'key': 'folderPath', 'type': 'object'},
        'file_name': {'key': 'fileName', 'type': 'object'},
    }

    _subtype_map = {
        'type': {'AmazonS3Location': 'AmazonS3Location', 'AzureBlobFSLocation': 'AzureBlobFSLocation', 'AzureBlobStorageLocation': 'AzureBlobStorageLocation', 'AzureDataLakeStoreLocation': 'AzureDataLakeStoreLocation', 'AzureFileStorageLocation': 'AzureFileStorageLocation', 'FileServerLocation': 'FileServerLocation', 'FtpServerLocation': 'FtpServerLocation', 'GoogleCloudStorageLocation': 'GoogleCloudStorageLocation', 'HdfsLocation': 'HdfsLocation', 'HttpServerLocation': 'HttpServerLocation', 'SftpLocation': 'SftpLocation'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DatasetLocation, self).__init__(**kwargs)
        self.additional_properties = kwargs.get('additional_properties', None)
        self.type = 'DatasetLocation'  # type: str
        self.folder_path = kwargs.get('folder_path', None)
        self.file_name = kwargs.get('file_name', None)


class AmazonS3Location(DatasetLocation):
    """The location of amazon S3 dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset storage location.Constant filled by server.
    :type type: str
    :param folder_path: Specify the folder path of dataset. Type: string (or Expression with
     resultType string).
    :type folder_path: object
    :param file_name: Specify the file name of dataset. Type: string (or Expression with resultType
     string).
    :type file_name: object
    :param bucket_name: Specify the bucketName of amazon S3. Type: string (or Expression with
     resultType string).
    :type bucket_name: object
    :param version: Specify the version of amazon S3. Type: string (or Expression with resultType
     string).
    :type version: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'folder_path': {'key': 'folderPath', 'type': 'object'},
        'file_name': {'key': 'fileName', 'type': 'object'},
        'bucket_name': {'key': 'bucketName', 'type': 'object'},
        'version': {'key': 'version', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AmazonS3Location, self).__init__(**kwargs)
        self.type = 'AmazonS3Location'  # type: str
        self.bucket_name = kwargs.get('bucket_name', None)
        self.version = kwargs.get('version', None)


class StoreReadSettings(msrest.serialization.Model):
    """Connector read setting.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AmazonS3ReadSettings, AzureBlobFSReadSettings, AzureBlobStorageReadSettings, AzureDataLakeStoreReadSettings, AzureFileStorageReadSettings, FileServerReadSettings, FtpReadSettings, GoogleCloudStorageReadSettings, HdfsReadSettings, HttpReadSettings, SftpReadSettings.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. The read setting type.Constant filled by server.
    :type type: str
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
    }

    _subtype_map = {
        'type': {'AmazonS3ReadSettings': 'AmazonS3ReadSettings', 'AzureBlobFSReadSettings': 'AzureBlobFSReadSettings', 'AzureBlobStorageReadSettings': 'AzureBlobStorageReadSettings', 'AzureDataLakeStoreReadSettings': 'AzureDataLakeStoreReadSettings', 'AzureFileStorageReadSettings': 'AzureFileStorageReadSettings', 'FileServerReadSettings': 'FileServerReadSettings', 'FtpReadSettings': 'FtpReadSettings', 'GoogleCloudStorageReadSettings': 'GoogleCloudStorageReadSettings', 'HdfsReadSettings': 'HdfsReadSettings', 'HttpReadSettings': 'HttpReadSettings', 'SftpReadSettings': 'SftpReadSettings'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(StoreReadSettings, self).__init__(**kwargs)
        self.additional_properties = kwargs.get('additional_properties', None)
        self.type = 'StoreReadSettings'  # type: str
        self.max_concurrent_connections = kwargs.get('max_concurrent_connections', None)


class AmazonS3ReadSettings(StoreReadSettings):
    """Azure data lake store read settings.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. The read setting type.Constant filled by server.
    :type type: str
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param recursive: If true, files under the folder path will be read recursively. Default is
     true. Type: boolean (or Expression with resultType boolean).
    :type recursive: object
    :param wildcard_folder_path: AmazonS3 wildcardFolderPath. Type: string (or Expression with
     resultType string).
    :type wildcard_folder_path: object
    :param wildcard_file_name: AmazonS3 wildcardFileName. Type: string (or Expression with
     resultType string).
    :type wildcard_file_name: object
    :param prefix: The prefix filter for the S3 object name. Type: string (or Expression with
     resultType string).
    :type prefix: object
    :param enable_partition_discovery: Indicates whether to enable partition discovery.
    :type enable_partition_discovery: bool
    :param modified_datetime_start: The start of file's modified datetime. Type: string (or
     Expression with resultType string).
    :type modified_datetime_start: object
    :param modified_datetime_end: The end of file's modified datetime. Type: string (or Expression
     with resultType string).
    :type modified_datetime_end: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'recursive': {'key': 'recursive', 'type': 'object'},
        'wildcard_folder_path': {'key': 'wildcardFolderPath', 'type': 'object'},
        'wildcard_file_name': {'key': 'wildcardFileName', 'type': 'object'},
        'prefix': {'key': 'prefix', 'type': 'object'},
        'enable_partition_discovery': {'key': 'enablePartitionDiscovery', 'type': 'bool'},
        'modified_datetime_start': {'key': 'modifiedDatetimeStart', 'type': 'object'},
        'modified_datetime_end': {'key': 'modifiedDatetimeEnd', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AmazonS3ReadSettings, self).__init__(**kwargs)
        self.type = 'AmazonS3ReadSettings'  # type: str
        self.recursive = kwargs.get('recursive', None)
        self.wildcard_folder_path = kwargs.get('wildcard_folder_path', None)
        self.wildcard_file_name = kwargs.get('wildcard_file_name', None)
        self.prefix = kwargs.get('prefix', None)
        self.enable_partition_discovery = kwargs.get('enable_partition_discovery', None)
        self.modified_datetime_start = kwargs.get('modified_datetime_start', None)
        self.modified_datetime_end = kwargs.get('modified_datetime_end', None)


class AppendVariableActivity(Activity):
    """Append value for a Variable of type Array.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param name: Required. Activity name.
    :type name: str
    :param type: Required. Type of activity.Constant filled by server.
    :type type: str
    :param description: Activity description.
    :type description: str
    :param depends_on: Activity depends on condition.
    :type depends_on: list[~azure.synapse.artifacts.models.ActivityDependency]
    :param user_properties: Activity user properties.
    :type user_properties: list[~azure.synapse.artifacts.models.UserProperty]
    :param variable_name: Name of the variable whose value needs to be appended to.
    :type variable_name: str
    :param value: Value to be appended. Could be a static value or Expression.
    :type value: object
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'depends_on': {'key': 'dependsOn', 'type': '[ActivityDependency]'},
        'user_properties': {'key': 'userProperties', 'type': '[UserProperty]'},
        'variable_name': {'key': 'typeProperties.variableName', 'type': 'str'},
        'value': {'key': 'typeProperties.value', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AppendVariableActivity, self).__init__(**kwargs)
        self.type = 'AppendVariable'  # type: str
        self.variable_name = kwargs.get('variable_name', None)
        self.value = kwargs.get('value', None)


class AutoPauseProperties(msrest.serialization.Model):
    """Auto-pausing properties of a Big Data pool powered by Apache Spark.

    :param delay_in_minutes: Number of minutes of idle time before the Big Data pool is
     automatically paused.
    :type delay_in_minutes: int
    :param enabled: Whether auto-pausing is enabled for the Big Data pool.
    :type enabled: bool
    """

    _attribute_map = {
        'delay_in_minutes': {'key': 'delayInMinutes', 'type': 'int'},
        'enabled': {'key': 'enabled', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AutoPauseProperties, self).__init__(**kwargs)
        self.delay_in_minutes = kwargs.get('delay_in_minutes', None)
        self.enabled = kwargs.get('enabled', None)


class AutoScaleProperties(msrest.serialization.Model):
    """Auto-scaling properties of a Big Data pool powered by Apache Spark.

    :param min_node_count: The minimum number of nodes the Big Data pool can support.
    :type min_node_count: int
    :param enabled: Whether automatic scaling is enabled for the Big Data pool.
    :type enabled: bool
    :param max_node_count: The maximum number of nodes the Big Data pool can support.
    :type max_node_count: int
    """

    _attribute_map = {
        'min_node_count': {'key': 'minNodeCount', 'type': 'int'},
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'max_node_count': {'key': 'maxNodeCount', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AutoScaleProperties, self).__init__(**kwargs)
        self.min_node_count = kwargs.get('min_node_count', None)
        self.enabled = kwargs.get('enabled', None)
        self.max_node_count = kwargs.get('max_node_count', None)


class AvroDataset(Dataset):
    """Avro dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param location: The location of the avro storage.
    :type location: ~azure.synapse.artifacts.models.DatasetLocation
    :param avro_compression_codec:  Possible values include: "none", "deflate", "snappy", "xz",
     "bzip2".
    :type avro_compression_codec: str or ~azure.synapse.artifacts.models.AvroCompressionCodec
    :param avro_compression_level:
    :type avro_compression_level: int
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
        'avro_compression_level': {'maximum': 9, 'minimum': 1},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'location': {'key': 'typeProperties.location', 'type': 'DatasetLocation'},
        'avro_compression_codec': {'key': 'typeProperties.avroCompressionCodec', 'type': 'str'},
        'avro_compression_level': {'key': 'typeProperties.avroCompressionLevel', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AvroDataset, self).__init__(**kwargs)
        self.type = 'Avro'  # type: str
        self.location = kwargs.get('location', None)
        self.avro_compression_codec = kwargs.get('avro_compression_codec', None)
        self.avro_compression_level = kwargs.get('avro_compression_level', None)


class DatasetStorageFormat(msrest.serialization.Model):
    """The format definition of a storage.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AvroFormat, JsonFormat, OrcFormat, ParquetFormat, TextFormat.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset storage format.Constant filled by server.
    :type type: str
    :param serializer: Serializer. Type: string (or Expression with resultType string).
    :type serializer: object
    :param deserializer: Deserializer. Type: string (or Expression with resultType string).
    :type deserializer: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'serializer': {'key': 'serializer', 'type': 'object'},
        'deserializer': {'key': 'deserializer', 'type': 'object'},
    }

    _subtype_map = {
        'type': {'AvroFormat': 'AvroFormat', 'JsonFormat': 'JsonFormat', 'OrcFormat': 'OrcFormat', 'ParquetFormat': 'ParquetFormat', 'TextFormat': 'TextFormat'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DatasetStorageFormat, self).__init__(**kwargs)
        self.additional_properties = kwargs.get('additional_properties', None)
        self.type = 'DatasetStorageFormat'  # type: str
        self.serializer = kwargs.get('serializer', None)
        self.deserializer = kwargs.get('deserializer', None)


class AvroFormat(DatasetStorageFormat):
    """The data stored in Avro format.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset storage format.Constant filled by server.
    :type type: str
    :param serializer: Serializer. Type: string (or Expression with resultType string).
    :type serializer: object
    :param deserializer: Deserializer. Type: string (or Expression with resultType string).
    :type deserializer: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'serializer': {'key': 'serializer', 'type': 'object'},
        'deserializer': {'key': 'deserializer', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AvroFormat, self).__init__(**kwargs)
        self.type = 'AvroFormat'  # type: str


class CopySink(msrest.serialization.Model):
    """A copy activity sink.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AvroSink, AzureBlobFSSink, AzureDataExplorerSink, AzureDataLakeStoreSink, AzureMySqlSink, AzurePostgreSqlSink, AzureQueueSink, AzureSearchIndexSink, AzureSqlSink, AzureTableSink, BinarySink, BlobSink, CommonDataServiceForAppsSink, CosmosDbMongoDbApiSink, CosmosDbSqlApiSink, DelimitedTextSink, DocumentDbCollectionSink, DynamicsCrmSink, DynamicsSink, FileSystemSink, InformixSink, JsonSink, MicrosoftAccessSink, OdbcSink, OracleSink, OrcSink, ParquetSink, SalesforceServiceCloudSink, SalesforceSink, SapCloudForCustomerSink, SqlDWSink, SqlMISink, SqlServerSink, SqlSink.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy sink type.Constant filled by server.
    :type type: str
    :param write_batch_size: Write batch size. Type: integer (or Expression with resultType
     integer), minimum: 0.
    :type write_batch_size: object
    :param write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type write_batch_timeout: object
    :param sink_retry_count: Sink retry count. Type: integer (or Expression with resultType
     integer).
    :type sink_retry_count: object
    :param sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type sink_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the sink data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'write_batch_size': {'key': 'writeBatchSize', 'type': 'object'},
        'write_batch_timeout': {'key': 'writeBatchTimeout', 'type': 'object'},
        'sink_retry_count': {'key': 'sinkRetryCount', 'type': 'object'},
        'sink_retry_wait': {'key': 'sinkRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
    }

    _subtype_map = {
        'type': {'AvroSink': 'AvroSink', 'AzureBlobFSSink': 'AzureBlobFSSink', 'AzureDataExplorerSink': 'AzureDataExplorerSink', 'AzureDataLakeStoreSink': 'AzureDataLakeStoreSink', 'AzureMySqlSink': 'AzureMySqlSink', 'AzurePostgreSqlSink': 'AzurePostgreSqlSink', 'AzureQueueSink': 'AzureQueueSink', 'AzureSearchIndexSink': 'AzureSearchIndexSink', 'AzureSqlSink': 'AzureSqlSink', 'AzureTableSink': 'AzureTableSink', 'BinarySink': 'BinarySink', 'BlobSink': 'BlobSink', 'CommonDataServiceForAppsSink': 'CommonDataServiceForAppsSink', 'CosmosDbMongoDbApiSink': 'CosmosDbMongoDbApiSink', 'CosmosDbSqlApiSink': 'CosmosDbSqlApiSink', 'DelimitedTextSink': 'DelimitedTextSink', 'DocumentDbCollectionSink': 'DocumentDbCollectionSink', 'DynamicsCrmSink': 'DynamicsCrmSink', 'DynamicsSink': 'DynamicsSink', 'FileSystemSink': 'FileSystemSink', 'InformixSink': 'InformixSink', 'JsonSink': 'JsonSink', 'MicrosoftAccessSink': 'MicrosoftAccessSink', 'OdbcSink': 'OdbcSink', 'OracleSink': 'OracleSink', 'OrcSink': 'OrcSink', 'ParquetSink': 'ParquetSink', 'SalesforceServiceCloudSink': 'SalesforceServiceCloudSink', 'SalesforceSink': 'SalesforceSink', 'SapCloudForCustomerSink': 'SapCloudForCustomerSink', 'SqlDWSink': 'SqlDWSink', 'SqlMISink': 'SqlMISink', 'SqlServerSink': 'SqlServerSink', 'SqlSink': 'SqlSink'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CopySink, self).__init__(**kwargs)
        self.additional_properties = kwargs.get('additional_properties', None)
        self.type = 'CopySink'  # type: str
        self.write_batch_size = kwargs.get('write_batch_size', None)
        self.write_batch_timeout = kwargs.get('write_batch_timeout', None)
        self.sink_retry_count = kwargs.get('sink_retry_count', None)
        self.sink_retry_wait = kwargs.get('sink_retry_wait', None)
        self.max_concurrent_connections = kwargs.get('max_concurrent_connections', None)


class AvroSink(CopySink):
    """A copy activity Avro sink.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy sink type.Constant filled by server.
    :type type: str
    :param write_batch_size: Write batch size. Type: integer (or Expression with resultType
     integer), minimum: 0.
    :type write_batch_size: object
    :param write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type write_batch_timeout: object
    :param sink_retry_count: Sink retry count. Type: integer (or Expression with resultType
     integer).
    :type sink_retry_count: object
    :param sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type sink_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the sink data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param store_settings: Avro store settings.
    :type store_settings: ~azure.synapse.artifacts.models.StoreWriteSettings
    :param format_settings: Avro format settings.
    :type format_settings: ~azure.synapse.artifacts.models.AvroWriteSettings
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'write_batch_size': {'key': 'writeBatchSize', 'type': 'object'},
        'write_batch_timeout': {'key': 'writeBatchTimeout', 'type': 'object'},
        'sink_retry_count': {'key': 'sinkRetryCount', 'type': 'object'},
        'sink_retry_wait': {'key': 'sinkRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'store_settings': {'key': 'storeSettings', 'type': 'StoreWriteSettings'},
        'format_settings': {'key': 'formatSettings', 'type': 'AvroWriteSettings'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AvroSink, self).__init__(**kwargs)
        self.type = 'AvroSink'  # type: str
        self.store_settings = kwargs.get('store_settings', None)
        self.format_settings = kwargs.get('format_settings', None)


class AvroSource(CopySource):
    """A copy activity Avro source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: object
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param store_settings: Avro store settings.
    :type store_settings: ~azure.synapse.artifacts.models.StoreReadSettings
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'store_settings': {'key': 'storeSettings', 'type': 'StoreReadSettings'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AvroSource, self).__init__(**kwargs)
        self.type = 'AvroSource'  # type: str
        self.store_settings = kwargs.get('store_settings', None)


class FormatWriteSettings(msrest.serialization.Model):
    """Format write settings.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AvroWriteSettings, DelimitedTextWriteSettings, JsonWriteSettings.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. The write setting type.Constant filled by server.
    :type type: str
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
    }

    _subtype_map = {
        'type': {'AvroWriteSettings': 'AvroWriteSettings', 'DelimitedTextWriteSettings': 'DelimitedTextWriteSettings', 'JsonWriteSettings': 'JsonWriteSettings'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FormatWriteSettings, self).__init__(**kwargs)
        self.additional_properties = kwargs.get('additional_properties', None)
        self.type = 'FormatWriteSettings'  # type: str


class AvroWriteSettings(FormatWriteSettings):
    """Avro write settings.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. The write setting type.Constant filled by server.
    :type type: str
    :param record_name: Top level record name in write result, which is required in AVRO spec.
    :type record_name: str
    :param record_namespace: Record namespace in the write result.
    :type record_namespace: str
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'record_name': {'key': 'recordName', 'type': 'str'},
        'record_namespace': {'key': 'recordNamespace', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AvroWriteSettings, self).__init__(**kwargs)
        self.type = 'AvroWriteSettings'  # type: str
        self.record_name = kwargs.get('record_name', None)
        self.record_namespace = kwargs.get('record_namespace', None)


class AzureBatchLinkedService(LinkedService):
    """Azure Batch linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param account_name: Required. The Azure Batch account name. Type: string (or Expression with
     resultType string).
    :type account_name: object
    :param access_key: The Azure Batch account access key.
    :type access_key: ~azure.synapse.artifacts.models.SecretBase
    :param batch_uri: Required. The Azure Batch URI. Type: string (or Expression with resultType
     string).
    :type batch_uri: object
    :param pool_name: Required. The Azure Batch pool name. Type: string (or Expression with
     resultType string).
    :type pool_name: object
    :param linked_service_name: Required. The Azure Storage linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'account_name': {'required': True},
        'batch_uri': {'required': True},
        'pool_name': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'account_name': {'key': 'typeProperties.accountName', 'type': 'object'},
        'access_key': {'key': 'typeProperties.accessKey', 'type': 'SecretBase'},
        'batch_uri': {'key': 'typeProperties.batchUri', 'type': 'object'},
        'pool_name': {'key': 'typeProperties.poolName', 'type': 'object'},
        'linked_service_name': {'key': 'typeProperties.linkedServiceName', 'type': 'LinkedServiceReference'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureBatchLinkedService, self).__init__(**kwargs)
        self.type = 'AzureBatch'  # type: str
        self.account_name = kwargs['account_name']
        self.access_key = kwargs.get('access_key', None)
        self.batch_uri = kwargs['batch_uri']
        self.pool_name = kwargs['pool_name']
        self.linked_service_name = kwargs['linked_service_name']
        self.encrypted_credential = kwargs.get('encrypted_credential', None)


class AzureBlobFSLinkedService(LinkedService):
    """Azure Data Lake Storage Gen2 linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param url: Required. Endpoint for the Azure Data Lake Storage Gen2 service. Type: string (or
     Expression with resultType string).
    :type url: object
    :param account_key: Account key for the Azure Data Lake Storage Gen2 service. Type: string (or
     Expression with resultType string).
    :type account_key: object
    :param service_principal_id: The ID of the application used to authenticate against the Azure
     Data Lake Storage Gen2 account. Type: string (or Expression with resultType string).
    :type service_principal_id: object
    :param service_principal_key: The Key of the application used to authenticate against the Azure
     Data Lake Storage Gen2 account.
    :type service_principal_key: ~azure.synapse.artifacts.models.SecretBase
    :param tenant: The name or ID of the tenant to which the service principal belongs. Type:
     string (or Expression with resultType string).
    :type tenant: object
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'url': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'url': {'key': 'typeProperties.url', 'type': 'object'},
        'account_key': {'key': 'typeProperties.accountKey', 'type': 'object'},
        'service_principal_id': {'key': 'typeProperties.servicePrincipalId', 'type': 'object'},
        'service_principal_key': {'key': 'typeProperties.servicePrincipalKey', 'type': 'SecretBase'},
        'tenant': {'key': 'typeProperties.tenant', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureBlobFSLinkedService, self).__init__(**kwargs)
        self.type = 'AzureBlobFS'  # type: str
        self.url = kwargs['url']
        self.account_key = kwargs.get('account_key', None)
        self.service_principal_id = kwargs.get('service_principal_id', None)
        self.service_principal_key = kwargs.get('service_principal_key', None)
        self.tenant = kwargs.get('tenant', None)
        self.encrypted_credential = kwargs.get('encrypted_credential', None)


class AzureBlobFSLocation(DatasetLocation):
    """The location of azure blobFS dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset storage location.Constant filled by server.
    :type type: str
    :param folder_path: Specify the folder path of dataset. Type: string (or Expression with
     resultType string).
    :type folder_path: object
    :param file_name: Specify the file name of dataset. Type: string (or Expression with resultType
     string).
    :type file_name: object
    :param file_system: Specify the fileSystem of azure blobFS. Type: string (or Expression with
     resultType string).
    :type file_system: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'folder_path': {'key': 'folderPath', 'type': 'object'},
        'file_name': {'key': 'fileName', 'type': 'object'},
        'file_system': {'key': 'fileSystem', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureBlobFSLocation, self).__init__(**kwargs)
        self.type = 'AzureBlobFSLocation'  # type: str
        self.file_system = kwargs.get('file_system', None)


class AzureBlobFSReadSettings(StoreReadSettings):
    """Azure blobFS read settings.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. The read setting type.Constant filled by server.
    :type type: str
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param recursive: If true, files under the folder path will be read recursively. Default is
     true. Type: boolean (or Expression with resultType boolean).
    :type recursive: object
    :param wildcard_folder_path: Azure blobFS wildcardFolderPath. Type: string (or Expression with
     resultType string).
    :type wildcard_folder_path: object
    :param wildcard_file_name: Azure blobFS wildcardFileName. Type: string (or Expression with
     resultType string).
    :type wildcard_file_name: object
    :param enable_partition_discovery: Indicates whether to enable partition discovery.
    :type enable_partition_discovery: bool
    :param modified_datetime_start: The start of file's modified datetime. Type: string (or
     Expression with resultType string).
    :type modified_datetime_start: object
    :param modified_datetime_end: The end of file's modified datetime. Type: string (or Expression
     with resultType string).
    :type modified_datetime_end: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'recursive': {'key': 'recursive', 'type': 'object'},
        'wildcard_folder_path': {'key': 'wildcardFolderPath', 'type': 'object'},
        'wildcard_file_name': {'key': 'wildcardFileName', 'type': 'object'},
        'enable_partition_discovery': {'key': 'enablePartitionDiscovery', 'type': 'bool'},
        'modified_datetime_start': {'key': 'modifiedDatetimeStart', 'type': 'object'},
        'modified_datetime_end': {'key': 'modifiedDatetimeEnd', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureBlobFSReadSettings, self).__init__(**kwargs)
        self.type = 'AzureBlobFSReadSettings'  # type: str
        self.recursive = kwargs.get('recursive', None)
        self.wildcard_folder_path = kwargs.get('wildcard_folder_path', None)
        self.wildcard_file_name = kwargs.get('wildcard_file_name', None)
        self.enable_partition_discovery = kwargs.get('enable_partition_discovery', None)
        self.modified_datetime_start = kwargs.get('modified_datetime_start', None)
        self.modified_datetime_end = kwargs.get('modified_datetime_end', None)


class AzureBlobFSSink(CopySink):
    """A copy activity Azure Data Lake Storage Gen2 sink.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy sink type.Constant filled by server.
    :type type: str
    :param write_batch_size: Write batch size. Type: integer (or Expression with resultType
     integer), minimum: 0.
    :type write_batch_size: object
    :param write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type write_batch_timeout: object
    :param sink_retry_count: Sink retry count. Type: integer (or Expression with resultType
     integer).
    :type sink_retry_count: object
    :param sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type sink_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the sink data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param copy_behavior: The type of copy behavior for copy sink.
    :type copy_behavior: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'write_batch_size': {'key': 'writeBatchSize', 'type': 'object'},
        'write_batch_timeout': {'key': 'writeBatchTimeout', 'type': 'object'},
        'sink_retry_count': {'key': 'sinkRetryCount', 'type': 'object'},
        'sink_retry_wait': {'key': 'sinkRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'copy_behavior': {'key': 'copyBehavior', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureBlobFSSink, self).__init__(**kwargs)
        self.type = 'AzureBlobFSSink'  # type: str
        self.copy_behavior = kwargs.get('copy_behavior', None)


class AzureBlobFSSource(CopySource):
    """A copy activity Azure BlobFS source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: object
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param treat_empty_as_null: Treat empty as null. Type: boolean (or Expression with resultType
     boolean).
    :type treat_empty_as_null: object
    :param skip_header_line_count: Number of header lines to skip from each blob. Type: integer (or
     Expression with resultType integer).
    :type skip_header_line_count: object
    :param recursive: If true, files under the folder path will be read recursively. Default is
     true. Type: boolean (or Expression with resultType boolean).
    :type recursive: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'treat_empty_as_null': {'key': 'treatEmptyAsNull', 'type': 'object'},
        'skip_header_line_count': {'key': 'skipHeaderLineCount', 'type': 'object'},
        'recursive': {'key': 'recursive', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureBlobFSSource, self).__init__(**kwargs)
        self.type = 'AzureBlobFSSource'  # type: str
        self.treat_empty_as_null = kwargs.get('treat_empty_as_null', None)
        self.skip_header_line_count = kwargs.get('skip_header_line_count', None)
        self.recursive = kwargs.get('recursive', None)


class StoreWriteSettings(msrest.serialization.Model):
    """Connector write settings.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AzureBlobFSWriteSettings, AzureBlobStorageWriteSettings, AzureDataLakeStoreWriteSettings, FileServerWriteSettings, SftpWriteSettings.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. The write setting type.Constant filled by server.
    :type type: str
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param copy_behavior: The type of copy behavior for copy sink.
    :type copy_behavior: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'copy_behavior': {'key': 'copyBehavior', 'type': 'object'},
    }

    _subtype_map = {
        'type': {'AzureBlobFSWriteSettings': 'AzureBlobFSWriteSettings', 'AzureBlobStorageWriteSettings': 'AzureBlobStorageWriteSettings', 'AzureDataLakeStoreWriteSettings': 'AzureDataLakeStoreWriteSettings', 'FileServerWriteSettings': 'FileServerWriteSettings', 'SftpWriteSettings': 'SftpWriteSettings'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(StoreWriteSettings, self).__init__(**kwargs)
        self.additional_properties = kwargs.get('additional_properties', None)
        self.type = 'StoreWriteSettings'  # type: str
        self.max_concurrent_connections = kwargs.get('max_concurrent_connections', None)
        self.copy_behavior = kwargs.get('copy_behavior', None)


class AzureBlobFSWriteSettings(StoreWriteSettings):
    """Azure blobFS write settings.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. The write setting type.Constant filled by server.
    :type type: str
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param copy_behavior: The type of copy behavior for copy sink.
    :type copy_behavior: object
    :param block_size_in_mb: Indicates the block size(MB) when writing data to blob. Type: integer
     (or Expression with resultType integer).
    :type block_size_in_mb: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'copy_behavior': {'key': 'copyBehavior', 'type': 'object'},
        'block_size_in_mb': {'key': 'blockSizeInMB', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureBlobFSWriteSettings, self).__init__(**kwargs)
        self.type = 'AzureBlobFSWriteSettings'  # type: str
        self.block_size_in_mb = kwargs.get('block_size_in_mb', None)


class AzureBlobStorageLinkedService(LinkedService):
    """The azure blob storage linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param connection_string: The connection string. It is mutually exclusive with sasUri,
     serviceEndpoint property. Type: string, SecureString or AzureKeyVaultSecretReference.
    :type connection_string: object
    :param account_key: The Azure key vault secret reference of accountKey in connection string.
    :type account_key: ~azure.synapse.artifacts.models.AzureKeyVaultSecretReference
    :param sas_uri: SAS URI of the Azure Blob Storage resource. It is mutually exclusive with
     connectionString, serviceEndpoint property. Type: string, SecureString or
     AzureKeyVaultSecretReference.
    :type sas_uri: object
    :param sas_token: The Azure key vault secret reference of sasToken in sas uri.
    :type sas_token: ~azure.synapse.artifacts.models.AzureKeyVaultSecretReference
    :param service_endpoint: Blob service endpoint of the Azure Blob Storage resource. It is
     mutually exclusive with connectionString, sasUri property.
    :type service_endpoint: str
    :param service_principal_id: The ID of the service principal used to authenticate against Azure
     SQL Data Warehouse. Type: string (or Expression with resultType string).
    :type service_principal_id: object
    :param service_principal_key: The key of the service principal used to authenticate against
     Azure SQL Data Warehouse.
    :type service_principal_key: ~azure.synapse.artifacts.models.SecretBase
    :param tenant: The name or ID of the tenant to which the service principal belongs. Type:
     string (or Expression with resultType string).
    :type tenant: object
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: str
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'connection_string': {'key': 'typeProperties.connectionString', 'type': 'object'},
        'account_key': {'key': 'typeProperties.accountKey', 'type': 'AzureKeyVaultSecretReference'},
        'sas_uri': {'key': 'typeProperties.sasUri', 'type': 'object'},
        'sas_token': {'key': 'typeProperties.sasToken', 'type': 'AzureKeyVaultSecretReference'},
        'service_endpoint': {'key': 'typeProperties.serviceEndpoint', 'type': 'str'},
        'service_principal_id': {'key': 'typeProperties.servicePrincipalId', 'type': 'object'},
        'service_principal_key': {'key': 'typeProperties.servicePrincipalKey', 'type': 'SecretBase'},
        'tenant': {'key': 'typeProperties.tenant', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureBlobStorageLinkedService, self).__init__(**kwargs)
        self.type = 'AzureBlobStorage'  # type: str
        self.connection_string = kwargs.get('connection_string', None)
        self.account_key = kwargs.get('account_key', None)
        self.sas_uri = kwargs.get('sas_uri', None)
        self.sas_token = kwargs.get('sas_token', None)
        self.service_endpoint = kwargs.get('service_endpoint', None)
        self.service_principal_id = kwargs.get('service_principal_id', None)
        self.service_principal_key = kwargs.get('service_principal_key', None)
        self.tenant = kwargs.get('tenant', None)
        self.encrypted_credential = kwargs.get('encrypted_credential', None)


class AzureBlobStorageLocation(DatasetLocation):
    """The location of azure blob dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset storage location.Constant filled by server.
    :type type: str
    :param folder_path: Specify the folder path of dataset. Type: string (or Expression with
     resultType string).
    :type folder_path: object
    :param file_name: Specify the file name of dataset. Type: string (or Expression with resultType
     string).
    :type file_name: object
    :param container: Specify the container of azure blob. Type: string (or Expression with
     resultType string).
    :type container: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'folder_path': {'key': 'folderPath', 'type': 'object'},
        'file_name': {'key': 'fileName', 'type': 'object'},
        'container': {'key': 'container', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureBlobStorageLocation, self).__init__(**kwargs)
        self.type = 'AzureBlobStorageLocation'  # type: str
        self.container = kwargs.get('container', None)


class AzureBlobStorageReadSettings(StoreReadSettings):
    """Azure blob read settings.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. The read setting type.Constant filled by server.
    :type type: str
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param recursive: If true, files under the folder path will be read recursively. Default is
     true. Type: boolean (or Expression with resultType boolean).
    :type recursive: object
    :param wildcard_folder_path: Azure blob wildcardFolderPath. Type: string (or Expression with
     resultType string).
    :type wildcard_folder_path: object
    :param wildcard_file_name: Azure blob wildcardFileName. Type: string (or Expression with
     resultType string).
    :type wildcard_file_name: object
    :param prefix: The prefix filter for the Azure Blob name. Type: string (or Expression with
     resultType string).
    :type prefix: object
    :param enable_partition_discovery: Indicates whether to enable partition discovery.
    :type enable_partition_discovery: bool
    :param modified_datetime_start: The start of file's modified datetime. Type: string (or
     Expression with resultType string).
    :type modified_datetime_start: object
    :param modified_datetime_end: The end of file's modified datetime. Type: string (or Expression
     with resultType string).
    :type modified_datetime_end: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'recursive': {'key': 'recursive', 'type': 'object'},
        'wildcard_folder_path': {'key': 'wildcardFolderPath', 'type': 'object'},
        'wildcard_file_name': {'key': 'wildcardFileName', 'type': 'object'},
        'prefix': {'key': 'prefix', 'type': 'object'},
        'enable_partition_discovery': {'key': 'enablePartitionDiscovery', 'type': 'bool'},
        'modified_datetime_start': {'key': 'modifiedDatetimeStart', 'type': 'object'},
        'modified_datetime_end': {'key': 'modifiedDatetimeEnd', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureBlobStorageReadSettings, self).__init__(**kwargs)
        self.type = 'AzureBlobStorageReadSettings'  # type: str
        self.recursive = kwargs.get('recursive', None)
        self.wildcard_folder_path = kwargs.get('wildcard_folder_path', None)
        self.wildcard_file_name = kwargs.get('wildcard_file_name', None)
        self.prefix = kwargs.get('prefix', None)
        self.enable_partition_discovery = kwargs.get('enable_partition_discovery', None)
        self.modified_datetime_start = kwargs.get('modified_datetime_start', None)
        self.modified_datetime_end = kwargs.get('modified_datetime_end', None)


class AzureBlobStorageWriteSettings(StoreWriteSettings):
    """Azure blob write settings.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. The write setting type.Constant filled by server.
    :type type: str
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param copy_behavior: The type of copy behavior for copy sink.
    :type copy_behavior: object
    :param block_size_in_mb: Indicates the block size(MB) when writing data to blob. Type: integer
     (or Expression with resultType integer).
    :type block_size_in_mb: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'copy_behavior': {'key': 'copyBehavior', 'type': 'object'},
        'block_size_in_mb': {'key': 'blockSizeInMB', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureBlobStorageWriteSettings, self).__init__(**kwargs)
        self.type = 'AzureBlobStorageWriteSettings'  # type: str
        self.block_size_in_mb = kwargs.get('block_size_in_mb', None)


class AzureDatabricksLinkedService(LinkedService):
    """Azure Databricks linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param domain: Required. :code:`<REGION>`.azuredatabricks.net, domain name of your Databricks
     deployment. Type: string (or Expression with resultType string).
    :type domain: object
    :param access_token: Required. Access token for databricks REST API. Refer to
     https://docs.azuredatabricks.net/api/latest/authentication.html. Type: string (or Expression
     with resultType string).
    :type access_token: ~azure.synapse.artifacts.models.SecretBase
    :param existing_cluster_id: The id of an existing interactive cluster that will be used for all
     runs of this activity. Type: string (or Expression with resultType string).
    :type existing_cluster_id: object
    :param instance_pool_id: The id of an existing instance pool that will be used for all runs of
     this activity. Type: string (or Expression with resultType string).
    :type instance_pool_id: object
    :param new_cluster_version: If not using an existing interactive cluster, this specifies the
     Spark version of a new job cluster or instance pool nodes created for each run of this
     activity. Required if instancePoolId is specified. Type: string (or Expression with resultType
     string).
    :type new_cluster_version: object
    :param new_cluster_num_of_worker: If not using an existing interactive cluster, this specifies
     the number of worker nodes to use for the new job cluster or instance pool. For new job
     clusters, this a string-formatted Int32, like '1' means numOfWorker is 1 or '1:10' means auto-
     scale from 1 (min) to 10 (max). For instance pools, this is a string-formatted Int32, and can
     only specify a fixed number of worker nodes, such as '2'. Required if newClusterVersion is
     specified. Type: string (or Expression with resultType string).
    :type new_cluster_num_of_worker: object
    :param new_cluster_node_type: The node type of the new job cluster. This property is required
     if newClusterVersion is specified and instancePoolId is not specified. If instancePoolId is
     specified, this property is ignored. Type: string (or Expression with resultType string).
    :type new_cluster_node_type: object
    :param new_cluster_spark_conf: A set of optional, user-specified Spark configuration key-value
     pairs.
    :type new_cluster_spark_conf: dict[str, object]
    :param new_cluster_spark_env_vars: A set of optional, user-specified Spark environment
     variables key-value pairs.
    :type new_cluster_spark_env_vars: dict[str, object]
    :param new_cluster_custom_tags: Additional tags for cluster resources. This property is ignored
     in instance pool configurations.
    :type new_cluster_custom_tags: dict[str, object]
    :param new_cluster_driver_node_type: The driver node type for the new job cluster. This
     property is ignored in instance pool configurations. Type: string (or Expression with
     resultType string).
    :type new_cluster_driver_node_type: object
    :param new_cluster_init_scripts: User-defined initialization scripts for the new cluster. Type:
     array of strings (or Expression with resultType array of strings).
    :type new_cluster_init_scripts: object
    :param new_cluster_enable_elastic_disk: Enable the elastic disk on the new cluster. This
     property is now ignored, and takes the default elastic disk behavior in Databricks (elastic
     disks are always enabled). Type: boolean (or Expression with resultType boolean).
    :type new_cluster_enable_elastic_disk: object
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'domain': {'required': True},
        'access_token': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'domain': {'key': 'typeProperties.domain', 'type': 'object'},
        'access_token': {'key': 'typeProperties.accessToken', 'type': 'SecretBase'},
        'existing_cluster_id': {'key': 'typeProperties.existingClusterId', 'type': 'object'},
        'instance_pool_id': {'key': 'typeProperties.instancePoolId', 'type': 'object'},
        'new_cluster_version': {'key': 'typeProperties.newClusterVersion', 'type': 'object'},
        'new_cluster_num_of_worker': {'key': 'typeProperties.newClusterNumOfWorker', 'type': 'object'},
        'new_cluster_node_type': {'key': 'typeProperties.newClusterNodeType', 'type': 'object'},
        'new_cluster_spark_conf': {'key': 'typeProperties.newClusterSparkConf', 'type': '{object}'},
        'new_cluster_spark_env_vars': {'key': 'typeProperties.newClusterSparkEnvVars', 'type': '{object}'},
        'new_cluster_custom_tags': {'key': 'typeProperties.newClusterCustomTags', 'type': '{object}'},
        'new_cluster_driver_node_type': {'key': 'typeProperties.newClusterDriverNodeType', 'type': 'object'},
        'new_cluster_init_scripts': {'key': 'typeProperties.newClusterInitScripts', 'type': 'object'},
        'new_cluster_enable_elastic_disk': {'key': 'typeProperties.newClusterEnableElasticDisk', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureDatabricksLinkedService, self).__init__(**kwargs)
        self.type = 'AzureDatabricks'  # type: str
        self.domain = kwargs['domain']
        self.access_token = kwargs['access_token']
        self.existing_cluster_id = kwargs.get('existing_cluster_id', None)
        self.instance_pool_id = kwargs.get('instance_pool_id', None)
        self.new_cluster_version = kwargs.get('new_cluster_version', None)
        self.new_cluster_num_of_worker = kwargs.get('new_cluster_num_of_worker', None)
        self.new_cluster_node_type = kwargs.get('new_cluster_node_type', None)
        self.new_cluster_spark_conf = kwargs.get('new_cluster_spark_conf', None)
        self.new_cluster_spark_env_vars = kwargs.get('new_cluster_spark_env_vars', None)
        self.new_cluster_custom_tags = kwargs.get('new_cluster_custom_tags', None)
        self.new_cluster_driver_node_type = kwargs.get('new_cluster_driver_node_type', None)
        self.new_cluster_init_scripts = kwargs.get('new_cluster_init_scripts', None)
        self.new_cluster_enable_elastic_disk = kwargs.get('new_cluster_enable_elastic_disk', None)
        self.encrypted_credential = kwargs.get('encrypted_credential', None)


class ExecutionActivity(Activity):
    """Base class for all execution activities.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AzureDataExplorerCommandActivity, AzureFunctionActivity, AzureMLBatchExecutionActivity, AzureMLExecutePipelineActivity, AzureMLUpdateResourceActivity, CopyActivity, CustomActivity, DataLakeAnalyticsUSQLActivity, DatabricksNotebookActivity, DatabricksSparkJarActivity, DatabricksSparkPythonActivity, DeleteActivity, ExecuteDataFlowActivity, ExecuteSSISPackageActivity, GetMetadataActivity, HDInsightHiveActivity, HDInsightMapReduceActivity, HDInsightPigActivity, HDInsightSparkActivity, HDInsightStreamingActivity, LookupActivity, SqlServerStoredProcedureActivity, WebActivity.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param name: Required. Activity name.
    :type name: str
    :param type: Required. Type of activity.Constant filled by server.
    :type type: str
    :param description: Activity description.
    :type description: str
    :param depends_on: Activity depends on condition.
    :type depends_on: list[~azure.synapse.artifacts.models.ActivityDependency]
    :param user_properties: Activity user properties.
    :type user_properties: list[~azure.synapse.artifacts.models.UserProperty]
    :param linked_service_name: Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param policy: Activity policy.
    :type policy: ~azure.synapse.artifacts.models.ActivityPolicy
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'depends_on': {'key': 'dependsOn', 'type': '[ActivityDependency]'},
        'user_properties': {'key': 'userProperties', 'type': '[UserProperty]'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'policy': {'key': 'policy', 'type': 'ActivityPolicy'},
    }

    _subtype_map = {
        'type': {'AzureDataExplorerCommand': 'AzureDataExplorerCommandActivity', 'AzureFunctionActivity': 'AzureFunctionActivity', 'AzureMLBatchExecution': 'AzureMLBatchExecutionActivity', 'AzureMLExecutePipeline': 'AzureMLExecutePipelineActivity', 'AzureMLUpdateResource': 'AzureMLUpdateResourceActivity', 'Copy': 'CopyActivity', 'Custom': 'CustomActivity', 'DataLakeAnalyticsU-SQL': 'DataLakeAnalyticsUSQLActivity', 'DatabricksNotebook': 'DatabricksNotebookActivity', 'DatabricksSparkJar': 'DatabricksSparkJarActivity', 'DatabricksSparkPython': 'DatabricksSparkPythonActivity', 'Delete': 'DeleteActivity', 'ExecuteDataFlow': 'ExecuteDataFlowActivity', 'ExecuteSSISPackage': 'ExecuteSSISPackageActivity', 'GetMetadata': 'GetMetadataActivity', 'HDInsightHive': 'HDInsightHiveActivity', 'HDInsightMapReduce': 'HDInsightMapReduceActivity', 'HDInsightPig': 'HDInsightPigActivity', 'HDInsightSpark': 'HDInsightSparkActivity', 'HDInsightStreaming': 'HDInsightStreamingActivity', 'Lookup': 'LookupActivity', 'SqlServerStoredProcedure': 'SqlServerStoredProcedureActivity', 'WebActivity': 'WebActivity'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ExecutionActivity, self).__init__(**kwargs)
        self.type = 'Execution'  # type: str
        self.linked_service_name = kwargs.get('linked_service_name', None)
        self.policy = kwargs.get('policy', None)


class AzureDataExplorerCommandActivity(ExecutionActivity):
    """Azure Data Explorer command activity.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param name: Required. Activity name.
    :type name: str
    :param type: Required. Type of activity.Constant filled by server.
    :type type: str
    :param description: Activity description.
    :type description: str
    :param depends_on: Activity depends on condition.
    :type depends_on: list[~azure.synapse.artifacts.models.ActivityDependency]
    :param user_properties: Activity user properties.
    :type user_properties: list[~azure.synapse.artifacts.models.UserProperty]
    :param linked_service_name: Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param policy: Activity policy.
    :type policy: ~azure.synapse.artifacts.models.ActivityPolicy
    :param command: Required. A control command, according to the Azure Data Explorer command
     syntax. Type: string (or Expression with resultType string).
    :type command: object
    :param command_timeout: Control command timeout. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9]))..).
    :type command_timeout: object
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
        'command': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'depends_on': {'key': 'dependsOn', 'type': '[ActivityDependency]'},
        'user_properties': {'key': 'userProperties', 'type': '[UserProperty]'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'policy': {'key': 'policy', 'type': 'ActivityPolicy'},
        'command': {'key': 'typeProperties.command', 'type': 'object'},
        'command_timeout': {'key': 'typeProperties.commandTimeout', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureDataExplorerCommandActivity, self).__init__(**kwargs)
        self.type = 'AzureDataExplorerCommand'  # type: str
        self.command = kwargs['command']
        self.command_timeout = kwargs.get('command_timeout', None)


class AzureDataExplorerLinkedService(LinkedService):
    """Azure Data Explorer (Kusto) linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param endpoint: Required. The endpoint of Azure Data Explorer (the engine's endpoint). URL
     will be in the format https://:code:`<clusterName>`.:code:`<regionName>`.kusto.windows.net.
     Type: string (or Expression with resultType string).
    :type endpoint: object
    :param service_principal_id: Required. The ID of the service principal used to authenticate
     against Azure Data Explorer. Type: string (or Expression with resultType string).
    :type service_principal_id: object
    :param service_principal_key: Required. The key of the service principal used to authenticate
     against Kusto.
    :type service_principal_key: ~azure.synapse.artifacts.models.SecretBase
    :param database: Required. Database name for connection. Type: string (or Expression with
     resultType string).
    :type database: object
    :param tenant: Required. The name or ID of the tenant to which the service principal belongs.
     Type: string (or Expression with resultType string).
    :type tenant: object
    """

    _validation = {
        'type': {'required': True},
        'endpoint': {'required': True},
        'service_principal_id': {'required': True},
        'service_principal_key': {'required': True},
        'database': {'required': True},
        'tenant': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'endpoint': {'key': 'typeProperties.endpoint', 'type': 'object'},
        'service_principal_id': {'key': 'typeProperties.servicePrincipalId', 'type': 'object'},
        'service_principal_key': {'key': 'typeProperties.servicePrincipalKey', 'type': 'SecretBase'},
        'database': {'key': 'typeProperties.database', 'type': 'object'},
        'tenant': {'key': 'typeProperties.tenant', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureDataExplorerLinkedService, self).__init__(**kwargs)
        self.type = 'AzureDataExplorer'  # type: str
        self.endpoint = kwargs['endpoint']
        self.service_principal_id = kwargs['service_principal_id']
        self.service_principal_key = kwargs['service_principal_key']
        self.database = kwargs['database']
        self.tenant = kwargs['tenant']


class AzureDataExplorerSink(CopySink):
    """A copy activity Azure Data Explorer sink.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy sink type.Constant filled by server.
    :type type: str
    :param write_batch_size: Write batch size. Type: integer (or Expression with resultType
     integer), minimum: 0.
    :type write_batch_size: object
    :param write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type write_batch_timeout: object
    :param sink_retry_count: Sink retry count. Type: integer (or Expression with resultType
     integer).
    :type sink_retry_count: object
    :param sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type sink_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the sink data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param ingestion_mapping_name: A name of a pre-created csv mapping that was defined on the
     target Kusto table. Type: string.
    :type ingestion_mapping_name: object
    :param ingestion_mapping_as_json: An explicit column mapping description provided in a json
     format. Type: string.
    :type ingestion_mapping_as_json: object
    :param flush_immediately: If set to true, any aggregation will be skipped. Default is false.
     Type: boolean.
    :type flush_immediately: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'write_batch_size': {'key': 'writeBatchSize', 'type': 'object'},
        'write_batch_timeout': {'key': 'writeBatchTimeout', 'type': 'object'},
        'sink_retry_count': {'key': 'sinkRetryCount', 'type': 'object'},
        'sink_retry_wait': {'key': 'sinkRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'ingestion_mapping_name': {'key': 'ingestionMappingName', 'type': 'object'},
        'ingestion_mapping_as_json': {'key': 'ingestionMappingAsJson', 'type': 'object'},
        'flush_immediately': {'key': 'flushImmediately', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureDataExplorerSink, self).__init__(**kwargs)
        self.type = 'AzureDataExplorerSink'  # type: str
        self.ingestion_mapping_name = kwargs.get('ingestion_mapping_name', None)
        self.ingestion_mapping_as_json = kwargs.get('ingestion_mapping_as_json', None)
        self.flush_immediately = kwargs.get('flush_immediately', None)


class AzureDataExplorerSource(CopySource):
    """A copy activity Azure Data Explorer (Kusto) source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: object
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param query: Required. Database query. Should be a Kusto Query Language (KQL) query. Type:
     string (or Expression with resultType string).
    :type query: object
    :param no_truncation: The name of the Boolean option that controls whether truncation is
     applied to result-sets that go beyond a certain row-count limit.
    :type no_truncation: object
    :param query_timeout: Query timeout. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9]))..
    :type query_timeout: object
    """

    _validation = {
        'type': {'required': True},
        'query': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'query': {'key': 'query', 'type': 'object'},
        'no_truncation': {'key': 'noTruncation', 'type': 'object'},
        'query_timeout': {'key': 'queryTimeout', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureDataExplorerSource, self).__init__(**kwargs)
        self.type = 'AzureDataExplorerSource'  # type: str
        self.query = kwargs['query']
        self.no_truncation = kwargs.get('no_truncation', None)
        self.query_timeout = kwargs.get('query_timeout', None)


class AzureDataExplorerTableDataset(Dataset):
    """The Azure Data Explorer (Kusto) dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param table: The table name of the Azure Data Explorer database. Type: string (or Expression
     with resultType string).
    :type table: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table': {'key': 'typeProperties.table', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureDataExplorerTableDataset, self).__init__(**kwargs)
        self.type = 'AzureDataExplorerTable'  # type: str
        self.table = kwargs.get('table', None)


class AzureDataLakeAnalyticsLinkedService(LinkedService):
    """Azure Data Lake Analytics linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param account_name: Required. The Azure Data Lake Analytics account name. Type: string (or
     Expression with resultType string).
    :type account_name: object
    :param service_principal_id: The ID of the application used to authenticate against the Azure
     Data Lake Analytics account. Type: string (or Expression with resultType string).
    :type service_principal_id: object
    :param service_principal_key: The Key of the application used to authenticate against the Azure
     Data Lake Analytics account.
    :type service_principal_key: ~azure.synapse.artifacts.models.SecretBase
    :param tenant: Required. The name or ID of the tenant to which the service principal belongs.
     Type: string (or Expression with resultType string).
    :type tenant: object
    :param subscription_id: Data Lake Analytics account subscription ID (if different from Data
     Factory account). Type: string (or Expression with resultType string).
    :type subscription_id: object
    :param resource_group_name: Data Lake Analytics account resource group name (if different from
     Data Factory account). Type: string (or Expression with resultType string).
    :type resource_group_name: object
    :param data_lake_analytics_uri: Azure Data Lake Analytics URI Type: string (or Expression with
     resultType string).
    :type data_lake_analytics_uri: object
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'account_name': {'required': True},
        'tenant': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'account_name': {'key': 'typeProperties.accountName', 'type': 'object'},
        'service_principal_id': {'key': 'typeProperties.servicePrincipalId', 'type': 'object'},
        'service_principal_key': {'key': 'typeProperties.servicePrincipalKey', 'type': 'SecretBase'},
        'tenant': {'key': 'typeProperties.tenant', 'type': 'object'},
        'subscription_id': {'key': 'typeProperties.subscriptionId', 'type': 'object'},
        'resource_group_name': {'key': 'typeProperties.resourceGroupName', 'type': 'object'},
        'data_lake_analytics_uri': {'key': 'typeProperties.dataLakeAnalyticsUri', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureDataLakeAnalyticsLinkedService, self).__init__(**kwargs)
        self.type = 'AzureDataLakeAnalytics'  # type: str
        self.account_name = kwargs['account_name']
        self.service_principal_id = kwargs.get('service_principal_id', None)
        self.service_principal_key = kwargs.get('service_principal_key', None)
        self.tenant = kwargs['tenant']
        self.subscription_id = kwargs.get('subscription_id', None)
        self.resource_group_name = kwargs.get('resource_group_name', None)
        self.data_lake_analytics_uri = kwargs.get('data_lake_analytics_uri', None)
        self.encrypted_credential = kwargs.get('encrypted_credential', None)


class AzureDataLakeStoreLinkedService(LinkedService):
    """Azure Data Lake Store linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param data_lake_store_uri: Required. Data Lake Store service URI. Type: string (or Expression
     with resultType string).
    :type data_lake_store_uri: object
    :param service_principal_id: The ID of the application used to authenticate against the Azure
     Data Lake Store account. Type: string (or Expression with resultType string).
    :type service_principal_id: object
    :param service_principal_key: The Key of the application used to authenticate against the Azure
     Data Lake Store account.
    :type service_principal_key: ~azure.synapse.artifacts.models.SecretBase
    :param tenant: The name or ID of the tenant to which the service principal belongs. Type:
     string (or Expression with resultType string).
    :type tenant: object
    :param account_name: Data Lake Store account name. Type: string (or Expression with resultType
     string).
    :type account_name: object
    :param subscription_id: Data Lake Store account subscription ID (if different from Data Factory
     account). Type: string (or Expression with resultType string).
    :type subscription_id: object
    :param resource_group_name: Data Lake Store account resource group name (if different from Data
     Factory account). Type: string (or Expression with resultType string).
    :type resource_group_name: object
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'data_lake_store_uri': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'data_lake_store_uri': {'key': 'typeProperties.dataLakeStoreUri', 'type': 'object'},
        'service_principal_id': {'key': 'typeProperties.servicePrincipalId', 'type': 'object'},
        'service_principal_key': {'key': 'typeProperties.servicePrincipalKey', 'type': 'SecretBase'},
        'tenant': {'key': 'typeProperties.tenant', 'type': 'object'},
        'account_name': {'key': 'typeProperties.accountName', 'type': 'object'},
        'subscription_id': {'key': 'typeProperties.subscriptionId', 'type': 'object'},
        'resource_group_name': {'key': 'typeProperties.resourceGroupName', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureDataLakeStoreLinkedService, self).__init__(**kwargs)
        self.type = 'AzureDataLakeStore'  # type: str
        self.data_lake_store_uri = kwargs['data_lake_store_uri']
        self.service_principal_id = kwargs.get('service_principal_id', None)
        self.service_principal_key = kwargs.get('service_principal_key', None)
        self.tenant = kwargs.get('tenant', None)
        self.account_name = kwargs.get('account_name', None)
        self.subscription_id = kwargs.get('subscription_id', None)
        self.resource_group_name = kwargs.get('resource_group_name', None)
        self.encrypted_credential = kwargs.get('encrypted_credential', None)


class AzureDataLakeStoreLocation(DatasetLocation):
    """The location of azure data lake store dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset storage location.Constant filled by server.
    :type type: str
    :param folder_path: Specify the folder path of dataset. Type: string (or Expression with
     resultType string).
    :type folder_path: object
    :param file_name: Specify the file name of dataset. Type: string (or Expression with resultType
     string).
    :type file_name: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'folder_path': {'key': 'folderPath', 'type': 'object'},
        'file_name': {'key': 'fileName', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureDataLakeStoreLocation, self).__init__(**kwargs)
        self.type = 'AzureDataLakeStoreLocation'  # type: str


class AzureDataLakeStoreReadSettings(StoreReadSettings):
    """Azure data lake store read settings.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. The read setting type.Constant filled by server.
    :type type: str
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param recursive: If true, files under the folder path will be read recursively. Default is
     true. Type: boolean (or Expression with resultType boolean).
    :type recursive: object
    :param wildcard_folder_path: ADLS wildcardFolderPath. Type: string (or Expression with
     resultType string).
    :type wildcard_folder_path: object
    :param wildcard_file_name: ADLS wildcardFileName. Type: string (or Expression with resultType
     string).
    :type wildcard_file_name: object
    :param enable_partition_discovery: Indicates whether to enable partition discovery.
    :type enable_partition_discovery: bool
    :param modified_datetime_start: The start of file's modified datetime. Type: string (or
     Expression with resultType string).
    :type modified_datetime_start: object
    :param modified_datetime_end: The end of file's modified datetime. Type: string (or Expression
     with resultType string).
    :type modified_datetime_end: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'recursive': {'key': 'recursive', 'type': 'object'},
        'wildcard_folder_path': {'key': 'wildcardFolderPath', 'type': 'object'},
        'wildcard_file_name': {'key': 'wildcardFileName', 'type': 'object'},
        'enable_partition_discovery': {'key': 'enablePartitionDiscovery', 'type': 'bool'},
        'modified_datetime_start': {'key': 'modifiedDatetimeStart', 'type': 'object'},
        'modified_datetime_end': {'key': 'modifiedDatetimeEnd', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureDataLakeStoreReadSettings, self).__init__(**kwargs)
        self.type = 'AzureDataLakeStoreReadSettings'  # type: str
        self.recursive = kwargs.get('recursive', None)
        self.wildcard_folder_path = kwargs.get('wildcard_folder_path', None)
        self.wildcard_file_name = kwargs.get('wildcard_file_name', None)
        self.enable_partition_discovery = kwargs.get('enable_partition_discovery', None)
        self.modified_datetime_start = kwargs.get('modified_datetime_start', None)
        self.modified_datetime_end = kwargs.get('modified_datetime_end', None)


class AzureDataLakeStoreSink(CopySink):
    """A copy activity Azure Data Lake Store sink.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy sink type.Constant filled by server.
    :type type: str
    :param write_batch_size: Write batch size. Type: integer (or Expression with resultType
     integer), minimum: 0.
    :type write_batch_size: object
    :param write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type write_batch_timeout: object
    :param sink_retry_count: Sink retry count. Type: integer (or Expression with resultType
     integer).
    :type sink_retry_count: object
    :param sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type sink_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the sink data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param copy_behavior: The type of copy behavior for copy sink.
    :type copy_behavior: object
    :param enable_adls_single_file_parallel: Single File Parallel.
    :type enable_adls_single_file_parallel: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'write_batch_size': {'key': 'writeBatchSize', 'type': 'object'},
        'write_batch_timeout': {'key': 'writeBatchTimeout', 'type': 'object'},
        'sink_retry_count': {'key': 'sinkRetryCount', 'type': 'object'},
        'sink_retry_wait': {'key': 'sinkRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'copy_behavior': {'key': 'copyBehavior', 'type': 'object'},
        'enable_adls_single_file_parallel': {'key': 'enableAdlsSingleFileParallel', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureDataLakeStoreSink, self).__init__(**kwargs)
        self.type = 'AzureDataLakeStoreSink'  # type: str
        self.copy_behavior = kwargs.get('copy_behavior', None)
        self.enable_adls_single_file_parallel = kwargs.get('enable_adls_single_file_parallel', None)


class AzureDataLakeStoreSource(CopySource):
    """A copy activity Azure Data Lake source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: object
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param recursive: If true, files under the folder path will be read recursively. Default is
     true. Type: boolean (or Expression with resultType boolean).
    :type recursive: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'recursive': {'key': 'recursive', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureDataLakeStoreSource, self).__init__(**kwargs)
        self.type = 'AzureDataLakeStoreSource'  # type: str
        self.recursive = kwargs.get('recursive', None)


class AzureDataLakeStoreWriteSettings(StoreWriteSettings):
    """Azure data lake store write settings.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. The write setting type.Constant filled by server.
    :type type: str
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param copy_behavior: The type of copy behavior for copy sink.
    :type copy_behavior: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'copy_behavior': {'key': 'copyBehavior', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureDataLakeStoreWriteSettings, self).__init__(**kwargs)
        self.type = 'AzureDataLakeStoreWriteSettings'  # type: str


class Resource(msrest.serialization.Model):
    """Resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. Ex- Microsoft.Compute/virtualMachines or
     Microsoft.Storage/storageAccounts.
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class AzureEntityResource(Resource):
    """The resource model definition for a Azure Resource Manager resource with an etag.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. Ex- Microsoft.Compute/virtualMachines or
     Microsoft.Storage/storageAccounts.
    :vartype type: str
    :ivar etag: Resource Etag.
    :vartype etag: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureEntityResource, self).__init__(**kwargs)
        self.etag = None


class AzureFileStorageLinkedService(LinkedService):
    """Azure File Storage linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param host: Required. Host name of the server. Type: string (or Expression with resultType
     string).
    :type host: object
    :param user_id: User ID to logon the server. Type: string (or Expression with resultType
     string).
    :type user_id: object
    :param password: Password to logon the server.
    :type password: ~azure.synapse.artifacts.models.SecretBase
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'host': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'host': {'key': 'typeProperties.host', 'type': 'object'},
        'user_id': {'key': 'typeProperties.userId', 'type': 'object'},
        'password': {'key': 'typeProperties.password', 'type': 'SecretBase'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureFileStorageLinkedService, self).__init__(**kwargs)
        self.type = 'AzureFileStorage'  # type: str
        self.host = kwargs['host']
        self.user_id = kwargs.get('user_id', None)
        self.password = kwargs.get('password', None)
        self.encrypted_credential = kwargs.get('encrypted_credential', None)


class AzureFileStorageLocation(DatasetLocation):
    """The location of file server dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset storage location.Constant filled by server.
    :type type: str
    :param folder_path: Specify the folder path of dataset. Type: string (or Expression with
     resultType string).
    :type folder_path: object
    :param file_name: Specify the file name of dataset. Type: string (or Expression with resultType
     string).
    :type file_name: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'folder_path': {'key': 'folderPath', 'type': 'object'},
        'file_name': {'key': 'fileName', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureFileStorageLocation, self).__init__(**kwargs)
        self.type = 'AzureFileStorageLocation'  # type: str


class AzureFileStorageReadSettings(StoreReadSettings):
    """Azure File Storage read settings.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. The read setting type.Constant filled by server.
    :type type: str
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param recursive: If true, files under the folder path will be read recursively. Default is
     true. Type: boolean (or Expression with resultType boolean).
    :type recursive: object
    :param wildcard_folder_path: Azure File Storage wildcardFolderPath. Type: string (or Expression
     with resultType string).
    :type wildcard_folder_path: object
    :param wildcard_file_name: Azure File Storage wildcardFileName. Type: string (or Expression
     with resultType string).
    :type wildcard_file_name: object
    :param enable_partition_discovery: Indicates whether to enable partition discovery.
    :type enable_partition_discovery: bool
    :param modified_datetime_start: The start of file's modified datetime. Type: string (or
     Expression with resultType string).
    :type modified_datetime_start: object
    :param modified_datetime_end: The end of file's modified datetime. Type: string (or Expression
     with resultType string).
    :type modified_datetime_end: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'recursive': {'key': 'recursive', 'type': 'object'},
        'wildcard_folder_path': {'key': 'wildcardFolderPath', 'type': 'object'},
        'wildcard_file_name': {'key': 'wildcardFileName', 'type': 'object'},
        'enable_partition_discovery': {'key': 'enablePartitionDiscovery', 'type': 'bool'},
        'modified_datetime_start': {'key': 'modifiedDatetimeStart', 'type': 'object'},
        'modified_datetime_end': {'key': 'modifiedDatetimeEnd', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureFileStorageReadSettings, self).__init__(**kwargs)
        self.type = 'AzureFileStorageReadSettings'  # type: str
        self.recursive = kwargs.get('recursive', None)
        self.wildcard_folder_path = kwargs.get('wildcard_folder_path', None)
        self.wildcard_file_name = kwargs.get('wildcard_file_name', None)
        self.enable_partition_discovery = kwargs.get('enable_partition_discovery', None)
        self.modified_datetime_start = kwargs.get('modified_datetime_start', None)
        self.modified_datetime_end = kwargs.get('modified_datetime_end', None)


class AzureFunctionActivity(ExecutionActivity):
    """Azure Function activity.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param name: Required. Activity name.
    :type name: str
    :param type: Required. Type of activity.Constant filled by server.
    :type type: str
    :param description: Activity description.
    :type description: str
    :param depends_on: Activity depends on condition.
    :type depends_on: list[~azure.synapse.artifacts.models.ActivityDependency]
    :param user_properties: Activity user properties.
    :type user_properties: list[~azure.synapse.artifacts.models.UserProperty]
    :param linked_service_name: Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param policy: Activity policy.
    :type policy: ~azure.synapse.artifacts.models.ActivityPolicy
    :param method: Required. Rest API method for target endpoint. Possible values include: "GET",
     "POST", "PUT", "DELETE", "OPTIONS", "HEAD", "TRACE".
    :type method: str or ~azure.synapse.artifacts.models.AzureFunctionActivityMethod
    :param function_name: Required. Name of the Function that the Azure Function Activity will
     call. Type: string (or Expression with resultType string).
    :type function_name: object
    :param headers: Represents the headers that will be sent to the request. For example, to set
     the language and type on a request: "headers" : { "Accept-Language": "en-us", "Content-Type":
     "application/json" }. Type: string (or Expression with resultType string).
    :type headers: object
    :param body: Represents the payload that will be sent to the endpoint. Required for POST/PUT
     method, not allowed for GET method Type: string (or Expression with resultType string).
    :type body: object
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
        'method': {'required': True},
        'function_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'depends_on': {'key': 'dependsOn', 'type': '[ActivityDependency]'},
        'user_properties': {'key': 'userProperties', 'type': '[UserProperty]'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'policy': {'key': 'policy', 'type': 'ActivityPolicy'},
        'method': {'key': 'typeProperties.method', 'type': 'str'},
        'function_name': {'key': 'typeProperties.functionName', 'type': 'object'},
        'headers': {'key': 'typeProperties.headers', 'type': 'object'},
        'body': {'key': 'typeProperties.body', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureFunctionActivity, self).__init__(**kwargs)
        self.type = 'AzureFunctionActivity'  # type: str
        self.method = kwargs['method']
        self.function_name = kwargs['function_name']
        self.headers = kwargs.get('headers', None)
        self.body = kwargs.get('body', None)


class AzureFunctionLinkedService(LinkedService):
    """Azure Function linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param function_app_url: Required. The endpoint of the Azure Function App. URL will be in the
     format https://:code:`<accountName>`.azurewebsites.net.
    :type function_app_url: object
    :param function_key: Function or Host key for Azure Function App.
    :type function_key: ~azure.synapse.artifacts.models.SecretBase
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'function_app_url': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'function_app_url': {'key': 'typeProperties.functionAppUrl', 'type': 'object'},
        'function_key': {'key': 'typeProperties.functionKey', 'type': 'SecretBase'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureFunctionLinkedService, self).__init__(**kwargs)
        self.type = 'AzureFunction'  # type: str
        self.function_app_url = kwargs['function_app_url']
        self.function_key = kwargs.get('function_key', None)
        self.encrypted_credential = kwargs.get('encrypted_credential', None)


class AzureKeyVaultLinkedService(LinkedService):
    """Azure Key Vault linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param base_url: Required. The base URL of the Azure Key Vault. e.g.
     https://myakv.vault.azure.net Type: string (or Expression with resultType string).
    :type base_url: object
    """

    _validation = {
        'type': {'required': True},
        'base_url': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'base_url': {'key': 'typeProperties.baseUrl', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureKeyVaultLinkedService, self).__init__(**kwargs)
        self.type = 'AzureKeyVault'  # type: str
        self.base_url = kwargs['base_url']


class SecretBase(msrest.serialization.Model):
    """The base definition of a secret type.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AzureKeyVaultSecretReference, SecureString.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Type of the secret.Constant filled by server.
    :type type: str
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
    }

    _subtype_map = {
        'type': {'AzureKeyVaultSecret': 'AzureKeyVaultSecretReference', 'SecureString': 'SecureString'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SecretBase, self).__init__(**kwargs)
        self.type = None  # type: Optional[str]


class AzureKeyVaultSecretReference(SecretBase):
    """Azure Key Vault secret reference.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Type of the secret.Constant filled by server.
    :type type: str
    :param store: Required. The Azure Key Vault linked service reference.
    :type store: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param secret_name: Required. The name of the secret in Azure Key Vault. Type: string (or
     Expression with resultType string).
    :type secret_name: object
    :param secret_version: The version of the secret in Azure Key Vault. The default value is the
     latest version of the secret. Type: string (or Expression with resultType string).
    :type secret_version: object
    """

    _validation = {
        'type': {'required': True},
        'store': {'required': True},
        'secret_name': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'store': {'key': 'store', 'type': 'LinkedServiceReference'},
        'secret_name': {'key': 'secretName', 'type': 'object'},
        'secret_version': {'key': 'secretVersion', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureKeyVaultSecretReference, self).__init__(**kwargs)
        self.type = 'AzureKeyVaultSecret'  # type: str
        self.store = kwargs['store']
        self.secret_name = kwargs['secret_name']
        self.secret_version = kwargs.get('secret_version', None)


class AzureMariaDBLinkedService(LinkedService):
    """Azure Database for MariaDB linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param connection_string: An ODBC connection string. Type: string, SecureString or
     AzureKeyVaultSecretReference.
    :type connection_string: object
    :param pwd: The Azure key vault secret reference of password in connection string.
    :type pwd: ~azure.synapse.artifacts.models.AzureKeyVaultSecretReference
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'connection_string': {'key': 'typeProperties.connectionString', 'type': 'object'},
        'pwd': {'key': 'typeProperties.pwd', 'type': 'AzureKeyVaultSecretReference'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureMariaDBLinkedService, self).__init__(**kwargs)
        self.type = 'AzureMariaDB'  # type: str
        self.connection_string = kwargs.get('connection_string', None)
        self.pwd = kwargs.get('pwd', None)
        self.encrypted_credential = kwargs.get('encrypted_credential', None)


class AzureMariaDBSource(TabularSource):
    """A copy activity Azure MariaDB source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: object
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param query_timeout: Query timeout. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type query_timeout: object
    :param query: A query to retrieve data from source. Type: string (or Expression with resultType
     string).
    :type query: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'query_timeout': {'key': 'queryTimeout', 'type': 'object'},
        'query': {'key': 'query', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureMariaDBSource, self).__init__(**kwargs)
        self.type = 'AzureMariaDBSource'  # type: str
        self.query = kwargs.get('query', None)


class AzureMariaDBTableDataset(Dataset):
    """Azure Database for MariaDB dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param table_name: The table name. Type: string (or Expression with resultType string).
    :type table_name: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table_name': {'key': 'typeProperties.tableName', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureMariaDBTableDataset, self).__init__(**kwargs)
        self.type = 'AzureMariaDBTable'  # type: str
        self.table_name = kwargs.get('table_name', None)


class AzureMLBatchExecutionActivity(ExecutionActivity):
    """Azure ML Batch Execution activity.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param name: Required. Activity name.
    :type name: str
    :param type: Required. Type of activity.Constant filled by server.
    :type type: str
    :param description: Activity description.
    :type description: str
    :param depends_on: Activity depends on condition.
    :type depends_on: list[~azure.synapse.artifacts.models.ActivityDependency]
    :param user_properties: Activity user properties.
    :type user_properties: list[~azure.synapse.artifacts.models.UserProperty]
    :param linked_service_name: Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param policy: Activity policy.
    :type policy: ~azure.synapse.artifacts.models.ActivityPolicy
    :param global_parameters: Key,Value pairs to be passed to the Azure ML Batch Execution Service
     endpoint. Keys must match the names of web service parameters defined in the published Azure ML
     web service. Values will be passed in the GlobalParameters property of the Azure ML batch
     execution request.
    :type global_parameters: dict[str, object]
    :param web_service_outputs: Key,Value pairs, mapping the names of Azure ML endpoint's Web
     Service Outputs to AzureMLWebServiceFile objects specifying the output Blob locations. This
     information will be passed in the WebServiceOutputs property of the Azure ML batch execution
     request.
    :type web_service_outputs: dict[str, ~azure.synapse.artifacts.models.AzureMLWebServiceFile]
    :param web_service_inputs: Key,Value pairs, mapping the names of Azure ML endpoint's Web
     Service Inputs to AzureMLWebServiceFile objects specifying the input Blob locations.. This
     information will be passed in the WebServiceInputs property of the Azure ML batch execution
     request.
    :type web_service_inputs: dict[str, ~azure.synapse.artifacts.models.AzureMLWebServiceFile]
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'depends_on': {'key': 'dependsOn', 'type': '[ActivityDependency]'},
        'user_properties': {'key': 'userProperties', 'type': '[UserProperty]'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'policy': {'key': 'policy', 'type': 'ActivityPolicy'},
        'global_parameters': {'key': 'typeProperties.globalParameters', 'type': '{object}'},
        'web_service_outputs': {'key': 'typeProperties.webServiceOutputs', 'type': '{AzureMLWebServiceFile}'},
        'web_service_inputs': {'key': 'typeProperties.webServiceInputs', 'type': '{AzureMLWebServiceFile}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureMLBatchExecutionActivity, self).__init__(**kwargs)
        self.type = 'AzureMLBatchExecution'  # type: str
        self.global_parameters = kwargs.get('global_parameters', None)
        self.web_service_outputs = kwargs.get('web_service_outputs', None)
        self.web_service_inputs = kwargs.get('web_service_inputs', None)


class AzureMLExecutePipelineActivity(ExecutionActivity):
    """Azure ML Execute Pipeline activity.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param name: Required. Activity name.
    :type name: str
    :param type: Required. Type of activity.Constant filled by server.
    :type type: str
    :param description: Activity description.
    :type description: str
    :param depends_on: Activity depends on condition.
    :type depends_on: list[~azure.synapse.artifacts.models.ActivityDependency]
    :param user_properties: Activity user properties.
    :type user_properties: list[~azure.synapse.artifacts.models.UserProperty]
    :param linked_service_name: Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param policy: Activity policy.
    :type policy: ~azure.synapse.artifacts.models.ActivityPolicy
    :param ml_pipeline_id: Required. ID of the published Azure ML pipeline. Type: string (or
     Expression with resultType string).
    :type ml_pipeline_id: object
    :param experiment_name: Run history experiment name of the pipeline run. This information will
     be passed in the ExperimentName property of the published pipeline execution request. Type:
     string (or Expression with resultType string).
    :type experiment_name: object
    :param ml_pipeline_parameters: Key,Value pairs to be passed to the published Azure ML pipeline
     endpoint. Keys must match the names of pipeline parameters defined in the published pipeline.
     Values will be passed in the ParameterAssignments property of the published pipeline execution
     request. Type: object with key value pairs (or Expression with resultType object).
    :type ml_pipeline_parameters: object
    :param ml_parent_run_id: The parent Azure ML Service pipeline run id. This information will be
     passed in the ParentRunId property of the published pipeline execution request. Type: string
     (or Expression with resultType string).
    :type ml_parent_run_id: object
    :param continue_on_step_failure: Whether to continue execution of other steps in the
     PipelineRun if a step fails. This information will be passed in the continueOnStepFailure
     property of the published pipeline execution request. Type: boolean (or Expression with
     resultType boolean).
    :type continue_on_step_failure: object
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
        'ml_pipeline_id': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'depends_on': {'key': 'dependsOn', 'type': '[ActivityDependency]'},
        'user_properties': {'key': 'userProperties', 'type': '[UserProperty]'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'policy': {'key': 'policy', 'type': 'ActivityPolicy'},
        'ml_pipeline_id': {'key': 'typeProperties.mlPipelineId', 'type': 'object'},
        'experiment_name': {'key': 'typeProperties.experimentName', 'type': 'object'},
        'ml_pipeline_parameters': {'key': 'typeProperties.mlPipelineParameters', 'type': 'object'},
        'ml_parent_run_id': {'key': 'typeProperties.mlParentRunId', 'type': 'object'},
        'continue_on_step_failure': {'key': 'typeProperties.continueOnStepFailure', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureMLExecutePipelineActivity, self).__init__(**kwargs)
        self.type = 'AzureMLExecutePipeline'  # type: str
        self.ml_pipeline_id = kwargs['ml_pipeline_id']
        self.experiment_name = kwargs.get('experiment_name', None)
        self.ml_pipeline_parameters = kwargs.get('ml_pipeline_parameters', None)
        self.ml_parent_run_id = kwargs.get('ml_parent_run_id', None)
        self.continue_on_step_failure = kwargs.get('continue_on_step_failure', None)


class AzureMLLinkedService(LinkedService):
    """Azure ML Studio Web Service linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param ml_endpoint: Required. The Batch Execution REST URL for an Azure ML Studio Web Service
     endpoint. Type: string (or Expression with resultType string).
    :type ml_endpoint: object
    :param api_key: Required. The API key for accessing the Azure ML model endpoint.
    :type api_key: ~azure.synapse.artifacts.models.SecretBase
    :param update_resource_endpoint: The Update Resource REST URL for an Azure ML Studio Web
     Service endpoint. Type: string (or Expression with resultType string).
    :type update_resource_endpoint: object
    :param service_principal_id: The ID of the service principal used to authenticate against the
     ARM-based updateResourceEndpoint of an Azure ML Studio web service. Type: string (or Expression
     with resultType string).
    :type service_principal_id: object
    :param service_principal_key: The key of the service principal used to authenticate against the
     ARM-based updateResourceEndpoint of an Azure ML Studio web service.
    :type service_principal_key: ~azure.synapse.artifacts.models.SecretBase
    :param tenant: The name or ID of the tenant to which the service principal belongs. Type:
     string (or Expression with resultType string).
    :type tenant: object
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'ml_endpoint': {'required': True},
        'api_key': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'ml_endpoint': {'key': 'typeProperties.mlEndpoint', 'type': 'object'},
        'api_key': {'key': 'typeProperties.apiKey', 'type': 'SecretBase'},
        'update_resource_endpoint': {'key': 'typeProperties.updateResourceEndpoint', 'type': 'object'},
        'service_principal_id': {'key': 'typeProperties.servicePrincipalId', 'type': 'object'},
        'service_principal_key': {'key': 'typeProperties.servicePrincipalKey', 'type': 'SecretBase'},
        'tenant': {'key': 'typeProperties.tenant', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureMLLinkedService, self).__init__(**kwargs)
        self.type = 'AzureML'  # type: str
        self.ml_endpoint = kwargs['ml_endpoint']
        self.api_key = kwargs['api_key']
        self.update_resource_endpoint = kwargs.get('update_resource_endpoint', None)
        self.service_principal_id = kwargs.get('service_principal_id', None)
        self.service_principal_key = kwargs.get('service_principal_key', None)
        self.tenant = kwargs.get('tenant', None)
        self.encrypted_credential = kwargs.get('encrypted_credential', None)


class AzureMLServiceLinkedService(LinkedService):
    """Azure ML Service linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param subscription_id: Required. Azure ML Service workspace subscription ID. Type: string (or
     Expression with resultType string).
    :type subscription_id: object
    :param resource_group_name: Required. Azure ML Service workspace resource group name. Type:
     string (or Expression with resultType string).
    :type resource_group_name: object
    :param ml_workspace_name: Required. Azure ML Service workspace name. Type: string (or
     Expression with resultType string).
    :type ml_workspace_name: object
    :param service_principal_id: The ID of the service principal used to authenticate against the
     endpoint of a published Azure ML Service pipeline. Type: string (or Expression with resultType
     string).
    :type service_principal_id: object
    :param service_principal_key: The key of the service principal used to authenticate against the
     endpoint of a published Azure ML Service pipeline.
    :type service_principal_key: ~azure.synapse.artifacts.models.SecretBase
    :param tenant: The name or ID of the tenant to which the service principal belongs. Type:
     string (or Expression with resultType string).
    :type tenant: object
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'subscription_id': {'required': True},
        'resource_group_name': {'required': True},
        'ml_workspace_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'subscription_id': {'key': 'typeProperties.subscriptionId', 'type': 'object'},
        'resource_group_name': {'key': 'typeProperties.resourceGroupName', 'type': 'object'},
        'ml_workspace_name': {'key': 'typeProperties.mlWorkspaceName', 'type': 'object'},
        'service_principal_id': {'key': 'typeProperties.servicePrincipalId', 'type': 'object'},
        'service_principal_key': {'key': 'typeProperties.servicePrincipalKey', 'type': 'SecretBase'},
        'tenant': {'key': 'typeProperties.tenant', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureMLServiceLinkedService, self).__init__(**kwargs)
        self.type = 'AzureMLService'  # type: str
        self.subscription_id = kwargs['subscription_id']
        self.resource_group_name = kwargs['resource_group_name']
        self.ml_workspace_name = kwargs['ml_workspace_name']
        self.service_principal_id = kwargs.get('service_principal_id', None)
        self.service_principal_key = kwargs.get('service_principal_key', None)
        self.tenant = kwargs.get('tenant', None)
        self.encrypted_credential = kwargs.get('encrypted_credential', None)


class AzureMLUpdateResourceActivity(ExecutionActivity):
    """Azure ML Update Resource management activity.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param name: Required. Activity name.
    :type name: str
    :param type: Required. Type of activity.Constant filled by server.
    :type type: str
    :param description: Activity description.
    :type description: str
    :param depends_on: Activity depends on condition.
    :type depends_on: list[~azure.synapse.artifacts.models.ActivityDependency]
    :param user_properties: Activity user properties.
    :type user_properties: list[~azure.synapse.artifacts.models.UserProperty]
    :param linked_service_name: Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param policy: Activity policy.
    :type policy: ~azure.synapse.artifacts.models.ActivityPolicy
    :param trained_model_name: Required. Name of the Trained Model module in the Web Service
     experiment to be updated. Type: string (or Expression with resultType string).
    :type trained_model_name: object
    :param trained_model_linked_service_name: Required. Name of Azure Storage linked service
     holding the .ilearner file that will be uploaded by the update operation.
    :type trained_model_linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param trained_model_file_path: Required. The relative file path in trainedModelLinkedService
     to represent the .ilearner file that will be uploaded by the update operation.  Type: string
     (or Expression with resultType string).
    :type trained_model_file_path: object
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
        'trained_model_name': {'required': True},
        'trained_model_linked_service_name': {'required': True},
        'trained_model_file_path': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'depends_on': {'key': 'dependsOn', 'type': '[ActivityDependency]'},
        'user_properties': {'key': 'userProperties', 'type': '[UserProperty]'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'policy': {'key': 'policy', 'type': 'ActivityPolicy'},
        'trained_model_name': {'key': 'typeProperties.trainedModelName', 'type': 'object'},
        'trained_model_linked_service_name': {'key': 'typeProperties.trainedModelLinkedServiceName', 'type': 'LinkedServiceReference'},
        'trained_model_file_path': {'key': 'typeProperties.trainedModelFilePath', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureMLUpdateResourceActivity, self).__init__(**kwargs)
        self.type = 'AzureMLUpdateResource'  # type: str
        self.trained_model_name = kwargs['trained_model_name']
        self.trained_model_linked_service_name = kwargs['trained_model_linked_service_name']
        self.trained_model_file_path = kwargs['trained_model_file_path']


class AzureMLWebServiceFile(msrest.serialization.Model):
    """Azure ML WebService Input/Output file.

    All required parameters must be populated in order to send to Azure.

    :param file_path: Required. The relative file path, including container name, in the Azure Blob
     Storage specified by the LinkedService. Type: string (or Expression with resultType string).
    :type file_path: object
    :param linked_service_name: Required. Reference to an Azure Storage LinkedService, where Azure
     ML WebService Input/Output file located.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    """

    _validation = {
        'file_path': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'file_path': {'key': 'filePath', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureMLWebServiceFile, self).__init__(**kwargs)
        self.file_path = kwargs['file_path']
        self.linked_service_name = kwargs['linked_service_name']


class AzureMySqlLinkedService(LinkedService):
    """Azure MySQL database linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param connection_string: Required. The connection string. Type: string, SecureString or
     AzureKeyVaultSecretReference.
    :type connection_string: object
    :param password: The Azure key vault secret reference of password in connection string.
    :type password: ~azure.synapse.artifacts.models.AzureKeyVaultSecretReference
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'connection_string': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'connection_string': {'key': 'typeProperties.connectionString', 'type': 'object'},
        'password': {'key': 'typeProperties.password', 'type': 'AzureKeyVaultSecretReference'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureMySqlLinkedService, self).__init__(**kwargs)
        self.type = 'AzureMySql'  # type: str
        self.connection_string = kwargs['connection_string']
        self.password = kwargs.get('password', None)
        self.encrypted_credential = kwargs.get('encrypted_credential', None)


class AzureMySqlSink(CopySink):
    """A copy activity Azure MySql sink.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy sink type.Constant filled by server.
    :type type: str
    :param write_batch_size: Write batch size. Type: integer (or Expression with resultType
     integer), minimum: 0.
    :type write_batch_size: object
    :param write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type write_batch_timeout: object
    :param sink_retry_count: Sink retry count. Type: integer (or Expression with resultType
     integer).
    :type sink_retry_count: object
    :param sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type sink_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the sink data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param pre_copy_script: A query to execute before starting the copy. Type: string (or
     Expression with resultType string).
    :type pre_copy_script: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'write_batch_size': {'key': 'writeBatchSize', 'type': 'object'},
        'write_batch_timeout': {'key': 'writeBatchTimeout', 'type': 'object'},
        'sink_retry_count': {'key': 'sinkRetryCount', 'type': 'object'},
        'sink_retry_wait': {'key': 'sinkRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'pre_copy_script': {'key': 'preCopyScript', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureMySqlSink, self).__init__(**kwargs)
        self.type = 'AzureMySqlSink'  # type: str
        self.pre_copy_script = kwargs.get('pre_copy_script', None)


class AzureMySqlSource(TabularSource):
    """A copy activity Azure MySQL source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: object
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param query_timeout: Query timeout. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type query_timeout: object
    :param query: Database query. Type: string (or Expression with resultType string).
    :type query: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'query_timeout': {'key': 'queryTimeout', 'type': 'object'},
        'query': {'key': 'query', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureMySqlSource, self).__init__(**kwargs)
        self.type = 'AzureMySqlSource'  # type: str
        self.query = kwargs.get('query', None)


class AzureMySqlTableDataset(Dataset):
    """The Azure MySQL database dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param table_name: The Azure MySQL database table name. Type: string (or Expression with
     resultType string).
    :type table_name: object
    :param table: The name of Azure MySQL database table. Type: string (or Expression with
     resultType string).
    :type table: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table_name': {'key': 'typeProperties.tableName', 'type': 'object'},
        'table': {'key': 'typeProperties.table', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureMySqlTableDataset, self).__init__(**kwargs)
        self.type = 'AzureMySqlTable'  # type: str
        self.table_name = kwargs.get('table_name', None)
        self.table = kwargs.get('table', None)


class AzurePostgreSqlLinkedService(LinkedService):
    """Azure PostgreSQL linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param connection_string: An ODBC connection string. Type: string, SecureString or
     AzureKeyVaultSecretReference.
    :type connection_string: object
    :param password: The Azure key vault secret reference of password in connection string.
    :type password: ~azure.synapse.artifacts.models.AzureKeyVaultSecretReference
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'connection_string': {'key': 'typeProperties.connectionString', 'type': 'object'},
        'password': {'key': 'typeProperties.password', 'type': 'AzureKeyVaultSecretReference'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzurePostgreSqlLinkedService, self).__init__(**kwargs)
        self.type = 'AzurePostgreSql'  # type: str
        self.connection_string = kwargs.get('connection_string', None)
        self.password = kwargs.get('password', None)
        self.encrypted_credential = kwargs.get('encrypted_credential', None)


class AzurePostgreSqlSink(CopySink):
    """A copy activity Azure PostgreSQL sink.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy sink type.Constant filled by server.
    :type type: str
    :param write_batch_size: Write batch size. Type: integer (or Expression with resultType
     integer), minimum: 0.
    :type write_batch_size: object
    :param write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type write_batch_timeout: object
    :param sink_retry_count: Sink retry count. Type: integer (or Expression with resultType
     integer).
    :type sink_retry_count: object
    :param sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type sink_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the sink data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param pre_copy_script: A query to execute before starting the copy. Type: string (or
     Expression with resultType string).
    :type pre_copy_script: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'write_batch_size': {'key': 'writeBatchSize', 'type': 'object'},
        'write_batch_timeout': {'key': 'writeBatchTimeout', 'type': 'object'},
        'sink_retry_count': {'key': 'sinkRetryCount', 'type': 'object'},
        'sink_retry_wait': {'key': 'sinkRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'pre_copy_script': {'key': 'preCopyScript', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzurePostgreSqlSink, self).__init__(**kwargs)
        self.type = 'AzurePostgreSqlSink'  # type: str
        self.pre_copy_script = kwargs.get('pre_copy_script', None)


class AzurePostgreSqlSource(TabularSource):
    """A copy activity Azure PostgreSQL source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: object
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param query_timeout: Query timeout. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type query_timeout: object
    :param query: A query to retrieve data from source. Type: string (or Expression with resultType
     string).
    :type query: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'query_timeout': {'key': 'queryTimeout', 'type': 'object'},
        'query': {'key': 'query', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzurePostgreSqlSource, self).__init__(**kwargs)
        self.type = 'AzurePostgreSqlSource'  # type: str
        self.query = kwargs.get('query', None)


class AzurePostgreSqlTableDataset(Dataset):
    """Azure PostgreSQL dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param table_name: The table name of the Azure PostgreSQL database which includes both schema
     and table. Type: string (or Expression with resultType string).
    :type table_name: object
    :param table: The table name of the Azure PostgreSQL database. Type: string (or Expression with
     resultType string).
    :type table: object
    :param schema_type_properties_schema: The schema name of the Azure PostgreSQL database. Type:
     string (or Expression with resultType string).
    :type schema_type_properties_schema: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table_name': {'key': 'typeProperties.tableName', 'type': 'object'},
        'table': {'key': 'typeProperties.table', 'type': 'object'},
        'schema_type_properties_schema': {'key': 'typeProperties.schema', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzurePostgreSqlTableDataset, self).__init__(**kwargs)
        self.type = 'AzurePostgreSqlTable'  # type: str
        self.table_name = kwargs.get('table_name', None)
        self.table = kwargs.get('table', None)
        self.schema_type_properties_schema = kwargs.get('schema_type_properties_schema', None)


class AzureQueueSink(CopySink):
    """A copy activity Azure Queue sink.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy sink type.Constant filled by server.
    :type type: str
    :param write_batch_size: Write batch size. Type: integer (or Expression with resultType
     integer), minimum: 0.
    :type write_batch_size: object
    :param write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type write_batch_timeout: object
    :param sink_retry_count: Sink retry count. Type: integer (or Expression with resultType
     integer).
    :type sink_retry_count: object
    :param sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type sink_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the sink data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'write_batch_size': {'key': 'writeBatchSize', 'type': 'object'},
        'write_batch_timeout': {'key': 'writeBatchTimeout', 'type': 'object'},
        'sink_retry_count': {'key': 'sinkRetryCount', 'type': 'object'},
        'sink_retry_wait': {'key': 'sinkRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureQueueSink, self).__init__(**kwargs)
        self.type = 'AzureQueueSink'  # type: str


class AzureSearchIndexDataset(Dataset):
    """The Azure Search Index.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param index_name: Required. The name of the Azure Search Index. Type: string (or Expression
     with resultType string).
    :type index_name: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
        'index_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'index_name': {'key': 'typeProperties.indexName', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureSearchIndexDataset, self).__init__(**kwargs)
        self.type = 'AzureSearchIndex'  # type: str
        self.index_name = kwargs['index_name']


class AzureSearchIndexSink(CopySink):
    """A copy activity Azure Search Index sink.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy sink type.Constant filled by server.
    :type type: str
    :param write_batch_size: Write batch size. Type: integer (or Expression with resultType
     integer), minimum: 0.
    :type write_batch_size: object
    :param write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type write_batch_timeout: object
    :param sink_retry_count: Sink retry count. Type: integer (or Expression with resultType
     integer).
    :type sink_retry_count: object
    :param sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type sink_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the sink data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param write_behavior: Specify the write behavior when upserting documents into Azure Search
     Index. Possible values include: "Merge", "Upload".
    :type write_behavior: str or ~azure.synapse.artifacts.models.AzureSearchIndexWriteBehaviorType
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'write_batch_size': {'key': 'writeBatchSize', 'type': 'object'},
        'write_batch_timeout': {'key': 'writeBatchTimeout', 'type': 'object'},
        'sink_retry_count': {'key': 'sinkRetryCount', 'type': 'object'},
        'sink_retry_wait': {'key': 'sinkRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'write_behavior': {'key': 'writeBehavior', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureSearchIndexSink, self).__init__(**kwargs)
        self.type = 'AzureSearchIndexSink'  # type: str
        self.write_behavior = kwargs.get('write_behavior', None)


class AzureSearchLinkedService(LinkedService):
    """Linked service for Windows Azure Search Service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param url: Required. URL for Azure Search service. Type: string (or Expression with resultType
     string).
    :type url: object
    :param key: Admin Key for Azure Search service.
    :type key: ~azure.synapse.artifacts.models.SecretBase
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'url': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'url': {'key': 'typeProperties.url', 'type': 'object'},
        'key': {'key': 'typeProperties.key', 'type': 'SecretBase'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureSearchLinkedService, self).__init__(**kwargs)
        self.type = 'AzureSearch'  # type: str
        self.url = kwargs['url']
        self.key = kwargs.get('key', None)
        self.encrypted_credential = kwargs.get('encrypted_credential', None)


class AzureSqlDatabaseLinkedService(LinkedService):
    """Microsoft Azure SQL Database linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param connection_string: Required. The connection string. Type: string, SecureString or
     AzureKeyVaultSecretReference.
    :type connection_string: object
    :param password: The Azure key vault secret reference of password in connection string.
    :type password: ~azure.synapse.artifacts.models.AzureKeyVaultSecretReference
    :param service_principal_id: The ID of the service principal used to authenticate against Azure
     SQL Database. Type: string (or Expression with resultType string).
    :type service_principal_id: object
    :param service_principal_key: The key of the service principal used to authenticate against
     Azure SQL Database.
    :type service_principal_key: ~azure.synapse.artifacts.models.SecretBase
    :param tenant: The name or ID of the tenant to which the service principal belongs. Type:
     string (or Expression with resultType string).
    :type tenant: object
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'connection_string': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'connection_string': {'key': 'typeProperties.connectionString', 'type': 'object'},
        'password': {'key': 'typeProperties.password', 'type': 'AzureKeyVaultSecretReference'},
        'service_principal_id': {'key': 'typeProperties.servicePrincipalId', 'type': 'object'},
        'service_principal_key': {'key': 'typeProperties.servicePrincipalKey', 'type': 'SecretBase'},
        'tenant': {'key': 'typeProperties.tenant', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureSqlDatabaseLinkedService, self).__init__(**kwargs)
        self.type = 'AzureSqlDatabase'  # type: str
        self.connection_string = kwargs['connection_string']
        self.password = kwargs.get('password', None)
        self.service_principal_id = kwargs.get('service_principal_id', None)
        self.service_principal_key = kwargs.get('service_principal_key', None)
        self.tenant = kwargs.get('tenant', None)
        self.encrypted_credential = kwargs.get('encrypted_credential', None)


class AzureSqlDWLinkedService(LinkedService):
    """Azure SQL Data Warehouse linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param connection_string: Required. The connection string. Type: string, SecureString or
     AzureKeyVaultSecretReference. Type: string, SecureString or AzureKeyVaultSecretReference.
    :type connection_string: object
    :param password: The Azure key vault secret reference of password in connection string.
    :type password: ~azure.synapse.artifacts.models.AzureKeyVaultSecretReference
    :param service_principal_id: The ID of the service principal used to authenticate against Azure
     SQL Data Warehouse. Type: string (or Expression with resultType string).
    :type service_principal_id: object
    :param service_principal_key: The key of the service principal used to authenticate against
     Azure SQL Data Warehouse.
    :type service_principal_key: ~azure.synapse.artifacts.models.SecretBase
    :param tenant: The name or ID of the tenant to which the service principal belongs. Type:
     string (or Expression with resultType string).
    :type tenant: object
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'connection_string': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'connection_string': {'key': 'typeProperties.connectionString', 'type': 'object'},
        'password': {'key': 'typeProperties.password', 'type': 'AzureKeyVaultSecretReference'},
        'service_principal_id': {'key': 'typeProperties.servicePrincipalId', 'type': 'object'},
        'service_principal_key': {'key': 'typeProperties.servicePrincipalKey', 'type': 'SecretBase'},
        'tenant': {'key': 'typeProperties.tenant', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureSqlDWLinkedService, self).__init__(**kwargs)
        self.type = 'AzureSqlDW'  # type: str
        self.connection_string = kwargs['connection_string']
        self.password = kwargs.get('password', None)
        self.service_principal_id = kwargs.get('service_principal_id', None)
        self.service_principal_key = kwargs.get('service_principal_key', None)
        self.tenant = kwargs.get('tenant', None)
        self.encrypted_credential = kwargs.get('encrypted_credential', None)


class AzureSqlDWTableDataset(Dataset):
    """The Azure SQL Data Warehouse dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param table_name: This property will be retired. Please consider using schema + table
     properties instead.
    :type table_name: object
    :param schema_type_properties_schema: The schema name of the Azure SQL Data Warehouse. Type:
     string (or Expression with resultType string).
    :type schema_type_properties_schema: object
    :param table: The table name of the Azure SQL Data Warehouse. Type: string (or Expression with
     resultType string).
    :type table: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table_name': {'key': 'typeProperties.tableName', 'type': 'object'},
        'schema_type_properties_schema': {'key': 'typeProperties.schema', 'type': 'object'},
        'table': {'key': 'typeProperties.table', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureSqlDWTableDataset, self).__init__(**kwargs)
        self.type = 'AzureSqlDWTable'  # type: str
        self.table_name = kwargs.get('table_name', None)
        self.schema_type_properties_schema = kwargs.get('schema_type_properties_schema', None)
        self.table = kwargs.get('table', None)


class AzureSqlMILinkedService(LinkedService):
    """Azure SQL Managed Instance linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param connection_string: Required. The connection string. Type: string, SecureString or
     AzureKeyVaultSecretReference.
    :type connection_string: object
    :param password: The Azure key vault secret reference of password in connection string.
    :type password: ~azure.synapse.artifacts.models.AzureKeyVaultSecretReference
    :param service_principal_id: The ID of the service principal used to authenticate against Azure
     SQL Managed Instance. Type: string (or Expression with resultType string).
    :type service_principal_id: object
    :param service_principal_key: The key of the service principal used to authenticate against
     Azure SQL Managed Instance.
    :type service_principal_key: ~azure.synapse.artifacts.models.SecretBase
    :param tenant: The name or ID of the tenant to which the service principal belongs. Type:
     string (or Expression with resultType string).
    :type tenant: object
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'connection_string': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'connection_string': {'key': 'typeProperties.connectionString', 'type': 'object'},
        'password': {'key': 'typeProperties.password', 'type': 'AzureKeyVaultSecretReference'},
        'service_principal_id': {'key': 'typeProperties.servicePrincipalId', 'type': 'object'},
        'service_principal_key': {'key': 'typeProperties.servicePrincipalKey', 'type': 'SecretBase'},
        'tenant': {'key': 'typeProperties.tenant', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureSqlMILinkedService, self).__init__(**kwargs)
        self.type = 'AzureSqlMI'  # type: str
        self.connection_string = kwargs['connection_string']
        self.password = kwargs.get('password', None)
        self.service_principal_id = kwargs.get('service_principal_id', None)
        self.service_principal_key = kwargs.get('service_principal_key', None)
        self.tenant = kwargs.get('tenant', None)
        self.encrypted_credential = kwargs.get('encrypted_credential', None)


class AzureSqlMITableDataset(Dataset):
    """The Azure SQL Managed Instance dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param table_name: This property will be retired. Please consider using schema + table
     properties instead.
    :type table_name: object
    :param schema_type_properties_schema: The schema name of the Azure SQL Managed Instance. Type:
     string (or Expression with resultType string).
    :type schema_type_properties_schema: object
    :param table: The table name of the Azure SQL Managed Instance dataset. Type: string (or
     Expression with resultType string).
    :type table: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table_name': {'key': 'typeProperties.tableName', 'type': 'object'},
        'schema_type_properties_schema': {'key': 'typeProperties.schema', 'type': 'object'},
        'table': {'key': 'typeProperties.table', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureSqlMITableDataset, self).__init__(**kwargs)
        self.type = 'AzureSqlMITable'  # type: str
        self.table_name = kwargs.get('table_name', None)
        self.schema_type_properties_schema = kwargs.get('schema_type_properties_schema', None)
        self.table = kwargs.get('table', None)


class AzureSqlSink(CopySink):
    """A copy activity Azure SQL sink.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy sink type.Constant filled by server.
    :type type: str
    :param write_batch_size: Write batch size. Type: integer (or Expression with resultType
     integer), minimum: 0.
    :type write_batch_size: object
    :param write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type write_batch_timeout: object
    :param sink_retry_count: Sink retry count. Type: integer (or Expression with resultType
     integer).
    :type sink_retry_count: object
    :param sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type sink_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the sink data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param sql_writer_stored_procedure_name: SQL writer stored procedure name. Type: string (or
     Expression with resultType string).
    :type sql_writer_stored_procedure_name: object
    :param sql_writer_table_type: SQL writer table type. Type: string (or Expression with
     resultType string).
    :type sql_writer_table_type: object
    :param pre_copy_script: SQL pre-copy script. Type: string (or Expression with resultType
     string).
    :type pre_copy_script: object
    :param stored_procedure_parameters: SQL stored procedure parameters.
    :type stored_procedure_parameters: dict[str,
     ~azure.synapse.artifacts.models.StoredProcedureParameter]
    :param stored_procedure_table_type_parameter_name: The stored procedure parameter name of the
     table type. Type: string (or Expression with resultType string).
    :type stored_procedure_table_type_parameter_name: object
    :param table_option: The option to handle sink table, such as autoCreate. For now only
     'autoCreate' value is supported. Type: string (or Expression with resultType string).
    :type table_option: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'write_batch_size': {'key': 'writeBatchSize', 'type': 'object'},
        'write_batch_timeout': {'key': 'writeBatchTimeout', 'type': 'object'},
        'sink_retry_count': {'key': 'sinkRetryCount', 'type': 'object'},
        'sink_retry_wait': {'key': 'sinkRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'sql_writer_stored_procedure_name': {'key': 'sqlWriterStoredProcedureName', 'type': 'object'},
        'sql_writer_table_type': {'key': 'sqlWriterTableType', 'type': 'object'},
        'pre_copy_script': {'key': 'preCopyScript', 'type': 'object'},
        'stored_procedure_parameters': {'key': 'storedProcedureParameters', 'type': '{StoredProcedureParameter}'},
        'stored_procedure_table_type_parameter_name': {'key': 'storedProcedureTableTypeParameterName', 'type': 'object'},
        'table_option': {'key': 'tableOption', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureSqlSink, self).__init__(**kwargs)
        self.type = 'AzureSqlSink'  # type: str
        self.sql_writer_stored_procedure_name = kwargs.get('sql_writer_stored_procedure_name', None)
        self.sql_writer_table_type = kwargs.get('sql_writer_table_type', None)
        self.pre_copy_script = kwargs.get('pre_copy_script', None)
        self.stored_procedure_parameters = kwargs.get('stored_procedure_parameters', None)
        self.stored_procedure_table_type_parameter_name = kwargs.get('stored_procedure_table_type_parameter_name', None)
        self.table_option = kwargs.get('table_option', None)


class AzureSqlSource(TabularSource):
    """A copy activity Azure SQL source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: object
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param query_timeout: Query timeout. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type query_timeout: object
    :param sql_reader_query: SQL reader query. Type: string (or Expression with resultType string).
    :type sql_reader_query: object
    :param sql_reader_stored_procedure_name: Name of the stored procedure for a SQL Database
     source. This cannot be used at the same time as SqlReaderQuery. Type: string (or Expression
     with resultType string).
    :type sql_reader_stored_procedure_name: object
    :param stored_procedure_parameters: Value and type setting for stored procedure parameters.
     Example: "{Parameter1: {value: "1", type: "int"}}".
    :type stored_procedure_parameters: dict[str,
     ~azure.synapse.artifacts.models.StoredProcedureParameter]
    :param produce_additional_types: Which additional types to produce.
    :type produce_additional_types: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'query_timeout': {'key': 'queryTimeout', 'type': 'object'},
        'sql_reader_query': {'key': 'sqlReaderQuery', 'type': 'object'},
        'sql_reader_stored_procedure_name': {'key': 'sqlReaderStoredProcedureName', 'type': 'object'},
        'stored_procedure_parameters': {'key': 'storedProcedureParameters', 'type': '{StoredProcedureParameter}'},
        'produce_additional_types': {'key': 'produceAdditionalTypes', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureSqlSource, self).__init__(**kwargs)
        self.type = 'AzureSqlSource'  # type: str
        self.sql_reader_query = kwargs.get('sql_reader_query', None)
        self.sql_reader_stored_procedure_name = kwargs.get('sql_reader_stored_procedure_name', None)
        self.stored_procedure_parameters = kwargs.get('stored_procedure_parameters', None)
        self.produce_additional_types = kwargs.get('produce_additional_types', None)


class AzureSqlTableDataset(Dataset):
    """The Azure SQL Server database dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param table_name: This property will be retired. Please consider using schema + table
     properties instead.
    :type table_name: object
    :param schema_type_properties_schema: The schema name of the Azure SQL database. Type: string
     (or Expression with resultType string).
    :type schema_type_properties_schema: object
    :param table: The table name of the Azure SQL database. Type: string (or Expression with
     resultType string).
    :type table: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table_name': {'key': 'typeProperties.tableName', 'type': 'object'},
        'schema_type_properties_schema': {'key': 'typeProperties.schema', 'type': 'object'},
        'table': {'key': 'typeProperties.table', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureSqlTableDataset, self).__init__(**kwargs)
        self.type = 'AzureSqlTable'  # type: str
        self.table_name = kwargs.get('table_name', None)
        self.schema_type_properties_schema = kwargs.get('schema_type_properties_schema', None)
        self.table = kwargs.get('table', None)


class AzureStorageLinkedService(LinkedService):
    """The storage account linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param connection_string: The connection string. It is mutually exclusive with sasUri property.
     Type: string, SecureString or AzureKeyVaultSecretReference.
    :type connection_string: object
    :param account_key: The Azure key vault secret reference of accountKey in connection string.
    :type account_key: ~azure.synapse.artifacts.models.AzureKeyVaultSecretReference
    :param sas_uri: SAS URI of the Azure Storage resource. It is mutually exclusive with
     connectionString property. Type: string, SecureString or AzureKeyVaultSecretReference.
    :type sas_uri: object
    :param sas_token: The Azure key vault secret reference of sasToken in sas uri.
    :type sas_token: ~azure.synapse.artifacts.models.AzureKeyVaultSecretReference
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: str
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'connection_string': {'key': 'typeProperties.connectionString', 'type': 'object'},
        'account_key': {'key': 'typeProperties.accountKey', 'type': 'AzureKeyVaultSecretReference'},
        'sas_uri': {'key': 'typeProperties.sasUri', 'type': 'object'},
        'sas_token': {'key': 'typeProperties.sasToken', 'type': 'AzureKeyVaultSecretReference'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureStorageLinkedService, self).__init__(**kwargs)
        self.type = 'AzureStorage'  # type: str
        self.connection_string = kwargs.get('connection_string', None)
        self.account_key = kwargs.get('account_key', None)
        self.sas_uri = kwargs.get('sas_uri', None)
        self.sas_token = kwargs.get('sas_token', None)
        self.encrypted_credential = kwargs.get('encrypted_credential', None)


class AzureTableDataset(Dataset):
    """The Azure Table storage dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param table_name: Required. The table name of the Azure Table storage. Type: string (or
     Expression with resultType string).
    :type table_name: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
        'table_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table_name': {'key': 'typeProperties.tableName', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureTableDataset, self).__init__(**kwargs)
        self.type = 'AzureTable'  # type: str
        self.table_name = kwargs['table_name']


class AzureTableSink(CopySink):
    """A copy activity Azure Table sink.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy sink type.Constant filled by server.
    :type type: str
    :param write_batch_size: Write batch size. Type: integer (or Expression with resultType
     integer), minimum: 0.
    :type write_batch_size: object
    :param write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type write_batch_timeout: object
    :param sink_retry_count: Sink retry count. Type: integer (or Expression with resultType
     integer).
    :type sink_retry_count: object
    :param sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type sink_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the sink data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param azure_table_default_partition_key_value: Azure Table default partition key value. Type:
     string (or Expression with resultType string).
    :type azure_table_default_partition_key_value: object
    :param azure_table_partition_key_name: Azure Table partition key name. Type: string (or
     Expression with resultType string).
    :type azure_table_partition_key_name: object
    :param azure_table_row_key_name: Azure Table row key name. Type: string (or Expression with
     resultType string).
    :type azure_table_row_key_name: object
    :param azure_table_insert_type: Azure Table insert type. Type: string (or Expression with
     resultType string).
    :type azure_table_insert_type: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'write_batch_size': {'key': 'writeBatchSize', 'type': 'object'},
        'write_batch_timeout': {'key': 'writeBatchTimeout', 'type': 'object'},
        'sink_retry_count': {'key': 'sinkRetryCount', 'type': 'object'},
        'sink_retry_wait': {'key': 'sinkRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'azure_table_default_partition_key_value': {'key': 'azureTableDefaultPartitionKeyValue', 'type': 'object'},
        'azure_table_partition_key_name': {'key': 'azureTablePartitionKeyName', 'type': 'object'},
        'azure_table_row_key_name': {'key': 'azureTableRowKeyName', 'type': 'object'},
        'azure_table_insert_type': {'key': 'azureTableInsertType', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureTableSink, self).__init__(**kwargs)
        self.type = 'AzureTableSink'  # type: str
        self.azure_table_default_partition_key_value = kwargs.get('azure_table_default_partition_key_value', None)
        self.azure_table_partition_key_name = kwargs.get('azure_table_partition_key_name', None)
        self.azure_table_row_key_name = kwargs.get('azure_table_row_key_name', None)
        self.azure_table_insert_type = kwargs.get('azure_table_insert_type', None)


class AzureTableSource(TabularSource):
    """A copy activity Azure Table source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: object
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param query_timeout: Query timeout. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type query_timeout: object
    :param azure_table_source_query: Azure Table source query. Type: string (or Expression with
     resultType string).
    :type azure_table_source_query: object
    :param azure_table_source_ignore_table_not_found: Azure Table source ignore table not found.
     Type: boolean (or Expression with resultType boolean).
    :type azure_table_source_ignore_table_not_found: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'query_timeout': {'key': 'queryTimeout', 'type': 'object'},
        'azure_table_source_query': {'key': 'azureTableSourceQuery', 'type': 'object'},
        'azure_table_source_ignore_table_not_found': {'key': 'azureTableSourceIgnoreTableNotFound', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureTableSource, self).__init__(**kwargs)
        self.type = 'AzureTableSource'  # type: str
        self.azure_table_source_query = kwargs.get('azure_table_source_query', None)
        self.azure_table_source_ignore_table_not_found = kwargs.get('azure_table_source_ignore_table_not_found', None)


class AzureTableStorageLinkedService(LinkedService):
    """The azure table storage linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param connection_string: The connection string. It is mutually exclusive with sasUri property.
     Type: string, SecureString or AzureKeyVaultSecretReference.
    :type connection_string: object
    :param account_key: The Azure key vault secret reference of accountKey in connection string.
    :type account_key: ~azure.synapse.artifacts.models.AzureKeyVaultSecretReference
    :param sas_uri: SAS URI of the Azure Storage resource. It is mutually exclusive with
     connectionString property. Type: string, SecureString or AzureKeyVaultSecretReference.
    :type sas_uri: object
    :param sas_token: The Azure key vault secret reference of sasToken in sas uri.
    :type sas_token: ~azure.synapse.artifacts.models.AzureKeyVaultSecretReference
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: str
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'connection_string': {'key': 'typeProperties.connectionString', 'type': 'object'},
        'account_key': {'key': 'typeProperties.accountKey', 'type': 'AzureKeyVaultSecretReference'},
        'sas_uri': {'key': 'typeProperties.sasUri', 'type': 'object'},
        'sas_token': {'key': 'typeProperties.sasToken', 'type': 'AzureKeyVaultSecretReference'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureTableStorageLinkedService, self).__init__(**kwargs)
        self.type = 'AzureTableStorage'  # type: str
        self.connection_string = kwargs.get('connection_string', None)
        self.account_key = kwargs.get('account_key', None)
        self.sas_uri = kwargs.get('sas_uri', None)
        self.sas_token = kwargs.get('sas_token', None)
        self.encrypted_credential = kwargs.get('encrypted_credential', None)


class BigDataPoolReference(msrest.serialization.Model):
    """Big data pool reference.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Big data pool reference type. Possible values include:
     "BigDataPoolReference".
    :type type: str or ~azure.synapse.artifacts.models.BigDataPoolReferenceType
    :param reference_name: Required. Reference big data pool name.
    :type reference_name: str
    """

    _validation = {
        'type': {'required': True},
        'reference_name': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'reference_name': {'key': 'referenceName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BigDataPoolReference, self).__init__(**kwargs)
        self.type = kwargs['type']
        self.reference_name = kwargs['reference_name']


class TrackedResource(Resource):
    """The resource model definition for a ARM tracked top level resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. Ex- Microsoft.Compute/virtualMachines or
     Microsoft.Storage/storageAccounts.
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param location: Required. The geo-location where the resource lives.
    :type location: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TrackedResource, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)
        self.location = kwargs['location']


class BigDataPoolResourceInfo(TrackedResource):
    """A Big Data pool.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. Ex- Microsoft.Compute/virtualMachines or
     Microsoft.Storage/storageAccounts.
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param location: Required. The geo-location where the resource lives.
    :type location: str
    :param provisioning_state: The state of the Big Data pool.
    :type provisioning_state: str
    :param auto_scale: Auto-scaling properties.
    :type auto_scale: ~azure.synapse.artifacts.models.AutoScaleProperties
    :param creation_date: The time when the Big Data pool was created.
    :type creation_date: ~datetime.datetime
    :param auto_pause: Auto-pausing properties.
    :type auto_pause: ~azure.synapse.artifacts.models.AutoPauseProperties
    :param is_compute_isolation_enabled: Whether compute isolation is required or not.
    :type is_compute_isolation_enabled: bool
    :param spark_events_folder: The Spark events folder.
    :type spark_events_folder: str
    :param node_count: The number of nodes in the Big Data pool.
    :type node_count: int
    :param library_requirements: Library version requirements.
    :type library_requirements: ~azure.synapse.artifacts.models.LibraryRequirements
    :param spark_version: The Apache Spark version.
    :type spark_version: str
    :param default_spark_log_folder: The default folder where Spark logs will be written.
    :type default_spark_log_folder: str
    :param node_size: The level of compute power that each node in the Big Data pool has. Possible
     values include: "None", "Small", "Medium", "Large", "XLarge", "XXLarge".
    :type node_size: str or ~azure.synapse.artifacts.models.NodeSize
    :param node_size_family: The kind of nodes that the Big Data pool provides. Possible values
     include: "None", "MemoryOptimized".
    :type node_size_family: str or ~azure.synapse.artifacts.models.NodeSizeFamily
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'auto_scale': {'key': 'properties.autoScale', 'type': 'AutoScaleProperties'},
        'creation_date': {'key': 'properties.creationDate', 'type': 'iso-8601'},
        'auto_pause': {'key': 'properties.autoPause', 'type': 'AutoPauseProperties'},
        'is_compute_isolation_enabled': {'key': 'properties.isComputeIsolationEnabled', 'type': 'bool'},
        'spark_events_folder': {'key': 'properties.sparkEventsFolder', 'type': 'str'},
        'node_count': {'key': 'properties.nodeCount', 'type': 'int'},
        'library_requirements': {'key': 'properties.libraryRequirements', 'type': 'LibraryRequirements'},
        'spark_version': {'key': 'properties.sparkVersion', 'type': 'str'},
        'default_spark_log_folder': {'key': 'properties.defaultSparkLogFolder', 'type': 'str'},
        'node_size': {'key': 'properties.nodeSize', 'type': 'str'},
        'node_size_family': {'key': 'properties.nodeSizeFamily', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BigDataPoolResourceInfo, self).__init__(**kwargs)
        self.provisioning_state = kwargs.get('provisioning_state', None)
        self.auto_scale = kwargs.get('auto_scale', None)
        self.creation_date = kwargs.get('creation_date', None)
        self.auto_pause = kwargs.get('auto_pause', None)
        self.is_compute_isolation_enabled = kwargs.get('is_compute_isolation_enabled', None)
        self.spark_events_folder = kwargs.get('spark_events_folder', None)
        self.node_count = kwargs.get('node_count', None)
        self.library_requirements = kwargs.get('library_requirements', None)
        self.spark_version = kwargs.get('spark_version', None)
        self.default_spark_log_folder = kwargs.get('default_spark_log_folder', None)
        self.node_size = kwargs.get('node_size', None)
        self.node_size_family = kwargs.get('node_size_family', None)


class BigDataPoolResourceInfoListResult(msrest.serialization.Model):
    """Collection of Big Data pool information.

    :param next_link: Link to the next page of results.
    :type next_link: str
    :param value: List of Big Data pools.
    :type value: list[~azure.synapse.artifacts.models.BigDataPoolResourceInfo]
    """

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[BigDataPoolResourceInfo]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BigDataPoolResourceInfoListResult, self).__init__(**kwargs)
        self.next_link = kwargs.get('next_link', None)
        self.value = kwargs.get('value', None)


class BinaryDataset(Dataset):
    """Binary dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param location: The location of the Binary storage.
    :type location: ~azure.synapse.artifacts.models.DatasetLocation
    :param compression: The data compression method used for the binary dataset.
    :type compression: ~azure.synapse.artifacts.models.DatasetCompression
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'location': {'key': 'typeProperties.location', 'type': 'DatasetLocation'},
        'compression': {'key': 'typeProperties.compression', 'type': 'DatasetCompression'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BinaryDataset, self).__init__(**kwargs)
        self.type = 'Binary'  # type: str
        self.location = kwargs.get('location', None)
        self.compression = kwargs.get('compression', None)


class BinarySink(CopySink):
    """A copy activity Binary sink.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy sink type.Constant filled by server.
    :type type: str
    :param write_batch_size: Write batch size. Type: integer (or Expression with resultType
     integer), minimum: 0.
    :type write_batch_size: object
    :param write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type write_batch_timeout: object
    :param sink_retry_count: Sink retry count. Type: integer (or Expression with resultType
     integer).
    :type sink_retry_count: object
    :param sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type sink_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the sink data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param store_settings: Binary store settings.
    :type store_settings: ~azure.synapse.artifacts.models.StoreWriteSettings
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'write_batch_size': {'key': 'writeBatchSize', 'type': 'object'},
        'write_batch_timeout': {'key': 'writeBatchTimeout', 'type': 'object'},
        'sink_retry_count': {'key': 'sinkRetryCount', 'type': 'object'},
        'sink_retry_wait': {'key': 'sinkRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'store_settings': {'key': 'storeSettings', 'type': 'StoreWriteSettings'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BinarySink, self).__init__(**kwargs)
        self.type = 'BinarySink'  # type: str
        self.store_settings = kwargs.get('store_settings', None)


class BinarySource(CopySource):
    """A copy activity Binary source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: object
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param store_settings: Binary store settings.
    :type store_settings: ~azure.synapse.artifacts.models.StoreReadSettings
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'store_settings': {'key': 'storeSettings', 'type': 'StoreReadSettings'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BinarySource, self).__init__(**kwargs)
        self.type = 'BinarySource'  # type: str
        self.store_settings = kwargs.get('store_settings', None)


class Trigger(msrest.serialization.Model):
    """Azure Synapse nested object which contains information about creating pipeline run.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: ChainingTrigger, MultiplePipelineTrigger, RerunTumblingWindowTrigger, TumblingWindowTrigger.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Trigger type.Constant filled by server.
    :type type: str
    :param description: Trigger description.
    :type description: str
    :ivar runtime_state: Indicates if trigger is running or not. Updated when Start/Stop APIs are
     called on the Trigger. Possible values include: "Started", "Stopped", "Disabled".
    :vartype runtime_state: str or ~azure.synapse.artifacts.models.TriggerRuntimeState
    :param annotations: List of tags that can be used for describing the trigger.
    :type annotations: list[object]
    """

    _validation = {
        'type': {'required': True},
        'runtime_state': {'readonly': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'runtime_state': {'key': 'runtimeState', 'type': 'str'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
    }

    _subtype_map = {
        'type': {'ChainingTrigger': 'ChainingTrigger', 'MultiplePipelineTrigger': 'MultiplePipelineTrigger', 'RerunTumblingWindowTrigger': 'RerunTumblingWindowTrigger', 'TumblingWindowTrigger': 'TumblingWindowTrigger'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Trigger, self).__init__(**kwargs)
        self.additional_properties = kwargs.get('additional_properties', None)
        self.type = 'Trigger'  # type: str
        self.description = kwargs.get('description', None)
        self.runtime_state = None
        self.annotations = kwargs.get('annotations', None)


class MultiplePipelineTrigger(Trigger):
    """Base class for all triggers that support one to many model for trigger to pipeline.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: BlobEventsTrigger, BlobTrigger, ScheduleTrigger.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Trigger type.Constant filled by server.
    :type type: str
    :param description: Trigger description.
    :type description: str
    :ivar runtime_state: Indicates if trigger is running or not. Updated when Start/Stop APIs are
     called on the Trigger. Possible values include: "Started", "Stopped", "Disabled".
    :vartype runtime_state: str or ~azure.synapse.artifacts.models.TriggerRuntimeState
    :param annotations: List of tags that can be used for describing the trigger.
    :type annotations: list[object]
    :param pipelines: Pipelines that need to be started.
    :type pipelines: list[~azure.synapse.artifacts.models.TriggerPipelineReference]
    """

    _validation = {
        'type': {'required': True},
        'runtime_state': {'readonly': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'runtime_state': {'key': 'runtimeState', 'type': 'str'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'pipelines': {'key': 'pipelines', 'type': '[TriggerPipelineReference]'},
    }

    _subtype_map = {
        'type': {'BlobEventsTrigger': 'BlobEventsTrigger', 'BlobTrigger': 'BlobTrigger', 'ScheduleTrigger': 'ScheduleTrigger'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MultiplePipelineTrigger, self).__init__(**kwargs)
        self.type = 'MultiplePipelineTrigger'  # type: str
        self.pipelines = kwargs.get('pipelines', None)


class BlobEventsTrigger(MultiplePipelineTrigger):
    """Trigger that runs every time a Blob event occurs.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Trigger type.Constant filled by server.
    :type type: str
    :param description: Trigger description.
    :type description: str
    :ivar runtime_state: Indicates if trigger is running or not. Updated when Start/Stop APIs are
     called on the Trigger. Possible values include: "Started", "Stopped", "Disabled".
    :vartype runtime_state: str or ~azure.synapse.artifacts.models.TriggerRuntimeState
    :param annotations: List of tags that can be used for describing the trigger.
    :type annotations: list[object]
    :param pipelines: Pipelines that need to be started.
    :type pipelines: list[~azure.synapse.artifacts.models.TriggerPipelineReference]
    :param blob_path_begins_with: The blob path must begin with the pattern provided for trigger to
     fire. For example, '/records/blobs/december/' will only fire the trigger for blobs in the
     december folder under the records container. At least one of these must be provided:
     blobPathBeginsWith, blobPathEndsWith.
    :type blob_path_begins_with: str
    :param blob_path_ends_with: The blob path must end with the pattern provided for trigger to
     fire. For example, 'december/boxes.csv' will only fire the trigger for blobs named boxes in a
     december folder. At least one of these must be provided: blobPathBeginsWith, blobPathEndsWith.
    :type blob_path_ends_with: str
    :param ignore_empty_blobs: If set to true, blobs with zero bytes will be ignored.
    :type ignore_empty_blobs: bool
    :param events: Required. The type of events that cause this trigger to fire.
    :type events: list[str or ~azure.synapse.artifacts.models.BlobEventTypes]
    :param scope: Required. The ARM resource ID of the Storage Account.
    :type scope: str
    """

    _validation = {
        'type': {'required': True},
        'runtime_state': {'readonly': True},
        'events': {'required': True},
        'scope': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'runtime_state': {'key': 'runtimeState', 'type': 'str'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'pipelines': {'key': 'pipelines', 'type': '[TriggerPipelineReference]'},
        'blob_path_begins_with': {'key': 'typeProperties.blobPathBeginsWith', 'type': 'str'},
        'blob_path_ends_with': {'key': 'typeProperties.blobPathEndsWith', 'type': 'str'},
        'ignore_empty_blobs': {'key': 'typeProperties.ignoreEmptyBlobs', 'type': 'bool'},
        'events': {'key': 'typeProperties.events', 'type': '[str]'},
        'scope': {'key': 'typeProperties.scope', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BlobEventsTrigger, self).__init__(**kwargs)
        self.type = 'BlobEventsTrigger'  # type: str
        self.blob_path_begins_with = kwargs.get('blob_path_begins_with', None)
        self.blob_path_ends_with = kwargs.get('blob_path_ends_with', None)
        self.ignore_empty_blobs = kwargs.get('ignore_empty_blobs', None)
        self.events = kwargs['events']
        self.scope = kwargs['scope']


class BlobSink(CopySink):
    """A copy activity Azure Blob sink.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy sink type.Constant filled by server.
    :type type: str
    :param write_batch_size: Write batch size. Type: integer (or Expression with resultType
     integer), minimum: 0.
    :type write_batch_size: object
    :param write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type write_batch_timeout: object
    :param sink_retry_count: Sink retry count. Type: integer (or Expression with resultType
     integer).
    :type sink_retry_count: object
    :param sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type sink_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the sink data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param blob_writer_overwrite_files: Blob writer overwrite files. Type: boolean (or Expression
     with resultType boolean).
    :type blob_writer_overwrite_files: object
    :param blob_writer_date_time_format: Blob writer date time format. Type: string (or Expression
     with resultType string).
    :type blob_writer_date_time_format: object
    :param blob_writer_add_header: Blob writer add header. Type: boolean (or Expression with
     resultType boolean).
    :type blob_writer_add_header: object
    :param copy_behavior: The type of copy behavior for copy sink.
    :type copy_behavior: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'write_batch_size': {'key': 'writeBatchSize', 'type': 'object'},
        'write_batch_timeout': {'key': 'writeBatchTimeout', 'type': 'object'},
        'sink_retry_count': {'key': 'sinkRetryCount', 'type': 'object'},
        'sink_retry_wait': {'key': 'sinkRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'blob_writer_overwrite_files': {'key': 'blobWriterOverwriteFiles', 'type': 'object'},
        'blob_writer_date_time_format': {'key': 'blobWriterDateTimeFormat', 'type': 'object'},
        'blob_writer_add_header': {'key': 'blobWriterAddHeader', 'type': 'object'},
        'copy_behavior': {'key': 'copyBehavior', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BlobSink, self).__init__(**kwargs)
        self.type = 'BlobSink'  # type: str
        self.blob_writer_overwrite_files = kwargs.get('blob_writer_overwrite_files', None)
        self.blob_writer_date_time_format = kwargs.get('blob_writer_date_time_format', None)
        self.blob_writer_add_header = kwargs.get('blob_writer_add_header', None)
        self.copy_behavior = kwargs.get('copy_behavior', None)


class BlobSource(CopySource):
    """A copy activity Azure Blob source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: object
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param treat_empty_as_null: Treat empty as null. Type: boolean (or Expression with resultType
     boolean).
    :type treat_empty_as_null: object
    :param skip_header_line_count: Number of header lines to skip from each blob. Type: integer (or
     Expression with resultType integer).
    :type skip_header_line_count: object
    :param recursive: If true, files under the folder path will be read recursively. Default is
     true. Type: boolean (or Expression with resultType boolean).
    :type recursive: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'treat_empty_as_null': {'key': 'treatEmptyAsNull', 'type': 'object'},
        'skip_header_line_count': {'key': 'skipHeaderLineCount', 'type': 'object'},
        'recursive': {'key': 'recursive', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BlobSource, self).__init__(**kwargs)
        self.type = 'BlobSource'  # type: str
        self.treat_empty_as_null = kwargs.get('treat_empty_as_null', None)
        self.skip_header_line_count = kwargs.get('skip_header_line_count', None)
        self.recursive = kwargs.get('recursive', None)


class BlobTrigger(MultiplePipelineTrigger):
    """Trigger that runs every time the selected Blob container changes.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Trigger type.Constant filled by server.
    :type type: str
    :param description: Trigger description.
    :type description: str
    :ivar runtime_state: Indicates if trigger is running or not. Updated when Start/Stop APIs are
     called on the Trigger. Possible values include: "Started", "Stopped", "Disabled".
    :vartype runtime_state: str or ~azure.synapse.artifacts.models.TriggerRuntimeState
    :param annotations: List of tags that can be used for describing the trigger.
    :type annotations: list[object]
    :param pipelines: Pipelines that need to be started.
    :type pipelines: list[~azure.synapse.artifacts.models.TriggerPipelineReference]
    :param folder_path: Required. The path of the container/folder that will trigger the pipeline.
    :type folder_path: str
    :param max_concurrency: Required. The max number of parallel files to handle when it is
     triggered.
    :type max_concurrency: int
    :param linked_service: Required. The Azure Storage linked service reference.
    :type linked_service: ~azure.synapse.artifacts.models.LinkedServiceReference
    """

    _validation = {
        'type': {'required': True},
        'runtime_state': {'readonly': True},
        'folder_path': {'required': True},
        'max_concurrency': {'required': True},
        'linked_service': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'runtime_state': {'key': 'runtimeState', 'type': 'str'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'pipelines': {'key': 'pipelines', 'type': '[TriggerPipelineReference]'},
        'folder_path': {'key': 'typeProperties.folderPath', 'type': 'str'},
        'max_concurrency': {'key': 'typeProperties.maxConcurrency', 'type': 'int'},
        'linked_service': {'key': 'typeProperties.linkedService', 'type': 'LinkedServiceReference'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BlobTrigger, self).__init__(**kwargs)
        self.type = 'BlobTrigger'  # type: str
        self.folder_path = kwargs['folder_path']
        self.max_concurrency = kwargs['max_concurrency']
        self.linked_service = kwargs['linked_service']


class CassandraLinkedService(LinkedService):
    """Linked service for Cassandra data source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param host: Required. Host name for connection. Type: string (or Expression with resultType
     string).
    :type host: object
    :param authentication_type: AuthenticationType to be used for connection. Type: string (or
     Expression with resultType string).
    :type authentication_type: object
    :param port: The port for the connection. Type: integer (or Expression with resultType
     integer).
    :type port: object
    :param username: Username for authentication. Type: string (or Expression with resultType
     string).
    :type username: object
    :param password: Password for authentication.
    :type password: ~azure.synapse.artifacts.models.SecretBase
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'host': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'host': {'key': 'typeProperties.host', 'type': 'object'},
        'authentication_type': {'key': 'typeProperties.authenticationType', 'type': 'object'},
        'port': {'key': 'typeProperties.port', 'type': 'object'},
        'username': {'key': 'typeProperties.username', 'type': 'object'},
        'password': {'key': 'typeProperties.password', 'type': 'SecretBase'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CassandraLinkedService, self).__init__(**kwargs)
        self.type = 'Cassandra'  # type: str
        self.host = kwargs['host']
        self.authentication_type = kwargs.get('authentication_type', None)
        self.port = kwargs.get('port', None)
        self.username = kwargs.get('username', None)
        self.password = kwargs.get('password', None)
        self.encrypted_credential = kwargs.get('encrypted_credential', None)


class CassandraSource(TabularSource):
    """A copy activity source for a Cassandra database.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: object
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param query_timeout: Query timeout. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type query_timeout: object
    :param query: Database query. Should be a SQL-92 query expression or Cassandra Query Language
     (CQL) command. Type: string (or Expression with resultType string).
    :type query: object
    :param consistency_level: The consistency level specifies how many Cassandra servers must
     respond to a read request before returning data to the client application. Cassandra checks the
     specified number of Cassandra servers for data to satisfy the read request. Must be one of
     cassandraSourceReadConsistencyLevels. The default value is 'ONE'. It is case-insensitive.
     Possible values include: "ALL", "EACH_QUORUM", "QUORUM", "LOCAL_QUORUM", "ONE", "TWO", "THREE",
     "LOCAL_ONE", "SERIAL", "LOCAL_SERIAL".
    :type consistency_level: str or
     ~azure.synapse.artifacts.models.CassandraSourceReadConsistencyLevels
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'query_timeout': {'key': 'queryTimeout', 'type': 'object'},
        'query': {'key': 'query', 'type': 'object'},
        'consistency_level': {'key': 'consistencyLevel', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CassandraSource, self).__init__(**kwargs)
        self.type = 'CassandraSource'  # type: str
        self.query = kwargs.get('query', None)
        self.consistency_level = kwargs.get('consistency_level', None)


class CassandraTableDataset(Dataset):
    """The Cassandra database dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param table_name: The table name of the Cassandra database. Type: string (or Expression with
     resultType string).
    :type table_name: object
    :param keyspace: The keyspace of the Cassandra database. Type: string (or Expression with
     resultType string).
    :type keyspace: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table_name': {'key': 'typeProperties.tableName', 'type': 'object'},
        'keyspace': {'key': 'typeProperties.keyspace', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CassandraTableDataset, self).__init__(**kwargs)
        self.type = 'CassandraTable'  # type: str
        self.table_name = kwargs.get('table_name', None)
        self.keyspace = kwargs.get('keyspace', None)


class ChainingTrigger(Trigger):
    """Trigger that allows the referenced pipeline to depend on other pipeline runs based on runDimension Name/Value pairs. Upstream pipelines should declare the same runDimension Name and their runs should have the values for those runDimensions. The referenced pipeline run would be triggered if the values for the runDimension match for all upstream pipeline runs.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Trigger type.Constant filled by server.
    :type type: str
    :param description: Trigger description.
    :type description: str
    :ivar runtime_state: Indicates if trigger is running or not. Updated when Start/Stop APIs are
     called on the Trigger. Possible values include: "Started", "Stopped", "Disabled".
    :vartype runtime_state: str or ~azure.synapse.artifacts.models.TriggerRuntimeState
    :param annotations: List of tags that can be used for describing the trigger.
    :type annotations: list[object]
    :param pipeline: Required. Pipeline for which runs are created when all upstream pipelines
     complete successfully.
    :type pipeline: ~azure.synapse.artifacts.models.TriggerPipelineReference
    :param depends_on: Required. Upstream Pipelines.
    :type depends_on: list[~azure.synapse.artifacts.models.PipelineReference]
    :param run_dimension: Required. Run Dimension property that needs to be emitted by upstream
     pipelines.
    :type run_dimension: str
    """

    _validation = {
        'type': {'required': True},
        'runtime_state': {'readonly': True},
        'pipeline': {'required': True},
        'depends_on': {'required': True},
        'run_dimension': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'runtime_state': {'key': 'runtimeState', 'type': 'str'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'pipeline': {'key': 'pipeline', 'type': 'TriggerPipelineReference'},
        'depends_on': {'key': 'typeProperties.dependsOn', 'type': '[PipelineReference]'},
        'run_dimension': {'key': 'typeProperties.runDimension', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ChainingTrigger, self).__init__(**kwargs)
        self.type = 'ChainingTrigger'  # type: str
        self.pipeline = kwargs['pipeline']
        self.depends_on = kwargs['depends_on']
        self.run_dimension = kwargs['run_dimension']


class CloudError(msrest.serialization.Model):
    """The object that defines the structure of an Azure Synapse error response.

    All required parameters must be populated in order to send to Azure.

    :param code: Required. Error code.
    :type code: str
    :param message: Required. Error message.
    :type message: str
    :param target: Property name/path in request associated with error.
    :type target: str
    :param details: Array with additional error details.
    :type details: list[~azure.synapse.artifacts.models.CloudError]
    """

    _validation = {
        'code': {'required': True},
        'message': {'required': True},
    }

    _attribute_map = {
        'code': {'key': 'error.code', 'type': 'str'},
        'message': {'key': 'error.message', 'type': 'str'},
        'target': {'key': 'error.target', 'type': 'str'},
        'details': {'key': 'error.details', 'type': '[CloudError]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CloudError, self).__init__(**kwargs)
        self.code = kwargs['code']
        self.message = kwargs['message']
        self.target = kwargs.get('target', None)
        self.details = kwargs.get('details', None)


class CommonDataServiceForAppsEntityDataset(Dataset):
    """The Common Data Service for Apps entity dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param entity_name: The logical name of the entity. Type: string (or Expression with resultType
     string).
    :type entity_name: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'entity_name': {'key': 'typeProperties.entityName', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CommonDataServiceForAppsEntityDataset, self).__init__(**kwargs)
        self.type = 'CommonDataServiceForAppsEntity'  # type: str
        self.entity_name = kwargs.get('entity_name', None)


class CommonDataServiceForAppsLinkedService(LinkedService):
    """Common Data Service for Apps linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param deployment_type: Required. The deployment type of the Common Data Service for Apps
     instance. 'Online' for Common Data Service for Apps Online and 'OnPremisesWithIfd' for Common
     Data Service for Apps on-premises with Ifd. Type: string (or Expression with resultType
     string). Possible values include: "Online", "OnPremisesWithIfd".
    :type deployment_type: str or ~azure.synapse.artifacts.models.DynamicsDeploymentType
    :param host_name: The host name of the on-premises Common Data Service for Apps server. The
     property is required for on-prem and not allowed for online. Type: string (or Expression with
     resultType string).
    :type host_name: object
    :param port: The port of on-premises Common Data Service for Apps server. The property is
     required for on-prem and not allowed for online. Default is 443. Type: integer (or Expression
     with resultType integer), minimum: 0.
    :type port: object
    :param service_uri: The URL to the Microsoft Common Data Service for Apps server. The property
     is required for on-line and not allowed for on-prem. Type: string (or Expression with
     resultType string).
    :type service_uri: object
    :param organization_name: The organization name of the Common Data Service for Apps instance.
     The property is required for on-prem and required for online when there are more than one
     Common Data Service for Apps instances associated with the user. Type: string (or Expression
     with resultType string).
    :type organization_name: object
    :param authentication_type: Required. The authentication type to connect to Common Data Service
     for Apps server. 'Office365' for online scenario, 'Ifd' for on-premises with Ifd scenario.
     'AADServicePrincipal' for Server-To-Server authentication in online scenario. Type: string (or
     Expression with resultType string). Possible values include: "Office365", "Ifd",
     "AADServicePrincipal".
    :type authentication_type: str or ~azure.synapse.artifacts.models.DynamicsAuthenticationType
    :param username: User name to access the Common Data Service for Apps instance. Type: string
     (or Expression with resultType string).
    :type username: object
    :param password: Password to access the Common Data Service for Apps instance.
    :type password: ~azure.synapse.artifacts.models.SecretBase
    :param service_principal_id: The client ID of the application in Azure Active Directory used
     for Server-To-Server authentication. Type: string (or Expression with resultType string).
    :type service_principal_id: object
    :param service_principal_credential_type: The service principal credential type to use in
     Server-To-Server authentication. 'ServicePrincipalKey' for key/secret, 'ServicePrincipalCert'
     for certificate. Type: string (or Expression with resultType string). Possible values include:
     "ServicePrincipalKey", "ServicePrincipalCert".
    :type service_principal_credential_type: str or
     ~azure.synapse.artifacts.models.DynamicsServicePrincipalCredentialType
    :param service_principal_credential: The credential of the service principal object in Azure
     Active Directory. If servicePrincipalCredentialType is 'ServicePrincipalKey',
     servicePrincipalCredential can be SecureString or AzureKeyVaultSecretReference. If
     servicePrincipalCredentialType is 'ServicePrincipalCert', servicePrincipalCredential can only
     be AzureKeyVaultSecretReference.
    :type service_principal_credential: ~azure.synapse.artifacts.models.SecretBase
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'deployment_type': {'required': True},
        'authentication_type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'deployment_type': {'key': 'typeProperties.deploymentType', 'type': 'str'},
        'host_name': {'key': 'typeProperties.hostName', 'type': 'object'},
        'port': {'key': 'typeProperties.port', 'type': 'object'},
        'service_uri': {'key': 'typeProperties.serviceUri', 'type': 'object'},
        'organization_name': {'key': 'typeProperties.organizationName', 'type': 'object'},
        'authentication_type': {'key': 'typeProperties.authenticationType', 'type': 'str'},
        'username': {'key': 'typeProperties.username', 'type': 'object'},
        'password': {'key': 'typeProperties.password', 'type': 'SecretBase'},
        'service_principal_id': {'key': 'typeProperties.servicePrincipalId', 'type': 'object'},
        'service_principal_credential_type': {'key': 'typeProperties.servicePrincipalCredentialType', 'type': 'str'},
        'service_principal_credential': {'key': 'typeProperties.servicePrincipalCredential', 'type': 'SecretBase'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CommonDataServiceForAppsLinkedService, self).__init__(**kwargs)
        self.type = 'CommonDataServiceForApps'  # type: str
        self.deployment_type = kwargs['deployment_type']
        self.host_name = kwargs.get('host_name', None)
        self.port = kwargs.get('port', None)
        self.service_uri = kwargs.get('service_uri', None)
        self.organization_name = kwargs.get('organization_name', None)
        self.authentication_type = kwargs['authentication_type']
        self.username = kwargs.get('username', None)
        self.password = kwargs.get('password', None)
        self.service_principal_id = kwargs.get('service_principal_id', None)
        self.service_principal_credential_type = kwargs.get('service_principal_credential_type', None)
        self.service_principal_credential = kwargs.get('service_principal_credential', None)
        self.encrypted_credential = kwargs.get('encrypted_credential', None)


class CommonDataServiceForAppsSink(CopySink):
    """A copy activity Common Data Service for Apps sink.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy sink type.Constant filled by server.
    :type type: str
    :param write_batch_size: Write batch size. Type: integer (or Expression with resultType
     integer), minimum: 0.
    :type write_batch_size: object
    :param write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type write_batch_timeout: object
    :param sink_retry_count: Sink retry count. Type: integer (or Expression with resultType
     integer).
    :type sink_retry_count: object
    :param sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type sink_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the sink data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param write_behavior: Required. The write behavior for the operation. Possible values include:
     "Upsert".
    :type write_behavior: str or ~azure.synapse.artifacts.models.DynamicsSinkWriteBehavior
    :param ignore_null_values: The flag indicating whether to ignore null values from input dataset
     (except key fields) during write operation. Default is false. Type: boolean (or Expression with
     resultType boolean).
    :type ignore_null_values: object
    :param alternate_key_name: The logical name of the alternate key which will be used when
     upserting records. Type: string (or Expression with resultType string).
    :type alternate_key_name: object
    """

    _validation = {
        'type': {'required': True},
        'write_behavior': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'write_batch_size': {'key': 'writeBatchSize', 'type': 'object'},
        'write_batch_timeout': {'key': 'writeBatchTimeout', 'type': 'object'},
        'sink_retry_count': {'key': 'sinkRetryCount', 'type': 'object'},
        'sink_retry_wait': {'key': 'sinkRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'write_behavior': {'key': 'writeBehavior', 'type': 'str'},
        'ignore_null_values': {'key': 'ignoreNullValues', 'type': 'object'},
        'alternate_key_name': {'key': 'alternateKeyName', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CommonDataServiceForAppsSink, self).__init__(**kwargs)
        self.type = 'CommonDataServiceForAppsSink'  # type: str
        self.write_behavior = kwargs['write_behavior']
        self.ignore_null_values = kwargs.get('ignore_null_values', None)
        self.alternate_key_name = kwargs.get('alternate_key_name', None)


class CommonDataServiceForAppsSource(CopySource):
    """A copy activity Common Data Service for Apps source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: object
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param query: FetchXML is a proprietary query language that is used in Microsoft Common Data
     Service for Apps (online & on-premises). Type: string (or Expression with resultType string).
    :type query: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'query': {'key': 'query', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CommonDataServiceForAppsSource, self).__init__(**kwargs)
        self.type = 'CommonDataServiceForAppsSource'  # type: str
        self.query = kwargs.get('query', None)


class ConcurLinkedService(LinkedService):
    """Concur Service linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param client_id: Required. Application client_id supplied by Concur App Management.
    :type client_id: object
    :param username: Required. The user name that you use to access Concur Service.
    :type username: object
    :param password: The password corresponding to the user name that you provided in the username
     field.
    :type password: ~azure.synapse.artifacts.models.SecretBase
    :param use_encrypted_endpoints: Specifies whether the data source endpoints are encrypted using
     HTTPS. The default value is true.
    :type use_encrypted_endpoints: object
    :param use_host_verification: Specifies whether to require the host name in the server's
     certificate to match the host name of the server when connecting over SSL. The default value is
     true.
    :type use_host_verification: object
    :param use_peer_verification: Specifies whether to verify the identity of the server when
     connecting over SSL. The default value is true.
    :type use_peer_verification: object
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'client_id': {'required': True},
        'username': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'client_id': {'key': 'typeProperties.clientId', 'type': 'object'},
        'username': {'key': 'typeProperties.username', 'type': 'object'},
        'password': {'key': 'typeProperties.password', 'type': 'SecretBase'},
        'use_encrypted_endpoints': {'key': 'typeProperties.useEncryptedEndpoints', 'type': 'object'},
        'use_host_verification': {'key': 'typeProperties.useHostVerification', 'type': 'object'},
        'use_peer_verification': {'key': 'typeProperties.usePeerVerification', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ConcurLinkedService, self).__init__(**kwargs)
        self.type = 'Concur'  # type: str
        self.client_id = kwargs['client_id']
        self.username = kwargs['username']
        self.password = kwargs.get('password', None)
        self.use_encrypted_endpoints = kwargs.get('use_encrypted_endpoints', None)
        self.use_host_verification = kwargs.get('use_host_verification', None)
        self.use_peer_verification = kwargs.get('use_peer_verification', None)
        self.encrypted_credential = kwargs.get('encrypted_credential', None)


class ConcurObjectDataset(Dataset):
    """Concur Service dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param table_name: The table name. Type: string (or Expression with resultType string).
    :type table_name: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table_name': {'key': 'typeProperties.tableName', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ConcurObjectDataset, self).__init__(**kwargs)
        self.type = 'ConcurObject'  # type: str
        self.table_name = kwargs.get('table_name', None)


class ConcurSource(TabularSource):
    """A copy activity Concur Service source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: object
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param query_timeout: Query timeout. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type query_timeout: object
    :param query: A query to retrieve data from source. Type: string (or Expression with resultType
     string).
    :type query: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'query_timeout': {'key': 'queryTimeout', 'type': 'object'},
        'query': {'key': 'query', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ConcurSource, self).__init__(**kwargs)
        self.type = 'ConcurSource'  # type: str
        self.query = kwargs.get('query', None)


class ControlActivity(Activity):
    """Base class for all control activities like IfCondition, ForEach , Until.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param name: Required. Activity name.
    :type name: str
    :param type: Required. Type of activity.Constant filled by server.
    :type type: str
    :param description: Activity description.
    :type description: str
    :param depends_on: Activity depends on condition.
    :type depends_on: list[~azure.synapse.artifacts.models.ActivityDependency]
    :param user_properties: Activity user properties.
    :type user_properties: list[~azure.synapse.artifacts.models.UserProperty]
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'depends_on': {'key': 'dependsOn', 'type': '[ActivityDependency]'},
        'user_properties': {'key': 'userProperties', 'type': '[UserProperty]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ControlActivity, self).__init__(**kwargs)
        self.type = 'Container'  # type: str


class CopyActivity(ExecutionActivity):
    """Copy activity.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param name: Required. Activity name.
    :type name: str
    :param type: Required. Type of activity.Constant filled by server.
    :type type: str
    :param description: Activity description.
    :type description: str
    :param depends_on: Activity depends on condition.
    :type depends_on: list[~azure.synapse.artifacts.models.ActivityDependency]
    :param user_properties: Activity user properties.
    :type user_properties: list[~azure.synapse.artifacts.models.UserProperty]
    :param linked_service_name: Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param policy: Activity policy.
    :type policy: ~azure.synapse.artifacts.models.ActivityPolicy
    :param inputs: List of inputs for the activity.
    :type inputs: list[~azure.synapse.artifacts.models.DatasetReference]
    :param outputs: List of outputs for the activity.
    :type outputs: list[~azure.synapse.artifacts.models.DatasetReference]
    :param source: Required. Copy activity source.
    :type source: ~azure.synapse.artifacts.models.CopySource
    :param sink: Required. Copy activity sink.
    :type sink: ~azure.synapse.artifacts.models.CopySink
    :param translator: Copy activity translator. If not specified, tabular translator is used.
    :type translator: object
    :param enable_staging: Specifies whether to copy data via an interim staging. Default value is
     false. Type: boolean (or Expression with resultType boolean).
    :type enable_staging: object
    :param staging_settings: Specifies interim staging settings when EnableStaging is true.
    :type staging_settings: ~azure.synapse.artifacts.models.StagingSettings
    :param parallel_copies: Maximum number of concurrent sessions opened on the source or sink to
     avoid overloading the data store. Type: integer (or Expression with resultType integer),
     minimum: 0.
    :type parallel_copies: object
    :param data_integration_units: Maximum number of data integration units that can be used to
     perform this data movement. Type: integer (or Expression with resultType integer), minimum: 0.
    :type data_integration_units: object
    :param enable_skip_incompatible_row: Whether to skip incompatible row. Default value is false.
     Type: boolean (or Expression with resultType boolean).
    :type enable_skip_incompatible_row: object
    :param redirect_incompatible_row_settings: Redirect incompatible row settings when
     EnableSkipIncompatibleRow is true.
    :type redirect_incompatible_row_settings:
     ~azure.synapse.artifacts.models.RedirectIncompatibleRowSettings
    :param preserve_rules: Preserve Rules.
    :type preserve_rules: list[object]
    :param preserve: Preserve rules.
    :type preserve: list[object]
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
        'source': {'required': True},
        'sink': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'depends_on': {'key': 'dependsOn', 'type': '[ActivityDependency]'},
        'user_properties': {'key': 'userProperties', 'type': '[UserProperty]'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'policy': {'key': 'policy', 'type': 'ActivityPolicy'},
        'inputs': {'key': 'inputs', 'type': '[DatasetReference]'},
        'outputs': {'key': 'outputs', 'type': '[DatasetReference]'},
        'source': {'key': 'typeProperties.source', 'type': 'CopySource'},
        'sink': {'key': 'typeProperties.sink', 'type': 'CopySink'},
        'translator': {'key': 'typeProperties.translator', 'type': 'object'},
        'enable_staging': {'key': 'typeProperties.enableStaging', 'type': 'object'},
        'staging_settings': {'key': 'typeProperties.stagingSettings', 'type': 'StagingSettings'},
        'parallel_copies': {'key': 'typeProperties.parallelCopies', 'type': 'object'},
        'data_integration_units': {'key': 'typeProperties.dataIntegrationUnits', 'type': 'object'},
        'enable_skip_incompatible_row': {'key': 'typeProperties.enableSkipIncompatibleRow', 'type': 'object'},
        'redirect_incompatible_row_settings': {'key': 'typeProperties.redirectIncompatibleRowSettings', 'type': 'RedirectIncompatibleRowSettings'},
        'preserve_rules': {'key': 'typeProperties.preserveRules', 'type': '[object]'},
        'preserve': {'key': 'typeProperties.preserve', 'type': '[object]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CopyActivity, self).__init__(**kwargs)
        self.type = 'Copy'  # type: str
        self.inputs = kwargs.get('inputs', None)
        self.outputs = kwargs.get('outputs', None)
        self.source = kwargs['source']
        self.sink = kwargs['sink']
        self.translator = kwargs.get('translator', None)
        self.enable_staging = kwargs.get('enable_staging', None)
        self.staging_settings = kwargs.get('staging_settings', None)
        self.parallel_copies = kwargs.get('parallel_copies', None)
        self.data_integration_units = kwargs.get('data_integration_units', None)
        self.enable_skip_incompatible_row = kwargs.get('enable_skip_incompatible_row', None)
        self.redirect_incompatible_row_settings = kwargs.get('redirect_incompatible_row_settings', None)
        self.preserve_rules = kwargs.get('preserve_rules', None)
        self.preserve = kwargs.get('preserve', None)


class CopyTranslator(msrest.serialization.Model):
    """A copy activity translator.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: TabularTranslator.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy translator type.Constant filled by server.
    :type type: str
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
    }

    _subtype_map = {
        'type': {'TabularTranslator': 'TabularTranslator'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CopyTranslator, self).__init__(**kwargs)
        self.additional_properties = kwargs.get('additional_properties', None)
        self.type = 'CopyTranslator'  # type: str


class CosmosDbLinkedService(LinkedService):
    """Microsoft Azure Cosmos Database (CosmosDB) linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param connection_string: The connection string. Type: string, SecureString or
     AzureKeyVaultSecretReference.
    :type connection_string: object
    :param account_endpoint: The endpoint of the Azure CosmosDB account. Type: string (or
     Expression with resultType string).
    :type account_endpoint: object
    :param database: The name of the database. Type: string (or Expression with resultType string).
    :type database: object
    :param account_key: The account key of the Azure CosmosDB account. Type: SecureString or
     AzureKeyVaultSecretReference.
    :type account_key: ~azure.synapse.artifacts.models.SecretBase
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'connection_string': {'key': 'typeProperties.connectionString', 'type': 'object'},
        'account_endpoint': {'key': 'typeProperties.accountEndpoint', 'type': 'object'},
        'database': {'key': 'typeProperties.database', 'type': 'object'},
        'account_key': {'key': 'typeProperties.accountKey', 'type': 'SecretBase'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CosmosDbLinkedService, self).__init__(**kwargs)
        self.type = 'CosmosDb'  # type: str
        self.connection_string = kwargs.get('connection_string', None)
        self.account_endpoint = kwargs.get('account_endpoint', None)
        self.database = kwargs.get('database', None)
        self.account_key = kwargs.get('account_key', None)
        self.encrypted_credential = kwargs.get('encrypted_credential', None)


class CosmosDbMongoDbApiCollectionDataset(Dataset):
    """The CosmosDB (MongoDB API) database dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param collection: Required. The collection name of the CosmosDB (MongoDB API) database. Type:
     string (or Expression with resultType string).
    :type collection: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
        'collection': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'collection': {'key': 'typeProperties.collection', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CosmosDbMongoDbApiCollectionDataset, self).__init__(**kwargs)
        self.type = 'CosmosDbMongoDbApiCollection'  # type: str
        self.collection = kwargs['collection']


class CosmosDbMongoDbApiLinkedService(LinkedService):
    """Linked service for CosmosDB (MongoDB API) data source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param connection_string: Required. The CosmosDB (MongoDB API) connection string. Type: string,
     SecureString or AzureKeyVaultSecretReference. Type: string, SecureString or
     AzureKeyVaultSecretReference.
    :type connection_string: object
    :param database: Required. The name of the CosmosDB (MongoDB API) database that you want to
     access. Type: string (or Expression with resultType string).
    :type database: object
    """

    _validation = {
        'type': {'required': True},
        'connection_string': {'required': True},
        'database': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'connection_string': {'key': 'typeProperties.connectionString', 'type': 'object'},
        'database': {'key': 'typeProperties.database', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CosmosDbMongoDbApiLinkedService, self).__init__(**kwargs)
        self.type = 'CosmosDbMongoDbApi'  # type: str
        self.connection_string = kwargs['connection_string']
        self.database = kwargs['database']


class CosmosDbMongoDbApiSink(CopySink):
    """A copy activity sink for a CosmosDB (MongoDB API) database.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy sink type.Constant filled by server.
    :type type: str
    :param write_batch_size: Write batch size. Type: integer (or Expression with resultType
     integer), minimum: 0.
    :type write_batch_size: object
    :param write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type write_batch_timeout: object
    :param sink_retry_count: Sink retry count. Type: integer (or Expression with resultType
     integer).
    :type sink_retry_count: object
    :param sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type sink_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the sink data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param write_behavior: Specifies whether the document with same key to be overwritten (upsert)
     rather than throw exception (insert). The default value is "insert". Type: string (or
     Expression with resultType string). Type: string (or Expression with resultType string).
    :type write_behavior: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'write_batch_size': {'key': 'writeBatchSize', 'type': 'object'},
        'write_batch_timeout': {'key': 'writeBatchTimeout', 'type': 'object'},
        'sink_retry_count': {'key': 'sinkRetryCount', 'type': 'object'},
        'sink_retry_wait': {'key': 'sinkRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'write_behavior': {'key': 'writeBehavior', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CosmosDbMongoDbApiSink, self).__init__(**kwargs)
        self.type = 'CosmosDbMongoDbApiSink'  # type: str
        self.write_behavior = kwargs.get('write_behavior', None)


class CosmosDbMongoDbApiSource(CopySource):
    """A copy activity source for a CosmosDB (MongoDB API) database.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: object
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param filter: Specifies selection filter using query operators. To return all documents in a
     collection, omit this parameter or pass an empty document ({}). Type: string (or Expression
     with resultType string).
    :type filter: object
    :param cursor_methods: Cursor methods for Mongodb query.
    :type cursor_methods: ~azure.synapse.artifacts.models.MongoDbCursorMethodsProperties
    :param batch_size: Specifies the number of documents to return in each batch of the response
     from MongoDB instance. In most cases, modifying the batch size will not affect the user or the
     application. This property's main purpose is to avoid hit the limitation of response size.
     Type: integer (or Expression with resultType integer).
    :type batch_size: object
    :param query_timeout: Query timeout. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type query_timeout: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'filter': {'key': 'filter', 'type': 'object'},
        'cursor_methods': {'key': 'cursorMethods', 'type': 'MongoDbCursorMethodsProperties'},
        'batch_size': {'key': 'batchSize', 'type': 'object'},
        'query_timeout': {'key': 'queryTimeout', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CosmosDbMongoDbApiSource, self).__init__(**kwargs)
        self.type = 'CosmosDbMongoDbApiSource'  # type: str
        self.filter = kwargs.get('filter', None)
        self.cursor_methods = kwargs.get('cursor_methods', None)
        self.batch_size = kwargs.get('batch_size', None)
        self.query_timeout = kwargs.get('query_timeout', None)


class CosmosDbSqlApiCollectionDataset(Dataset):
    """Microsoft Azure CosmosDB (SQL API) Collection dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param collection_name: Required. CosmosDB (SQL API) collection name. Type: string (or
     Expression with resultType string).
    :type collection_name: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
        'collection_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'collection_name': {'key': 'typeProperties.collectionName', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CosmosDbSqlApiCollectionDataset, self).__init__(**kwargs)
        self.type = 'CosmosDbSqlApiCollection'  # type: str
        self.collection_name = kwargs['collection_name']


class CosmosDbSqlApiSink(CopySink):
    """A copy activity Azure CosmosDB (SQL API) Collection sink.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy sink type.Constant filled by server.
    :type type: str
    :param write_batch_size: Write batch size. Type: integer (or Expression with resultType
     integer), minimum: 0.
    :type write_batch_size: object
    :param write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type write_batch_timeout: object
    :param sink_retry_count: Sink retry count. Type: integer (or Expression with resultType
     integer).
    :type sink_retry_count: object
    :param sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type sink_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the sink data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param write_behavior: Describes how to write data to Azure Cosmos DB. Type: string (or
     Expression with resultType string). Allowed values: insert and upsert.
    :type write_behavior: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'write_batch_size': {'key': 'writeBatchSize', 'type': 'object'},
        'write_batch_timeout': {'key': 'writeBatchTimeout', 'type': 'object'},
        'sink_retry_count': {'key': 'sinkRetryCount', 'type': 'object'},
        'sink_retry_wait': {'key': 'sinkRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'write_behavior': {'key': 'writeBehavior', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CosmosDbSqlApiSink, self).__init__(**kwargs)
        self.type = 'CosmosDbSqlApiSink'  # type: str
        self.write_behavior = kwargs.get('write_behavior', None)


class CosmosDbSqlApiSource(CopySource):
    """A copy activity Azure CosmosDB (SQL API) Collection source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: object
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param query: SQL API query. Type: string (or Expression with resultType string).
    :type query: object
    :param page_size: Page size of the result. Type: integer (or Expression with resultType
     integer).
    :type page_size: object
    :param preferred_regions: Preferred regions. Type: array of strings (or Expression with
     resultType array of strings).
    :type preferred_regions: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'query': {'key': 'query', 'type': 'object'},
        'page_size': {'key': 'pageSize', 'type': 'object'},
        'preferred_regions': {'key': 'preferredRegions', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CosmosDbSqlApiSource, self).__init__(**kwargs)
        self.type = 'CosmosDbSqlApiSource'  # type: str
        self.query = kwargs.get('query', None)
        self.page_size = kwargs.get('page_size', None)
        self.preferred_regions = kwargs.get('preferred_regions', None)


class CouchbaseLinkedService(LinkedService):
    """Couchbase server linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param connection_string: An ODBC connection string. Type: string, SecureString or
     AzureKeyVaultSecretReference.
    :type connection_string: object
    :param cred_string: The Azure key vault secret reference of credString in connection string.
    :type cred_string: ~azure.synapse.artifacts.models.AzureKeyVaultSecretReference
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'connection_string': {'key': 'typeProperties.connectionString', 'type': 'object'},
        'cred_string': {'key': 'typeProperties.credString', 'type': 'AzureKeyVaultSecretReference'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CouchbaseLinkedService, self).__init__(**kwargs)
        self.type = 'Couchbase'  # type: str
        self.connection_string = kwargs.get('connection_string', None)
        self.cred_string = kwargs.get('cred_string', None)
        self.encrypted_credential = kwargs.get('encrypted_credential', None)


class CouchbaseSource(TabularSource):
    """A copy activity Couchbase server source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: object
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param query_timeout: Query timeout. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type query_timeout: object
    :param query: A query to retrieve data from source. Type: string (or Expression with resultType
     string).
    :type query: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'query_timeout': {'key': 'queryTimeout', 'type': 'object'},
        'query': {'key': 'query', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CouchbaseSource, self).__init__(**kwargs)
        self.type = 'CouchbaseSource'  # type: str
        self.query = kwargs.get('query', None)


class CouchbaseTableDataset(Dataset):
    """Couchbase server dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param table_name: The table name. Type: string (or Expression with resultType string).
    :type table_name: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table_name': {'key': 'typeProperties.tableName', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CouchbaseTableDataset, self).__init__(**kwargs)
        self.type = 'CouchbaseTable'  # type: str
        self.table_name = kwargs.get('table_name', None)


class CreateDataFlowDebugSessionRequest(msrest.serialization.Model):
    """Request body structure for creating data flow debug session.

    :param data_flow_name: The name of the data flow.
    :type data_flow_name: str
    :param existing_cluster_id: The ID of existing Databricks cluster.
    :type existing_cluster_id: str
    :param cluster_timeout: Timeout setting for Databricks cluster.
    :type cluster_timeout: int
    :param new_cluster_name: The name of new Databricks cluster.
    :type new_cluster_name: str
    :param new_cluster_node_type: The type of new Databricks cluster.
    :type new_cluster_node_type: str
    :param data_bricks_linked_service: Data bricks linked service.
    :type data_bricks_linked_service: ~azure.synapse.artifacts.models.LinkedServiceResource
    """

    _attribute_map = {
        'data_flow_name': {'key': 'dataFlowName', 'type': 'str'},
        'existing_cluster_id': {'key': 'existingClusterId', 'type': 'str'},
        'cluster_timeout': {'key': 'clusterTimeout', 'type': 'int'},
        'new_cluster_name': {'key': 'newClusterName', 'type': 'str'},
        'new_cluster_node_type': {'key': 'newClusterNodeType', 'type': 'str'},
        'data_bricks_linked_service': {'key': 'dataBricksLinkedService', 'type': 'LinkedServiceResource'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CreateDataFlowDebugSessionRequest, self).__init__(**kwargs)
        self.data_flow_name = kwargs.get('data_flow_name', None)
        self.existing_cluster_id = kwargs.get('existing_cluster_id', None)
        self.cluster_timeout = kwargs.get('cluster_timeout', None)
        self.new_cluster_name = kwargs.get('new_cluster_name', None)
        self.new_cluster_node_type = kwargs.get('new_cluster_node_type', None)
        self.data_bricks_linked_service = kwargs.get('data_bricks_linked_service', None)


class CreateDataFlowDebugSessionResponse(msrest.serialization.Model):
    """Response body structure for creating data flow debug session.

    :param session_id: The ID of data flow debug session.
    :type session_id: str
    """

    _attribute_map = {
        'session_id': {'key': 'sessionId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CreateDataFlowDebugSessionResponse, self).__init__(**kwargs)
        self.session_id = kwargs.get('session_id', None)


class CreateRunResponse(msrest.serialization.Model):
    """Response body with a run identifier.

    All required parameters must be populated in order to send to Azure.

    :param run_id: Required. Identifier of a run.
    :type run_id: str
    """

    _validation = {
        'run_id': {'required': True},
    }

    _attribute_map = {
        'run_id': {'key': 'runId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CreateRunResponse, self).__init__(**kwargs)
        self.run_id = kwargs['run_id']


class CustomActivity(ExecutionActivity):
    """Custom activity type.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param name: Required. Activity name.
    :type name: str
    :param type: Required. Type of activity.Constant filled by server.
    :type type: str
    :param description: Activity description.
    :type description: str
    :param depends_on: Activity depends on condition.
    :type depends_on: list[~azure.synapse.artifacts.models.ActivityDependency]
    :param user_properties: Activity user properties.
    :type user_properties: list[~azure.synapse.artifacts.models.UserProperty]
    :param linked_service_name: Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param policy: Activity policy.
    :type policy: ~azure.synapse.artifacts.models.ActivityPolicy
    :param command: Required. Command for custom activity Type: string (or Expression with
     resultType string).
    :type command: object
    :param resource_linked_service: Resource linked service reference.
    :type resource_linked_service: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param folder_path: Folder path for resource files Type: string (or Expression with resultType
     string).
    :type folder_path: object
    :param reference_objects: Reference objects.
    :type reference_objects: ~azure.synapse.artifacts.models.CustomActivityReferenceObject
    :param extended_properties: User defined property bag. There is no restriction on the keys or
     values that can be used. The user specified custom activity has the full responsibility to
     consume and interpret the content defined.
    :type extended_properties: dict[str, object]
    :param retention_time_in_days: The retention time for the files submitted for custom activity.
     Type: double (or Expression with resultType double).
    :type retention_time_in_days: object
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
        'command': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'depends_on': {'key': 'dependsOn', 'type': '[ActivityDependency]'},
        'user_properties': {'key': 'userProperties', 'type': '[UserProperty]'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'policy': {'key': 'policy', 'type': 'ActivityPolicy'},
        'command': {'key': 'typeProperties.command', 'type': 'object'},
        'resource_linked_service': {'key': 'typeProperties.resourceLinkedService', 'type': 'LinkedServiceReference'},
        'folder_path': {'key': 'typeProperties.folderPath', 'type': 'object'},
        'reference_objects': {'key': 'typeProperties.referenceObjects', 'type': 'CustomActivityReferenceObject'},
        'extended_properties': {'key': 'typeProperties.extendedProperties', 'type': '{object}'},
        'retention_time_in_days': {'key': 'typeProperties.retentionTimeInDays', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CustomActivity, self).__init__(**kwargs)
        self.type = 'Custom'  # type: str
        self.command = kwargs['command']
        self.resource_linked_service = kwargs.get('resource_linked_service', None)
        self.folder_path = kwargs.get('folder_path', None)
        self.reference_objects = kwargs.get('reference_objects', None)
        self.extended_properties = kwargs.get('extended_properties', None)
        self.retention_time_in_days = kwargs.get('retention_time_in_days', None)


class CustomActivityReferenceObject(msrest.serialization.Model):
    """Reference objects for custom activity.

    :param linked_services: Linked service references.
    :type linked_services: list[~azure.synapse.artifacts.models.LinkedServiceReference]
    :param datasets: Dataset references.
    :type datasets: list[~azure.synapse.artifacts.models.DatasetReference]
    """

    _attribute_map = {
        'linked_services': {'key': 'linkedServices', 'type': '[LinkedServiceReference]'},
        'datasets': {'key': 'datasets', 'type': '[DatasetReference]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CustomActivityReferenceObject, self).__init__(**kwargs)
        self.linked_services = kwargs.get('linked_services', None)
        self.datasets = kwargs.get('datasets', None)


class CustomDataset(Dataset):
    """The custom dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param type_properties: Custom dataset properties.
    :type type_properties: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'type_properties': {'key': 'typeProperties', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CustomDataset, self).__init__(**kwargs)
        self.type = 'CustomDataset'  # type: str
        self.type_properties = kwargs.get('type_properties', None)


class CustomDataSourceLinkedService(LinkedService):
    """Custom linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param type_properties: Required. Custom linked service properties.
    :type type_properties: object
    """

    _validation = {
        'type': {'required': True},
        'type_properties': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'type_properties': {'key': 'typeProperties', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CustomDataSourceLinkedService, self).__init__(**kwargs)
        self.type = 'CustomDataSource'  # type: str
        self.type_properties = kwargs['type_properties']


class CustomSetupBase(msrest.serialization.Model):
    """The base definition of the custom setup.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: .

    All required parameters must be populated in order to send to Azure.

    :param type: Required. The type of custom setup.Constant filled by server.
    :type type: str
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
    }

    _subtype_map = {
        'type': {}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CustomSetupBase, self).__init__(**kwargs)
        self.type = None  # type: Optional[str]


class DatabricksNotebookActivity(ExecutionActivity):
    """DatabricksNotebook activity.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param name: Required. Activity name.
    :type name: str
    :param type: Required. Type of activity.Constant filled by server.
    :type type: str
    :param description: Activity description.
    :type description: str
    :param depends_on: Activity depends on condition.
    :type depends_on: list[~azure.synapse.artifacts.models.ActivityDependency]
    :param user_properties: Activity user properties.
    :type user_properties: list[~azure.synapse.artifacts.models.UserProperty]
    :param linked_service_name: Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param policy: Activity policy.
    :type policy: ~azure.synapse.artifacts.models.ActivityPolicy
    :param notebook_path: Required. The absolute path of the notebook to be run in the Databricks
     Workspace. This path must begin with a slash. Type: string (or Expression with resultType
     string).
    :type notebook_path: object
    :param base_parameters: Base parameters to be used for each run of this job.If the notebook
     takes a parameter that is not specified, the default value from the notebook will be used.
    :type base_parameters: dict[str, object]
    :param libraries: A list of libraries to be installed on the cluster that will execute the job.
    :type libraries: list[dict[str, object]]
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
        'notebook_path': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'depends_on': {'key': 'dependsOn', 'type': '[ActivityDependency]'},
        'user_properties': {'key': 'userProperties', 'type': '[UserProperty]'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'policy': {'key': 'policy', 'type': 'ActivityPolicy'},
        'notebook_path': {'key': 'typeProperties.notebookPath', 'type': 'object'},
        'base_parameters': {'key': 'typeProperties.baseParameters', 'type': '{object}'},
        'libraries': {'key': 'typeProperties.libraries', 'type': '[{object}]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DatabricksNotebookActivity, self).__init__(**kwargs)
        self.type = 'DatabricksNotebook'  # type: str
        self.notebook_path = kwargs['notebook_path']
        self.base_parameters = kwargs.get('base_parameters', None)
        self.libraries = kwargs.get('libraries', None)


class DatabricksSparkJarActivity(ExecutionActivity):
    """DatabricksSparkJar activity.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param name: Required. Activity name.
    :type name: str
    :param type: Required. Type of activity.Constant filled by server.
    :type type: str
    :param description: Activity description.
    :type description: str
    :param depends_on: Activity depends on condition.
    :type depends_on: list[~azure.synapse.artifacts.models.ActivityDependency]
    :param user_properties: Activity user properties.
    :type user_properties: list[~azure.synapse.artifacts.models.UserProperty]
    :param linked_service_name: Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param policy: Activity policy.
    :type policy: ~azure.synapse.artifacts.models.ActivityPolicy
    :param main_class_name: Required. The full name of the class containing the main method to be
     executed. This class must be contained in a JAR provided as a library. Type: string (or
     Expression with resultType string).
    :type main_class_name: object
    :param parameters: Parameters that will be passed to the main method.
    :type parameters: list[object]
    :param libraries: A list of libraries to be installed on the cluster that will execute the job.
    :type libraries: list[dict[str, object]]
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
        'main_class_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'depends_on': {'key': 'dependsOn', 'type': '[ActivityDependency]'},
        'user_properties': {'key': 'userProperties', 'type': '[UserProperty]'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'policy': {'key': 'policy', 'type': 'ActivityPolicy'},
        'main_class_name': {'key': 'typeProperties.mainClassName', 'type': 'object'},
        'parameters': {'key': 'typeProperties.parameters', 'type': '[object]'},
        'libraries': {'key': 'typeProperties.libraries', 'type': '[{object}]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DatabricksSparkJarActivity, self).__init__(**kwargs)
        self.type = 'DatabricksSparkJar'  # type: str
        self.main_class_name = kwargs['main_class_name']
        self.parameters = kwargs.get('parameters', None)
        self.libraries = kwargs.get('libraries', None)


class DatabricksSparkPythonActivity(ExecutionActivity):
    """DatabricksSparkPython activity.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param name: Required. Activity name.
    :type name: str
    :param type: Required. Type of activity.Constant filled by server.
    :type type: str
    :param description: Activity description.
    :type description: str
    :param depends_on: Activity depends on condition.
    :type depends_on: list[~azure.synapse.artifacts.models.ActivityDependency]
    :param user_properties: Activity user properties.
    :type user_properties: list[~azure.synapse.artifacts.models.UserProperty]
    :param linked_service_name: Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param policy: Activity policy.
    :type policy: ~azure.synapse.artifacts.models.ActivityPolicy
    :param python_file: Required. The URI of the Python file to be executed. DBFS paths are
     supported. Type: string (or Expression with resultType string).
    :type python_file: object
    :param parameters: Command line parameters that will be passed to the Python file.
    :type parameters: list[object]
    :param libraries: A list of libraries to be installed on the cluster that will execute the job.
    :type libraries: list[dict[str, object]]
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
        'python_file': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'depends_on': {'key': 'dependsOn', 'type': '[ActivityDependency]'},
        'user_properties': {'key': 'userProperties', 'type': '[UserProperty]'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'policy': {'key': 'policy', 'type': 'ActivityPolicy'},
        'python_file': {'key': 'typeProperties.pythonFile', 'type': 'object'},
        'parameters': {'key': 'typeProperties.parameters', 'type': '[object]'},
        'libraries': {'key': 'typeProperties.libraries', 'type': '[{object}]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DatabricksSparkPythonActivity, self).__init__(**kwargs)
        self.type = 'DatabricksSparkPython'  # type: str
        self.python_file = kwargs['python_file']
        self.parameters = kwargs.get('parameters', None)
        self.libraries = kwargs.get('libraries', None)


class DataFlow(msrest.serialization.Model):
    """Azure Synapse nested object which contains a flow with data movements and transformations.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: MappingDataFlow.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Type of data flow.Constant filled by server.
    :type type: str
    :param description: The description of the data flow.
    :type description: str
    :param annotations: List of tags that can be used for describing the data flow.
    :type annotations: list[object]
    :param folder: The folder that this data flow is in. If not specified, Data flow will appear at
     the root level.
    :type folder: ~azure.synapse.artifacts.models.DataFlowFolder
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DataFlowFolder'},
    }

    _subtype_map = {
        'type': {'MappingDataFlow': 'MappingDataFlow'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DataFlow, self).__init__(**kwargs)
        self.type = None  # type: Optional[str]
        self.description = kwargs.get('description', None)
        self.annotations = kwargs.get('annotations', None)
        self.folder = kwargs.get('folder', None)


class DataFlowDebugCommandRequest(msrest.serialization.Model):
    """Request body structure for data flow expression preview.

    All required parameters must be populated in order to send to Azure.

    :param session_id: Required. The ID of data flow debug session.
    :type session_id: str
    :param data_flow_name: The data flow which contains the debug session.
    :type data_flow_name: str
    :param command_name: The command name.
    :type command_name: str
    :param command_payload: Required. The command payload object.
    :type command_payload: object
    """

    _validation = {
        'session_id': {'required': True},
        'command_payload': {'required': True},
    }

    _attribute_map = {
        'session_id': {'key': 'sessionId', 'type': 'str'},
        'data_flow_name': {'key': 'dataFlowName', 'type': 'str'},
        'command_name': {'key': 'commandName', 'type': 'str'},
        'command_payload': {'key': 'commandPayload', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DataFlowDebugCommandRequest, self).__init__(**kwargs)
        self.session_id = kwargs['session_id']
        self.data_flow_name = kwargs.get('data_flow_name', None)
        self.command_name = kwargs.get('command_name', None)
        self.command_payload = kwargs['command_payload']


class DataFlowDebugCommandResponse(msrest.serialization.Model):
    """Response body structure of data flow result for data preview, statistics or expression preview.

    :param status: The run status of data preview, statistics or expression preview.
    :type status: str
    :param data: The result data of data preview, statistics or expression preview.
    :type data: str
    """

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'data': {'key': 'data', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DataFlowDebugCommandResponse, self).__init__(**kwargs)
        self.status = kwargs.get('status', None)
        self.data = kwargs.get('data', None)


class DataFlowDebugPackage(msrest.serialization.Model):
    """Request body structure for starting data flow debug session.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param session_id: The ID of data flow debug session.
    :type session_id: str
    :param data_flow: Data flow instance.
    :type data_flow: ~azure.synapse.artifacts.models.DataFlowDebugResource
    :param datasets: List of datasets.
    :type datasets: list[~azure.synapse.artifacts.models.DatasetDebugResource]
    :param linked_services: List of linked services.
    :type linked_services: list[~azure.synapse.artifacts.models.LinkedServiceDebugResource]
    :param staging: Staging info for debug session.
    :type staging: ~azure.synapse.artifacts.models.DataFlowStagingInfo
    :param debug_settings: Data flow debug settings.
    :type debug_settings: ~azure.synapse.artifacts.models.DataFlowDebugPackageDebugSettings
    """

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'session_id': {'key': 'sessionId', 'type': 'str'},
        'data_flow': {'key': 'dataFlow', 'type': 'DataFlowDebugResource'},
        'datasets': {'key': 'datasets', 'type': '[DatasetDebugResource]'},
        'linked_services': {'key': 'linkedServices', 'type': '[LinkedServiceDebugResource]'},
        'staging': {'key': 'staging', 'type': 'DataFlowStagingInfo'},
        'debug_settings': {'key': 'debugSettings', 'type': 'DataFlowDebugPackageDebugSettings'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DataFlowDebugPackage, self).__init__(**kwargs)
        self.additional_properties = kwargs.get('additional_properties', None)
        self.session_id = kwargs.get('session_id', None)
        self.data_flow = kwargs.get('data_flow', None)
        self.datasets = kwargs.get('datasets', None)
        self.linked_services = kwargs.get('linked_services', None)
        self.staging = kwargs.get('staging', None)
        self.debug_settings = kwargs.get('debug_settings', None)


class DataFlowDebugPackageDebugSettings(msrest.serialization.Model):
    """Data flow debug settings.

    :param source_settings: Source setting for data flow debug.
    :type source_settings: list[~azure.synapse.artifacts.models.DataFlowSourceSetting]
    :param parameters: Data flow parameters.
    :type parameters: dict[str, object]
    :param dataset_parameters: Parameters for dataset.
    :type dataset_parameters: object
    """

    _attribute_map = {
        'source_settings': {'key': 'sourceSettings', 'type': '[DataFlowSourceSetting]'},
        'parameters': {'key': 'parameters', 'type': '{object}'},
        'dataset_parameters': {'key': 'datasetParameters', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DataFlowDebugPackageDebugSettings, self).__init__(**kwargs)
        self.source_settings = kwargs.get('source_settings', None)
        self.parameters = kwargs.get('parameters', None)
        self.dataset_parameters = kwargs.get('dataset_parameters', None)


class DataFlowDebugPreviewDataRequest(msrest.serialization.Model):
    """Request body structure for data flow preview data.

    :param session_id: The ID of data flow debug session.
    :type session_id: str
    :param data_flow_name: The data flow which contains the debug session.
    :type data_flow_name: str
    :param stream_name: The output stream name.
    :type stream_name: str
    :param row_limits: The row limit for preview request.
    :type row_limits: int
    """

    _attribute_map = {
        'session_id': {'key': 'sessionId', 'type': 'str'},
        'data_flow_name': {'key': 'dataFlowName', 'type': 'str'},
        'stream_name': {'key': 'streamName', 'type': 'str'},
        'row_limits': {'key': 'rowLimits', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DataFlowDebugPreviewDataRequest, self).__init__(**kwargs)
        self.session_id = kwargs.get('session_id', None)
        self.data_flow_name = kwargs.get('data_flow_name', None)
        self.stream_name = kwargs.get('stream_name', None)
        self.row_limits = kwargs.get('row_limits', None)


class DataFlowDebugQueryResponse(msrest.serialization.Model):
    """Response body structure of data flow query for data preview, statistics or expression preview.

    :param run_id: The run ID of data flow debug session.
    :type run_id: str
    """

    _attribute_map = {
        'run_id': {'key': 'runId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DataFlowDebugQueryResponse, self).__init__(**kwargs)
        self.run_id = kwargs.get('run_id', None)


class SubResourceDebugResource(msrest.serialization.Model):
    """Azure Synapse nested debug resource.

    :param name: The resource name.
    :type name: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SubResourceDebugResource, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)


class DataFlowDebugResource(SubResourceDebugResource):
    """Data flow debug resource.

    All required parameters must be populated in order to send to Azure.

    :param name: The resource name.
    :type name: str
    :param properties: Required. Data flow properties.
    :type properties: ~azure.synapse.artifacts.models.DataFlow
    """

    _validation = {
        'properties': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'DataFlow'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DataFlowDebugResource, self).__init__(**kwargs)
        self.properties = kwargs['properties']


class DataFlowDebugResultResponse(msrest.serialization.Model):
    """Response body structure of data flow result for data preview, statistics or expression preview.

    :param status: The run status of data preview, statistics or expression preview.
    :type status: str
    :param data: The result data of data preview, statistics or expression preview.
    :type data: str
    """

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'data': {'key': 'data', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DataFlowDebugResultResponse, self).__init__(**kwargs)
        self.status = kwargs.get('status', None)
        self.data = kwargs.get('data', None)


class DataFlowDebugSessionInfo(msrest.serialization.Model):
    """Data flow debug session info.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param data_flow_name: The name of the data flow.
    :type data_flow_name: str
    :param compute_type: Compute type of the cluster.
    :type compute_type: str
    :param core_count: Core count of the cluster.
    :type core_count: int
    :param node_count: Node count of the cluster. (deprecated property).
    :type node_count: int
    :param integration_runtime_name: Attached integration runtime name of data flow debug session.
    :type integration_runtime_name: str
    :param session_id: The ID of data flow debug session.
    :type session_id: str
    :param start_time: Start time of data flow debug session.
    :type start_time: str
    :param time_to_live_in_minutes: Compute type of the cluster.
    :type time_to_live_in_minutes: int
    :param last_activity_time: Last activity time of data flow debug session.
    :type last_activity_time: str
    """

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'data_flow_name': {'key': 'dataFlowName', 'type': 'str'},
        'compute_type': {'key': 'computeType', 'type': 'str'},
        'core_count': {'key': 'coreCount', 'type': 'int'},
        'node_count': {'key': 'nodeCount', 'type': 'int'},
        'integration_runtime_name': {'key': 'integrationRuntimeName', 'type': 'str'},
        'session_id': {'key': 'sessionId', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'str'},
        'time_to_live_in_minutes': {'key': 'timeToLiveInMinutes', 'type': 'int'},
        'last_activity_time': {'key': 'lastActivityTime', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DataFlowDebugSessionInfo, self).__init__(**kwargs)
        self.additional_properties = kwargs.get('additional_properties', None)
        self.data_flow_name = kwargs.get('data_flow_name', None)
        self.compute_type = kwargs.get('compute_type', None)
        self.core_count = kwargs.get('core_count', None)
        self.node_count = kwargs.get('node_count', None)
        self.integration_runtime_name = kwargs.get('integration_runtime_name', None)
        self.session_id = kwargs.get('session_id', None)
        self.start_time = kwargs.get('start_time', None)
        self.time_to_live_in_minutes = kwargs.get('time_to_live_in_minutes', None)
        self.last_activity_time = kwargs.get('last_activity_time', None)


class DataFlowDebugStatisticsRequest(msrest.serialization.Model):
    """Request body structure for data flow statistics.

    :param session_id: The ID of data flow debug session.
    :type session_id: str
    :param data_flow_name: The data flow which contains the debug session.
    :type data_flow_name: str
    :param stream_name: The output stream name.
    :type stream_name: str
    :param columns: List of column names.
    :type columns: list[str]
    """

    _attribute_map = {
        'session_id': {'key': 'sessionId', 'type': 'str'},
        'data_flow_name': {'key': 'dataFlowName', 'type': 'str'},
        'stream_name': {'key': 'streamName', 'type': 'str'},
        'columns': {'key': 'columns', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DataFlowDebugStatisticsRequest, self).__init__(**kwargs)
        self.session_id = kwargs.get('session_id', None)
        self.data_flow_name = kwargs.get('data_flow_name', None)
        self.stream_name = kwargs.get('stream_name', None)
        self.columns = kwargs.get('columns', None)


class DataFlowFolder(msrest.serialization.Model):
    """The folder that this data flow is in. If not specified, Data flow will appear at the root level.

    :param name: The name of the folder that this data flow is in.
    :type name: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DataFlowFolder, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)


class DataFlowListResponse(msrest.serialization.Model):
    """A list of data flow resources.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. List of data flows.
    :type value: list[~azure.synapse.artifacts.models.DataFlowResource]
    :param next_link: The link to the next page of results, if any remaining results exist.
    :type next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[DataFlowResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DataFlowListResponse, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = kwargs.get('next_link', None)


class DataFlowReference(msrest.serialization.Model):
    """Data flow reference type.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Data flow reference type. Possible values include: "DataFlowReference".
    :type type: str or ~azure.synapse.artifacts.models.DataFlowReferenceType
    :param reference_name: Required. Reference data flow name.
    :type reference_name: str
    :param dataset_parameters: Reference data flow parameters from dataset.
    :type dataset_parameters: object
    """

    _validation = {
        'type': {'required': True},
        'reference_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'reference_name': {'key': 'referenceName', 'type': 'str'},
        'dataset_parameters': {'key': 'datasetParameters', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DataFlowReference, self).__init__(**kwargs)
        self.additional_properties = kwargs.get('additional_properties', None)
        self.type = kwargs['type']
        self.reference_name = kwargs['reference_name']
        self.dataset_parameters = kwargs.get('dataset_parameters', None)


class DataFlowResource(AzureEntityResource):
    """Data flow resource type.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. Ex- Microsoft.Compute/virtualMachines or
     Microsoft.Storage/storageAccounts.
    :vartype type: str
    :ivar etag: Resource Etag.
    :vartype etag: str
    :param properties: Required. Data flow properties.
    :type properties: ~azure.synapse.artifacts.models.DataFlow
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'DataFlow'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DataFlowResource, self).__init__(**kwargs)
        self.properties = kwargs['properties']


class Transformation(msrest.serialization.Model):
    """A data flow transformation.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Transformation name.
    :type name: str
    :param description: Transformation description.
    :type description: str
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Transformation, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.description = kwargs.get('description', None)


class DataFlowSink(Transformation):
    """Transformation for data flow sink.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Transformation name.
    :type name: str
    :param description: Transformation description.
    :type description: str
    :param dataset: Dataset reference.
    :type dataset: ~azure.synapse.artifacts.models.DatasetReference
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'dataset': {'key': 'dataset', 'type': 'DatasetReference'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DataFlowSink, self).__init__(**kwargs)
        self.dataset = kwargs.get('dataset', None)


class DataFlowSource(Transformation):
    """Transformation for data flow source.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Transformation name.
    :type name: str
    :param description: Transformation description.
    :type description: str
    :param dataset: Dataset reference.
    :type dataset: ~azure.synapse.artifacts.models.DatasetReference
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'dataset': {'key': 'dataset', 'type': 'DatasetReference'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DataFlowSource, self).__init__(**kwargs)
        self.dataset = kwargs.get('dataset', None)


class DataFlowSourceSetting(msrest.serialization.Model):
    """Definition of data flow source setting for debug.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param source_name: The data flow source name.
    :type source_name: str
    :param row_limit: Defines the row limit of data flow source in debug.
    :type row_limit: int
    """

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'source_name': {'key': 'sourceName', 'type': 'str'},
        'row_limit': {'key': 'rowLimit', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DataFlowSourceSetting, self).__init__(**kwargs)
        self.additional_properties = kwargs.get('additional_properties', None)
        self.source_name = kwargs.get('source_name', None)
        self.row_limit = kwargs.get('row_limit', None)


class DataFlowStagingInfo(msrest.serialization.Model):
    """Staging info for execute data flow activity.

    :param linked_service: Staging linked service reference.
    :type linked_service: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param folder_path: Folder path for staging blob.
    :type folder_path: str
    """

    _attribute_map = {
        'linked_service': {'key': 'linkedService', 'type': 'LinkedServiceReference'},
        'folder_path': {'key': 'folderPath', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DataFlowStagingInfo, self).__init__(**kwargs)
        self.linked_service = kwargs.get('linked_service', None)
        self.folder_path = kwargs.get('folder_path', None)


class DataLakeAnalyticsUSQLActivity(ExecutionActivity):
    """Data Lake Analytics U-SQL activity.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param name: Required. Activity name.
    :type name: str
    :param type: Required. Type of activity.Constant filled by server.
    :type type: str
    :param description: Activity description.
    :type description: str
    :param depends_on: Activity depends on condition.
    :type depends_on: list[~azure.synapse.artifacts.models.ActivityDependency]
    :param user_properties: Activity user properties.
    :type user_properties: list[~azure.synapse.artifacts.models.UserProperty]
    :param linked_service_name: Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param policy: Activity policy.
    :type policy: ~azure.synapse.artifacts.models.ActivityPolicy
    :param script_path: Required. Case-sensitive path to folder that contains the U-SQL script.
     Type: string (or Expression with resultType string).
    :type script_path: object
    :param script_linked_service: Required. Script linked service reference.
    :type script_linked_service: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param degree_of_parallelism: The maximum number of nodes simultaneously used to run the job.
     Default value is 1. Type: integer (or Expression with resultType integer), minimum: 1.
    :type degree_of_parallelism: object
    :param priority: Determines which jobs out of all that are queued should be selected to run
     first. The lower the number, the higher the priority. Default value is 1000. Type: integer (or
     Expression with resultType integer), minimum: 1.
    :type priority: object
    :param parameters: Parameters for U-SQL job request.
    :type parameters: dict[str, object]
    :param runtime_version: Runtime version of the U-SQL engine to use. Type: string (or Expression
     with resultType string).
    :type runtime_version: object
    :param compilation_mode: Compilation mode of U-SQL. Must be one of these values : Semantic,
     Full and SingleBox. Type: string (or Expression with resultType string).
    :type compilation_mode: object
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
        'script_path': {'required': True},
        'script_linked_service': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'depends_on': {'key': 'dependsOn', 'type': '[ActivityDependency]'},
        'user_properties': {'key': 'userProperties', 'type': '[UserProperty]'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'policy': {'key': 'policy', 'type': 'ActivityPolicy'},
        'script_path': {'key': 'typeProperties.scriptPath', 'type': 'object'},
        'script_linked_service': {'key': 'typeProperties.scriptLinkedService', 'type': 'LinkedServiceReference'},
        'degree_of_parallelism': {'key': 'typeProperties.degreeOfParallelism', 'type': 'object'},
        'priority': {'key': 'typeProperties.priority', 'type': 'object'},
        'parameters': {'key': 'typeProperties.parameters', 'type': '{object}'},
        'runtime_version': {'key': 'typeProperties.runtimeVersion', 'type': 'object'},
        'compilation_mode': {'key': 'typeProperties.compilationMode', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DataLakeAnalyticsUSQLActivity, self).__init__(**kwargs)
        self.type = 'DataLakeAnalyticsU-SQL'  # type: str
        self.script_path = kwargs['script_path']
        self.script_linked_service = kwargs['script_linked_service']
        self.degree_of_parallelism = kwargs.get('degree_of_parallelism', None)
        self.priority = kwargs.get('priority', None)
        self.parameters = kwargs.get('parameters', None)
        self.runtime_version = kwargs.get('runtime_version', None)
        self.compilation_mode = kwargs.get('compilation_mode', None)


class DataLakeStorageAccountDetails(msrest.serialization.Model):
    """Details of the data lake storage account associated with the workspace.

    :param account_url: Account URL.
    :type account_url: str
    :param filesystem: Filesystem name.
    :type filesystem: str
    """

    _attribute_map = {
        'account_url': {'key': 'accountUrl', 'type': 'str'},
        'filesystem': {'key': 'filesystem', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DataLakeStorageAccountDetails, self).__init__(**kwargs)
        self.account_url = kwargs.get('account_url', None)
        self.filesystem = kwargs.get('filesystem', None)


class DatasetCompression(msrest.serialization.Model):
    """The compression method used on a dataset.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: DatasetBZip2Compression, DatasetDeflateCompression, DatasetGZipCompression, DatasetZipDeflateCompression.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset compression.Constant filled by server.
    :type type: str
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
    }

    _subtype_map = {
        'type': {'BZip2': 'DatasetBZip2Compression', 'Deflate': 'DatasetDeflateCompression', 'GZip': 'DatasetGZipCompression', 'ZipDeflate': 'DatasetZipDeflateCompression'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DatasetCompression, self).__init__(**kwargs)
        self.additional_properties = kwargs.get('additional_properties', None)
        self.type = 'DatasetCompression'  # type: str


class DatasetBZip2Compression(DatasetCompression):
    """The BZip2 compression method used on a dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset compression.Constant filled by server.
    :type type: str
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DatasetBZip2Compression, self).__init__(**kwargs)
        self.type = 'BZip2'  # type: str


class DatasetDataElement(msrest.serialization.Model):
    """Columns that define the structure of the dataset.

    :param name: Name of the column. Type: string (or Expression with resultType string).
    :type name: object
    :param type: Type of the column. Type: string (or Expression with resultType string).
    :type type: object
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'object'},
        'type': {'key': 'type', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DatasetDataElement, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.type = kwargs.get('type', None)


class DatasetDebugResource(SubResourceDebugResource):
    """Dataset debug resource.

    All required parameters must be populated in order to send to Azure.

    :param name: The resource name.
    :type name: str
    :param properties: Required. Dataset properties.
    :type properties: ~azure.synapse.artifacts.models.Dataset
    """

    _validation = {
        'properties': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'Dataset'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DatasetDebugResource, self).__init__(**kwargs)
        self.properties = kwargs['properties']


class DatasetDeflateCompression(DatasetCompression):
    """The Deflate compression method used on a dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset compression.Constant filled by server.
    :type type: str
    :param level: The Deflate compression level. Possible values include: "Optimal", "Fastest".
    :type level: str or ~azure.synapse.artifacts.models.DatasetCompressionLevel
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'level': {'key': 'level', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DatasetDeflateCompression, self).__init__(**kwargs)
        self.type = 'Deflate'  # type: str
        self.level = kwargs.get('level', None)


class DatasetFolder(msrest.serialization.Model):
    """The folder that this Dataset is in. If not specified, Dataset will appear at the root level.

    :param name: The name of the folder that this Dataset is in.
    :type name: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DatasetFolder, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)


class DatasetGZipCompression(DatasetCompression):
    """The GZip compression method used on a dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset compression.Constant filled by server.
    :type type: str
    :param level: The GZip compression level. Possible values include: "Optimal", "Fastest".
    :type level: str or ~azure.synapse.artifacts.models.DatasetCompressionLevel
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'level': {'key': 'level', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DatasetGZipCompression, self).__init__(**kwargs)
        self.type = 'GZip'  # type: str
        self.level = kwargs.get('level', None)


class DatasetListResponse(msrest.serialization.Model):
    """A list of dataset resources.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. List of datasets.
    :type value: list[~azure.synapse.artifacts.models.DatasetResource]
    :param next_link: The link to the next page of results, if any remaining results exist.
    :type next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[DatasetResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DatasetListResponse, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = kwargs.get('next_link', None)


class DatasetReference(msrest.serialization.Model):
    """Dataset reference type.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Dataset reference type. Possible values include: "DatasetReference".
    :type type: str or ~azure.synapse.artifacts.models.DatasetReferenceType
    :param reference_name: Required. Reference dataset name.
    :type reference_name: str
    :param parameters: Arguments for dataset.
    :type parameters: dict[str, object]
    """

    _validation = {
        'type': {'required': True},
        'reference_name': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'reference_name': {'key': 'referenceName', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{object}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DatasetReference, self).__init__(**kwargs)
        self.type = kwargs['type']
        self.reference_name = kwargs['reference_name']
        self.parameters = kwargs.get('parameters', None)


class DatasetResource(AzureEntityResource):
    """Dataset resource type.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. Ex- Microsoft.Compute/virtualMachines or
     Microsoft.Storage/storageAccounts.
    :vartype type: str
    :ivar etag: Resource Etag.
    :vartype etag: str
    :param properties: Required. Dataset properties.
    :type properties: ~azure.synapse.artifacts.models.Dataset
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'Dataset'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DatasetResource, self).__init__(**kwargs)
        self.properties = kwargs['properties']


class DatasetSchemaDataElement(msrest.serialization.Model):
    """Columns that define the physical type schema of the dataset.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param name: Name of the schema column. Type: string (or Expression with resultType string).
    :type name: object
    :param type: Type of the schema column. Type: string (or Expression with resultType string).
    :type type: object
    """

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'object'},
        'type': {'key': 'type', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DatasetSchemaDataElement, self).__init__(**kwargs)
        self.additional_properties = kwargs.get('additional_properties', None)
        self.name = kwargs.get('name', None)
        self.type = kwargs.get('type', None)


class DatasetZipDeflateCompression(DatasetCompression):
    """The ZipDeflate compression method used on a dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset compression.Constant filled by server.
    :type type: str
    :param level: The ZipDeflate compression level. Possible values include: "Optimal", "Fastest".
    :type level: str or ~azure.synapse.artifacts.models.DatasetCompressionLevel
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'level': {'key': 'level', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DatasetZipDeflateCompression, self).__init__(**kwargs)
        self.type = 'ZipDeflate'  # type: str
        self.level = kwargs.get('level', None)


class Db2LinkedService(LinkedService):
    """Linked service for DB2 data source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param server: Required. Server name for connection. Type: string (or Expression with
     resultType string).
    :type server: object
    :param database: Required. Database name for connection. Type: string (or Expression with
     resultType string).
    :type database: object
    :param authentication_type: AuthenticationType to be used for connection. Possible values
     include: "Basic".
    :type authentication_type: str or ~azure.synapse.artifacts.models.Db2AuthenticationType
    :param username: Username for authentication. Type: string (or Expression with resultType
     string).
    :type username: object
    :param password: Password for authentication.
    :type password: ~azure.synapse.artifacts.models.SecretBase
    :param package_collection: Under where packages are created when querying database. Type:
     string (or Expression with resultType string).
    :type package_collection: object
    :param certificate_common_name: Certificate Common Name when TLS is enabled. Type: string (or
     Expression with resultType string).
    :type certificate_common_name: object
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'server': {'required': True},
        'database': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'server': {'key': 'typeProperties.server', 'type': 'object'},
        'database': {'key': 'typeProperties.database', 'type': 'object'},
        'authentication_type': {'key': 'typeProperties.authenticationType', 'type': 'str'},
        'username': {'key': 'typeProperties.username', 'type': 'object'},
        'password': {'key': 'typeProperties.password', 'type': 'SecretBase'},
        'package_collection': {'key': 'typeProperties.packageCollection', 'type': 'object'},
        'certificate_common_name': {'key': 'typeProperties.certificateCommonName', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Db2LinkedService, self).__init__(**kwargs)
        self.type = 'Db2'  # type: str
        self.server = kwargs['server']
        self.database = kwargs['database']
        self.authentication_type = kwargs.get('authentication_type', None)
        self.username = kwargs.get('username', None)
        self.password = kwargs.get('password', None)
        self.package_collection = kwargs.get('package_collection', None)
        self.certificate_common_name = kwargs.get('certificate_common_name', None)
        self.encrypted_credential = kwargs.get('encrypted_credential', None)


class Db2Source(TabularSource):
    """A copy activity source for Db2 databases.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: object
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param query_timeout: Query timeout. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type query_timeout: object
    :param query: Database query. Type: string (or Expression with resultType string).
    :type query: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'query_timeout': {'key': 'queryTimeout', 'type': 'object'},
        'query': {'key': 'query', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Db2Source, self).__init__(**kwargs)
        self.type = 'Db2Source'  # type: str
        self.query = kwargs.get('query', None)


class Db2TableDataset(Dataset):
    """The Db2 table dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param table_name: This property will be retired. Please consider using schema + table
     properties instead.
    :type table_name: object
    :param schema_type_properties_schema: The Db2 schema name. Type: string (or Expression with
     resultType string).
    :type schema_type_properties_schema: object
    :param table: The Db2 table name. Type: string (or Expression with resultType string).
    :type table: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table_name': {'key': 'typeProperties.tableName', 'type': 'object'},
        'schema_type_properties_schema': {'key': 'typeProperties.schema', 'type': 'object'},
        'table': {'key': 'typeProperties.table', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Db2TableDataset, self).__init__(**kwargs)
        self.type = 'Db2Table'  # type: str
        self.table_name = kwargs.get('table_name', None)
        self.schema_type_properties_schema = kwargs.get('schema_type_properties_schema', None)
        self.table = kwargs.get('table', None)


class DeleteActivity(ExecutionActivity):
    """Delete activity.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param name: Required. Activity name.
    :type name: str
    :param type: Required. Type of activity.Constant filled by server.
    :type type: str
    :param description: Activity description.
    :type description: str
    :param depends_on: Activity depends on condition.
    :type depends_on: list[~azure.synapse.artifacts.models.ActivityDependency]
    :param user_properties: Activity user properties.
    :type user_properties: list[~azure.synapse.artifacts.models.UserProperty]
    :param linked_service_name: Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param policy: Activity policy.
    :type policy: ~azure.synapse.artifacts.models.ActivityPolicy
    :param recursive: If true, files or sub-folders under current folder path will be deleted
     recursively. Default is false. Type: boolean (or Expression with resultType boolean).
    :type recursive: object
    :param max_concurrent_connections: The max concurrent connections to connect data source at the
     same time.
    :type max_concurrent_connections: int
    :param enable_logging: Whether to record detailed logs of delete-activity execution. Default
     value is false. Type: boolean (or Expression with resultType boolean).
    :type enable_logging: object
    :param log_storage_settings: Log storage settings customer need to provide when enableLogging
     is true.
    :type log_storage_settings: ~azure.synapse.artifacts.models.LogStorageSettings
    :param dataset: Required. Delete activity dataset reference.
    :type dataset: ~azure.synapse.artifacts.models.DatasetReference
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
        'max_concurrent_connections': {'minimum': 1},
        'dataset': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'depends_on': {'key': 'dependsOn', 'type': '[ActivityDependency]'},
        'user_properties': {'key': 'userProperties', 'type': '[UserProperty]'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'policy': {'key': 'policy', 'type': 'ActivityPolicy'},
        'recursive': {'key': 'typeProperties.recursive', 'type': 'object'},
        'max_concurrent_connections': {'key': 'typeProperties.maxConcurrentConnections', 'type': 'int'},
        'enable_logging': {'key': 'typeProperties.enableLogging', 'type': 'object'},
        'log_storage_settings': {'key': 'typeProperties.logStorageSettings', 'type': 'LogStorageSettings'},
        'dataset': {'key': 'typeProperties.dataset', 'type': 'DatasetReference'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DeleteActivity, self).__init__(**kwargs)
        self.type = 'Delete'  # type: str
        self.recursive = kwargs.get('recursive', None)
        self.max_concurrent_connections = kwargs.get('max_concurrent_connections', None)
        self.enable_logging = kwargs.get('enable_logging', None)
        self.log_storage_settings = kwargs.get('log_storage_settings', None)
        self.dataset = kwargs['dataset']


class DeleteDataFlowDebugSessionRequest(msrest.serialization.Model):
    """Request body structure for deleting data flow debug session.

    :param session_id: The ID of data flow debug session.
    :type session_id: str
    :param data_flow_name: The data flow which contains the debug session.
    :type data_flow_name: str
    """

    _attribute_map = {
        'session_id': {'key': 'sessionId', 'type': 'str'},
        'data_flow_name': {'key': 'dataFlowName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DeleteDataFlowDebugSessionRequest, self).__init__(**kwargs)
        self.session_id = kwargs.get('session_id', None)
        self.data_flow_name = kwargs.get('data_flow_name', None)


class DelimitedTextDataset(Dataset):
    """Delimited text dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param location: The location of the delimited text storage.
    :type location: ~azure.synapse.artifacts.models.DatasetLocation
    :param column_delimiter: The column delimiter. Type: string (or Expression with resultType
     string).
    :type column_delimiter: object
    :param row_delimiter: The row delimiter. Type: string (or Expression with resultType string).
    :type row_delimiter: object
    :param encoding_name: The code page name of the preferred encoding. If miss, the default value
     is UTF-8, unless BOM denotes another Unicode encoding. Refer to the name column of the table in
     the following link to set supported values:
     https://msdn.microsoft.com/library/system.text.encoding.aspx. Type: string (or Expression with
     resultType string).
    :type encoding_name: object
    :param compression_codec:  Possible values include: "bzip2", "gzip", "deflate", "zipDeflate",
     "snappy", "lz4".
    :type compression_codec: str or ~azure.synapse.artifacts.models.DelimitedTextCompressionCodec
    :param compression_level: The data compression method used for DelimitedText. Possible values
     include: "Optimal", "Fastest".
    :type compression_level: str or ~azure.synapse.artifacts.models.DatasetCompressionLevel
    :param quote_char: The quote character. Type: string (or Expression with resultType string).
    :type quote_char: object
    :param escape_char: The escape character. Type: string (or Expression with resultType string).
    :type escape_char: object
    :param first_row_as_header: When used as input, treat the first row of data as headers. When
     used as output,write the headers into the output as the first row of data. The default value is
     false. Type: boolean (or Expression with resultType boolean).
    :type first_row_as_header: object
    :param null_value: The null value string. Type: string (or Expression with resultType string).
    :type null_value: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'location': {'key': 'typeProperties.location', 'type': 'DatasetLocation'},
        'column_delimiter': {'key': 'typeProperties.columnDelimiter', 'type': 'object'},
        'row_delimiter': {'key': 'typeProperties.rowDelimiter', 'type': 'object'},
        'encoding_name': {'key': 'typeProperties.encodingName', 'type': 'object'},
        'compression_codec': {'key': 'typeProperties.compressionCodec', 'type': 'str'},
        'compression_level': {'key': 'typeProperties.compressionLevel', 'type': 'str'},
        'quote_char': {'key': 'typeProperties.quoteChar', 'type': 'object'},
        'escape_char': {'key': 'typeProperties.escapeChar', 'type': 'object'},
        'first_row_as_header': {'key': 'typeProperties.firstRowAsHeader', 'type': 'object'},
        'null_value': {'key': 'typeProperties.nullValue', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DelimitedTextDataset, self).__init__(**kwargs)
        self.type = 'DelimitedText'  # type: str
        self.location = kwargs.get('location', None)
        self.column_delimiter = kwargs.get('column_delimiter', None)
        self.row_delimiter = kwargs.get('row_delimiter', None)
        self.encoding_name = kwargs.get('encoding_name', None)
        self.compression_codec = kwargs.get('compression_codec', None)
        self.compression_level = kwargs.get('compression_level', None)
        self.quote_char = kwargs.get('quote_char', None)
        self.escape_char = kwargs.get('escape_char', None)
        self.first_row_as_header = kwargs.get('first_row_as_header', None)
        self.null_value = kwargs.get('null_value', None)


class FormatReadSettings(msrest.serialization.Model):
    """Format read settings.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: DelimitedTextReadSettings.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. The read setting type.Constant filled by server.
    :type type: str
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
    }

    _subtype_map = {
        'type': {'DelimitedTextReadSettings': 'DelimitedTextReadSettings'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FormatReadSettings, self).__init__(**kwargs)
        self.additional_properties = kwargs.get('additional_properties', None)
        self.type = 'FormatReadSettings'  # type: str


class DelimitedTextReadSettings(FormatReadSettings):
    """Delimited text read settings.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. The read setting type.Constant filled by server.
    :type type: str
    :param skip_line_count: Indicates the number of non-empty rows to skip when reading data from
     input files. Type: integer (or Expression with resultType integer).
    :type skip_line_count: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'skip_line_count': {'key': 'skipLineCount', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DelimitedTextReadSettings, self).__init__(**kwargs)
        self.type = 'DelimitedTextReadSettings'  # type: str
        self.skip_line_count = kwargs.get('skip_line_count', None)


class DelimitedTextSink(CopySink):
    """A copy activity DelimitedText sink.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy sink type.Constant filled by server.
    :type type: str
    :param write_batch_size: Write batch size. Type: integer (or Expression with resultType
     integer), minimum: 0.
    :type write_batch_size: object
    :param write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type write_batch_timeout: object
    :param sink_retry_count: Sink retry count. Type: integer (or Expression with resultType
     integer).
    :type sink_retry_count: object
    :param sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type sink_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the sink data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param store_settings: DelimitedText store settings.
    :type store_settings: ~azure.synapse.artifacts.models.StoreWriteSettings
    :param format_settings: DelimitedText format settings.
    :type format_settings: ~azure.synapse.artifacts.models.DelimitedTextWriteSettings
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'write_batch_size': {'key': 'writeBatchSize', 'type': 'object'},
        'write_batch_timeout': {'key': 'writeBatchTimeout', 'type': 'object'},
        'sink_retry_count': {'key': 'sinkRetryCount', 'type': 'object'},
        'sink_retry_wait': {'key': 'sinkRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'store_settings': {'key': 'storeSettings', 'type': 'StoreWriteSettings'},
        'format_settings': {'key': 'formatSettings', 'type': 'DelimitedTextWriteSettings'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DelimitedTextSink, self).__init__(**kwargs)
        self.type = 'DelimitedTextSink'  # type: str
        self.store_settings = kwargs.get('store_settings', None)
        self.format_settings = kwargs.get('format_settings', None)


class DelimitedTextSource(CopySource):
    """A copy activity DelimitedText source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: object
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param store_settings: DelimitedText store settings.
    :type store_settings: ~azure.synapse.artifacts.models.StoreReadSettings
    :param format_settings: DelimitedText format settings.
    :type format_settings: ~azure.synapse.artifacts.models.DelimitedTextReadSettings
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'store_settings': {'key': 'storeSettings', 'type': 'StoreReadSettings'},
        'format_settings': {'key': 'formatSettings', 'type': 'DelimitedTextReadSettings'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DelimitedTextSource, self).__init__(**kwargs)
        self.type = 'DelimitedTextSource'  # type: str
        self.store_settings = kwargs.get('store_settings', None)
        self.format_settings = kwargs.get('format_settings', None)


class DelimitedTextWriteSettings(FormatWriteSettings):
    """Delimited text write settings.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. The write setting type.Constant filled by server.
    :type type: str
    :param quote_all_text: Indicates whether string values should always be enclosed with quotes.
     Type: boolean (or Expression with resultType boolean).
    :type quote_all_text: object
    :param file_extension: Required. The file extension used to create the files. Type: string (or
     Expression with resultType string).
    :type file_extension: object
    """

    _validation = {
        'type': {'required': True},
        'file_extension': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'quote_all_text': {'key': 'quoteAllText', 'type': 'object'},
        'file_extension': {'key': 'fileExtension', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DelimitedTextWriteSettings, self).__init__(**kwargs)
        self.type = 'DelimitedTextWriteSettings'  # type: str
        self.quote_all_text = kwargs.get('quote_all_text', None)
        self.file_extension = kwargs['file_extension']


class DependencyReference(msrest.serialization.Model):
    """Referenced dependency.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: SelfDependencyTumblingWindowTriggerReference, TriggerDependencyReference.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. The type of dependency reference.Constant filled by server.
    :type type: str
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
    }

    _subtype_map = {
        'type': {'SelfDependencyTumblingWindowTriggerReference': 'SelfDependencyTumblingWindowTriggerReference', 'TriggerDependencyReference': 'TriggerDependencyReference'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DependencyReference, self).__init__(**kwargs)
        self.type = None  # type: Optional[str]


class DistcpSettings(msrest.serialization.Model):
    """Distcp settings.

    All required parameters must be populated in order to send to Azure.

    :param resource_manager_endpoint: Required. Specifies the Yarn ResourceManager endpoint. Type:
     string (or Expression with resultType string).
    :type resource_manager_endpoint: object
    :param temp_script_path: Required. Specifies an existing folder path which will be used to
     store temp Distcp command script. The script file is generated by ADF and will be removed after
     Copy job finished. Type: string (or Expression with resultType string).
    :type temp_script_path: object
    :param distcp_options: Specifies the Distcp options. Type: string (or Expression with
     resultType string).
    :type distcp_options: object
    """

    _validation = {
        'resource_manager_endpoint': {'required': True},
        'temp_script_path': {'required': True},
    }

    _attribute_map = {
        'resource_manager_endpoint': {'key': 'resourceManagerEndpoint', 'type': 'object'},
        'temp_script_path': {'key': 'tempScriptPath', 'type': 'object'},
        'distcp_options': {'key': 'distcpOptions', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DistcpSettings, self).__init__(**kwargs)
        self.resource_manager_endpoint = kwargs['resource_manager_endpoint']
        self.temp_script_path = kwargs['temp_script_path']
        self.distcp_options = kwargs.get('distcp_options', None)


class DocumentDbCollectionDataset(Dataset):
    """Microsoft Azure Document Database Collection dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param collection_name: Required. Document Database collection name. Type: string (or
     Expression with resultType string).
    :type collection_name: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
        'collection_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'collection_name': {'key': 'typeProperties.collectionName', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DocumentDbCollectionDataset, self).__init__(**kwargs)
        self.type = 'DocumentDbCollection'  # type: str
        self.collection_name = kwargs['collection_name']


class DocumentDbCollectionSink(CopySink):
    """A copy activity Document Database Collection sink.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy sink type.Constant filled by server.
    :type type: str
    :param write_batch_size: Write batch size. Type: integer (or Expression with resultType
     integer), minimum: 0.
    :type write_batch_size: object
    :param write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type write_batch_timeout: object
    :param sink_retry_count: Sink retry count. Type: integer (or Expression with resultType
     integer).
    :type sink_retry_count: object
    :param sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type sink_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the sink data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param nesting_separator: Nested properties separator. Default is . (dot). Type: string (or
     Expression with resultType string).
    :type nesting_separator: object
    :param write_behavior: Describes how to write data to Azure Cosmos DB. Type: string (or
     Expression with resultType string). Allowed values: insert and upsert.
    :type write_behavior: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'write_batch_size': {'key': 'writeBatchSize', 'type': 'object'},
        'write_batch_timeout': {'key': 'writeBatchTimeout', 'type': 'object'},
        'sink_retry_count': {'key': 'sinkRetryCount', 'type': 'object'},
        'sink_retry_wait': {'key': 'sinkRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'nesting_separator': {'key': 'nestingSeparator', 'type': 'object'},
        'write_behavior': {'key': 'writeBehavior', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DocumentDbCollectionSink, self).__init__(**kwargs)
        self.type = 'DocumentDbCollectionSink'  # type: str
        self.nesting_separator = kwargs.get('nesting_separator', None)
        self.write_behavior = kwargs.get('write_behavior', None)


class DocumentDbCollectionSource(CopySource):
    """A copy activity Document Database Collection source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: object
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param query: Documents query. Type: string (or Expression with resultType string).
    :type query: object
    :param nesting_separator: Nested properties separator. Type: string (or Expression with
     resultType string).
    :type nesting_separator: object
    :param query_timeout: Query timeout. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type query_timeout: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'query': {'key': 'query', 'type': 'object'},
        'nesting_separator': {'key': 'nestingSeparator', 'type': 'object'},
        'query_timeout': {'key': 'queryTimeout', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DocumentDbCollectionSource, self).__init__(**kwargs)
        self.type = 'DocumentDbCollectionSource'  # type: str
        self.query = kwargs.get('query', None)
        self.nesting_separator = kwargs.get('nesting_separator', None)
        self.query_timeout = kwargs.get('query_timeout', None)


class DrillLinkedService(LinkedService):
    """Drill server linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param connection_string: An ODBC connection string. Type: string, SecureString or
     AzureKeyVaultSecretReference.
    :type connection_string: object
    :param pwd: The Azure key vault secret reference of password in connection string.
    :type pwd: ~azure.synapse.artifacts.models.AzureKeyVaultSecretReference
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'connection_string': {'key': 'typeProperties.connectionString', 'type': 'object'},
        'pwd': {'key': 'typeProperties.pwd', 'type': 'AzureKeyVaultSecretReference'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DrillLinkedService, self).__init__(**kwargs)
        self.type = 'Drill'  # type: str
        self.connection_string = kwargs.get('connection_string', None)
        self.pwd = kwargs.get('pwd', None)
        self.encrypted_credential = kwargs.get('encrypted_credential', None)


class DrillSource(TabularSource):
    """A copy activity Drill server source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: object
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param query_timeout: Query timeout. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type query_timeout: object
    :param query: A query to retrieve data from source. Type: string (or Expression with resultType
     string).
    :type query: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'query_timeout': {'key': 'queryTimeout', 'type': 'object'},
        'query': {'key': 'query', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DrillSource, self).__init__(**kwargs)
        self.type = 'DrillSource'  # type: str
        self.query = kwargs.get('query', None)


class DrillTableDataset(Dataset):
    """Drill server dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param table_name: This property will be retired. Please consider using schema + table
     properties instead.
    :type table_name: object
    :param table: The table name of the Drill. Type: string (or Expression with resultType string).
    :type table: object
    :param schema_type_properties_schema: The schema name of the Drill. Type: string (or Expression
     with resultType string).
    :type schema_type_properties_schema: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table_name': {'key': 'typeProperties.tableName', 'type': 'object'},
        'table': {'key': 'typeProperties.table', 'type': 'object'},
        'schema_type_properties_schema': {'key': 'typeProperties.schema', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DrillTableDataset, self).__init__(**kwargs)
        self.type = 'DrillTable'  # type: str
        self.table_name = kwargs.get('table_name', None)
        self.table = kwargs.get('table', None)
        self.schema_type_properties_schema = kwargs.get('schema_type_properties_schema', None)


class DWCopyCommandDefaultValue(msrest.serialization.Model):
    """Default value.

    :param column_name: Column name. Type: object (or Expression with resultType string).
    :type column_name: object
    :param default_value: The default value of the column. Type: object (or Expression with
     resultType string).
    :type default_value: object
    """

    _attribute_map = {
        'column_name': {'key': 'columnName', 'type': 'object'},
        'default_value': {'key': 'defaultValue', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DWCopyCommandDefaultValue, self).__init__(**kwargs)
        self.column_name = kwargs.get('column_name', None)
        self.default_value = kwargs.get('default_value', None)


class DWCopyCommandSettings(msrest.serialization.Model):
    """DW Copy Command settings.

    :param default_values: Specifies the default values for each target column in SQL DW. The
     default values in the property overwrite the DEFAULT constraint set in the DB, and identity
     column cannot have a default value. Type: array of objects (or Expression with resultType array
     of objects).
    :type default_values: list[~azure.synapse.artifacts.models.DWCopyCommandDefaultValue]
    :param additional_options: Additional options directly passed to SQL DW in Copy Command. Type:
     key value pairs (value should be string type) (or Expression with resultType object). Example:
     "additionalOptions": { "MAXERRORS": "1000", "DATEFORMAT": "'ymd'" }.
    :type additional_options: dict[str, str]
    """

    _attribute_map = {
        'default_values': {'key': 'defaultValues', 'type': '[DWCopyCommandDefaultValue]'},
        'additional_options': {'key': 'additionalOptions', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DWCopyCommandSettings, self).__init__(**kwargs)
        self.default_values = kwargs.get('default_values', None)
        self.additional_options = kwargs.get('additional_options', None)


class DynamicsAXLinkedService(LinkedService):
    """Dynamics AX linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param url: Required. The Dynamics AX (or Dynamics 365 Finance and Operations) instance OData
     endpoint.
    :type url: object
    :param service_principal_id: Required. Specify the application's client ID. Type: string (or
     Expression with resultType string).
    :type service_principal_id: object
    :param service_principal_key: Required. Specify the application's key. Mark this field as a
     SecureString to store it securely in Data Factory, or reference a secret stored in Azure Key
     Vault. Type: string (or Expression with resultType string).
    :type service_principal_key: ~azure.synapse.artifacts.models.SecretBase
    :param tenant: Required. Specify the tenant information (domain name or tenant ID) under which
     your application resides. Retrieve it by hovering the mouse in the top-right corner of the
     Azure portal. Type: string (or Expression with resultType string).
    :type tenant: object
    :param aad_resource_id: Required. Specify the resource you are requesting authorization. Type:
     string (or Expression with resultType string).
    :type aad_resource_id: object
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'url': {'required': True},
        'service_principal_id': {'required': True},
        'service_principal_key': {'required': True},
        'tenant': {'required': True},
        'aad_resource_id': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'url': {'key': 'typeProperties.url', 'type': 'object'},
        'service_principal_id': {'key': 'typeProperties.servicePrincipalId', 'type': 'object'},
        'service_principal_key': {'key': 'typeProperties.servicePrincipalKey', 'type': 'SecretBase'},
        'tenant': {'key': 'typeProperties.tenant', 'type': 'object'},
        'aad_resource_id': {'key': 'typeProperties.aadResourceId', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DynamicsAXLinkedService, self).__init__(**kwargs)
        self.type = 'DynamicsAX'  # type: str
        self.url = kwargs['url']
        self.service_principal_id = kwargs['service_principal_id']
        self.service_principal_key = kwargs['service_principal_key']
        self.tenant = kwargs['tenant']
        self.aad_resource_id = kwargs['aad_resource_id']
        self.encrypted_credential = kwargs.get('encrypted_credential', None)


class DynamicsAXResourceDataset(Dataset):
    """The path of the Dynamics AX OData entity.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param path: Required. The path of the Dynamics AX OData entity. Type: string (or Expression
     with resultType string).
    :type path: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
        'path': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'path': {'key': 'typeProperties.path', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DynamicsAXResourceDataset, self).__init__(**kwargs)
        self.type = 'DynamicsAXResource'  # type: str
        self.path = kwargs['path']


class DynamicsAXSource(TabularSource):
    """A copy activity Dynamics AX source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: object
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param query_timeout: Query timeout. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type query_timeout: object
    :param query: A query to retrieve data from source. Type: string (or Expression with resultType
     string).
    :type query: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'query_timeout': {'key': 'queryTimeout', 'type': 'object'},
        'query': {'key': 'query', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DynamicsAXSource, self).__init__(**kwargs)
        self.type = 'DynamicsAXSource'  # type: str
        self.query = kwargs.get('query', None)


class DynamicsCrmEntityDataset(Dataset):
    """The Dynamics CRM entity dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param entity_name: The logical name of the entity. Type: string (or Expression with resultType
     string).
    :type entity_name: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'entity_name': {'key': 'typeProperties.entityName', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DynamicsCrmEntityDataset, self).__init__(**kwargs)
        self.type = 'DynamicsCrmEntity'  # type: str
        self.entity_name = kwargs.get('entity_name', None)


class DynamicsCrmLinkedService(LinkedService):
    """Dynamics CRM linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param deployment_type: Required. The deployment type of the Dynamics CRM instance. 'Online'
     for Dynamics CRM Online and 'OnPremisesWithIfd' for Dynamics CRM on-premises with Ifd. Type:
     string (or Expression with resultType string). Possible values include: "Online",
     "OnPremisesWithIfd".
    :type deployment_type: str or ~azure.synapse.artifacts.models.DynamicsDeploymentType
    :param host_name: The host name of the on-premises Dynamics CRM server. The property is
     required for on-prem and not allowed for online. Type: string (or Expression with resultType
     string).
    :type host_name: object
    :param port: The port of on-premises Dynamics CRM server. The property is required for on-prem
     and not allowed for online. Default is 443. Type: integer (or Expression with resultType
     integer), minimum: 0.
    :type port: object
    :param service_uri: The URL to the Microsoft Dynamics CRM server. The property is required for
     on-line and not allowed for on-prem. Type: string (or Expression with resultType string).
    :type service_uri: object
    :param organization_name: The organization name of the Dynamics CRM instance. The property is
     required for on-prem and required for online when there are more than one Dynamics CRM
     instances associated with the user. Type: string (or Expression with resultType string).
    :type organization_name: object
    :param authentication_type: Required. The authentication type to connect to Dynamics CRM
     server. 'Office365' for online scenario, 'Ifd' for on-premises with Ifd scenario,
     'AADServicePrincipal' for Server-To-Server authentication in online scenario. Type: string (or
     Expression with resultType string). Possible values include: "Office365", "Ifd",
     "AADServicePrincipal".
    :type authentication_type: str or ~azure.synapse.artifacts.models.DynamicsAuthenticationType
    :param username: User name to access the Dynamics CRM instance. Type: string (or Expression
     with resultType string).
    :type username: object
    :param password: Password to access the Dynamics CRM instance.
    :type password: ~azure.synapse.artifacts.models.SecretBase
    :param service_principal_id: The client ID of the application in Azure Active Directory used
     for Server-To-Server authentication. Type: string (or Expression with resultType string).
    :type service_principal_id: object
    :param service_principal_credential_type: The service principal credential type to use in
     Server-To-Server authentication. 'ServicePrincipalKey' for key/secret, 'ServicePrincipalCert'
     for certificate. Type: string (or Expression with resultType string). Possible values include:
     "ServicePrincipalKey", "ServicePrincipalCert".
    :type service_principal_credential_type: str or
     ~azure.synapse.artifacts.models.DynamicsServicePrincipalCredentialType
    :param service_principal_credential: The credential of the service principal object in Azure
     Active Directory. If servicePrincipalCredentialType is 'ServicePrincipalKey',
     servicePrincipalCredential can be SecureString or AzureKeyVaultSecretReference. If
     servicePrincipalCredentialType is 'ServicePrincipalCert', servicePrincipalCredential can only
     be AzureKeyVaultSecretReference.
    :type service_principal_credential: ~azure.synapse.artifacts.models.SecretBase
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'deployment_type': {'required': True},
        'authentication_type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'deployment_type': {'key': 'typeProperties.deploymentType', 'type': 'str'},
        'host_name': {'key': 'typeProperties.hostName', 'type': 'object'},
        'port': {'key': 'typeProperties.port', 'type': 'object'},
        'service_uri': {'key': 'typeProperties.serviceUri', 'type': 'object'},
        'organization_name': {'key': 'typeProperties.organizationName', 'type': 'object'},
        'authentication_type': {'key': 'typeProperties.authenticationType', 'type': 'str'},
        'username': {'key': 'typeProperties.username', 'type': 'object'},
        'password': {'key': 'typeProperties.password', 'type': 'SecretBase'},
        'service_principal_id': {'key': 'typeProperties.servicePrincipalId', 'type': 'object'},
        'service_principal_credential_type': {'key': 'typeProperties.servicePrincipalCredentialType', 'type': 'str'},
        'service_principal_credential': {'key': 'typeProperties.servicePrincipalCredential', 'type': 'SecretBase'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DynamicsCrmLinkedService, self).__init__(**kwargs)
        self.type = 'DynamicsCrm'  # type: str
        self.deployment_type = kwargs['deployment_type']
        self.host_name = kwargs.get('host_name', None)
        self.port = kwargs.get('port', None)
        self.service_uri = kwargs.get('service_uri', None)
        self.organization_name = kwargs.get('organization_name', None)
        self.authentication_type = kwargs['authentication_type']
        self.username = kwargs.get('username', None)
        self.password = kwargs.get('password', None)
        self.service_principal_id = kwargs.get('service_principal_id', None)
        self.service_principal_credential_type = kwargs.get('service_principal_credential_type', None)
        self.service_principal_credential = kwargs.get('service_principal_credential', None)
        self.encrypted_credential = kwargs.get('encrypted_credential', None)


class DynamicsCrmSink(CopySink):
    """A copy activity Dynamics CRM sink.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy sink type.Constant filled by server.
    :type type: str
    :param write_batch_size: Write batch size. Type: integer (or Expression with resultType
     integer), minimum: 0.
    :type write_batch_size: object
    :param write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type write_batch_timeout: object
    :param sink_retry_count: Sink retry count. Type: integer (or Expression with resultType
     integer).
    :type sink_retry_count: object
    :param sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type sink_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the sink data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param write_behavior: Required. The write behavior for the operation. Possible values include:
     "Upsert".
    :type write_behavior: str or ~azure.synapse.artifacts.models.DynamicsSinkWriteBehavior
    :param ignore_null_values: The flag indicating whether to ignore null values from input dataset
     (except key fields) during write operation. Default is false. Type: boolean (or Expression with
     resultType boolean).
    :type ignore_null_values: object
    :param alternate_key_name: The logical name of the alternate key which will be used when
     upserting records. Type: string (or Expression with resultType string).
    :type alternate_key_name: object
    """

    _validation = {
        'type': {'required': True},
        'write_behavior': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'write_batch_size': {'key': 'writeBatchSize', 'type': 'object'},
        'write_batch_timeout': {'key': 'writeBatchTimeout', 'type': 'object'},
        'sink_retry_count': {'key': 'sinkRetryCount', 'type': 'object'},
        'sink_retry_wait': {'key': 'sinkRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'write_behavior': {'key': 'writeBehavior', 'type': 'str'},
        'ignore_null_values': {'key': 'ignoreNullValues', 'type': 'object'},
        'alternate_key_name': {'key': 'alternateKeyName', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DynamicsCrmSink, self).__init__(**kwargs)
        self.type = 'DynamicsCrmSink'  # type: str
        self.write_behavior = kwargs['write_behavior']
        self.ignore_null_values = kwargs.get('ignore_null_values', None)
        self.alternate_key_name = kwargs.get('alternate_key_name', None)


class DynamicsCrmSource(CopySource):
    """A copy activity Dynamics CRM source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: object
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param query: FetchXML is a proprietary query language that is used in Microsoft Dynamics CRM
     (online & on-premises). Type: string (or Expression with resultType string).
    :type query: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'query': {'key': 'query', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DynamicsCrmSource, self).__init__(**kwargs)
        self.type = 'DynamicsCrmSource'  # type: str
        self.query = kwargs.get('query', None)


class DynamicsEntityDataset(Dataset):
    """The Dynamics entity dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param entity_name: The logical name of the entity. Type: string (or Expression with resultType
     string).
    :type entity_name: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'entity_name': {'key': 'typeProperties.entityName', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DynamicsEntityDataset, self).__init__(**kwargs)
        self.type = 'DynamicsEntity'  # type: str
        self.entity_name = kwargs.get('entity_name', None)


class DynamicsLinkedService(LinkedService):
    """Dynamics linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param deployment_type: Required. The deployment type of the Dynamics instance. 'Online' for
     Dynamics Online and 'OnPremisesWithIfd' for Dynamics on-premises with Ifd. Type: string (or
     Expression with resultType string). Possible values include: "Online", "OnPremisesWithIfd".
    :type deployment_type: str or ~azure.synapse.artifacts.models.DynamicsDeploymentType
    :param host_name: The host name of the on-premises Dynamics server. The property is required
     for on-prem and not allowed for online. Type: string (or Expression with resultType string).
    :type host_name: str
    :param port: The port of on-premises Dynamics server. The property is required for on-prem and
     not allowed for online. Default is 443. Type: integer (or Expression with resultType integer),
     minimum: 0.
    :type port: str
    :param service_uri: The URL to the Microsoft Dynamics server. The property is required for on-
     line and not allowed for on-prem. Type: string (or Expression with resultType string).
    :type service_uri: str
    :param organization_name: The organization name of the Dynamics instance. The property is
     required for on-prem and required for online when there are more than one Dynamics instances
     associated with the user. Type: string (or Expression with resultType string).
    :type organization_name: str
    :param authentication_type: Required. The authentication type to connect to Dynamics server.
     'Office365' for online scenario, 'Ifd' for on-premises with Ifd scenario, 'AADServicePrincipal'
     for Server-To-Server authentication in online scenario. Type: string (or Expression with
     resultType string). Possible values include: "Office365", "Ifd", "AADServicePrincipal".
    :type authentication_type: str or ~azure.synapse.artifacts.models.DynamicsAuthenticationType
    :param username: User name to access the Dynamics instance. Type: string (or Expression with
     resultType string).
    :type username: object
    :param password: Password to access the Dynamics instance.
    :type password: ~azure.synapse.artifacts.models.SecretBase
    :param service_principal_id: The client ID of the application in Azure Active Directory used
     for Server-To-Server authentication. Type: string (or Expression with resultType string).
    :type service_principal_id: object
    :param service_principal_credential_type: The service principal credential type to use in
     Server-To-Server authentication. 'ServicePrincipalKey' for key/secret, 'ServicePrincipalCert'
     for certificate. Type: string (or Expression with resultType string). Possible values include:
     "ServicePrincipalKey", "ServicePrincipalCert".
    :type service_principal_credential_type: str or
     ~azure.synapse.artifacts.models.DynamicsServicePrincipalCredentialType
    :param service_principal_credential: The credential of the service principal object in Azure
     Active Directory. If servicePrincipalCredentialType is 'ServicePrincipalKey',
     servicePrincipalCredential can be SecureString or AzureKeyVaultSecretReference. If
     servicePrincipalCredentialType is 'ServicePrincipalCert', servicePrincipalCredential can only
     be AzureKeyVaultSecretReference.
    :type service_principal_credential: ~azure.synapse.artifacts.models.SecretBase
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'deployment_type': {'required': True},
        'authentication_type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'deployment_type': {'key': 'typeProperties.deploymentType', 'type': 'str'},
        'host_name': {'key': 'typeProperties.hostName', 'type': 'str'},
        'port': {'key': 'typeProperties.port', 'type': 'str'},
        'service_uri': {'key': 'typeProperties.serviceUri', 'type': 'str'},
        'organization_name': {'key': 'typeProperties.organizationName', 'type': 'str'},
        'authentication_type': {'key': 'typeProperties.authenticationType', 'type': 'str'},
        'username': {'key': 'typeProperties.username', 'type': 'object'},
        'password': {'key': 'typeProperties.password', 'type': 'SecretBase'},
        'service_principal_id': {'key': 'typeProperties.servicePrincipalId', 'type': 'object'},
        'service_principal_credential_type': {'key': 'typeProperties.servicePrincipalCredentialType', 'type': 'str'},
        'service_principal_credential': {'key': 'typeProperties.servicePrincipalCredential', 'type': 'SecretBase'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DynamicsLinkedService, self).__init__(**kwargs)
        self.type = 'Dynamics'  # type: str
        self.deployment_type = kwargs['deployment_type']
        self.host_name = kwargs.get('host_name', None)
        self.port = kwargs.get('port', None)
        self.service_uri = kwargs.get('service_uri', None)
        self.organization_name = kwargs.get('organization_name', None)
        self.authentication_type = kwargs['authentication_type']
        self.username = kwargs.get('username', None)
        self.password = kwargs.get('password', None)
        self.service_principal_id = kwargs.get('service_principal_id', None)
        self.service_principal_credential_type = kwargs.get('service_principal_credential_type', None)
        self.service_principal_credential = kwargs.get('service_principal_credential', None)
        self.encrypted_credential = kwargs.get('encrypted_credential', None)


class DynamicsSink(CopySink):
    """A copy activity Dynamics sink.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy sink type.Constant filled by server.
    :type type: str
    :param write_batch_size: Write batch size. Type: integer (or Expression with resultType
     integer), minimum: 0.
    :type write_batch_size: object
    :param write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type write_batch_timeout: object
    :param sink_retry_count: Sink retry count. Type: integer (or Expression with resultType
     integer).
    :type sink_retry_count: object
    :param sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type sink_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the sink data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param write_behavior: Required. The write behavior for the operation. Possible values include:
     "Upsert".
    :type write_behavior: str or ~azure.synapse.artifacts.models.DynamicsSinkWriteBehavior
    :param ignore_null_values: The flag indicating whether ignore null values from input dataset
     (except key fields) during write operation. Default is false. Type: boolean (or Expression with
     resultType boolean).
    :type ignore_null_values: object
    :param alternate_key_name: The logical name of the alternate key which will be used when
     upserting records. Type: string (or Expression with resultType string).
    :type alternate_key_name: object
    """

    _validation = {
        'type': {'required': True},
        'write_behavior': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'write_batch_size': {'key': 'writeBatchSize', 'type': 'object'},
        'write_batch_timeout': {'key': 'writeBatchTimeout', 'type': 'object'},
        'sink_retry_count': {'key': 'sinkRetryCount', 'type': 'object'},
        'sink_retry_wait': {'key': 'sinkRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'write_behavior': {'key': 'writeBehavior', 'type': 'str'},
        'ignore_null_values': {'key': 'ignoreNullValues', 'type': 'object'},
        'alternate_key_name': {'key': 'alternateKeyName', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DynamicsSink, self).__init__(**kwargs)
        self.type = 'DynamicsSink'  # type: str
        self.write_behavior = kwargs['write_behavior']
        self.ignore_null_values = kwargs.get('ignore_null_values', None)
        self.alternate_key_name = kwargs.get('alternate_key_name', None)


class DynamicsSource(CopySource):
    """A copy activity Dynamics source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: object
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param query: FetchXML is a proprietary query language that is used in Microsoft Dynamics
     (online & on-premises). Type: string (or Expression with resultType string).
    :type query: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'query': {'key': 'query', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DynamicsSource, self).__init__(**kwargs)
        self.type = 'DynamicsSource'  # type: str
        self.query = kwargs.get('query', None)


class EloquaLinkedService(LinkedService):
    """Eloqua server linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param endpoint: Required. The endpoint of the Eloqua server. (i.e. eloqua.example.com).
    :type endpoint: object
    :param username: Required. The site name and user name of your Eloqua account in the form:
     sitename/username. (i.e. Eloqua/Alice).
    :type username: object
    :param password: The password corresponding to the user name.
    :type password: ~azure.synapse.artifacts.models.SecretBase
    :param use_encrypted_endpoints: Specifies whether the data source endpoints are encrypted using
     HTTPS. The default value is true.
    :type use_encrypted_endpoints: object
    :param use_host_verification: Specifies whether to require the host name in the server's
     certificate to match the host name of the server when connecting over SSL. The default value is
     true.
    :type use_host_verification: object
    :param use_peer_verification: Specifies whether to verify the identity of the server when
     connecting over SSL. The default value is true.
    :type use_peer_verification: object
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'endpoint': {'required': True},
        'username': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'endpoint': {'key': 'typeProperties.endpoint', 'type': 'object'},
        'username': {'key': 'typeProperties.username', 'type': 'object'},
        'password': {'key': 'typeProperties.password', 'type': 'SecretBase'},
        'use_encrypted_endpoints': {'key': 'typeProperties.useEncryptedEndpoints', 'type': 'object'},
        'use_host_verification': {'key': 'typeProperties.useHostVerification', 'type': 'object'},
        'use_peer_verification': {'key': 'typeProperties.usePeerVerification', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EloquaLinkedService, self).__init__(**kwargs)
        self.type = 'Eloqua'  # type: str
        self.endpoint = kwargs['endpoint']
        self.username = kwargs['username']
        self.password = kwargs.get('password', None)
        self.use_encrypted_endpoints = kwargs.get('use_encrypted_endpoints', None)
        self.use_host_verification = kwargs.get('use_host_verification', None)
        self.use_peer_verification = kwargs.get('use_peer_verification', None)
        self.encrypted_credential = kwargs.get('encrypted_credential', None)


class EloquaObjectDataset(Dataset):
    """Eloqua server dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param table_name: The table name. Type: string (or Expression with resultType string).
    :type table_name: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table_name': {'key': 'typeProperties.tableName', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EloquaObjectDataset, self).__init__(**kwargs)
        self.type = 'EloquaObject'  # type: str
        self.table_name = kwargs.get('table_name', None)


class EloquaSource(TabularSource):
    """A copy activity Eloqua server source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: object
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param query_timeout: Query timeout. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type query_timeout: object
    :param query: A query to retrieve data from source. Type: string (or Expression with resultType
     string).
    :type query: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'query_timeout': {'key': 'queryTimeout', 'type': 'object'},
        'query': {'key': 'query', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EloquaSource, self).__init__(**kwargs)
        self.type = 'EloquaSource'  # type: str
        self.query = kwargs.get('query', None)


class EntityReference(msrest.serialization.Model):
    """The entity reference.

    :param type: The type of this referenced entity. Possible values include:
     "IntegrationRuntimeReference", "LinkedServiceReference".
    :type type: str or ~azure.synapse.artifacts.models.IntegrationRuntimeEntityReferenceType
    :param reference_name: The name of this referenced entity.
    :type reference_name: str
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'reference_name': {'key': 'referenceName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EntityReference, self).__init__(**kwargs)
        self.type = kwargs.get('type', None)
        self.reference_name = kwargs.get('reference_name', None)


class ErrorAdditionalInfo(msrest.serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: object
    """

    _validation = {
        'type': {'readonly': True},
        'info': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'info': {'key': 'info', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorAdditionalInfo, self).__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorContract(msrest.serialization.Model):
    """Contains details when the response code indicates an error.

    :param error: The error details.
    :type error: ~azure.synapse.artifacts.models.ErrorResponse
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'ErrorResponse'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorContract, self).__init__(**kwargs)
        self.error = kwargs.get('error', None)


class ErrorResponse(msrest.serialization.Model):
    """The resource management error response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.synapse.artifacts.models.ErrorResponse]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.synapse.artifacts.models.ErrorAdditionalInfo]
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
        'target': {'readonly': True},
        'details': {'readonly': True},
        'additional_info': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[ErrorResponse]'},
        'additional_info': {'key': 'additionalInfo', 'type': '[ErrorAdditionalInfo]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorResponse, self).__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class EvaluateDataFlowExpressionRequest(msrest.serialization.Model):
    """Request body structure for data flow expression preview.

    :param session_id: The ID of data flow debug session.
    :type session_id: str
    :param data_flow_name: The data flow which contains the debug session.
    :type data_flow_name: str
    :param stream_name: The output stream name.
    :type stream_name: str
    :param row_limits: The row limit for preview request.
    :type row_limits: int
    :param expression: The expression for preview.
    :type expression: str
    """

    _attribute_map = {
        'session_id': {'key': 'sessionId', 'type': 'str'},
        'data_flow_name': {'key': 'dataFlowName', 'type': 'str'},
        'stream_name': {'key': 'streamName', 'type': 'str'},
        'row_limits': {'key': 'rowLimits', 'type': 'int'},
        'expression': {'key': 'expression', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EvaluateDataFlowExpressionRequest, self).__init__(**kwargs)
        self.session_id = kwargs.get('session_id', None)
        self.data_flow_name = kwargs.get('data_flow_name', None)
        self.stream_name = kwargs.get('stream_name', None)
        self.row_limits = kwargs.get('row_limits', None)
        self.expression = kwargs.get('expression', None)


class ExecuteDataFlowActivity(ExecutionActivity):
    """Execute data flow activity.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param name: Required. Activity name.
    :type name: str
    :param type: Required. Type of activity.Constant filled by server.
    :type type: str
    :param description: Activity description.
    :type description: str
    :param depends_on: Activity depends on condition.
    :type depends_on: list[~azure.synapse.artifacts.models.ActivityDependency]
    :param user_properties: Activity user properties.
    :type user_properties: list[~azure.synapse.artifacts.models.UserProperty]
    :param linked_service_name: Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param policy: Activity policy.
    :type policy: ~azure.synapse.artifacts.models.ActivityPolicy
    :param data_flow: Required. Data flow reference.
    :type data_flow: ~azure.synapse.artifacts.models.DataFlowReference
    :param staging: Staging info for execute data flow activity.
    :type staging: ~azure.synapse.artifacts.models.DataFlowStagingInfo
    :param integration_runtime: The integration runtime reference.
    :type integration_runtime: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param compute: Compute properties for data flow activity.
    :type compute: ~azure.synapse.artifacts.models.ExecuteDataFlowActivityTypePropertiesCompute
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
        'data_flow': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'depends_on': {'key': 'dependsOn', 'type': '[ActivityDependency]'},
        'user_properties': {'key': 'userProperties', 'type': '[UserProperty]'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'policy': {'key': 'policy', 'type': 'ActivityPolicy'},
        'data_flow': {'key': 'typeProperties.dataFlow', 'type': 'DataFlowReference'},
        'staging': {'key': 'typeProperties.staging', 'type': 'DataFlowStagingInfo'},
        'integration_runtime': {'key': 'typeProperties.integrationRuntime', 'type': 'IntegrationRuntimeReference'},
        'compute': {'key': 'typeProperties.compute', 'type': 'ExecuteDataFlowActivityTypePropertiesCompute'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ExecuteDataFlowActivity, self).__init__(**kwargs)
        self.type = 'ExecuteDataFlow'  # type: str
        self.data_flow = kwargs['data_flow']
        self.staging = kwargs.get('staging', None)
        self.integration_runtime = kwargs.get('integration_runtime', None)
        self.compute = kwargs.get('compute', None)


class ExecuteDataFlowActivityTypePropertiesCompute(msrest.serialization.Model):
    """Compute properties for data flow activity.

    :param compute_type: Compute type of the cluster which will execute data flow job. Possible
     values include: "General", "MemoryOptimized", "ComputeOptimized".
    :type compute_type: str or ~azure.synapse.artifacts.models.DataFlowComputeType
    :param core_count: Core count of the cluster which will execute data flow job. Supported values
     are: 8, 16, 32, 48, 80, 144 and 272.
    :type core_count: int
    """

    _attribute_map = {
        'compute_type': {'key': 'computeType', 'type': 'str'},
        'core_count': {'key': 'coreCount', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ExecuteDataFlowActivityTypePropertiesCompute, self).__init__(**kwargs)
        self.compute_type = kwargs.get('compute_type', None)
        self.core_count = kwargs.get('core_count', None)


class ExecutePipelineActivity(Activity):
    """Execute pipeline activity.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param name: Required. Activity name.
    :type name: str
    :param type: Required. Type of activity.Constant filled by server.
    :type type: str
    :param description: Activity description.
    :type description: str
    :param depends_on: Activity depends on condition.
    :type depends_on: list[~azure.synapse.artifacts.models.ActivityDependency]
    :param user_properties: Activity user properties.
    :type user_properties: list[~azure.synapse.artifacts.models.UserProperty]
    :param pipeline: Required. Pipeline reference.
    :type pipeline: ~azure.synapse.artifacts.models.PipelineReference
    :param parameters: Pipeline parameters.
    :type parameters: dict[str, object]
    :param wait_on_completion: Defines whether activity execution will wait for the dependent
     pipeline execution to finish. Default is false.
    :type wait_on_completion: bool
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
        'pipeline': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'depends_on': {'key': 'dependsOn', 'type': '[ActivityDependency]'},
        'user_properties': {'key': 'userProperties', 'type': '[UserProperty]'},
        'pipeline': {'key': 'typeProperties.pipeline', 'type': 'PipelineReference'},
        'parameters': {'key': 'typeProperties.parameters', 'type': '{object}'},
        'wait_on_completion': {'key': 'typeProperties.waitOnCompletion', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ExecutePipelineActivity, self).__init__(**kwargs)
        self.type = 'ExecutePipeline'  # type: str
        self.pipeline = kwargs['pipeline']
        self.parameters = kwargs.get('parameters', None)
        self.wait_on_completion = kwargs.get('wait_on_completion', None)


class ExecuteSSISPackageActivity(ExecutionActivity):
    """Execute SSIS package activity.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param name: Required. Activity name.
    :type name: str
    :param type: Required. Type of activity.Constant filled by server.
    :type type: str
    :param description: Activity description.
    :type description: str
    :param depends_on: Activity depends on condition.
    :type depends_on: list[~azure.synapse.artifacts.models.ActivityDependency]
    :param user_properties: Activity user properties.
    :type user_properties: list[~azure.synapse.artifacts.models.UserProperty]
    :param linked_service_name: Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param policy: Activity policy.
    :type policy: ~azure.synapse.artifacts.models.ActivityPolicy
    :param package_location: Required. SSIS package location.
    :type package_location: ~azure.synapse.artifacts.models.SSISPackageLocation
    :param runtime: Specifies the runtime to execute SSIS package. The value should be "x86" or
     "x64". Type: string (or Expression with resultType string).
    :type runtime: object
    :param logging_level: The logging level of SSIS package execution. Type: string (or Expression
     with resultType string).
    :type logging_level: object
    :param environment_path: The environment path to execute the SSIS package. Type: string (or
     Expression with resultType string).
    :type environment_path: object
    :param execution_credential: The package execution credential.
    :type execution_credential: ~azure.synapse.artifacts.models.SSISExecutionCredential
    :param connect_via: Required. The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param project_parameters: The project level parameters to execute the SSIS package.
    :type project_parameters: dict[str, ~azure.synapse.artifacts.models.SSISExecutionParameter]
    :param package_parameters: The package level parameters to execute the SSIS package.
    :type package_parameters: dict[str, ~azure.synapse.artifacts.models.SSISExecutionParameter]
    :param project_connection_managers: The project level connection managers to execute the SSIS
     package.
    :type project_connection_managers: dict[str, object]
    :param package_connection_managers: The package level connection managers to execute the SSIS
     package.
    :type package_connection_managers: dict[str, object]
    :param property_overrides: The property overrides to execute the SSIS package.
    :type property_overrides: dict[str, ~azure.synapse.artifacts.models.SSISPropertyOverride]
    :param log_location: SSIS package execution log location.
    :type log_location: ~azure.synapse.artifacts.models.SSISLogLocation
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
        'package_location': {'required': True},
        'connect_via': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'depends_on': {'key': 'dependsOn', 'type': '[ActivityDependency]'},
        'user_properties': {'key': 'userProperties', 'type': '[UserProperty]'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'policy': {'key': 'policy', 'type': 'ActivityPolicy'},
        'package_location': {'key': 'typeProperties.packageLocation', 'type': 'SSISPackageLocation'},
        'runtime': {'key': 'typeProperties.runtime', 'type': 'object'},
        'logging_level': {'key': 'typeProperties.loggingLevel', 'type': 'object'},
        'environment_path': {'key': 'typeProperties.environmentPath', 'type': 'object'},
        'execution_credential': {'key': 'typeProperties.executionCredential', 'type': 'SSISExecutionCredential'},
        'connect_via': {'key': 'typeProperties.connectVia', 'type': 'IntegrationRuntimeReference'},
        'project_parameters': {'key': 'typeProperties.projectParameters', 'type': '{SSISExecutionParameter}'},
        'package_parameters': {'key': 'typeProperties.packageParameters', 'type': '{SSISExecutionParameter}'},
        'project_connection_managers': {'key': 'typeProperties.projectConnectionManagers', 'type': '{object}'},
        'package_connection_managers': {'key': 'typeProperties.packageConnectionManagers', 'type': '{object}'},
        'property_overrides': {'key': 'typeProperties.propertyOverrides', 'type': '{SSISPropertyOverride}'},
        'log_location': {'key': 'typeProperties.logLocation', 'type': 'SSISLogLocation'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ExecuteSSISPackageActivity, self).__init__(**kwargs)
        self.type = 'ExecuteSSISPackage'  # type: str
        self.package_location = kwargs['package_location']
        self.runtime = kwargs.get('runtime', None)
        self.logging_level = kwargs.get('logging_level', None)
        self.environment_path = kwargs.get('environment_path', None)
        self.execution_credential = kwargs.get('execution_credential', None)
        self.connect_via = kwargs['connect_via']
        self.project_parameters = kwargs.get('project_parameters', None)
        self.package_parameters = kwargs.get('package_parameters', None)
        self.project_connection_managers = kwargs.get('project_connection_managers', None)
        self.package_connection_managers = kwargs.get('package_connection_managers', None)
        self.property_overrides = kwargs.get('property_overrides', None)
        self.log_location = kwargs.get('log_location', None)


class ExposureControlRequest(msrest.serialization.Model):
    """The exposure control request.

    :param feature_name: The feature name.
    :type feature_name: str
    :param feature_type: The feature type.
    :type feature_type: str
    """

    _attribute_map = {
        'feature_name': {'key': 'featureName', 'type': 'str'},
        'feature_type': {'key': 'featureType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ExposureControlRequest, self).__init__(**kwargs)
        self.feature_name = kwargs.get('feature_name', None)
        self.feature_type = kwargs.get('feature_type', None)


class ExposureControlResponse(msrest.serialization.Model):
    """The exposure control response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar feature_name: The feature name.
    :vartype feature_name: str
    :ivar value: The feature value.
    :vartype value: str
    """

    _validation = {
        'feature_name': {'readonly': True},
        'value': {'readonly': True},
    }

    _attribute_map = {
        'feature_name': {'key': 'featureName', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ExposureControlResponse, self).__init__(**kwargs)
        self.feature_name = None
        self.value = None


class Expression(msrest.serialization.Model):
    """Azure Synapse expression definition.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Expression type. Possible values include: "Expression".
    :type type: str or ~azure.synapse.artifacts.models.ExpressionType
    :param value: Required. Expression value.
    :type value: str
    """

    _validation = {
        'type': {'required': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Expression, self).__init__(**kwargs)
        self.type = kwargs['type']
        self.value = kwargs['value']


class FileServerLinkedService(LinkedService):
    """File system linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param host: Required. Host name of the server. Type: string (or Expression with resultType
     string).
    :type host: object
    :param user_id: User ID to logon the server. Type: string (or Expression with resultType
     string).
    :type user_id: object
    :param password: Password to logon the server.
    :type password: ~azure.synapse.artifacts.models.SecretBase
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'host': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'host': {'key': 'typeProperties.host', 'type': 'object'},
        'user_id': {'key': 'typeProperties.userId', 'type': 'object'},
        'password': {'key': 'typeProperties.password', 'type': 'SecretBase'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FileServerLinkedService, self).__init__(**kwargs)
        self.type = 'FileServer'  # type: str
        self.host = kwargs['host']
        self.user_id = kwargs.get('user_id', None)
        self.password = kwargs.get('password', None)
        self.encrypted_credential = kwargs.get('encrypted_credential', None)


class FileServerLocation(DatasetLocation):
    """The location of file server dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset storage location.Constant filled by server.
    :type type: str
    :param folder_path: Specify the folder path of dataset. Type: string (or Expression with
     resultType string).
    :type folder_path: object
    :param file_name: Specify the file name of dataset. Type: string (or Expression with resultType
     string).
    :type file_name: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'folder_path': {'key': 'folderPath', 'type': 'object'},
        'file_name': {'key': 'fileName', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FileServerLocation, self).__init__(**kwargs)
        self.type = 'FileServerLocation'  # type: str


class FileServerReadSettings(StoreReadSettings):
    """File server read settings.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. The read setting type.Constant filled by server.
    :type type: str
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param recursive: If true, files under the folder path will be read recursively. Default is
     true. Type: boolean (or Expression with resultType boolean).
    :type recursive: object
    :param wildcard_folder_path: FileServer wildcardFolderPath. Type: string (or Expression with
     resultType string).
    :type wildcard_folder_path: object
    :param wildcard_file_name: FileServer wildcardFileName. Type: string (or Expression with
     resultType string).
    :type wildcard_file_name: object
    :param enable_partition_discovery: Indicates whether to enable partition discovery.
    :type enable_partition_discovery: bool
    :param modified_datetime_start: The start of file's modified datetime. Type: string (or
     Expression with resultType string).
    :type modified_datetime_start: object
    :param modified_datetime_end: The end of file's modified datetime. Type: string (or Expression
     with resultType string).
    :type modified_datetime_end: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'recursive': {'key': 'recursive', 'type': 'object'},
        'wildcard_folder_path': {'key': 'wildcardFolderPath', 'type': 'object'},
        'wildcard_file_name': {'key': 'wildcardFileName', 'type': 'object'},
        'enable_partition_discovery': {'key': 'enablePartitionDiscovery', 'type': 'bool'},
        'modified_datetime_start': {'key': 'modifiedDatetimeStart', 'type': 'object'},
        'modified_datetime_end': {'key': 'modifiedDatetimeEnd', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FileServerReadSettings, self).__init__(**kwargs)
        self.type = 'FileServerReadSettings'  # type: str
        self.recursive = kwargs.get('recursive', None)
        self.wildcard_folder_path = kwargs.get('wildcard_folder_path', None)
        self.wildcard_file_name = kwargs.get('wildcard_file_name', None)
        self.enable_partition_discovery = kwargs.get('enable_partition_discovery', None)
        self.modified_datetime_start = kwargs.get('modified_datetime_start', None)
        self.modified_datetime_end = kwargs.get('modified_datetime_end', None)


class FileServerWriteSettings(StoreWriteSettings):
    """File server write settings.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. The write setting type.Constant filled by server.
    :type type: str
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param copy_behavior: The type of copy behavior for copy sink.
    :type copy_behavior: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'copy_behavior': {'key': 'copyBehavior', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FileServerWriteSettings, self).__init__(**kwargs)
        self.type = 'FileServerWriteSettings'  # type: str


class FileSystemSink(CopySink):
    """A copy activity file system sink.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy sink type.Constant filled by server.
    :type type: str
    :param write_batch_size: Write batch size. Type: integer (or Expression with resultType
     integer), minimum: 0.
    :type write_batch_size: object
    :param write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type write_batch_timeout: object
    :param sink_retry_count: Sink retry count. Type: integer (or Expression with resultType
     integer).
    :type sink_retry_count: object
    :param sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type sink_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the sink data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param copy_behavior: The type of copy behavior for copy sink.
    :type copy_behavior: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'write_batch_size': {'key': 'writeBatchSize', 'type': 'object'},
        'write_batch_timeout': {'key': 'writeBatchTimeout', 'type': 'object'},
        'sink_retry_count': {'key': 'sinkRetryCount', 'type': 'object'},
        'sink_retry_wait': {'key': 'sinkRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'copy_behavior': {'key': 'copyBehavior', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FileSystemSink, self).__init__(**kwargs)
        self.type = 'FileSystemSink'  # type: str
        self.copy_behavior = kwargs.get('copy_behavior', None)


class FileSystemSource(CopySource):
    """A copy activity file system source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: object
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param recursive: If true, files under the folder path will be read recursively. Default is
     true. Type: boolean (or Expression with resultType boolean).
    :type recursive: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'recursive': {'key': 'recursive', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FileSystemSource, self).__init__(**kwargs)
        self.type = 'FileSystemSource'  # type: str
        self.recursive = kwargs.get('recursive', None)


class FilterActivity(Activity):
    """Filter and return results from input array based on the conditions.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param name: Required. Activity name.
    :type name: str
    :param type: Required. Type of activity.Constant filled by server.
    :type type: str
    :param description: Activity description.
    :type description: str
    :param depends_on: Activity depends on condition.
    :type depends_on: list[~azure.synapse.artifacts.models.ActivityDependency]
    :param user_properties: Activity user properties.
    :type user_properties: list[~azure.synapse.artifacts.models.UserProperty]
    :param items: Required. Input array on which filter should be applied.
    :type items: ~azure.synapse.artifacts.models.Expression
    :param condition: Required. Condition to be used for filtering the input.
    :type condition: ~azure.synapse.artifacts.models.Expression
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
        'items': {'required': True},
        'condition': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'depends_on': {'key': 'dependsOn', 'type': '[ActivityDependency]'},
        'user_properties': {'key': 'userProperties', 'type': '[UserProperty]'},
        'items': {'key': 'typeProperties.items', 'type': 'Expression'},
        'condition': {'key': 'typeProperties.condition', 'type': 'Expression'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FilterActivity, self).__init__(**kwargs)
        self.type = 'Filter'  # type: str
        self.items = kwargs['items']
        self.condition = kwargs['condition']


class ForEachActivity(Activity):
    """This activity is used for iterating over a collection and execute given activities.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param name: Required. Activity name.
    :type name: str
    :param type: Required. Type of activity.Constant filled by server.
    :type type: str
    :param description: Activity description.
    :type description: str
    :param depends_on: Activity depends on condition.
    :type depends_on: list[~azure.synapse.artifacts.models.ActivityDependency]
    :param user_properties: Activity user properties.
    :type user_properties: list[~azure.synapse.artifacts.models.UserProperty]
    :param is_sequential: Should the loop be executed in sequence or in parallel (max 50).
    :type is_sequential: bool
    :param batch_count: Batch count to be used for controlling the number of parallel execution
     (when isSequential is set to false).
    :type batch_count: int
    :param items: Required. Collection to iterate.
    :type items: ~azure.synapse.artifacts.models.Expression
    :param activities: Required. List of activities to execute .
    :type activities: list[~azure.synapse.artifacts.models.Activity]
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
        'batch_count': {'maximum': 50},
        'items': {'required': True},
        'activities': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'depends_on': {'key': 'dependsOn', 'type': '[ActivityDependency]'},
        'user_properties': {'key': 'userProperties', 'type': '[UserProperty]'},
        'is_sequential': {'key': 'typeProperties.isSequential', 'type': 'bool'},
        'batch_count': {'key': 'typeProperties.batchCount', 'type': 'int'},
        'items': {'key': 'typeProperties.items', 'type': 'Expression'},
        'activities': {'key': 'typeProperties.activities', 'type': '[Activity]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ForEachActivity, self).__init__(**kwargs)
        self.type = 'ForEach'  # type: str
        self.is_sequential = kwargs.get('is_sequential', None)
        self.batch_count = kwargs.get('batch_count', None)
        self.items = kwargs['items']
        self.activities = kwargs['activities']


class FtpReadSettings(StoreReadSettings):
    """Ftp read settings.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. The read setting type.Constant filled by server.
    :type type: str
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param recursive: If true, files under the folder path will be read recursively. Default is
     true. Type: boolean (or Expression with resultType boolean).
    :type recursive: object
    :param wildcard_folder_path: Ftp wildcardFolderPath. Type: string (or Expression with
     resultType string).
    :type wildcard_folder_path: object
    :param wildcard_file_name: Ftp wildcardFileName. Type: string (or Expression with resultType
     string).
    :type wildcard_file_name: object
    :param use_binary_transfer: Specify whether to use binary transfer mode for FTP stores.
    :type use_binary_transfer: bool
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'recursive': {'key': 'recursive', 'type': 'object'},
        'wildcard_folder_path': {'key': 'wildcardFolderPath', 'type': 'object'},
        'wildcard_file_name': {'key': 'wildcardFileName', 'type': 'object'},
        'use_binary_transfer': {'key': 'useBinaryTransfer', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FtpReadSettings, self).__init__(**kwargs)
        self.type = 'FtpReadSettings'  # type: str
        self.recursive = kwargs.get('recursive', None)
        self.wildcard_folder_path = kwargs.get('wildcard_folder_path', None)
        self.wildcard_file_name = kwargs.get('wildcard_file_name', None)
        self.use_binary_transfer = kwargs.get('use_binary_transfer', None)


class FtpServerLinkedService(LinkedService):
    """A FTP server Linked Service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param host: Required. Host name of the FTP server. Type: string (or Expression with resultType
     string).
    :type host: object
    :param port: The TCP port number that the FTP server uses to listen for client connections.
     Default value is 21. Type: integer (or Expression with resultType integer), minimum: 0.
    :type port: object
    :param authentication_type: The authentication type to be used to connect to the FTP server.
     Possible values include: "Basic", "Anonymous".
    :type authentication_type: str or ~azure.synapse.artifacts.models.FtpAuthenticationType
    :param user_name: Username to logon the FTP server. Type: string (or Expression with resultType
     string).
    :type user_name: object
    :param password: Password to logon the FTP server.
    :type password: ~azure.synapse.artifacts.models.SecretBase
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    :param enable_ssl: If true, connect to the FTP server over SSL/TLS channel. Default value is
     true. Type: boolean (or Expression with resultType boolean).
    :type enable_ssl: object
    :param enable_server_certificate_validation: If true, validate the FTP server SSL certificate
     when connect over SSL/TLS channel. Default value is true. Type: boolean (or Expression with
     resultType boolean).
    :type enable_server_certificate_validation: object
    """

    _validation = {
        'type': {'required': True},
        'host': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'host': {'key': 'typeProperties.host', 'type': 'object'},
        'port': {'key': 'typeProperties.port', 'type': 'object'},
        'authentication_type': {'key': 'typeProperties.authenticationType', 'type': 'str'},
        'user_name': {'key': 'typeProperties.userName', 'type': 'object'},
        'password': {'key': 'typeProperties.password', 'type': 'SecretBase'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
        'enable_ssl': {'key': 'typeProperties.enableSsl', 'type': 'object'},
        'enable_server_certificate_validation': {'key': 'typeProperties.enableServerCertificateValidation', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FtpServerLinkedService, self).__init__(**kwargs)
        self.type = 'FtpServer'  # type: str
        self.host = kwargs['host']
        self.port = kwargs.get('port', None)
        self.authentication_type = kwargs.get('authentication_type', None)
        self.user_name = kwargs.get('user_name', None)
        self.password = kwargs.get('password', None)
        self.encrypted_credential = kwargs.get('encrypted_credential', None)
        self.enable_ssl = kwargs.get('enable_ssl', None)
        self.enable_server_certificate_validation = kwargs.get('enable_server_certificate_validation', None)


class FtpServerLocation(DatasetLocation):
    """The location of ftp server dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset storage location.Constant filled by server.
    :type type: str
    :param folder_path: Specify the folder path of dataset. Type: string (or Expression with
     resultType string).
    :type folder_path: object
    :param file_name: Specify the file name of dataset. Type: string (or Expression with resultType
     string).
    :type file_name: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'folder_path': {'key': 'folderPath', 'type': 'object'},
        'file_name': {'key': 'fileName', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FtpServerLocation, self).__init__(**kwargs)
        self.type = 'FtpServerLocation'  # type: str


class GetMetadataActivity(ExecutionActivity):
    """Activity to get metadata of dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param name: Required. Activity name.
    :type name: str
    :param type: Required. Type of activity.Constant filled by server.
    :type type: str
    :param description: Activity description.
    :type description: str
    :param depends_on: Activity depends on condition.
    :type depends_on: list[~azure.synapse.artifacts.models.ActivityDependency]
    :param user_properties: Activity user properties.
    :type user_properties: list[~azure.synapse.artifacts.models.UserProperty]
    :param linked_service_name: Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param policy: Activity policy.
    :type policy: ~azure.synapse.artifacts.models.ActivityPolicy
    :param dataset: Required. GetMetadata activity dataset reference.
    :type dataset: ~azure.synapse.artifacts.models.DatasetReference
    :param field_list: Fields of metadata to get from dataset.
    :type field_list: list[object]
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
        'dataset': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'depends_on': {'key': 'dependsOn', 'type': '[ActivityDependency]'},
        'user_properties': {'key': 'userProperties', 'type': '[UserProperty]'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'policy': {'key': 'policy', 'type': 'ActivityPolicy'},
        'dataset': {'key': 'typeProperties.dataset', 'type': 'DatasetReference'},
        'field_list': {'key': 'typeProperties.fieldList', 'type': '[object]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(GetMetadataActivity, self).__init__(**kwargs)
        self.type = 'GetMetadata'  # type: str
        self.dataset = kwargs['dataset']
        self.field_list = kwargs.get('field_list', None)


class GetSsisObjectMetadataRequest(msrest.serialization.Model):
    """The request payload of get SSIS object metadata.

    :param metadata_path: Metadata path.
    :type metadata_path: str
    """

    _attribute_map = {
        'metadata_path': {'key': 'metadataPath', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(GetSsisObjectMetadataRequest, self).__init__(**kwargs)
        self.metadata_path = kwargs.get('metadata_path', None)


class GoogleAdWordsLinkedService(LinkedService):
    """Google AdWords service linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param client_customer_id: Required. The Client customer ID of the AdWords account that you
     want to fetch report data for.
    :type client_customer_id: object
    :param developer_token: Required. The developer token associated with the manager account that
     you use to grant access to the AdWords API.
    :type developer_token: ~azure.synapse.artifacts.models.SecretBase
    :param authentication_type: Required. The OAuth 2.0 authentication mechanism used for
     authentication. ServiceAuthentication can only be used on self-hosted IR. Possible values
     include: "ServiceAuthentication", "UserAuthentication".
    :type authentication_type: str or
     ~azure.synapse.artifacts.models.GoogleAdWordsAuthenticationType
    :param refresh_token: The refresh token obtained from Google for authorizing access to AdWords
     for UserAuthentication.
    :type refresh_token: ~azure.synapse.artifacts.models.SecretBase
    :param client_id: The client id of the google application used to acquire the refresh token.
     Type: string (or Expression with resultType string).
    :type client_id: object
    :param client_secret: The client secret of the google application used to acquire the refresh
     token.
    :type client_secret: ~azure.synapse.artifacts.models.SecretBase
    :param email: The service account email ID that is used for ServiceAuthentication and can only
     be used on self-hosted IR.
    :type email: object
    :param key_file_path: The full path to the .p12 key file that is used to authenticate the
     service account email address and can only be used on self-hosted IR.
    :type key_file_path: object
    :param trusted_cert_path: The full path of the .pem file containing trusted CA certificates for
     verifying the server when connecting over SSL. This property can only be set when using SSL on
     self-hosted IR. The default value is the cacerts.pem file installed with the IR.
    :type trusted_cert_path: object
    :param use_system_trust_store: Specifies whether to use a CA certificate from the system trust
     store or from a specified PEM file. The default value is false.
    :type use_system_trust_store: object
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'client_customer_id': {'required': True},
        'developer_token': {'required': True},
        'authentication_type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'client_customer_id': {'key': 'typeProperties.clientCustomerID', 'type': 'object'},
        'developer_token': {'key': 'typeProperties.developerToken', 'type': 'SecretBase'},
        'authentication_type': {'key': 'typeProperties.authenticationType', 'type': 'str'},
        'refresh_token': {'key': 'typeProperties.refreshToken', 'type': 'SecretBase'},
        'client_id': {'key': 'typeProperties.clientId', 'type': 'object'},
        'client_secret': {'key': 'typeProperties.clientSecret', 'type': 'SecretBase'},
        'email': {'key': 'typeProperties.email', 'type': 'object'},
        'key_file_path': {'key': 'typeProperties.keyFilePath', 'type': 'object'},
        'trusted_cert_path': {'key': 'typeProperties.trustedCertPath', 'type': 'object'},
        'use_system_trust_store': {'key': 'typeProperties.useSystemTrustStore', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(GoogleAdWordsLinkedService, self).__init__(**kwargs)
        self.type = 'GoogleAdWords'  # type: str
        self.client_customer_id = kwargs['client_customer_id']
        self.developer_token = kwargs['developer_token']
        self.authentication_type = kwargs['authentication_type']
        self.refresh_token = kwargs.get('refresh_token', None)
        self.client_id = kwargs.get('client_id', None)
        self.client_secret = kwargs.get('client_secret', None)
        self.email = kwargs.get('email', None)
        self.key_file_path = kwargs.get('key_file_path', None)
        self.trusted_cert_path = kwargs.get('trusted_cert_path', None)
        self.use_system_trust_store = kwargs.get('use_system_trust_store', None)
        self.encrypted_credential = kwargs.get('encrypted_credential', None)


class GoogleAdWordsObjectDataset(Dataset):
    """Google AdWords service dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param table_name: The table name. Type: string (or Expression with resultType string).
    :type table_name: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table_name': {'key': 'typeProperties.tableName', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(GoogleAdWordsObjectDataset, self).__init__(**kwargs)
        self.type = 'GoogleAdWordsObject'  # type: str
        self.table_name = kwargs.get('table_name', None)


class GoogleAdWordsSource(TabularSource):
    """A copy activity Google AdWords service source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: object
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param query_timeout: Query timeout. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type query_timeout: object
    :param query: A query to retrieve data from source. Type: string (or Expression with resultType
     string).
    :type query: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'query_timeout': {'key': 'queryTimeout', 'type': 'object'},
        'query': {'key': 'query', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(GoogleAdWordsSource, self).__init__(**kwargs)
        self.type = 'GoogleAdWordsSource'  # type: str
        self.query = kwargs.get('query', None)


class GoogleBigQueryLinkedService(LinkedService):
    """Google BigQuery service linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param project: Required. The default BigQuery project to query against.
    :type project: object
    :param additional_projects: A comma-separated list of public BigQuery projects to access.
    :type additional_projects: object
    :param request_google_drive_scope: Whether to request access to Google Drive. Allowing Google
     Drive access enables support for federated tables that combine BigQuery data with data from
     Google Drive. The default value is false.
    :type request_google_drive_scope: object
    :param authentication_type: Required. The OAuth 2.0 authentication mechanism used for
     authentication. ServiceAuthentication can only be used on self-hosted IR. Possible values
     include: "ServiceAuthentication", "UserAuthentication".
    :type authentication_type: str or
     ~azure.synapse.artifacts.models.GoogleBigQueryAuthenticationType
    :param refresh_token: The refresh token obtained from Google for authorizing access to BigQuery
     for UserAuthentication.
    :type refresh_token: ~azure.synapse.artifacts.models.SecretBase
    :param client_id: The client id of the google application used to acquire the refresh token.
     Type: string (or Expression with resultType string).
    :type client_id: object
    :param client_secret: The client secret of the google application used to acquire the refresh
     token.
    :type client_secret: ~azure.synapse.artifacts.models.SecretBase
    :param email: The service account email ID that is used for ServiceAuthentication and can only
     be used on self-hosted IR.
    :type email: object
    :param key_file_path: The full path to the .p12 key file that is used to authenticate the
     service account email address and can only be used on self-hosted IR.
    :type key_file_path: object
    :param trusted_cert_path: The full path of the .pem file containing trusted CA certificates for
     verifying the server when connecting over SSL. This property can only be set when using SSL on
     self-hosted IR. The default value is the cacerts.pem file installed with the IR.
    :type trusted_cert_path: object
    :param use_system_trust_store: Specifies whether to use a CA certificate from the system trust
     store or from a specified PEM file. The default value is false.
    :type use_system_trust_store: object
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'project': {'required': True},
        'authentication_type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'project': {'key': 'typeProperties.project', 'type': 'object'},
        'additional_projects': {'key': 'typeProperties.additionalProjects', 'type': 'object'},
        'request_google_drive_scope': {'key': 'typeProperties.requestGoogleDriveScope', 'type': 'object'},
        'authentication_type': {'key': 'typeProperties.authenticationType', 'type': 'str'},
        'refresh_token': {'key': 'typeProperties.refreshToken', 'type': 'SecretBase'},
        'client_id': {'key': 'typeProperties.clientId', 'type': 'object'},
        'client_secret': {'key': 'typeProperties.clientSecret', 'type': 'SecretBase'},
        'email': {'key': 'typeProperties.email', 'type': 'object'},
        'key_file_path': {'key': 'typeProperties.keyFilePath', 'type': 'object'},
        'trusted_cert_path': {'key': 'typeProperties.trustedCertPath', 'type': 'object'},
        'use_system_trust_store': {'key': 'typeProperties.useSystemTrustStore', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(GoogleBigQueryLinkedService, self).__init__(**kwargs)
        self.type = 'GoogleBigQuery'  # type: str
        self.project = kwargs['project']
        self.additional_projects = kwargs.get('additional_projects', None)
        self.request_google_drive_scope = kwargs.get('request_google_drive_scope', None)
        self.authentication_type = kwargs['authentication_type']
        self.refresh_token = kwargs.get('refresh_token', None)
        self.client_id = kwargs.get('client_id', None)
        self.client_secret = kwargs.get('client_secret', None)
        self.email = kwargs.get('email', None)
        self.key_file_path = kwargs.get('key_file_path', None)
        self.trusted_cert_path = kwargs.get('trusted_cert_path', None)
        self.use_system_trust_store = kwargs.get('use_system_trust_store', None)
        self.encrypted_credential = kwargs.get('encrypted_credential', None)


class GoogleBigQueryObjectDataset(Dataset):
    """Google BigQuery service dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param table_name: This property will be retired. Please consider using database + table
     properties instead.
    :type table_name: object
    :param table: The table name of the Google BigQuery. Type: string (or Expression with
     resultType string).
    :type table: object
    :param dataset: The database name of the Google BigQuery. Type: string (or Expression with
     resultType string).
    :type dataset: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table_name': {'key': 'typeProperties.tableName', 'type': 'object'},
        'table': {'key': 'typeProperties.table', 'type': 'object'},
        'dataset': {'key': 'typeProperties.dataset', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(GoogleBigQueryObjectDataset, self).__init__(**kwargs)
        self.type = 'GoogleBigQueryObject'  # type: str
        self.table_name = kwargs.get('table_name', None)
        self.table = kwargs.get('table', None)
        self.dataset = kwargs.get('dataset', None)


class GoogleBigQuerySource(TabularSource):
    """A copy activity Google BigQuery service source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: object
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param query_timeout: Query timeout. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type query_timeout: object
    :param query: A query to retrieve data from source. Type: string (or Expression with resultType
     string).
    :type query: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'query_timeout': {'key': 'queryTimeout', 'type': 'object'},
        'query': {'key': 'query', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(GoogleBigQuerySource, self).__init__(**kwargs)
        self.type = 'GoogleBigQuerySource'  # type: str
        self.query = kwargs.get('query', None)


class GoogleCloudStorageLinkedService(LinkedService):
    """Linked service for Google Cloud Storage.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param access_key_id: The access key identifier of the Google Cloud Storage Identity and Access
     Management (IAM) user. Type: string (or Expression with resultType string).
    :type access_key_id: object
    :param secret_access_key: The secret access key of the Google Cloud Storage Identity and Access
     Management (IAM) user.
    :type secret_access_key: ~azure.synapse.artifacts.models.SecretBase
    :param service_url: This value specifies the endpoint to access with the Google Cloud Storage
     Connector. This is an optional property; change it only if you want to try a different service
     endpoint or want to switch between https and http. Type: string (or Expression with resultType
     string).
    :type service_url: object
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'access_key_id': {'key': 'typeProperties.accessKeyId', 'type': 'object'},
        'secret_access_key': {'key': 'typeProperties.secretAccessKey', 'type': 'SecretBase'},
        'service_url': {'key': 'typeProperties.serviceUrl', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(GoogleCloudStorageLinkedService, self).__init__(**kwargs)
        self.type = 'GoogleCloudStorage'  # type: str
        self.access_key_id = kwargs.get('access_key_id', None)
        self.secret_access_key = kwargs.get('secret_access_key', None)
        self.service_url = kwargs.get('service_url', None)
        self.encrypted_credential = kwargs.get('encrypted_credential', None)


class GoogleCloudStorageLocation(DatasetLocation):
    """The location of Google Cloud Storage dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset storage location.Constant filled by server.
    :type type: str
    :param folder_path: Specify the folder path of dataset. Type: string (or Expression with
     resultType string).
    :type folder_path: object
    :param file_name: Specify the file name of dataset. Type: string (or Expression with resultType
     string).
    :type file_name: object
    :param bucket_name: Specify the bucketName of Google Cloud Storage. Type: string (or Expression
     with resultType string).
    :type bucket_name: object
    :param version: Specify the version of Google Cloud Storage. Type: string (or Expression with
     resultType string).
    :type version: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'folder_path': {'key': 'folderPath', 'type': 'object'},
        'file_name': {'key': 'fileName', 'type': 'object'},
        'bucket_name': {'key': 'bucketName', 'type': 'object'},
        'version': {'key': 'version', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(GoogleCloudStorageLocation, self).__init__(**kwargs)
        self.type = 'GoogleCloudStorageLocation'  # type: str
        self.bucket_name = kwargs.get('bucket_name', None)
        self.version = kwargs.get('version', None)


class GoogleCloudStorageReadSettings(StoreReadSettings):
    """Google Cloud Storage read settings.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. The read setting type.Constant filled by server.
    :type type: str
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param recursive: If true, files under the folder path will be read recursively. Default is
     true. Type: boolean (or Expression with resultType boolean).
    :type recursive: object
    :param wildcard_folder_path: Google Cloud Storage wildcardFolderPath. Type: string (or
     Expression with resultType string).
    :type wildcard_folder_path: object
    :param wildcard_file_name: Google Cloud Storage wildcardFileName. Type: string (or Expression
     with resultType string).
    :type wildcard_file_name: object
    :param prefix: The prefix filter for the Google Cloud Storage object name. Type: string (or
     Expression with resultType string).
    :type prefix: object
    :param enable_partition_discovery: Indicates whether to enable partition discovery.
    :type enable_partition_discovery: bool
    :param modified_datetime_start: The start of file's modified datetime. Type: string (or
     Expression with resultType string).
    :type modified_datetime_start: object
    :param modified_datetime_end: The end of file's modified datetime. Type: string (or Expression
     with resultType string).
    :type modified_datetime_end: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'recursive': {'key': 'recursive', 'type': 'object'},
        'wildcard_folder_path': {'key': 'wildcardFolderPath', 'type': 'object'},
        'wildcard_file_name': {'key': 'wildcardFileName', 'type': 'object'},
        'prefix': {'key': 'prefix', 'type': 'object'},
        'enable_partition_discovery': {'key': 'enablePartitionDiscovery', 'type': 'bool'},
        'modified_datetime_start': {'key': 'modifiedDatetimeStart', 'type': 'object'},
        'modified_datetime_end': {'key': 'modifiedDatetimeEnd', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(GoogleCloudStorageReadSettings, self).__init__(**kwargs)
        self.type = 'GoogleCloudStorageReadSettings'  # type: str
        self.recursive = kwargs.get('recursive', None)
        self.wildcard_folder_path = kwargs.get('wildcard_folder_path', None)
        self.wildcard_file_name = kwargs.get('wildcard_file_name', None)
        self.prefix = kwargs.get('prefix', None)
        self.enable_partition_discovery = kwargs.get('enable_partition_discovery', None)
        self.modified_datetime_start = kwargs.get('modified_datetime_start', None)
        self.modified_datetime_end = kwargs.get('modified_datetime_end', None)


class GreenplumLinkedService(LinkedService):
    """Greenplum Database linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param connection_string: An ODBC connection string. Type: string, SecureString or
     AzureKeyVaultSecretReference.
    :type connection_string: object
    :param pwd: The Azure key vault secret reference of password in connection string.
    :type pwd: ~azure.synapse.artifacts.models.AzureKeyVaultSecretReference
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'connection_string': {'key': 'typeProperties.connectionString', 'type': 'object'},
        'pwd': {'key': 'typeProperties.pwd', 'type': 'AzureKeyVaultSecretReference'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(GreenplumLinkedService, self).__init__(**kwargs)
        self.type = 'Greenplum'  # type: str
        self.connection_string = kwargs.get('connection_string', None)
        self.pwd = kwargs.get('pwd', None)
        self.encrypted_credential = kwargs.get('encrypted_credential', None)


class GreenplumSource(TabularSource):
    """A copy activity Greenplum Database source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: object
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param query_timeout: Query timeout. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type query_timeout: object
    :param query: A query to retrieve data from source. Type: string (or Expression with resultType
     string).
    :type query: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'query_timeout': {'key': 'queryTimeout', 'type': 'object'},
        'query': {'key': 'query', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(GreenplumSource, self).__init__(**kwargs)
        self.type = 'GreenplumSource'  # type: str
        self.query = kwargs.get('query', None)


class GreenplumTableDataset(Dataset):
    """Greenplum Database dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param table_name: This property will be retired. Please consider using schema + table
     properties instead.
    :type table_name: object
    :param table: The table name of Greenplum. Type: string (or Expression with resultType string).
    :type table: object
    :param schema_type_properties_schema: The schema name of Greenplum. Type: string (or Expression
     with resultType string).
    :type schema_type_properties_schema: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table_name': {'key': 'typeProperties.tableName', 'type': 'object'},
        'table': {'key': 'typeProperties.table', 'type': 'object'},
        'schema_type_properties_schema': {'key': 'typeProperties.schema', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(GreenplumTableDataset, self).__init__(**kwargs)
        self.type = 'GreenplumTable'  # type: str
        self.table_name = kwargs.get('table_name', None)
        self.table = kwargs.get('table', None)
        self.schema_type_properties_schema = kwargs.get('schema_type_properties_schema', None)


class HBaseLinkedService(LinkedService):
    """HBase server linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param host: Required. The IP address or host name of the HBase server. (i.e. 192.168.222.160).
    :type host: object
    :param port: The TCP port that the HBase instance uses to listen for client connections. The
     default value is 9090.
    :type port: object
    :param http_path: The partial URL corresponding to the HBase server. (i.e.
     /gateway/sandbox/hbase/version).
    :type http_path: object
    :param authentication_type: Required. The authentication mechanism to use to connect to the
     HBase server. Possible values include: "Anonymous", "Basic".
    :type authentication_type: str or ~azure.synapse.artifacts.models.HBaseAuthenticationType
    :param username: The user name used to connect to the HBase instance.
    :type username: object
    :param password: The password corresponding to the user name.
    :type password: ~azure.synapse.artifacts.models.SecretBase
    :param enable_ssl: Specifies whether the connections to the server are encrypted using SSL. The
     default value is false.
    :type enable_ssl: object
    :param trusted_cert_path: The full path of the .pem file containing trusted CA certificates for
     verifying the server when connecting over SSL. This property can only be set when using SSL on
     self-hosted IR. The default value is the cacerts.pem file installed with the IR.
    :type trusted_cert_path: object
    :param allow_host_name_cn_mismatch: Specifies whether to require a CA-issued SSL certificate
     name to match the host name of the server when connecting over SSL. The default value is false.
    :type allow_host_name_cn_mismatch: object
    :param allow_self_signed_server_cert: Specifies whether to allow self-signed certificates from
     the server. The default value is false.
    :type allow_self_signed_server_cert: object
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'host': {'required': True},
        'authentication_type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'host': {'key': 'typeProperties.host', 'type': 'object'},
        'port': {'key': 'typeProperties.port', 'type': 'object'},
        'http_path': {'key': 'typeProperties.httpPath', 'type': 'object'},
        'authentication_type': {'key': 'typeProperties.authenticationType', 'type': 'str'},
        'username': {'key': 'typeProperties.username', 'type': 'object'},
        'password': {'key': 'typeProperties.password', 'type': 'SecretBase'},
        'enable_ssl': {'key': 'typeProperties.enableSsl', 'type': 'object'},
        'trusted_cert_path': {'key': 'typeProperties.trustedCertPath', 'type': 'object'},
        'allow_host_name_cn_mismatch': {'key': 'typeProperties.allowHostNameCNMismatch', 'type': 'object'},
        'allow_self_signed_server_cert': {'key': 'typeProperties.allowSelfSignedServerCert', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HBaseLinkedService, self).__init__(**kwargs)
        self.type = 'HBase'  # type: str
        self.host = kwargs['host']
        self.port = kwargs.get('port', None)
        self.http_path = kwargs.get('http_path', None)
        self.authentication_type = kwargs['authentication_type']
        self.username = kwargs.get('username', None)
        self.password = kwargs.get('password', None)
        self.enable_ssl = kwargs.get('enable_ssl', None)
        self.trusted_cert_path = kwargs.get('trusted_cert_path', None)
        self.allow_host_name_cn_mismatch = kwargs.get('allow_host_name_cn_mismatch', None)
        self.allow_self_signed_server_cert = kwargs.get('allow_self_signed_server_cert', None)
        self.encrypted_credential = kwargs.get('encrypted_credential', None)


class HBaseObjectDataset(Dataset):
    """HBase server dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param table_name: The table name. Type: string (or Expression with resultType string).
    :type table_name: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table_name': {'key': 'typeProperties.tableName', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HBaseObjectDataset, self).__init__(**kwargs)
        self.type = 'HBaseObject'  # type: str
        self.table_name = kwargs.get('table_name', None)


class HBaseSource(TabularSource):
    """A copy activity HBase server source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: object
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param query_timeout: Query timeout. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type query_timeout: object
    :param query: A query to retrieve data from source. Type: string (or Expression with resultType
     string).
    :type query: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'query_timeout': {'key': 'queryTimeout', 'type': 'object'},
        'query': {'key': 'query', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HBaseSource, self).__init__(**kwargs)
        self.type = 'HBaseSource'  # type: str
        self.query = kwargs.get('query', None)


class HdfsLinkedService(LinkedService):
    """Hadoop Distributed File System (HDFS) linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param url: Required. The URL of the HDFS service endpoint, e.g.
     http://myhostname:50070/webhdfs/v1 . Type: string (or Expression with resultType string).
    :type url: object
    :param authentication_type: Type of authentication used to connect to the HDFS. Possible values
     are: Anonymous and Windows. Type: string (or Expression with resultType string).
    :type authentication_type: object
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    :param user_name: User name for Windows authentication. Type: string (or Expression with
     resultType string).
    :type user_name: object
    :param password: Password for Windows authentication.
    :type password: ~azure.synapse.artifacts.models.SecretBase
    """

    _validation = {
        'type': {'required': True},
        'url': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'url': {'key': 'typeProperties.url', 'type': 'object'},
        'authentication_type': {'key': 'typeProperties.authenticationType', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
        'user_name': {'key': 'typeProperties.userName', 'type': 'object'},
        'password': {'key': 'typeProperties.password', 'type': 'SecretBase'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HdfsLinkedService, self).__init__(**kwargs)
        self.type = 'Hdfs'  # type: str
        self.url = kwargs['url']
        self.authentication_type = kwargs.get('authentication_type', None)
        self.encrypted_credential = kwargs.get('encrypted_credential', None)
        self.user_name = kwargs.get('user_name', None)
        self.password = kwargs.get('password', None)


class HdfsLocation(DatasetLocation):
    """The location of HDFS.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset storage location.Constant filled by server.
    :type type: str
    :param folder_path: Specify the folder path of dataset. Type: string (or Expression with
     resultType string).
    :type folder_path: object
    :param file_name: Specify the file name of dataset. Type: string (or Expression with resultType
     string).
    :type file_name: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'folder_path': {'key': 'folderPath', 'type': 'object'},
        'file_name': {'key': 'fileName', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HdfsLocation, self).__init__(**kwargs)
        self.type = 'HdfsLocation'  # type: str


class HdfsReadSettings(StoreReadSettings):
    """HDFS read settings.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. The read setting type.Constant filled by server.
    :type type: str
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param recursive: If true, files under the folder path will be read recursively. Default is
     true. Type: boolean (or Expression with resultType boolean).
    :type recursive: object
    :param wildcard_folder_path: HDFS wildcardFolderPath. Type: string (or Expression with
     resultType string).
    :type wildcard_folder_path: object
    :param wildcard_file_name: HDFS wildcardFileName. Type: string (or Expression with resultType
     string).
    :type wildcard_file_name: object
    :param enable_partition_discovery: Indicates whether to enable partition discovery.
    :type enable_partition_discovery: bool
    :param modified_datetime_start: The start of file's modified datetime. Type: string (or
     Expression with resultType string).
    :type modified_datetime_start: object
    :param modified_datetime_end: The end of file's modified datetime. Type: string (or Expression
     with resultType string).
    :type modified_datetime_end: object
    :param distcp_settings: Specifies Distcp-related settings.
    :type distcp_settings: ~azure.synapse.artifacts.models.DistcpSettings
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'recursive': {'key': 'recursive', 'type': 'object'},
        'wildcard_folder_path': {'key': 'wildcardFolderPath', 'type': 'object'},
        'wildcard_file_name': {'key': 'wildcardFileName', 'type': 'object'},
        'enable_partition_discovery': {'key': 'enablePartitionDiscovery', 'type': 'bool'},
        'modified_datetime_start': {'key': 'modifiedDatetimeStart', 'type': 'object'},
        'modified_datetime_end': {'key': 'modifiedDatetimeEnd', 'type': 'object'},
        'distcp_settings': {'key': 'distcpSettings', 'type': 'DistcpSettings'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HdfsReadSettings, self).__init__(**kwargs)
        self.type = 'HdfsReadSettings'  # type: str
        self.recursive = kwargs.get('recursive', None)
        self.wildcard_folder_path = kwargs.get('wildcard_folder_path', None)
        self.wildcard_file_name = kwargs.get('wildcard_file_name', None)
        self.enable_partition_discovery = kwargs.get('enable_partition_discovery', None)
        self.modified_datetime_start = kwargs.get('modified_datetime_start', None)
        self.modified_datetime_end = kwargs.get('modified_datetime_end', None)
        self.distcp_settings = kwargs.get('distcp_settings', None)


class HdfsSource(CopySource):
    """A copy activity HDFS source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: object
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param recursive: If true, files under the folder path will be read recursively. Default is
     true. Type: boolean (or Expression with resultType boolean).
    :type recursive: object
    :param distcp_settings: Specifies Distcp-related settings.
    :type distcp_settings: ~azure.synapse.artifacts.models.DistcpSettings
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'recursive': {'key': 'recursive', 'type': 'object'},
        'distcp_settings': {'key': 'distcpSettings', 'type': 'DistcpSettings'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HdfsSource, self).__init__(**kwargs)
        self.type = 'HdfsSource'  # type: str
        self.recursive = kwargs.get('recursive', None)
        self.distcp_settings = kwargs.get('distcp_settings', None)


class HDInsightHiveActivity(ExecutionActivity):
    """HDInsight Hive activity type.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param name: Required. Activity name.
    :type name: str
    :param type: Required. Type of activity.Constant filled by server.
    :type type: str
    :param description: Activity description.
    :type description: str
    :param depends_on: Activity depends on condition.
    :type depends_on: list[~azure.synapse.artifacts.models.ActivityDependency]
    :param user_properties: Activity user properties.
    :type user_properties: list[~azure.synapse.artifacts.models.UserProperty]
    :param linked_service_name: Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param policy: Activity policy.
    :type policy: ~azure.synapse.artifacts.models.ActivityPolicy
    :param storage_linked_services: Storage linked service references.
    :type storage_linked_services: list[~azure.synapse.artifacts.models.LinkedServiceReference]
    :param arguments: User specified arguments to HDInsightActivity.
    :type arguments: list[object]
    :param get_debug_info: Debug info option. Possible values include: "None", "Always", "Failure".
    :type get_debug_info: str or ~azure.synapse.artifacts.models.HDInsightActivityDebugInfoOption
    :param script_path: Script path. Type: string (or Expression with resultType string).
    :type script_path: object
    :param script_linked_service: Script linked service reference.
    :type script_linked_service: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param defines: Allows user to specify defines for Hive job request.
    :type defines: dict[str, object]
    :param variables: User specified arguments under hivevar namespace.
    :type variables: list[object]
    :param query_timeout: Query timeout value (in minutes).  Effective when the HDInsight cluster
     is with ESP (Enterprise Security Package).
    :type query_timeout: int
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'depends_on': {'key': 'dependsOn', 'type': '[ActivityDependency]'},
        'user_properties': {'key': 'userProperties', 'type': '[UserProperty]'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'policy': {'key': 'policy', 'type': 'ActivityPolicy'},
        'storage_linked_services': {'key': 'typeProperties.storageLinkedServices', 'type': '[LinkedServiceReference]'},
        'arguments': {'key': 'typeProperties.arguments', 'type': '[object]'},
        'get_debug_info': {'key': 'typeProperties.getDebugInfo', 'type': 'str'},
        'script_path': {'key': 'typeProperties.scriptPath', 'type': 'object'},
        'script_linked_service': {'key': 'typeProperties.scriptLinkedService', 'type': 'LinkedServiceReference'},
        'defines': {'key': 'typeProperties.defines', 'type': '{object}'},
        'variables': {'key': 'typeProperties.variables', 'type': '[object]'},
        'query_timeout': {'key': 'typeProperties.queryTimeout', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HDInsightHiveActivity, self).__init__(**kwargs)
        self.type = 'HDInsightHive'  # type: str
        self.storage_linked_services = kwargs.get('storage_linked_services', None)
        self.arguments = kwargs.get('arguments', None)
        self.get_debug_info = kwargs.get('get_debug_info', None)
        self.script_path = kwargs.get('script_path', None)
        self.script_linked_service = kwargs.get('script_linked_service', None)
        self.defines = kwargs.get('defines', None)
        self.variables = kwargs.get('variables', None)
        self.query_timeout = kwargs.get('query_timeout', None)


class HDInsightLinkedService(LinkedService):
    """HDInsight linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param cluster_uri: Required. HDInsight cluster URI. Type: string (or Expression with
     resultType string).
    :type cluster_uri: object
    :param user_name: HDInsight cluster user name. Type: string (or Expression with resultType
     string).
    :type user_name: object
    :param password: HDInsight cluster password.
    :type password: ~azure.synapse.artifacts.models.SecretBase
    :param linked_service_name: The Azure Storage linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param hcatalog_linked_service_name: A reference to the Azure SQL linked service that points to
     the HCatalog database.
    :type hcatalog_linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    :param is_esp_enabled: Specify if the HDInsight is created with ESP (Enterprise Security
     Package). Type: Boolean.
    :type is_esp_enabled: object
    :param file_system: Specify the FileSystem if the main storage for the HDInsight is ADLS Gen2.
     Type: string (or Expression with resultType string).
    :type file_system: object
    """

    _validation = {
        'type': {'required': True},
        'cluster_uri': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'cluster_uri': {'key': 'typeProperties.clusterUri', 'type': 'object'},
        'user_name': {'key': 'typeProperties.userName', 'type': 'object'},
        'password': {'key': 'typeProperties.password', 'type': 'SecretBase'},
        'linked_service_name': {'key': 'typeProperties.linkedServiceName', 'type': 'LinkedServiceReference'},
        'hcatalog_linked_service_name': {'key': 'typeProperties.hcatalogLinkedServiceName', 'type': 'LinkedServiceReference'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
        'is_esp_enabled': {'key': 'typeProperties.isEspEnabled', 'type': 'object'},
        'file_system': {'key': 'typeProperties.fileSystem', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HDInsightLinkedService, self).__init__(**kwargs)
        self.type = 'HDInsight'  # type: str
        self.cluster_uri = kwargs['cluster_uri']
        self.user_name = kwargs.get('user_name', None)
        self.password = kwargs.get('password', None)
        self.linked_service_name = kwargs.get('linked_service_name', None)
        self.hcatalog_linked_service_name = kwargs.get('hcatalog_linked_service_name', None)
        self.encrypted_credential = kwargs.get('encrypted_credential', None)
        self.is_esp_enabled = kwargs.get('is_esp_enabled', None)
        self.file_system = kwargs.get('file_system', None)


class HDInsightMapReduceActivity(ExecutionActivity):
    """HDInsight MapReduce activity type.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param name: Required. Activity name.
    :type name: str
    :param type: Required. Type of activity.Constant filled by server.
    :type type: str
    :param description: Activity description.
    :type description: str
    :param depends_on: Activity depends on condition.
    :type depends_on: list[~azure.synapse.artifacts.models.ActivityDependency]
    :param user_properties: Activity user properties.
    :type user_properties: list[~azure.synapse.artifacts.models.UserProperty]
    :param linked_service_name: Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param policy: Activity policy.
    :type policy: ~azure.synapse.artifacts.models.ActivityPolicy
    :param storage_linked_services: Storage linked service references.
    :type storage_linked_services: list[~azure.synapse.artifacts.models.LinkedServiceReference]
    :param arguments: User specified arguments to HDInsightActivity.
    :type arguments: list[object]
    :param get_debug_info: Debug info option. Possible values include: "None", "Always", "Failure".
    :type get_debug_info: str or ~azure.synapse.artifacts.models.HDInsightActivityDebugInfoOption
    :param class_name: Required. Class name. Type: string (or Expression with resultType string).
    :type class_name: object
    :param jar_file_path: Required. Jar path. Type: string (or Expression with resultType string).
    :type jar_file_path: object
    :param jar_linked_service: Jar linked service reference.
    :type jar_linked_service: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param jar_libs: Jar libs.
    :type jar_libs: list[object]
    :param defines: Allows user to specify defines for the MapReduce job request.
    :type defines: dict[str, object]
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
        'class_name': {'required': True},
        'jar_file_path': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'depends_on': {'key': 'dependsOn', 'type': '[ActivityDependency]'},
        'user_properties': {'key': 'userProperties', 'type': '[UserProperty]'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'policy': {'key': 'policy', 'type': 'ActivityPolicy'},
        'storage_linked_services': {'key': 'typeProperties.storageLinkedServices', 'type': '[LinkedServiceReference]'},
        'arguments': {'key': 'typeProperties.arguments', 'type': '[object]'},
        'get_debug_info': {'key': 'typeProperties.getDebugInfo', 'type': 'str'},
        'class_name': {'key': 'typeProperties.className', 'type': 'object'},
        'jar_file_path': {'key': 'typeProperties.jarFilePath', 'type': 'object'},
        'jar_linked_service': {'key': 'typeProperties.jarLinkedService', 'type': 'LinkedServiceReference'},
        'jar_libs': {'key': 'typeProperties.jarLibs', 'type': '[object]'},
        'defines': {'key': 'typeProperties.defines', 'type': '{object}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HDInsightMapReduceActivity, self).__init__(**kwargs)
        self.type = 'HDInsightMapReduce'  # type: str
        self.storage_linked_services = kwargs.get('storage_linked_services', None)
        self.arguments = kwargs.get('arguments', None)
        self.get_debug_info = kwargs.get('get_debug_info', None)
        self.class_name = kwargs['class_name']
        self.jar_file_path = kwargs['jar_file_path']
        self.jar_linked_service = kwargs.get('jar_linked_service', None)
        self.jar_libs = kwargs.get('jar_libs', None)
        self.defines = kwargs.get('defines', None)


class HDInsightOnDemandLinkedService(LinkedService):
    """HDInsight ondemand linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param cluster_size: Required. Number of worker/data nodes in the cluster. Suggestion value: 4.
     Type: string (or Expression with resultType string).
    :type cluster_size: object
    :param time_to_live: Required. The allowed idle time for the on-demand HDInsight cluster.
     Specifies how long the on-demand HDInsight cluster stays alive after completion of an activity
     run if there are no other active jobs in the cluster. The minimum value is 5 mins. Type: string
     (or Expression with resultType string).
    :type time_to_live: object
    :param version: Required. Version of the HDInsight cluster.  Type: string (or Expression with
     resultType string).
    :type version: object
    :param linked_service_name: Required. Azure Storage linked service to be used by the on-demand
     cluster for storing and processing data.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param host_subscription_id: Required. The customer’s subscription to host the cluster. Type:
     string (or Expression with resultType string).
    :type host_subscription_id: object
    :param service_principal_id: The service principal id for the hostSubscriptionId. Type: string
     (or Expression with resultType string).
    :type service_principal_id: object
    :param service_principal_key: The key for the service principal id.
    :type service_principal_key: ~azure.synapse.artifacts.models.SecretBase
    :param tenant: Required. The Tenant id/name to which the service principal belongs. Type:
     string (or Expression with resultType string).
    :type tenant: object
    :param cluster_resource_group: Required. The resource group where the cluster belongs. Type:
     string (or Expression with resultType string).
    :type cluster_resource_group: object
    :param cluster_name_prefix: The prefix of cluster name, postfix will be distinct with
     timestamp. Type: string (or Expression with resultType string).
    :type cluster_name_prefix: object
    :param cluster_user_name: The username to access the cluster. Type: string (or Expression with
     resultType string).
    :type cluster_user_name: object
    :param cluster_password: The password to access the cluster.
    :type cluster_password: ~azure.synapse.artifacts.models.SecretBase
    :param cluster_ssh_user_name: The username to SSH remotely connect to cluster’s node (for
     Linux). Type: string (or Expression with resultType string).
    :type cluster_ssh_user_name: object
    :param cluster_ssh_password: The password to SSH remotely connect cluster’s node (for Linux).
    :type cluster_ssh_password: ~azure.synapse.artifacts.models.SecretBase
    :param additional_linked_service_names: Specifies additional storage accounts for the HDInsight
     linked service so that the Data Factory service can register them on your behalf.
    :type additional_linked_service_names:
     list[~azure.synapse.artifacts.models.LinkedServiceReference]
    :param hcatalog_linked_service_name: The name of Azure SQL linked service that point to the
     HCatalog database. The on-demand HDInsight cluster is created by using the Azure SQL database
     as the metastore.
    :type hcatalog_linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param cluster_type: The cluster type. Type: string (or Expression with resultType string).
    :type cluster_type: object
    :param spark_version: The version of spark if the cluster type is 'spark'. Type: string (or
     Expression with resultType string).
    :type spark_version: object
    :param core_configuration: Specifies the core configuration parameters (as in core-site.xml)
     for the HDInsight cluster to be created.
    :type core_configuration: object
    :param h_base_configuration: Specifies the HBase configuration parameters (hbase-site.xml) for
     the HDInsight cluster.
    :type h_base_configuration: object
    :param hdfs_configuration: Specifies the HDFS configuration parameters (hdfs-site.xml) for the
     HDInsight cluster.
    :type hdfs_configuration: object
    :param hive_configuration: Specifies the hive configuration parameters (hive-site.xml) for the
     HDInsight cluster.
    :type hive_configuration: object
    :param map_reduce_configuration: Specifies the MapReduce configuration parameters (mapred-
     site.xml) for the HDInsight cluster.
    :type map_reduce_configuration: object
    :param oozie_configuration: Specifies the Oozie configuration parameters (oozie-site.xml) for
     the HDInsight cluster.
    :type oozie_configuration: object
    :param storm_configuration: Specifies the Storm configuration parameters (storm-site.xml) for
     the HDInsight cluster.
    :type storm_configuration: object
    :param yarn_configuration: Specifies the Yarn configuration parameters (yarn-site.xml) for the
     HDInsight cluster.
    :type yarn_configuration: object
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    :param head_node_size: Specifies the size of the head node for the HDInsight cluster.
    :type head_node_size: object
    :param data_node_size: Specifies the size of the data node for the HDInsight cluster.
    :type data_node_size: object
    :param zookeeper_node_size: Specifies the size of the Zoo Keeper node for the HDInsight
     cluster.
    :type zookeeper_node_size: object
    :param script_actions: Custom script actions to run on HDI ondemand cluster once it's up.
     Please refer to https://docs.microsoft.com/en-us/azure/hdinsight/hdinsight-hadoop-customize-
     cluster-linux?toc=%2Fen-us%2Fazure%2Fhdinsight%2Fr-server%2FTOC.json&bc=%2Fen-
     us%2Fazure%2Fbread%2Ftoc.json#understanding-script-actions.
    :type script_actions: list[~azure.synapse.artifacts.models.ScriptAction]
    :param virtual_network_id: The ARM resource ID for the vNet to which the cluster should be
     joined after creation. Type: string (or Expression with resultType string).
    :type virtual_network_id: object
    :param subnet_name: The ARM resource ID for the subnet in the vNet. If virtualNetworkId was
     specified, then this property is required. Type: string (or Expression with resultType string).
    :type subnet_name: object
    """

    _validation = {
        'type': {'required': True},
        'cluster_size': {'required': True},
        'time_to_live': {'required': True},
        'version': {'required': True},
        'linked_service_name': {'required': True},
        'host_subscription_id': {'required': True},
        'tenant': {'required': True},
        'cluster_resource_group': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'cluster_size': {'key': 'typeProperties.clusterSize', 'type': 'object'},
        'time_to_live': {'key': 'typeProperties.timeToLive', 'type': 'object'},
        'version': {'key': 'typeProperties.version', 'type': 'object'},
        'linked_service_name': {'key': 'typeProperties.linkedServiceName', 'type': 'LinkedServiceReference'},
        'host_subscription_id': {'key': 'typeProperties.hostSubscriptionId', 'type': 'object'},
        'service_principal_id': {'key': 'typeProperties.servicePrincipalId', 'type': 'object'},
        'service_principal_key': {'key': 'typeProperties.servicePrincipalKey', 'type': 'SecretBase'},
        'tenant': {'key': 'typeProperties.tenant', 'type': 'object'},
        'cluster_resource_group': {'key': 'typeProperties.clusterResourceGroup', 'type': 'object'},
        'cluster_name_prefix': {'key': 'typeProperties.clusterNamePrefix', 'type': 'object'},
        'cluster_user_name': {'key': 'typeProperties.clusterUserName', 'type': 'object'},
        'cluster_password': {'key': 'typeProperties.clusterPassword', 'type': 'SecretBase'},
        'cluster_ssh_user_name': {'key': 'typeProperties.clusterSshUserName', 'type': 'object'},
        'cluster_ssh_password': {'key': 'typeProperties.clusterSshPassword', 'type': 'SecretBase'},
        'additional_linked_service_names': {'key': 'typeProperties.additionalLinkedServiceNames', 'type': '[LinkedServiceReference]'},
        'hcatalog_linked_service_name': {'key': 'typeProperties.hcatalogLinkedServiceName', 'type': 'LinkedServiceReference'},
        'cluster_type': {'key': 'typeProperties.clusterType', 'type': 'object'},
        'spark_version': {'key': 'typeProperties.sparkVersion', 'type': 'object'},
        'core_configuration': {'key': 'typeProperties.coreConfiguration', 'type': 'object'},
        'h_base_configuration': {'key': 'typeProperties.hBaseConfiguration', 'type': 'object'},
        'hdfs_configuration': {'key': 'typeProperties.hdfsConfiguration', 'type': 'object'},
        'hive_configuration': {'key': 'typeProperties.hiveConfiguration', 'type': 'object'},
        'map_reduce_configuration': {'key': 'typeProperties.mapReduceConfiguration', 'type': 'object'},
        'oozie_configuration': {'key': 'typeProperties.oozieConfiguration', 'type': 'object'},
        'storm_configuration': {'key': 'typeProperties.stormConfiguration', 'type': 'object'},
        'yarn_configuration': {'key': 'typeProperties.yarnConfiguration', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
        'head_node_size': {'key': 'typeProperties.headNodeSize', 'type': 'object'},
        'data_node_size': {'key': 'typeProperties.dataNodeSize', 'type': 'object'},
        'zookeeper_node_size': {'key': 'typeProperties.zookeeperNodeSize', 'type': 'object'},
        'script_actions': {'key': 'typeProperties.scriptActions', 'type': '[ScriptAction]'},
        'virtual_network_id': {'key': 'typeProperties.virtualNetworkId', 'type': 'object'},
        'subnet_name': {'key': 'typeProperties.subnetName', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HDInsightOnDemandLinkedService, self).__init__(**kwargs)
        self.type = 'HDInsightOnDemand'  # type: str
        self.cluster_size = kwargs['cluster_size']
        self.time_to_live = kwargs['time_to_live']
        self.version = kwargs['version']
        self.linked_service_name = kwargs['linked_service_name']
        self.host_subscription_id = kwargs['host_subscription_id']
        self.service_principal_id = kwargs.get('service_principal_id', None)
        self.service_principal_key = kwargs.get('service_principal_key', None)
        self.tenant = kwargs['tenant']
        self.cluster_resource_group = kwargs['cluster_resource_group']
        self.cluster_name_prefix = kwargs.get('cluster_name_prefix', None)
        self.cluster_user_name = kwargs.get('cluster_user_name', None)
        self.cluster_password = kwargs.get('cluster_password', None)
        self.cluster_ssh_user_name = kwargs.get('cluster_ssh_user_name', None)
        self.cluster_ssh_password = kwargs.get('cluster_ssh_password', None)
        self.additional_linked_service_names = kwargs.get('additional_linked_service_names', None)
        self.hcatalog_linked_service_name = kwargs.get('hcatalog_linked_service_name', None)
        self.cluster_type = kwargs.get('cluster_type', None)
        self.spark_version = kwargs.get('spark_version', None)
        self.core_configuration = kwargs.get('core_configuration', None)
        self.h_base_configuration = kwargs.get('h_base_configuration', None)
        self.hdfs_configuration = kwargs.get('hdfs_configuration', None)
        self.hive_configuration = kwargs.get('hive_configuration', None)
        self.map_reduce_configuration = kwargs.get('map_reduce_configuration', None)
        self.oozie_configuration = kwargs.get('oozie_configuration', None)
        self.storm_configuration = kwargs.get('storm_configuration', None)
        self.yarn_configuration = kwargs.get('yarn_configuration', None)
        self.encrypted_credential = kwargs.get('encrypted_credential', None)
        self.head_node_size = kwargs.get('head_node_size', None)
        self.data_node_size = kwargs.get('data_node_size', None)
        self.zookeeper_node_size = kwargs.get('zookeeper_node_size', None)
        self.script_actions = kwargs.get('script_actions', None)
        self.virtual_network_id = kwargs.get('virtual_network_id', None)
        self.subnet_name = kwargs.get('subnet_name', None)


class HDInsightPigActivity(ExecutionActivity):
    """HDInsight Pig activity type.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param name: Required. Activity name.
    :type name: str
    :param type: Required. Type of activity.Constant filled by server.
    :type type: str
    :param description: Activity description.
    :type description: str
    :param depends_on: Activity depends on condition.
    :type depends_on: list[~azure.synapse.artifacts.models.ActivityDependency]
    :param user_properties: Activity user properties.
    :type user_properties: list[~azure.synapse.artifacts.models.UserProperty]
    :param linked_service_name: Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param policy: Activity policy.
    :type policy: ~azure.synapse.artifacts.models.ActivityPolicy
    :param storage_linked_services: Storage linked service references.
    :type storage_linked_services: list[~azure.synapse.artifacts.models.LinkedServiceReference]
    :param arguments: User specified arguments to HDInsightActivity. Type: array (or Expression
     with resultType array).
    :type arguments: object
    :param get_debug_info: Debug info option. Possible values include: "None", "Always", "Failure".
    :type get_debug_info: str or ~azure.synapse.artifacts.models.HDInsightActivityDebugInfoOption
    :param script_path: Script path. Type: string (or Expression with resultType string).
    :type script_path: object
    :param script_linked_service: Script linked service reference.
    :type script_linked_service: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param defines: Allows user to specify defines for Pig job request.
    :type defines: dict[str, object]
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'depends_on': {'key': 'dependsOn', 'type': '[ActivityDependency]'},
        'user_properties': {'key': 'userProperties', 'type': '[UserProperty]'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'policy': {'key': 'policy', 'type': 'ActivityPolicy'},
        'storage_linked_services': {'key': 'typeProperties.storageLinkedServices', 'type': '[LinkedServiceReference]'},
        'arguments': {'key': 'typeProperties.arguments', 'type': 'object'},
        'get_debug_info': {'key': 'typeProperties.getDebugInfo', 'type': 'str'},
        'script_path': {'key': 'typeProperties.scriptPath', 'type': 'object'},
        'script_linked_service': {'key': 'typeProperties.scriptLinkedService', 'type': 'LinkedServiceReference'},
        'defines': {'key': 'typeProperties.defines', 'type': '{object}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HDInsightPigActivity, self).__init__(**kwargs)
        self.type = 'HDInsightPig'  # type: str
        self.storage_linked_services = kwargs.get('storage_linked_services', None)
        self.arguments = kwargs.get('arguments', None)
        self.get_debug_info = kwargs.get('get_debug_info', None)
        self.script_path = kwargs.get('script_path', None)
        self.script_linked_service = kwargs.get('script_linked_service', None)
        self.defines = kwargs.get('defines', None)


class HDInsightSparkActivity(ExecutionActivity):
    """HDInsight Spark activity.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param name: Required. Activity name.
    :type name: str
    :param type: Required. Type of activity.Constant filled by server.
    :type type: str
    :param description: Activity description.
    :type description: str
    :param depends_on: Activity depends on condition.
    :type depends_on: list[~azure.synapse.artifacts.models.ActivityDependency]
    :param user_properties: Activity user properties.
    :type user_properties: list[~azure.synapse.artifacts.models.UserProperty]
    :param linked_service_name: Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param policy: Activity policy.
    :type policy: ~azure.synapse.artifacts.models.ActivityPolicy
    :param root_path: Required. The root path in 'sparkJobLinkedService' for all the job’s files.
     Type: string (or Expression with resultType string).
    :type root_path: object
    :param entry_file_path: Required. The relative path to the root folder of the code/package to
     be executed. Type: string (or Expression with resultType string).
    :type entry_file_path: object
    :param arguments: The user-specified arguments to HDInsightSparkActivity.
    :type arguments: list[object]
    :param get_debug_info: Debug info option. Possible values include: "None", "Always", "Failure".
    :type get_debug_info: str or ~azure.synapse.artifacts.models.HDInsightActivityDebugInfoOption
    :param spark_job_linked_service: The storage linked service for uploading the entry file and
     dependencies, and for receiving logs.
    :type spark_job_linked_service: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param class_name: The application's Java/Spark main class.
    :type class_name: str
    :param proxy_user: The user to impersonate that will execute the job. Type: string (or
     Expression with resultType string).
    :type proxy_user: object
    :param spark_config: Spark configuration property.
    :type spark_config: dict[str, object]
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
        'root_path': {'required': True},
        'entry_file_path': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'depends_on': {'key': 'dependsOn', 'type': '[ActivityDependency]'},
        'user_properties': {'key': 'userProperties', 'type': '[UserProperty]'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'policy': {'key': 'policy', 'type': 'ActivityPolicy'},
        'root_path': {'key': 'typeProperties.rootPath', 'type': 'object'},
        'entry_file_path': {'key': 'typeProperties.entryFilePath', 'type': 'object'},
        'arguments': {'key': 'typeProperties.arguments', 'type': '[object]'},
        'get_debug_info': {'key': 'typeProperties.getDebugInfo', 'type': 'str'},
        'spark_job_linked_service': {'key': 'typeProperties.sparkJobLinkedService', 'type': 'LinkedServiceReference'},
        'class_name': {'key': 'typeProperties.className', 'type': 'str'},
        'proxy_user': {'key': 'typeProperties.proxyUser', 'type': 'object'},
        'spark_config': {'key': 'typeProperties.sparkConfig', 'type': '{object}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HDInsightSparkActivity, self).__init__(**kwargs)
        self.type = 'HDInsightSpark'  # type: str
        self.root_path = kwargs['root_path']
        self.entry_file_path = kwargs['entry_file_path']
        self.arguments = kwargs.get('arguments', None)
        self.get_debug_info = kwargs.get('get_debug_info', None)
        self.spark_job_linked_service = kwargs.get('spark_job_linked_service', None)
        self.class_name = kwargs.get('class_name', None)
        self.proxy_user = kwargs.get('proxy_user', None)
        self.spark_config = kwargs.get('spark_config', None)


class HDInsightStreamingActivity(ExecutionActivity):
    """HDInsight streaming activity type.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param name: Required. Activity name.
    :type name: str
    :param type: Required. Type of activity.Constant filled by server.
    :type type: str
    :param description: Activity description.
    :type description: str
    :param depends_on: Activity depends on condition.
    :type depends_on: list[~azure.synapse.artifacts.models.ActivityDependency]
    :param user_properties: Activity user properties.
    :type user_properties: list[~azure.synapse.artifacts.models.UserProperty]
    :param linked_service_name: Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param policy: Activity policy.
    :type policy: ~azure.synapse.artifacts.models.ActivityPolicy
    :param storage_linked_services: Storage linked service references.
    :type storage_linked_services: list[~azure.synapse.artifacts.models.LinkedServiceReference]
    :param arguments: User specified arguments to HDInsightActivity.
    :type arguments: list[object]
    :param get_debug_info: Debug info option. Possible values include: "None", "Always", "Failure".
    :type get_debug_info: str or ~azure.synapse.artifacts.models.HDInsightActivityDebugInfoOption
    :param mapper: Required. Mapper executable name. Type: string (or Expression with resultType
     string).
    :type mapper: object
    :param reducer: Required. Reducer executable name. Type: string (or Expression with resultType
     string).
    :type reducer: object
    :param input: Required. Input blob path. Type: string (or Expression with resultType string).
    :type input: object
    :param output: Required. Output blob path. Type: string (or Expression with resultType string).
    :type output: object
    :param file_paths: Required. Paths to streaming job files. Can be directories.
    :type file_paths: list[object]
    :param file_linked_service: Linked service reference where the files are located.
    :type file_linked_service: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param combiner: Combiner executable name. Type: string (or Expression with resultType string).
    :type combiner: object
    :param command_environment: Command line environment values.
    :type command_environment: list[object]
    :param defines: Allows user to specify defines for streaming job request.
    :type defines: dict[str, object]
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
        'mapper': {'required': True},
        'reducer': {'required': True},
        'input': {'required': True},
        'output': {'required': True},
        'file_paths': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'depends_on': {'key': 'dependsOn', 'type': '[ActivityDependency]'},
        'user_properties': {'key': 'userProperties', 'type': '[UserProperty]'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'policy': {'key': 'policy', 'type': 'ActivityPolicy'},
        'storage_linked_services': {'key': 'typeProperties.storageLinkedServices', 'type': '[LinkedServiceReference]'},
        'arguments': {'key': 'typeProperties.arguments', 'type': '[object]'},
        'get_debug_info': {'key': 'typeProperties.getDebugInfo', 'type': 'str'},
        'mapper': {'key': 'typeProperties.mapper', 'type': 'object'},
        'reducer': {'key': 'typeProperties.reducer', 'type': 'object'},
        'input': {'key': 'typeProperties.input', 'type': 'object'},
        'output': {'key': 'typeProperties.output', 'type': 'object'},
        'file_paths': {'key': 'typeProperties.filePaths', 'type': '[object]'},
        'file_linked_service': {'key': 'typeProperties.fileLinkedService', 'type': 'LinkedServiceReference'},
        'combiner': {'key': 'typeProperties.combiner', 'type': 'object'},
        'command_environment': {'key': 'typeProperties.commandEnvironment', 'type': '[object]'},
        'defines': {'key': 'typeProperties.defines', 'type': '{object}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HDInsightStreamingActivity, self).__init__(**kwargs)
        self.type = 'HDInsightStreaming'  # type: str
        self.storage_linked_services = kwargs.get('storage_linked_services', None)
        self.arguments = kwargs.get('arguments', None)
        self.get_debug_info = kwargs.get('get_debug_info', None)
        self.mapper = kwargs['mapper']
        self.reducer = kwargs['reducer']
        self.input = kwargs['input']
        self.output = kwargs['output']
        self.file_paths = kwargs['file_paths']
        self.file_linked_service = kwargs.get('file_linked_service', None)
        self.combiner = kwargs.get('combiner', None)
        self.command_environment = kwargs.get('command_environment', None)
        self.defines = kwargs.get('defines', None)


class HiveLinkedService(LinkedService):
    """Hive Server linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param host: Required. IP address or host name of the Hive server, separated by ';' for
     multiple hosts (only when serviceDiscoveryMode is enable).
    :type host: object
    :param port: The TCP port that the Hive server uses to listen for client connections.
    :type port: object
    :param server_type: The type of Hive server. Possible values include: "HiveServer1",
     "HiveServer2", "HiveThriftServer".
    :type server_type: str or ~azure.synapse.artifacts.models.HiveServerType
    :param thrift_transport_protocol: The transport protocol to use in the Thrift layer. Possible
     values include: "Binary", "SASL", "HTTP ".
    :type thrift_transport_protocol: str or
     ~azure.synapse.artifacts.models.HiveThriftTransportProtocol
    :param authentication_type: Required. The authentication method used to access the Hive server.
     Possible values include: "Anonymous", "Username", "UsernameAndPassword",
     "WindowsAzureHDInsightService".
    :type authentication_type: str or ~azure.synapse.artifacts.models.HiveAuthenticationType
    :param service_discovery_mode: true to indicate using the ZooKeeper service, false not.
    :type service_discovery_mode: object
    :param zoo_keeper_name_space: The namespace on ZooKeeper under which Hive Server 2 nodes are
     added.
    :type zoo_keeper_name_space: object
    :param use_native_query: Specifies whether the driver uses native HiveQL queries,or converts
     them into an equivalent form in HiveQL.
    :type use_native_query: object
    :param username: The user name that you use to access Hive Server.
    :type username: object
    :param password: The password corresponding to the user name that you provided in the Username
     field.
    :type password: ~azure.synapse.artifacts.models.SecretBase
    :param http_path: The partial URL corresponding to the Hive server.
    :type http_path: object
    :param enable_ssl: Specifies whether the connections to the server are encrypted using SSL. The
     default value is false.
    :type enable_ssl: object
    :param trusted_cert_path: The full path of the .pem file containing trusted CA certificates for
     verifying the server when connecting over SSL. This property can only be set when using SSL on
     self-hosted IR. The default value is the cacerts.pem file installed with the IR.
    :type trusted_cert_path: object
    :param use_system_trust_store: Specifies whether to use a CA certificate from the system trust
     store or from a specified PEM file. The default value is false.
    :type use_system_trust_store: object
    :param allow_host_name_cn_mismatch: Specifies whether to require a CA-issued SSL certificate
     name to match the host name of the server when connecting over SSL. The default value is false.
    :type allow_host_name_cn_mismatch: object
    :param allow_self_signed_server_cert: Specifies whether to allow self-signed certificates from
     the server. The default value is false.
    :type allow_self_signed_server_cert: object
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'host': {'required': True},
        'authentication_type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'host': {'key': 'typeProperties.host', 'type': 'object'},
        'port': {'key': 'typeProperties.port', 'type': 'object'},
        'server_type': {'key': 'typeProperties.serverType', 'type': 'str'},
        'thrift_transport_protocol': {'key': 'typeProperties.thriftTransportProtocol', 'type': 'str'},
        'authentication_type': {'key': 'typeProperties.authenticationType', 'type': 'str'},
        'service_discovery_mode': {'key': 'typeProperties.serviceDiscoveryMode', 'type': 'object'},
        'zoo_keeper_name_space': {'key': 'typeProperties.zooKeeperNameSpace', 'type': 'object'},
        'use_native_query': {'key': 'typeProperties.useNativeQuery', 'type': 'object'},
        'username': {'key': 'typeProperties.username', 'type': 'object'},
        'password': {'key': 'typeProperties.password', 'type': 'SecretBase'},
        'http_path': {'key': 'typeProperties.httpPath', 'type': 'object'},
        'enable_ssl': {'key': 'typeProperties.enableSsl', 'type': 'object'},
        'trusted_cert_path': {'key': 'typeProperties.trustedCertPath', 'type': 'object'},
        'use_system_trust_store': {'key': 'typeProperties.useSystemTrustStore', 'type': 'object'},
        'allow_host_name_cn_mismatch': {'key': 'typeProperties.allowHostNameCNMismatch', 'type': 'object'},
        'allow_self_signed_server_cert': {'key': 'typeProperties.allowSelfSignedServerCert', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HiveLinkedService, self).__init__(**kwargs)
        self.type = 'Hive'  # type: str
        self.host = kwargs['host']
        self.port = kwargs.get('port', None)
        self.server_type = kwargs.get('server_type', None)
        self.thrift_transport_protocol = kwargs.get('thrift_transport_protocol', None)
        self.authentication_type = kwargs['authentication_type']
        self.service_discovery_mode = kwargs.get('service_discovery_mode', None)
        self.zoo_keeper_name_space = kwargs.get('zoo_keeper_name_space', None)
        self.use_native_query = kwargs.get('use_native_query', None)
        self.username = kwargs.get('username', None)
        self.password = kwargs.get('password', None)
        self.http_path = kwargs.get('http_path', None)
        self.enable_ssl = kwargs.get('enable_ssl', None)
        self.trusted_cert_path = kwargs.get('trusted_cert_path', None)
        self.use_system_trust_store = kwargs.get('use_system_trust_store', None)
        self.allow_host_name_cn_mismatch = kwargs.get('allow_host_name_cn_mismatch', None)
        self.allow_self_signed_server_cert = kwargs.get('allow_self_signed_server_cert', None)
        self.encrypted_credential = kwargs.get('encrypted_credential', None)


class HiveObjectDataset(Dataset):
    """Hive Server dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param table_name: This property will be retired. Please consider using schema + table
     properties instead.
    :type table_name: object
    :param table: The table name of the Hive. Type: string (or Expression with resultType string).
    :type table: object
    :param schema_type_properties_schema: The schema name of the Hive. Type: string (or Expression
     with resultType string).
    :type schema_type_properties_schema: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table_name': {'key': 'typeProperties.tableName', 'type': 'object'},
        'table': {'key': 'typeProperties.table', 'type': 'object'},
        'schema_type_properties_schema': {'key': 'typeProperties.schema', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HiveObjectDataset, self).__init__(**kwargs)
        self.type = 'HiveObject'  # type: str
        self.table_name = kwargs.get('table_name', None)
        self.table = kwargs.get('table', None)
        self.schema_type_properties_schema = kwargs.get('schema_type_properties_schema', None)


class HiveSource(TabularSource):
    """A copy activity Hive Server source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: object
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param query_timeout: Query timeout. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type query_timeout: object
    :param query: A query to retrieve data from source. Type: string (or Expression with resultType
     string).
    :type query: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'query_timeout': {'key': 'queryTimeout', 'type': 'object'},
        'query': {'key': 'query', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HiveSource, self).__init__(**kwargs)
        self.type = 'HiveSource'  # type: str
        self.query = kwargs.get('query', None)


class HttpLinkedService(LinkedService):
    """Linked service for an HTTP source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param url: Required. The base URL of the HTTP endpoint, e.g. http://www.microsoft.com. Type:
     string (or Expression with resultType string).
    :type url: object
    :param authentication_type: The authentication type to be used to connect to the HTTP server.
     Possible values include: "Basic", "Anonymous", "Digest", "Windows", "ClientCertificate".
    :type authentication_type: str or ~azure.synapse.artifacts.models.HttpAuthenticationType
    :param user_name: User name for Basic, Digest, or Windows authentication. Type: string (or
     Expression with resultType string).
    :type user_name: object
    :param password: Password for Basic, Digest, Windows, or ClientCertificate with
     EmbeddedCertData authentication.
    :type password: ~azure.synapse.artifacts.models.SecretBase
    :param embedded_cert_data: Base64 encoded certificate data for ClientCertificate
     authentication. For on-premises copy with ClientCertificate authentication, either
     CertThumbprint or EmbeddedCertData/Password should be specified. Type: string (or Expression
     with resultType string).
    :type embedded_cert_data: object
    :param cert_thumbprint: Thumbprint of certificate for ClientCertificate authentication. Only
     valid for on-premises copy. For on-premises copy with ClientCertificate authentication, either
     CertThumbprint or EmbeddedCertData/Password should be specified. Type: string (or Expression
     with resultType string).
    :type cert_thumbprint: object
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    :param enable_server_certificate_validation: If true, validate the HTTPS server SSL
     certificate. Default value is true. Type: boolean (or Expression with resultType boolean).
    :type enable_server_certificate_validation: object
    """

    _validation = {
        'type': {'required': True},
        'url': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'url': {'key': 'typeProperties.url', 'type': 'object'},
        'authentication_type': {'key': 'typeProperties.authenticationType', 'type': 'str'},
        'user_name': {'key': 'typeProperties.userName', 'type': 'object'},
        'password': {'key': 'typeProperties.password', 'type': 'SecretBase'},
        'embedded_cert_data': {'key': 'typeProperties.embeddedCertData', 'type': 'object'},
        'cert_thumbprint': {'key': 'typeProperties.certThumbprint', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
        'enable_server_certificate_validation': {'key': 'typeProperties.enableServerCertificateValidation', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HttpLinkedService, self).__init__(**kwargs)
        self.type = 'HttpServer'  # type: str
        self.url = kwargs['url']
        self.authentication_type = kwargs.get('authentication_type', None)
        self.user_name = kwargs.get('user_name', None)
        self.password = kwargs.get('password', None)
        self.embedded_cert_data = kwargs.get('embedded_cert_data', None)
        self.cert_thumbprint = kwargs.get('cert_thumbprint', None)
        self.encrypted_credential = kwargs.get('encrypted_credential', None)
        self.enable_server_certificate_validation = kwargs.get('enable_server_certificate_validation', None)


class HttpReadSettings(StoreReadSettings):
    """Sftp read settings.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. The read setting type.Constant filled by server.
    :type type: str
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param request_method: The HTTP method used to call the RESTful API. The default is GET. Type:
     string (or Expression with resultType string).
    :type request_method: object
    :param request_body: The HTTP request body to the RESTful API if requestMethod is POST. Type:
     string (or Expression with resultType string).
    :type request_body: object
    :param additional_headers: The additional HTTP headers in the request to the RESTful API. Type:
     string (or Expression with resultType string).
    :type additional_headers: object
    :param request_timeout: Specifies the timeout for a HTTP client to get HTTP response from HTTP
     server.
    :type request_timeout: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'request_method': {'key': 'requestMethod', 'type': 'object'},
        'request_body': {'key': 'requestBody', 'type': 'object'},
        'additional_headers': {'key': 'additionalHeaders', 'type': 'object'},
        'request_timeout': {'key': 'requestTimeout', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HttpReadSettings, self).__init__(**kwargs)
        self.type = 'HttpReadSettings'  # type: str
        self.request_method = kwargs.get('request_method', None)
        self.request_body = kwargs.get('request_body', None)
        self.additional_headers = kwargs.get('additional_headers', None)
        self.request_timeout = kwargs.get('request_timeout', None)


class HttpServerLocation(DatasetLocation):
    """The location of http server.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset storage location.Constant filled by server.
    :type type: str
    :param folder_path: Specify the folder path of dataset. Type: string (or Expression with
     resultType string).
    :type folder_path: object
    :param file_name: Specify the file name of dataset. Type: string (or Expression with resultType
     string).
    :type file_name: object
    :param relative_url: Specify the relativeUrl of http server. Type: string (or Expression with
     resultType string).
    :type relative_url: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'folder_path': {'key': 'folderPath', 'type': 'object'},
        'file_name': {'key': 'fileName', 'type': 'object'},
        'relative_url': {'key': 'relativeUrl', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HttpServerLocation, self).__init__(**kwargs)
        self.type = 'HttpServerLocation'  # type: str
        self.relative_url = kwargs.get('relative_url', None)


class HttpSource(CopySource):
    """A copy activity source for an HTTP file.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: object
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param http_request_timeout: Specifies the timeout for a HTTP client to get HTTP response from
     HTTP server. The default value is equivalent to System.Net.HttpWebRequest.Timeout. Type: string
     (or Expression with resultType string), pattern:
     ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type http_request_timeout: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'http_request_timeout': {'key': 'httpRequestTimeout', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HttpSource, self).__init__(**kwargs)
        self.type = 'HttpSource'  # type: str
        self.http_request_timeout = kwargs.get('http_request_timeout', None)


class HubspotLinkedService(LinkedService):
    """Hubspot Service linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param client_id: Required. The client ID associated with your Hubspot application.
    :type client_id: object
    :param client_secret: The client secret associated with your Hubspot application.
    :type client_secret: ~azure.synapse.artifacts.models.SecretBase
    :param access_token: The access token obtained when initially authenticating your OAuth
     integration.
    :type access_token: ~azure.synapse.artifacts.models.SecretBase
    :param refresh_token: The refresh token obtained when initially authenticating your OAuth
     integration.
    :type refresh_token: ~azure.synapse.artifacts.models.SecretBase
    :param use_encrypted_endpoints: Specifies whether the data source endpoints are encrypted using
     HTTPS. The default value is true.
    :type use_encrypted_endpoints: object
    :param use_host_verification: Specifies whether to require the host name in the server's
     certificate to match the host name of the server when connecting over SSL. The default value is
     true.
    :type use_host_verification: object
    :param use_peer_verification: Specifies whether to verify the identity of the server when
     connecting over SSL. The default value is true.
    :type use_peer_verification: object
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'client_id': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'client_id': {'key': 'typeProperties.clientId', 'type': 'object'},
        'client_secret': {'key': 'typeProperties.clientSecret', 'type': 'SecretBase'},
        'access_token': {'key': 'typeProperties.accessToken', 'type': 'SecretBase'},
        'refresh_token': {'key': 'typeProperties.refreshToken', 'type': 'SecretBase'},
        'use_encrypted_endpoints': {'key': 'typeProperties.useEncryptedEndpoints', 'type': 'object'},
        'use_host_verification': {'key': 'typeProperties.useHostVerification', 'type': 'object'},
        'use_peer_verification': {'key': 'typeProperties.usePeerVerification', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HubspotLinkedService, self).__init__(**kwargs)
        self.type = 'Hubspot'  # type: str
        self.client_id = kwargs['client_id']
        self.client_secret = kwargs.get('client_secret', None)
        self.access_token = kwargs.get('access_token', None)
        self.refresh_token = kwargs.get('refresh_token', None)
        self.use_encrypted_endpoints = kwargs.get('use_encrypted_endpoints', None)
        self.use_host_verification = kwargs.get('use_host_verification', None)
        self.use_peer_verification = kwargs.get('use_peer_verification', None)
        self.encrypted_credential = kwargs.get('encrypted_credential', None)


class HubspotObjectDataset(Dataset):
    """Hubspot Service dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param table_name: The table name. Type: string (or Expression with resultType string).
    :type table_name: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table_name': {'key': 'typeProperties.tableName', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HubspotObjectDataset, self).__init__(**kwargs)
        self.type = 'HubspotObject'  # type: str
        self.table_name = kwargs.get('table_name', None)


class HubspotSource(TabularSource):
    """A copy activity Hubspot Service source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: object
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param query_timeout: Query timeout. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type query_timeout: object
    :param query: A query to retrieve data from source. Type: string (or Expression with resultType
     string).
    :type query: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'query_timeout': {'key': 'queryTimeout', 'type': 'object'},
        'query': {'key': 'query', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HubspotSource, self).__init__(**kwargs)
        self.type = 'HubspotSource'  # type: str
        self.query = kwargs.get('query', None)


class IfConditionActivity(Activity):
    """This activity evaluates a boolean expression and executes either the activities under the ifTrueActivities property or the ifFalseActivities property depending on the result of the expression.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param name: Required. Activity name.
    :type name: str
    :param type: Required. Type of activity.Constant filled by server.
    :type type: str
    :param description: Activity description.
    :type description: str
    :param depends_on: Activity depends on condition.
    :type depends_on: list[~azure.synapse.artifacts.models.ActivityDependency]
    :param user_properties: Activity user properties.
    :type user_properties: list[~azure.synapse.artifacts.models.UserProperty]
    :param expression: Required. An expression that would evaluate to Boolean. This is used to
     determine the block of activities (ifTrueActivities or ifFalseActivities) that will be
     executed.
    :type expression: ~azure.synapse.artifacts.models.Expression
    :param if_true_activities: List of activities to execute if expression is evaluated to true.
     This is an optional property and if not provided, the activity will exit without any action.
    :type if_true_activities: list[~azure.synapse.artifacts.models.Activity]
    :param if_false_activities: List of activities to execute if expression is evaluated to false.
     This is an optional property and if not provided, the activity will exit without any action.
    :type if_false_activities: list[~azure.synapse.artifacts.models.Activity]
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
        'expression': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'depends_on': {'key': 'dependsOn', 'type': '[ActivityDependency]'},
        'user_properties': {'key': 'userProperties', 'type': '[UserProperty]'},
        'expression': {'key': 'typeProperties.expression', 'type': 'Expression'},
        'if_true_activities': {'key': 'typeProperties.ifTrueActivities', 'type': '[Activity]'},
        'if_false_activities': {'key': 'typeProperties.ifFalseActivities', 'type': '[Activity]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(IfConditionActivity, self).__init__(**kwargs)
        self.type = 'IfCondition'  # type: str
        self.expression = kwargs['expression']
        self.if_true_activities = kwargs.get('if_true_activities', None)
        self.if_false_activities = kwargs.get('if_false_activities', None)


class ImpalaLinkedService(LinkedService):
    """Impala server linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param host: Required. The IP address or host name of the Impala server. (i.e.
     192.168.222.160).
    :type host: object
    :param port: The TCP port that the Impala server uses to listen for client connections. The
     default value is 21050.
    :type port: object
    :param authentication_type: Required. The authentication type to use. Possible values include:
     "Anonymous", "SASLUsername", "UsernameAndPassword".
    :type authentication_type: str or ~azure.synapse.artifacts.models.ImpalaAuthenticationType
    :param username: The user name used to access the Impala server. The default value is anonymous
     when using SASLUsername.
    :type username: object
    :param password: The password corresponding to the user name when using UsernameAndPassword.
    :type password: ~azure.synapse.artifacts.models.SecretBase
    :param enable_ssl: Specifies whether the connections to the server are encrypted using SSL. The
     default value is false.
    :type enable_ssl: object
    :param trusted_cert_path: The full path of the .pem file containing trusted CA certificates for
     verifying the server when connecting over SSL. This property can only be set when using SSL on
     self-hosted IR. The default value is the cacerts.pem file installed with the IR.
    :type trusted_cert_path: object
    :param use_system_trust_store: Specifies whether to use a CA certificate from the system trust
     store or from a specified PEM file. The default value is false.
    :type use_system_trust_store: object
    :param allow_host_name_cn_mismatch: Specifies whether to require a CA-issued SSL certificate
     name to match the host name of the server when connecting over SSL. The default value is false.
    :type allow_host_name_cn_mismatch: object
    :param allow_self_signed_server_cert: Specifies whether to allow self-signed certificates from
     the server. The default value is false.
    :type allow_self_signed_server_cert: object
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'host': {'required': True},
        'authentication_type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'host': {'key': 'typeProperties.host', 'type': 'object'},
        'port': {'key': 'typeProperties.port', 'type': 'object'},
        'authentication_type': {'key': 'typeProperties.authenticationType', 'type': 'str'},
        'username': {'key': 'typeProperties.username', 'type': 'object'},
        'password': {'key': 'typeProperties.password', 'type': 'SecretBase'},
        'enable_ssl': {'key': 'typeProperties.enableSsl', 'type': 'object'},
        'trusted_cert_path': {'key': 'typeProperties.trustedCertPath', 'type': 'object'},
        'use_system_trust_store': {'key': 'typeProperties.useSystemTrustStore', 'type': 'object'},
        'allow_host_name_cn_mismatch': {'key': 'typeProperties.allowHostNameCNMismatch', 'type': 'object'},
        'allow_self_signed_server_cert': {'key': 'typeProperties.allowSelfSignedServerCert', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ImpalaLinkedService, self).__init__(**kwargs)
        self.type = 'Impala'  # type: str
        self.host = kwargs['host']
        self.port = kwargs.get('port', None)
        self.authentication_type = kwargs['authentication_type']
        self.username = kwargs.get('username', None)
        self.password = kwargs.get('password', None)
        self.enable_ssl = kwargs.get('enable_ssl', None)
        self.trusted_cert_path = kwargs.get('trusted_cert_path', None)
        self.use_system_trust_store = kwargs.get('use_system_trust_store', None)
        self.allow_host_name_cn_mismatch = kwargs.get('allow_host_name_cn_mismatch', None)
        self.allow_self_signed_server_cert = kwargs.get('allow_self_signed_server_cert', None)
        self.encrypted_credential = kwargs.get('encrypted_credential', None)


class ImpalaObjectDataset(Dataset):
    """Impala server dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param table_name: This property will be retired. Please consider using schema + table
     properties instead.
    :type table_name: object
    :param table: The table name of the Impala. Type: string (or Expression with resultType
     string).
    :type table: object
    :param schema_type_properties_schema: The schema name of the Impala. Type: string (or
     Expression with resultType string).
    :type schema_type_properties_schema: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table_name': {'key': 'typeProperties.tableName', 'type': 'object'},
        'table': {'key': 'typeProperties.table', 'type': 'object'},
        'schema_type_properties_schema': {'key': 'typeProperties.schema', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ImpalaObjectDataset, self).__init__(**kwargs)
        self.type = 'ImpalaObject'  # type: str
        self.table_name = kwargs.get('table_name', None)
        self.table = kwargs.get('table', None)
        self.schema_type_properties_schema = kwargs.get('schema_type_properties_schema', None)


class ImpalaSource(TabularSource):
    """A copy activity Impala server source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: object
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param query_timeout: Query timeout. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type query_timeout: object
    :param query: A query to retrieve data from source. Type: string (or Expression with resultType
     string).
    :type query: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'query_timeout': {'key': 'queryTimeout', 'type': 'object'},
        'query': {'key': 'query', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ImpalaSource, self).__init__(**kwargs)
        self.type = 'ImpalaSource'  # type: str
        self.query = kwargs.get('query', None)


class InformixLinkedService(LinkedService):
    """Informix linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param connection_string: Required. The non-access credential portion of the connection string
     as well as an optional encrypted credential. Type: string, SecureString or
     AzureKeyVaultSecretReference.
    :type connection_string: object
    :param authentication_type: Type of authentication used to connect to the Informix as ODBC data
     store. Possible values are: Anonymous and Basic. Type: string (or Expression with resultType
     string).
    :type authentication_type: object
    :param credential: The access credential portion of the connection string specified in driver-
     specific property-value format.
    :type credential: ~azure.synapse.artifacts.models.SecretBase
    :param user_name: User name for Basic authentication. Type: string (or Expression with
     resultType string).
    :type user_name: object
    :param password: Password for Basic authentication.
    :type password: ~azure.synapse.artifacts.models.SecretBase
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'connection_string': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'connection_string': {'key': 'typeProperties.connectionString', 'type': 'object'},
        'authentication_type': {'key': 'typeProperties.authenticationType', 'type': 'object'},
        'credential': {'key': 'typeProperties.credential', 'type': 'SecretBase'},
        'user_name': {'key': 'typeProperties.userName', 'type': 'object'},
        'password': {'key': 'typeProperties.password', 'type': 'SecretBase'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(InformixLinkedService, self).__init__(**kwargs)
        self.type = 'Informix'  # type: str
        self.connection_string = kwargs['connection_string']
        self.authentication_type = kwargs.get('authentication_type', None)
        self.credential = kwargs.get('credential', None)
        self.user_name = kwargs.get('user_name', None)
        self.password = kwargs.get('password', None)
        self.encrypted_credential = kwargs.get('encrypted_credential', None)


class InformixSink(CopySink):
    """A copy activity Informix sink.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy sink type.Constant filled by server.
    :type type: str
    :param write_batch_size: Write batch size. Type: integer (or Expression with resultType
     integer), minimum: 0.
    :type write_batch_size: object
    :param write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type write_batch_timeout: object
    :param sink_retry_count: Sink retry count. Type: integer (or Expression with resultType
     integer).
    :type sink_retry_count: object
    :param sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type sink_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the sink data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param pre_copy_script: A query to execute before starting the copy. Type: string (or
     Expression with resultType string).
    :type pre_copy_script: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'write_batch_size': {'key': 'writeBatchSize', 'type': 'object'},
        'write_batch_timeout': {'key': 'writeBatchTimeout', 'type': 'object'},
        'sink_retry_count': {'key': 'sinkRetryCount', 'type': 'object'},
        'sink_retry_wait': {'key': 'sinkRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'pre_copy_script': {'key': 'preCopyScript', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(InformixSink, self).__init__(**kwargs)
        self.type = 'InformixSink'  # type: str
        self.pre_copy_script = kwargs.get('pre_copy_script', None)


class InformixSource(TabularSource):
    """A copy activity source for Informix.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: object
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param query_timeout: Query timeout. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type query_timeout: object
    :param query: Database query. Type: string (or Expression with resultType string).
    :type query: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'query_timeout': {'key': 'queryTimeout', 'type': 'object'},
        'query': {'key': 'query', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(InformixSource, self).__init__(**kwargs)
        self.type = 'InformixSource'  # type: str
        self.query = kwargs.get('query', None)


class InformixTableDataset(Dataset):
    """The Informix table dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param table_name: The Informix table name. Type: string (or Expression with resultType
     string).
    :type table_name: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table_name': {'key': 'typeProperties.tableName', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(InformixTableDataset, self).__init__(**kwargs)
        self.type = 'InformixTable'  # type: str
        self.table_name = kwargs.get('table_name', None)


class IntegrationRuntime(msrest.serialization.Model):
    """Azure Synapse nested object which serves as a compute resource for activities.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: ManagedIntegrationRuntime, SelfHostedIntegrationRuntime.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of integration runtime.Constant filled by server.  Possible values
     include: "Managed", "SelfHosted".
    :type type: str or ~azure.synapse.artifacts.models.IntegrationRuntimeType
    :param description: Integration runtime description.
    :type description: str
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    _subtype_map = {
        'type': {'Managed': 'ManagedIntegrationRuntime', 'SelfHosted': 'SelfHostedIntegrationRuntime'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(IntegrationRuntime, self).__init__(**kwargs)
        self.additional_properties = kwargs.get('additional_properties', None)
        self.type = 'IntegrationRuntime'  # type: str
        self.description = kwargs.get('description', None)


class IntegrationRuntimeComputeProperties(msrest.serialization.Model):
    """The compute resource properties for managed integration runtime.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param location: The location for managed integration runtime. The supported regions could be
     found on https://docs.microsoft.com/en-us/azure/data-factory/data-factory-data-movement-
     activities.
    :type location: str
    :param node_size: The node size requirement to managed integration runtime.
    :type node_size: str
    :param number_of_nodes: The required number of nodes for managed integration runtime.
    :type number_of_nodes: int
    :param max_parallel_executions_per_node: Maximum parallel executions count per node for managed
     integration runtime.
    :type max_parallel_executions_per_node: int
    :param data_flow_properties: Data flow properties for managed integration runtime.
    :type data_flow_properties:
     ~azure.synapse.artifacts.models.IntegrationRuntimeDataFlowProperties
    :param v_net_properties: VNet properties for managed integration runtime.
    :type v_net_properties: ~azure.synapse.artifacts.models.IntegrationRuntimeVNetProperties
    """

    _validation = {
        'number_of_nodes': {'minimum': 1},
        'max_parallel_executions_per_node': {'minimum': 1},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'location': {'key': 'location', 'type': 'str'},
        'node_size': {'key': 'nodeSize', 'type': 'str'},
        'number_of_nodes': {'key': 'numberOfNodes', 'type': 'int'},
        'max_parallel_executions_per_node': {'key': 'maxParallelExecutionsPerNode', 'type': 'int'},
        'data_flow_properties': {'key': 'dataFlowProperties', 'type': 'IntegrationRuntimeDataFlowProperties'},
        'v_net_properties': {'key': 'vNetProperties', 'type': 'IntegrationRuntimeVNetProperties'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(IntegrationRuntimeComputeProperties, self).__init__(**kwargs)
        self.additional_properties = kwargs.get('additional_properties', None)
        self.location = kwargs.get('location', None)
        self.node_size = kwargs.get('node_size', None)
        self.number_of_nodes = kwargs.get('number_of_nodes', None)
        self.max_parallel_executions_per_node = kwargs.get('max_parallel_executions_per_node', None)
        self.data_flow_properties = kwargs.get('data_flow_properties', None)
        self.v_net_properties = kwargs.get('v_net_properties', None)


class IntegrationRuntimeCustomSetupScriptProperties(msrest.serialization.Model):
    """Custom setup script properties for a managed dedicated integration runtime.

    :param blob_container_uri: The URI of the Azure blob container that contains the custom setup
     script.
    :type blob_container_uri: str
    :param sas_token: The SAS token of the Azure blob container.
    :type sas_token: ~azure.synapse.artifacts.models.SecureString
    """

    _attribute_map = {
        'blob_container_uri': {'key': 'blobContainerUri', 'type': 'str'},
        'sas_token': {'key': 'sasToken', 'type': 'SecureString'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(IntegrationRuntimeCustomSetupScriptProperties, self).__init__(**kwargs)
        self.blob_container_uri = kwargs.get('blob_container_uri', None)
        self.sas_token = kwargs.get('sas_token', None)


class IntegrationRuntimeDataFlowProperties(msrest.serialization.Model):
    """Data flow properties for managed integration runtime.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param compute_type: Compute type of the cluster which will execute data flow job. Possible
     values include: "General", "MemoryOptimized", "ComputeOptimized".
    :type compute_type: str or ~azure.synapse.artifacts.models.DataFlowComputeType
    :param core_count: Core count of the cluster which will execute data flow job. Supported values
     are: 8, 16, 32, 48, 80, 144 and 272.
    :type core_count: int
    :param time_to_live: Time to live (in minutes) setting of the cluster which will execute data
     flow job.
    :type time_to_live: int
    """

    _validation = {
        'time_to_live': {'minimum': 0},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'compute_type': {'key': 'computeType', 'type': 'str'},
        'core_count': {'key': 'coreCount', 'type': 'int'},
        'time_to_live': {'key': 'timeToLive', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(IntegrationRuntimeDataFlowProperties, self).__init__(**kwargs)
        self.additional_properties = kwargs.get('additional_properties', None)
        self.compute_type = kwargs.get('compute_type', None)
        self.core_count = kwargs.get('core_count', None)
        self.time_to_live = kwargs.get('time_to_live', None)


class IntegrationRuntimeDataProxyProperties(msrest.serialization.Model):
    """Data proxy properties for a managed dedicated integration runtime.

    :param connect_via: The self-hosted integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.EntityReference
    :param staging_linked_service: The staging linked service reference.
    :type staging_linked_service: ~azure.synapse.artifacts.models.EntityReference
    :param path: The path to contain the staged data in the Blob storage.
    :type path: str
    """

    _attribute_map = {
        'connect_via': {'key': 'connectVia', 'type': 'EntityReference'},
        'staging_linked_service': {'key': 'stagingLinkedService', 'type': 'EntityReference'},
        'path': {'key': 'path', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(IntegrationRuntimeDataProxyProperties, self).__init__(**kwargs)
        self.connect_via = kwargs.get('connect_via', None)
        self.staging_linked_service = kwargs.get('staging_linked_service', None)
        self.path = kwargs.get('path', None)


class IntegrationRuntimeListResponse(msrest.serialization.Model):
    """A list of integration runtime resources.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. List of integration runtimes.
    :type value: list[~azure.synapse.artifacts.models.IntegrationRuntimeResource]
    :param next_link: The link to the next page of results, if any remaining results exist.
    :type next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[IntegrationRuntimeResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(IntegrationRuntimeListResponse, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = kwargs.get('next_link', None)


class IntegrationRuntimeReference(msrest.serialization.Model):
    """Integration runtime reference type.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Type of integration runtime. Possible values include:
     "IntegrationRuntimeReference".
    :type type: str or ~azure.synapse.artifacts.models.IntegrationRuntimeReferenceType
    :param reference_name: Required. Reference integration runtime name.
    :type reference_name: str
    :param parameters: Arguments for integration runtime.
    :type parameters: dict[str, object]
    """

    _validation = {
        'type': {'required': True},
        'reference_name': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'reference_name': {'key': 'referenceName', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{object}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(IntegrationRuntimeReference, self).__init__(**kwargs)
        self.type = kwargs['type']
        self.reference_name = kwargs['reference_name']
        self.parameters = kwargs.get('parameters', None)


class IntegrationRuntimeResource(AzureEntityResource):
    """Integration runtime resource type.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. Ex- Microsoft.Compute/virtualMachines or
     Microsoft.Storage/storageAccounts.
    :vartype type: str
    :ivar etag: Resource Etag.
    :vartype etag: str
    :param properties: Required. Integration runtime properties.
    :type properties: ~azure.synapse.artifacts.models.IntegrationRuntime
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'IntegrationRuntime'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(IntegrationRuntimeResource, self).__init__(**kwargs)
        self.properties = kwargs['properties']


class IntegrationRuntimeSsisCatalogInfo(msrest.serialization.Model):
    """Catalog information for managed dedicated integration runtime.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param catalog_server_endpoint: The catalog database server URL.
    :type catalog_server_endpoint: str
    :param catalog_admin_user_name: The administrator user name of catalog database.
    :type catalog_admin_user_name: str
    :param catalog_admin_password: The password of the administrator user account of the catalog
     database.
    :type catalog_admin_password: ~azure.synapse.artifacts.models.SecureString
    :param catalog_pricing_tier: The pricing tier for the catalog database. The valid values could
     be found in https://azure.microsoft.com/en-us/pricing/details/sql-database/. Possible values
     include: "Basic", "Standard", "Premium", "PremiumRS".
    :type catalog_pricing_tier: str or
     ~azure.synapse.artifacts.models.IntegrationRuntimeSsisCatalogPricingTier
    """

    _validation = {
        'catalog_admin_user_name': {'max_length': 128, 'min_length': 1},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'catalog_server_endpoint': {'key': 'catalogServerEndpoint', 'type': 'str'},
        'catalog_admin_user_name': {'key': 'catalogAdminUserName', 'type': 'str'},
        'catalog_admin_password': {'key': 'catalogAdminPassword', 'type': 'SecureString'},
        'catalog_pricing_tier': {'key': 'catalogPricingTier', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(IntegrationRuntimeSsisCatalogInfo, self).__init__(**kwargs)
        self.additional_properties = kwargs.get('additional_properties', None)
        self.catalog_server_endpoint = kwargs.get('catalog_server_endpoint', None)
        self.catalog_admin_user_name = kwargs.get('catalog_admin_user_name', None)
        self.catalog_admin_password = kwargs.get('catalog_admin_password', None)
        self.catalog_pricing_tier = kwargs.get('catalog_pricing_tier', None)


class IntegrationRuntimeSsisProperties(msrest.serialization.Model):
    """SSIS properties for managed integration runtime.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param catalog_info: Catalog information for managed dedicated integration runtime.
    :type catalog_info: ~azure.synapse.artifacts.models.IntegrationRuntimeSsisCatalogInfo
    :param license_type: License type for bringing your own license scenario. Possible values
     include: "BasePrice", "LicenseIncluded".
    :type license_type: str or ~azure.synapse.artifacts.models.IntegrationRuntimeLicenseType
    :param custom_setup_script_properties: Custom setup script properties for a managed dedicated
     integration runtime.
    :type custom_setup_script_properties:
     ~azure.synapse.artifacts.models.IntegrationRuntimeCustomSetupScriptProperties
    :param data_proxy_properties: Data proxy properties for a managed dedicated integration
     runtime.
    :type data_proxy_properties:
     ~azure.synapse.artifacts.models.IntegrationRuntimeDataProxyProperties
    :param edition: The edition for the SSIS Integration Runtime. Possible values include:
     "Standard", "Enterprise".
    :type edition: str or ~azure.synapse.artifacts.models.IntegrationRuntimeEdition
    :param express_custom_setup_properties: Custom setup without script properties for a SSIS
     integration runtime.
    :type express_custom_setup_properties: list[~azure.synapse.artifacts.models.CustomSetupBase]
    """

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'catalog_info': {'key': 'catalogInfo', 'type': 'IntegrationRuntimeSsisCatalogInfo'},
        'license_type': {'key': 'licenseType', 'type': 'str'},
        'custom_setup_script_properties': {'key': 'customSetupScriptProperties', 'type': 'IntegrationRuntimeCustomSetupScriptProperties'},
        'data_proxy_properties': {'key': 'dataProxyProperties', 'type': 'IntegrationRuntimeDataProxyProperties'},
        'edition': {'key': 'edition', 'type': 'str'},
        'express_custom_setup_properties': {'key': 'expressCustomSetupProperties', 'type': '[CustomSetupBase]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(IntegrationRuntimeSsisProperties, self).__init__(**kwargs)
        self.additional_properties = kwargs.get('additional_properties', None)
        self.catalog_info = kwargs.get('catalog_info', None)
        self.license_type = kwargs.get('license_type', None)
        self.custom_setup_script_properties = kwargs.get('custom_setup_script_properties', None)
        self.data_proxy_properties = kwargs.get('data_proxy_properties', None)
        self.edition = kwargs.get('edition', None)
        self.express_custom_setup_properties = kwargs.get('express_custom_setup_properties', None)


class IntegrationRuntimeVNetProperties(msrest.serialization.Model):
    """VNet properties for managed integration runtime.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param v_net_id: The ID of the VNet that this integration runtime will join.
    :type v_net_id: str
    :param subnet: The name of the subnet this integration runtime will join.
    :type subnet: str
    :param public_i_ps: Resource IDs of the public IP addresses that this integration runtime will
     use.
    :type public_i_ps: list[str]
    """

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'v_net_id': {'key': 'vNetId', 'type': 'str'},
        'subnet': {'key': 'subnet', 'type': 'str'},
        'public_i_ps': {'key': 'publicIPs', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(IntegrationRuntimeVNetProperties, self).__init__(**kwargs)
        self.additional_properties = kwargs.get('additional_properties', None)
        self.v_net_id = kwargs.get('v_net_id', None)
        self.subnet = kwargs.get('subnet', None)
        self.public_i_ps = kwargs.get('public_i_ps', None)


class JiraLinkedService(LinkedService):
    """Jira Service linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param host: Required. The IP address or host name of the Jira service. (e.g.
     jira.example.com).
    :type host: object
    :param port: The TCP port that the Jira server uses to listen for client connections. The
     default value is 443 if connecting through HTTPS, or 8080 if connecting through HTTP.
    :type port: object
    :param username: Required. The user name that you use to access Jira Service.
    :type username: object
    :param password: The password corresponding to the user name that you provided in the username
     field.
    :type password: ~azure.synapse.artifacts.models.SecretBase
    :param use_encrypted_endpoints: Specifies whether the data source endpoints are encrypted using
     HTTPS. The default value is true.
    :type use_encrypted_endpoints: object
    :param use_host_verification: Specifies whether to require the host name in the server's
     certificate to match the host name of the server when connecting over SSL. The default value is
     true.
    :type use_host_verification: object
    :param use_peer_verification: Specifies whether to verify the identity of the server when
     connecting over SSL. The default value is true.
    :type use_peer_verification: object
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'host': {'required': True},
        'username': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'host': {'key': 'typeProperties.host', 'type': 'object'},
        'port': {'key': 'typeProperties.port', 'type': 'object'},
        'username': {'key': 'typeProperties.username', 'type': 'object'},
        'password': {'key': 'typeProperties.password', 'type': 'SecretBase'},
        'use_encrypted_endpoints': {'key': 'typeProperties.useEncryptedEndpoints', 'type': 'object'},
        'use_host_verification': {'key': 'typeProperties.useHostVerification', 'type': 'object'},
        'use_peer_verification': {'key': 'typeProperties.usePeerVerification', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(JiraLinkedService, self).__init__(**kwargs)
        self.type = 'Jira'  # type: str
        self.host = kwargs['host']
        self.port = kwargs.get('port', None)
        self.username = kwargs['username']
        self.password = kwargs.get('password', None)
        self.use_encrypted_endpoints = kwargs.get('use_encrypted_endpoints', None)
        self.use_host_verification = kwargs.get('use_host_verification', None)
        self.use_peer_verification = kwargs.get('use_peer_verification', None)
        self.encrypted_credential = kwargs.get('encrypted_credential', None)


class JiraObjectDataset(Dataset):
    """Jira Service dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param table_name: The table name. Type: string (or Expression with resultType string).
    :type table_name: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table_name': {'key': 'typeProperties.tableName', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(JiraObjectDataset, self).__init__(**kwargs)
        self.type = 'JiraObject'  # type: str
        self.table_name = kwargs.get('table_name', None)


class JiraSource(TabularSource):
    """A copy activity Jira Service source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: object
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param query_timeout: Query timeout. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type query_timeout: object
    :param query: A query to retrieve data from source. Type: string (or Expression with resultType
     string).
    :type query: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'query_timeout': {'key': 'queryTimeout', 'type': 'object'},
        'query': {'key': 'query', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(JiraSource, self).__init__(**kwargs)
        self.type = 'JiraSource'  # type: str
        self.query = kwargs.get('query', None)


class JsonDataset(Dataset):
    """Json dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param location: The location of the json data storage.
    :type location: ~azure.synapse.artifacts.models.DatasetLocation
    :param encoding_name: The code page name of the preferred encoding. If not specified, the
     default value is UTF-8, unless BOM denotes another Unicode encoding. Refer to the name column
     of the table in the following link to set supported values:
     https://msdn.microsoft.com/library/system.text.encoding.aspx. Type: string (or Expression with
     resultType string).
    :type encoding_name: object
    :param compression: The data compression method used for the json dataset.
    :type compression: ~azure.synapse.artifacts.models.DatasetCompression
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'location': {'key': 'typeProperties.location', 'type': 'DatasetLocation'},
        'encoding_name': {'key': 'typeProperties.encodingName', 'type': 'object'},
        'compression': {'key': 'typeProperties.compression', 'type': 'DatasetCompression'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(JsonDataset, self).__init__(**kwargs)
        self.type = 'Json'  # type: str
        self.location = kwargs.get('location', None)
        self.encoding_name = kwargs.get('encoding_name', None)
        self.compression = kwargs.get('compression', None)


class JsonFormat(DatasetStorageFormat):
    """The data stored in JSON format.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset storage format.Constant filled by server.
    :type type: str
    :param serializer: Serializer. Type: string (or Expression with resultType string).
    :type serializer: object
    :param deserializer: Deserializer. Type: string (or Expression with resultType string).
    :type deserializer: object
    :param file_pattern: File pattern of JSON. To be more specific, the way of separating a
     collection of JSON objects. The default value is 'setOfObjects'. It is case-sensitive. Possible
     values include: "setOfObjects", "arrayOfObjects".
    :type file_pattern: str or ~azure.synapse.artifacts.models.JsonFormatFilePattern
    :param nesting_separator: The character used to separate nesting levels. Default value is '.'
     (dot). Type: string (or Expression with resultType string).
    :type nesting_separator: object
    :param encoding_name: The code page name of the preferred encoding. If not provided, the
     default value is 'utf-8', unless the byte order mark (BOM) denotes another Unicode encoding.
     The full list of supported values can be found in the 'Name' column of the table of encodings
     in the following reference: https://go.microsoft.com/fwlink/?linkid=861078. Type: string (or
     Expression with resultType string).
    :type encoding_name: object
    :param json_node_reference: The JSONPath of the JSON array element to be flattened. Example:
     "$.ArrayPath". Type: string (or Expression with resultType string).
    :type json_node_reference: object
    :param json_path_definition: The JSONPath definition for each column mapping with a customized
     column name to extract data from JSON file. For fields under root object, start with "$"; for
     fields inside the array chosen by jsonNodeReference property, start from the array element.
     Example: {"Column1": "$.Column1Path", "Column2": "Column2PathInArray"}. Type: object (or
     Expression with resultType object).
    :type json_path_definition: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'serializer': {'key': 'serializer', 'type': 'object'},
        'deserializer': {'key': 'deserializer', 'type': 'object'},
        'file_pattern': {'key': 'filePattern', 'type': 'str'},
        'nesting_separator': {'key': 'nestingSeparator', 'type': 'object'},
        'encoding_name': {'key': 'encodingName', 'type': 'object'},
        'json_node_reference': {'key': 'jsonNodeReference', 'type': 'object'},
        'json_path_definition': {'key': 'jsonPathDefinition', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(JsonFormat, self).__init__(**kwargs)
        self.type = 'JsonFormat'  # type: str
        self.file_pattern = kwargs.get('file_pattern', None)
        self.nesting_separator = kwargs.get('nesting_separator', None)
        self.encoding_name = kwargs.get('encoding_name', None)
        self.json_node_reference = kwargs.get('json_node_reference', None)
        self.json_path_definition = kwargs.get('json_path_definition', None)


class JsonSink(CopySink):
    """A copy activity Json sink.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy sink type.Constant filled by server.
    :type type: str
    :param write_batch_size: Write batch size. Type: integer (or Expression with resultType
     integer), minimum: 0.
    :type write_batch_size: object
    :param write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type write_batch_timeout: object
    :param sink_retry_count: Sink retry count. Type: integer (or Expression with resultType
     integer).
    :type sink_retry_count: object
    :param sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type sink_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the sink data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param store_settings: Json store settings.
    :type store_settings: ~azure.synapse.artifacts.models.StoreWriteSettings
    :param format_settings: Json format settings.
    :type format_settings: ~azure.synapse.artifacts.models.JsonWriteSettings
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'write_batch_size': {'key': 'writeBatchSize', 'type': 'object'},
        'write_batch_timeout': {'key': 'writeBatchTimeout', 'type': 'object'},
        'sink_retry_count': {'key': 'sinkRetryCount', 'type': 'object'},
        'sink_retry_wait': {'key': 'sinkRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'store_settings': {'key': 'storeSettings', 'type': 'StoreWriteSettings'},
        'format_settings': {'key': 'formatSettings', 'type': 'JsonWriteSettings'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(JsonSink, self).__init__(**kwargs)
        self.type = 'JsonSink'  # type: str
        self.store_settings = kwargs.get('store_settings', None)
        self.format_settings = kwargs.get('format_settings', None)


class JsonSource(CopySource):
    """A copy activity Json source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: object
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param store_settings: Json store settings.
    :type store_settings: ~azure.synapse.artifacts.models.StoreReadSettings
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'store_settings': {'key': 'storeSettings', 'type': 'StoreReadSettings'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(JsonSource, self).__init__(**kwargs)
        self.type = 'JsonSource'  # type: str
        self.store_settings = kwargs.get('store_settings', None)


class JsonWriteSettings(FormatWriteSettings):
    """Json write settings.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. The write setting type.Constant filled by server.
    :type type: str
    :param file_pattern: File pattern of JSON. This setting controls the way a collection of JSON
     objects will be treated. The default value is 'setOfObjects'. It is case-sensitive. Possible
     values include: "setOfObjects", "arrayOfObjects".
    :type file_pattern: str or ~azure.synapse.artifacts.models.JsonWriteFilePattern
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'file_pattern': {'key': 'filePattern', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(JsonWriteSettings, self).__init__(**kwargs)
        self.type = 'JsonWriteSettings'  # type: str
        self.file_pattern = kwargs.get('file_pattern', None)


class LibraryRequirements(msrest.serialization.Model):
    """Library requirements for a Big Data pool powered by Apache Spark.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar time: The last update time of the library requirements file.
    :vartype time: ~datetime.datetime
    :param content: The library requirements.
    :type content: str
    :param filename: The filename of the library requirements file.
    :type filename: str
    """

    _validation = {
        'time': {'readonly': True},
    }

    _attribute_map = {
        'time': {'key': 'time', 'type': 'iso-8601'},
        'content': {'key': 'content', 'type': 'str'},
        'filename': {'key': 'filename', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LibraryRequirements, self).__init__(**kwargs)
        self.time = None
        self.content = kwargs.get('content', None)
        self.filename = kwargs.get('filename', None)


class LinkedIntegrationRuntimeType(msrest.serialization.Model):
    """The base definition of a linked integration runtime.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: LinkedIntegrationRuntimeKeyAuthorization, LinkedIntegrationRuntimeRbacAuthorization.

    All required parameters must be populated in order to send to Azure.

    :param authorization_type: Required. The authorization type for integration runtime
     sharing.Constant filled by server.
    :type authorization_type: str
    """

    _validation = {
        'authorization_type': {'required': True},
    }

    _attribute_map = {
        'authorization_type': {'key': 'authorizationType', 'type': 'str'},
    }

    _subtype_map = {
        'authorization_type': {'Key': 'LinkedIntegrationRuntimeKeyAuthorization', 'RBAC': 'LinkedIntegrationRuntimeRbacAuthorization'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LinkedIntegrationRuntimeType, self).__init__(**kwargs)
        self.authorization_type = None  # type: Optional[str]


class LinkedIntegrationRuntimeKeyAuthorization(LinkedIntegrationRuntimeType):
    """The key authorization type integration runtime.

    All required parameters must be populated in order to send to Azure.

    :param authorization_type: Required. The authorization type for integration runtime
     sharing.Constant filled by server.
    :type authorization_type: str
    :param key: Required. The key used for authorization.
    :type key: ~azure.synapse.artifacts.models.SecureString
    """

    _validation = {
        'authorization_type': {'required': True},
        'key': {'required': True},
    }

    _attribute_map = {
        'authorization_type': {'key': 'authorizationType', 'type': 'str'},
        'key': {'key': 'key', 'type': 'SecureString'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LinkedIntegrationRuntimeKeyAuthorization, self).__init__(**kwargs)
        self.authorization_type = 'Key'  # type: str
        self.key = kwargs['key']


class LinkedIntegrationRuntimeRbacAuthorization(LinkedIntegrationRuntimeType):
    """The role based access control (RBAC) authorization type integration runtime.

    All required parameters must be populated in order to send to Azure.

    :param authorization_type: Required. The authorization type for integration runtime
     sharing.Constant filled by server.
    :type authorization_type: str
    :param resource_id: Required. The resource identifier of the integration runtime to be shared.
    :type resource_id: str
    """

    _validation = {
        'authorization_type': {'required': True},
        'resource_id': {'required': True},
    }

    _attribute_map = {
        'authorization_type': {'key': 'authorizationType', 'type': 'str'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LinkedIntegrationRuntimeRbacAuthorization, self).__init__(**kwargs)
        self.authorization_type = 'RBAC'  # type: str
        self.resource_id = kwargs['resource_id']


class LinkedServiceDebugResource(SubResourceDebugResource):
    """Linked service debug resource.

    All required parameters must be populated in order to send to Azure.

    :param name: The resource name.
    :type name: str
    :param properties: Required. Properties of linked service.
    :type properties: ~azure.synapse.artifacts.models.LinkedService
    """

    _validation = {
        'properties': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'LinkedService'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LinkedServiceDebugResource, self).__init__(**kwargs)
        self.properties = kwargs['properties']


class LinkedServiceListResponse(msrest.serialization.Model):
    """A list of linked service resources.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. List of linked services.
    :type value: list[~azure.synapse.artifacts.models.LinkedServiceResource]
    :param next_link: The link to the next page of results, if any remaining results exist.
    :type next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[LinkedServiceResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LinkedServiceListResponse, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = kwargs.get('next_link', None)


class LinkedServiceReference(msrest.serialization.Model):
    """Linked service reference type.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Linked service reference type. Possible values include:
     "LinkedServiceReference".
    :type type: str or ~azure.synapse.artifacts.models.Type
    :param reference_name: Required. Reference LinkedService name.
    :type reference_name: str
    :param parameters: Arguments for LinkedService.
    :type parameters: dict[str, object]
    """

    _validation = {
        'type': {'required': True},
        'reference_name': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'reference_name': {'key': 'referenceName', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{object}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LinkedServiceReference, self).__init__(**kwargs)
        self.type = kwargs['type']
        self.reference_name = kwargs['reference_name']
        self.parameters = kwargs.get('parameters', None)


class LinkedServiceResource(AzureEntityResource):
    """Linked service resource type.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. Ex- Microsoft.Compute/virtualMachines or
     Microsoft.Storage/storageAccounts.
    :vartype type: str
    :ivar etag: Resource Etag.
    :vartype etag: str
    :param properties: Required. Properties of linked service.
    :type properties: ~azure.synapse.artifacts.models.LinkedService
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'LinkedService'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LinkedServiceResource, self).__init__(**kwargs)
        self.properties = kwargs['properties']


class LogStorageSettings(msrest.serialization.Model):
    """Log storage settings.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param linked_service_name: Required. Log storage linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param path: The path to storage for storing detailed logs of activity execution. Type: string
     (or Expression with resultType string).
    :type path: object
    """

    _validation = {
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'path': {'key': 'path', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LogStorageSettings, self).__init__(**kwargs)
        self.additional_properties = kwargs.get('additional_properties', None)
        self.linked_service_name = kwargs['linked_service_name']
        self.path = kwargs.get('path', None)


class LookupActivity(ExecutionActivity):
    """Lookup activity.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param name: Required. Activity name.
    :type name: str
    :param type: Required. Type of activity.Constant filled by server.
    :type type: str
    :param description: Activity description.
    :type description: str
    :param depends_on: Activity depends on condition.
    :type depends_on: list[~azure.synapse.artifacts.models.ActivityDependency]
    :param user_properties: Activity user properties.
    :type user_properties: list[~azure.synapse.artifacts.models.UserProperty]
    :param linked_service_name: Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param policy: Activity policy.
    :type policy: ~azure.synapse.artifacts.models.ActivityPolicy
    :param source: Required. Dataset-specific source properties, same as copy activity source.
    :type source: ~azure.synapse.artifacts.models.CopySource
    :param dataset: Required. Lookup activity dataset reference.
    :type dataset: ~azure.synapse.artifacts.models.DatasetReference
    :param first_row_only: Whether to return first row or all rows. Default value is true. Type:
     boolean (or Expression with resultType boolean).
    :type first_row_only: object
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
        'source': {'required': True},
        'dataset': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'depends_on': {'key': 'dependsOn', 'type': '[ActivityDependency]'},
        'user_properties': {'key': 'userProperties', 'type': '[UserProperty]'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'policy': {'key': 'policy', 'type': 'ActivityPolicy'},
        'source': {'key': 'typeProperties.source', 'type': 'CopySource'},
        'dataset': {'key': 'typeProperties.dataset', 'type': 'DatasetReference'},
        'first_row_only': {'key': 'typeProperties.firstRowOnly', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LookupActivity, self).__init__(**kwargs)
        self.type = 'Lookup'  # type: str
        self.source = kwargs['source']
        self.dataset = kwargs['dataset']
        self.first_row_only = kwargs.get('first_row_only', None)


class MagentoLinkedService(LinkedService):
    """Magento server linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param host: Required. The URL of the Magento instance. (i.e. 192.168.222.110/magento3).
    :type host: object
    :param access_token: The access token from Magento.
    :type access_token: ~azure.synapse.artifacts.models.SecretBase
    :param use_encrypted_endpoints: Specifies whether the data source endpoints are encrypted using
     HTTPS. The default value is true.
    :type use_encrypted_endpoints: object
    :param use_host_verification: Specifies whether to require the host name in the server's
     certificate to match the host name of the server when connecting over SSL. The default value is
     true.
    :type use_host_verification: object
    :param use_peer_verification: Specifies whether to verify the identity of the server when
     connecting over SSL. The default value is true.
    :type use_peer_verification: object
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'host': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'host': {'key': 'typeProperties.host', 'type': 'object'},
        'access_token': {'key': 'typeProperties.accessToken', 'type': 'SecretBase'},
        'use_encrypted_endpoints': {'key': 'typeProperties.useEncryptedEndpoints', 'type': 'object'},
        'use_host_verification': {'key': 'typeProperties.useHostVerification', 'type': 'object'},
        'use_peer_verification': {'key': 'typeProperties.usePeerVerification', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MagentoLinkedService, self).__init__(**kwargs)
        self.type = 'Magento'  # type: str
        self.host = kwargs['host']
        self.access_token = kwargs.get('access_token', None)
        self.use_encrypted_endpoints = kwargs.get('use_encrypted_endpoints', None)
        self.use_host_verification = kwargs.get('use_host_verification', None)
        self.use_peer_verification = kwargs.get('use_peer_verification', None)
        self.encrypted_credential = kwargs.get('encrypted_credential', None)


class MagentoObjectDataset(Dataset):
    """Magento server dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param table_name: The table name. Type: string (or Expression with resultType string).
    :type table_name: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table_name': {'key': 'typeProperties.tableName', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MagentoObjectDataset, self).__init__(**kwargs)
        self.type = 'MagentoObject'  # type: str
        self.table_name = kwargs.get('table_name', None)


class MagentoSource(TabularSource):
    """A copy activity Magento server source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: object
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param query_timeout: Query timeout. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type query_timeout: object
    :param query: A query to retrieve data from source. Type: string (or Expression with resultType
     string).
    :type query: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'query_timeout': {'key': 'queryTimeout', 'type': 'object'},
        'query': {'key': 'query', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MagentoSource, self).__init__(**kwargs)
        self.type = 'MagentoSource'  # type: str
        self.query = kwargs.get('query', None)


class ManagedIdentity(msrest.serialization.Model):
    """The workspace managed identity.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal ID of the workspace managed identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of the workspace managed identity.
    :vartype tenant_id: str
    :param type: The type of managed identity for the workspace. Possible values include: "None",
     "SystemAssigned".
    :type type: str or ~azure.synapse.artifacts.models.ResourceIdentityType
    """

    _validation = {
        'principal_id': {'readonly': True},
        'tenant_id': {'readonly': True},
    }

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ManagedIdentity, self).__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None
        self.type = kwargs.get('type', None)


class ManagedIntegrationRuntime(IntegrationRuntime):
    """Managed integration runtime, including managed elastic and managed dedicated integration runtimes.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of integration runtime.Constant filled by server.  Possible values
     include: "Managed", "SelfHosted".
    :type type: str or ~azure.synapse.artifacts.models.IntegrationRuntimeType
    :param description: Integration runtime description.
    :type description: str
    :ivar state: Integration runtime state, only valid for managed dedicated integration runtime.
     Possible values include: "Initial", "Stopped", "Started", "Starting", "Stopping",
     "NeedRegistration", "Online", "Limited", "Offline", "AccessDenied".
    :vartype state: str or ~azure.synapse.artifacts.models.IntegrationRuntimeState
    :param compute_properties: The compute resource for managed integration runtime.
    :type compute_properties: ~azure.synapse.artifacts.models.IntegrationRuntimeComputeProperties
    :param ssis_properties: SSIS properties for managed integration runtime.
    :type ssis_properties: ~azure.synapse.artifacts.models.IntegrationRuntimeSsisProperties
    """

    _validation = {
        'type': {'required': True},
        'state': {'readonly': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'state': {'key': 'state', 'type': 'str'},
        'compute_properties': {'key': 'typeProperties.computeProperties', 'type': 'IntegrationRuntimeComputeProperties'},
        'ssis_properties': {'key': 'typeProperties.ssisProperties', 'type': 'IntegrationRuntimeSsisProperties'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ManagedIntegrationRuntime, self).__init__(**kwargs)
        self.type = 'Managed'  # type: str
        self.state = None
        self.compute_properties = kwargs.get('compute_properties', None)
        self.ssis_properties = kwargs.get('ssis_properties', None)


class MappingDataFlow(DataFlow):
    """Mapping data flow.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Type of data flow.Constant filled by server.
    :type type: str
    :param description: The description of the data flow.
    :type description: str
    :param annotations: List of tags that can be used for describing the data flow.
    :type annotations: list[object]
    :param folder: The folder that this data flow is in. If not specified, Data flow will appear at
     the root level.
    :type folder: ~azure.synapse.artifacts.models.DataFlowFolder
    :param sources: List of sources in data flow.
    :type sources: list[~azure.synapse.artifacts.models.DataFlowSource]
    :param sinks: List of sinks in data flow.
    :type sinks: list[~azure.synapse.artifacts.models.DataFlowSink]
    :param transformations: List of transformations in data flow.
    :type transformations: list[~azure.synapse.artifacts.models.Transformation]
    :param script: DataFlow script.
    :type script: str
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DataFlowFolder'},
        'sources': {'key': 'typeProperties.sources', 'type': '[DataFlowSource]'},
        'sinks': {'key': 'typeProperties.sinks', 'type': '[DataFlowSink]'},
        'transformations': {'key': 'typeProperties.transformations', 'type': '[Transformation]'},
        'script': {'key': 'typeProperties.script', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MappingDataFlow, self).__init__(**kwargs)
        self.type = 'MappingDataFlow'  # type: str
        self.sources = kwargs.get('sources', None)
        self.sinks = kwargs.get('sinks', None)
        self.transformations = kwargs.get('transformations', None)
        self.script = kwargs.get('script', None)


class MariaDBLinkedService(LinkedService):
    """MariaDB server linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param connection_string: An ODBC connection string. Type: string, SecureString or
     AzureKeyVaultSecretReference.
    :type connection_string: object
    :param pwd: The Azure key vault secret reference of password in connection string.
    :type pwd: ~azure.synapse.artifacts.models.AzureKeyVaultSecretReference
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'connection_string': {'key': 'typeProperties.connectionString', 'type': 'object'},
        'pwd': {'key': 'typeProperties.pwd', 'type': 'AzureKeyVaultSecretReference'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MariaDBLinkedService, self).__init__(**kwargs)
        self.type = 'MariaDB'  # type: str
        self.connection_string = kwargs.get('connection_string', None)
        self.pwd = kwargs.get('pwd', None)
        self.encrypted_credential = kwargs.get('encrypted_credential', None)


class MariaDBSource(TabularSource):
    """A copy activity MariaDB server source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: object
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param query_timeout: Query timeout. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type query_timeout: object
    :param query: A query to retrieve data from source. Type: string (or Expression with resultType
     string).
    :type query: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'query_timeout': {'key': 'queryTimeout', 'type': 'object'},
        'query': {'key': 'query', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MariaDBSource, self).__init__(**kwargs)
        self.type = 'MariaDBSource'  # type: str
        self.query = kwargs.get('query', None)


class MariaDBTableDataset(Dataset):
    """MariaDB server dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param table_name: The table name. Type: string (or Expression with resultType string).
    :type table_name: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table_name': {'key': 'typeProperties.tableName', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MariaDBTableDataset, self).__init__(**kwargs)
        self.type = 'MariaDBTable'  # type: str
        self.table_name = kwargs.get('table_name', None)


class MarketoLinkedService(LinkedService):
    """Marketo server linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param endpoint: Required. The endpoint of the Marketo server. (i.e. 123-ABC-321.mktorest.com).
    :type endpoint: object
    :param client_id: Required. The client Id of your Marketo service.
    :type client_id: object
    :param client_secret: The client secret of your Marketo service.
    :type client_secret: ~azure.synapse.artifacts.models.SecretBase
    :param use_encrypted_endpoints: Specifies whether the data source endpoints are encrypted using
     HTTPS. The default value is true.
    :type use_encrypted_endpoints: object
    :param use_host_verification: Specifies whether to require the host name in the server's
     certificate to match the host name of the server when connecting over SSL. The default value is
     true.
    :type use_host_verification: object
    :param use_peer_verification: Specifies whether to verify the identity of the server when
     connecting over SSL. The default value is true.
    :type use_peer_verification: object
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'endpoint': {'required': True},
        'client_id': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'endpoint': {'key': 'typeProperties.endpoint', 'type': 'object'},
        'client_id': {'key': 'typeProperties.clientId', 'type': 'object'},
        'client_secret': {'key': 'typeProperties.clientSecret', 'type': 'SecretBase'},
        'use_encrypted_endpoints': {'key': 'typeProperties.useEncryptedEndpoints', 'type': 'object'},
        'use_host_verification': {'key': 'typeProperties.useHostVerification', 'type': 'object'},
        'use_peer_verification': {'key': 'typeProperties.usePeerVerification', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MarketoLinkedService, self).__init__(**kwargs)
        self.type = 'Marketo'  # type: str
        self.endpoint = kwargs['endpoint']
        self.client_id = kwargs['client_id']
        self.client_secret = kwargs.get('client_secret', None)
        self.use_encrypted_endpoints = kwargs.get('use_encrypted_endpoints', None)
        self.use_host_verification = kwargs.get('use_host_verification', None)
        self.use_peer_verification = kwargs.get('use_peer_verification', None)
        self.encrypted_credential = kwargs.get('encrypted_credential', None)


class MarketoObjectDataset(Dataset):
    """Marketo server dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param table_name: The table name. Type: string (or Expression with resultType string).
    :type table_name: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table_name': {'key': 'typeProperties.tableName', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MarketoObjectDataset, self).__init__(**kwargs)
        self.type = 'MarketoObject'  # type: str
        self.table_name = kwargs.get('table_name', None)


class MarketoSource(TabularSource):
    """A copy activity Marketo server source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: object
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param query_timeout: Query timeout. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type query_timeout: object
    :param query: A query to retrieve data from source. Type: string (or Expression with resultType
     string).
    :type query: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'query_timeout': {'key': 'queryTimeout', 'type': 'object'},
        'query': {'key': 'query', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MarketoSource, self).__init__(**kwargs)
        self.type = 'MarketoSource'  # type: str
        self.query = kwargs.get('query', None)


class MicrosoftAccessLinkedService(LinkedService):
    """Microsoft Access linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param connection_string: Required. The non-access credential portion of the connection string
     as well as an optional encrypted credential. Type: string, SecureString or
     AzureKeyVaultSecretReference.
    :type connection_string: object
    :param authentication_type: Type of authentication used to connect to the Microsoft Access as
     ODBC data store. Possible values are: Anonymous and Basic. Type: string (or Expression with
     resultType string).
    :type authentication_type: object
    :param credential: The access credential portion of the connection string specified in driver-
     specific property-value format.
    :type credential: ~azure.synapse.artifacts.models.SecretBase
    :param user_name: User name for Basic authentication. Type: string (or Expression with
     resultType string).
    :type user_name: object
    :param password: Password for Basic authentication.
    :type password: ~azure.synapse.artifacts.models.SecretBase
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'connection_string': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'connection_string': {'key': 'typeProperties.connectionString', 'type': 'object'},
        'authentication_type': {'key': 'typeProperties.authenticationType', 'type': 'object'},
        'credential': {'key': 'typeProperties.credential', 'type': 'SecretBase'},
        'user_name': {'key': 'typeProperties.userName', 'type': 'object'},
        'password': {'key': 'typeProperties.password', 'type': 'SecretBase'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MicrosoftAccessLinkedService, self).__init__(**kwargs)
        self.type = 'MicrosoftAccess'  # type: str
        self.connection_string = kwargs['connection_string']
        self.authentication_type = kwargs.get('authentication_type', None)
        self.credential = kwargs.get('credential', None)
        self.user_name = kwargs.get('user_name', None)
        self.password = kwargs.get('password', None)
        self.encrypted_credential = kwargs.get('encrypted_credential', None)


class MicrosoftAccessSink(CopySink):
    """A copy activity Microsoft Access sink.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy sink type.Constant filled by server.
    :type type: str
    :param write_batch_size: Write batch size. Type: integer (or Expression with resultType
     integer), minimum: 0.
    :type write_batch_size: object
    :param write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type write_batch_timeout: object
    :param sink_retry_count: Sink retry count. Type: integer (or Expression with resultType
     integer).
    :type sink_retry_count: object
    :param sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type sink_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the sink data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param pre_copy_script: A query to execute before starting the copy. Type: string (or
     Expression with resultType string).
    :type pre_copy_script: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'write_batch_size': {'key': 'writeBatchSize', 'type': 'object'},
        'write_batch_timeout': {'key': 'writeBatchTimeout', 'type': 'object'},
        'sink_retry_count': {'key': 'sinkRetryCount', 'type': 'object'},
        'sink_retry_wait': {'key': 'sinkRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'pre_copy_script': {'key': 'preCopyScript', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MicrosoftAccessSink, self).__init__(**kwargs)
        self.type = 'MicrosoftAccessSink'  # type: str
        self.pre_copy_script = kwargs.get('pre_copy_script', None)


class MicrosoftAccessSource(CopySource):
    """A copy activity source for Microsoft Access.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: object
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param query: Database query. Type: string (or Expression with resultType string).
    :type query: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'query': {'key': 'query', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MicrosoftAccessSource, self).__init__(**kwargs)
        self.type = 'MicrosoftAccessSource'  # type: str
        self.query = kwargs.get('query', None)


class MicrosoftAccessTableDataset(Dataset):
    """The Microsoft Access table dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param table_name: The Microsoft Access table name. Type: string (or Expression with resultType
     string).
    :type table_name: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table_name': {'key': 'typeProperties.tableName', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MicrosoftAccessTableDataset, self).__init__(**kwargs)
        self.type = 'MicrosoftAccessTable'  # type: str
        self.table_name = kwargs.get('table_name', None)


class MongoDbCollectionDataset(Dataset):
    """The MongoDB database dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param collection_name: Required. The table name of the MongoDB database. Type: string (or
     Expression with resultType string).
    :type collection_name: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
        'collection_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'collection_name': {'key': 'typeProperties.collectionName', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MongoDbCollectionDataset, self).__init__(**kwargs)
        self.type = 'MongoDbCollection'  # type: str
        self.collection_name = kwargs['collection_name']


class MongoDbCursorMethodsProperties(msrest.serialization.Model):
    """Cursor methods for Mongodb query.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param project: Specifies the fields to return in the documents that match the query filter. To
     return all fields in the matching documents, omit this parameter. Type: string (or Expression
     with resultType string).
    :type project: object
    :param sort: Specifies the order in which the query returns matching documents. Type: string
     (or Expression with resultType string). Type: string (or Expression with resultType string).
    :type sort: object
    :param skip: Specifies the how many documents skipped and where MongoDB begins returning
     results. This approach may be useful in implementing paginated results. Type: integer (or
     Expression with resultType integer).
    :type skip: object
    :param limit: Specifies the maximum number of documents the server returns. limit() is
     analogous to the LIMIT statement in a SQL database. Type: integer (or Expression with
     resultType integer).
    :type limit: object
    """

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'project': {'key': 'project', 'type': 'object'},
        'sort': {'key': 'sort', 'type': 'object'},
        'skip': {'key': 'skip', 'type': 'object'},
        'limit': {'key': 'limit', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MongoDbCursorMethodsProperties, self).__init__(**kwargs)
        self.additional_properties = kwargs.get('additional_properties', None)
        self.project = kwargs.get('project', None)
        self.sort = kwargs.get('sort', None)
        self.skip = kwargs.get('skip', None)
        self.limit = kwargs.get('limit', None)


class MongoDbLinkedService(LinkedService):
    """Linked service for MongoDb data source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param server: Required. The IP address or server name of the MongoDB server. Type: string (or
     Expression with resultType string).
    :type server: object
    :param authentication_type: The authentication type to be used to connect to the MongoDB
     database. Possible values include: "Basic", "Anonymous".
    :type authentication_type: str or ~azure.synapse.artifacts.models.MongoDbAuthenticationType
    :param database_name: Required. The name of the MongoDB database that you want to access. Type:
     string (or Expression with resultType string).
    :type database_name: object
    :param username: Username for authentication. Type: string (or Expression with resultType
     string).
    :type username: object
    :param password: Password for authentication.
    :type password: ~azure.synapse.artifacts.models.SecretBase
    :param auth_source: Database to verify the username and password. Type: string (or Expression
     with resultType string).
    :type auth_source: object
    :param port: The TCP port number that the MongoDB server uses to listen for client connections.
     The default value is 27017. Type: integer (or Expression with resultType integer), minimum: 0.
    :type port: object
    :param enable_ssl: Specifies whether the connections to the server are encrypted using SSL. The
     default value is false. Type: boolean (or Expression with resultType boolean).
    :type enable_ssl: object
    :param allow_self_signed_server_cert: Specifies whether to allow self-signed certificates from
     the server. The default value is false. Type: boolean (or Expression with resultType boolean).
    :type allow_self_signed_server_cert: object
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'server': {'required': True},
        'database_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'server': {'key': 'typeProperties.server', 'type': 'object'},
        'authentication_type': {'key': 'typeProperties.authenticationType', 'type': 'str'},
        'database_name': {'key': 'typeProperties.databaseName', 'type': 'object'},
        'username': {'key': 'typeProperties.username', 'type': 'object'},
        'password': {'key': 'typeProperties.password', 'type': 'SecretBase'},
        'auth_source': {'key': 'typeProperties.authSource', 'type': 'object'},
        'port': {'key': 'typeProperties.port', 'type': 'object'},
        'enable_ssl': {'key': 'typeProperties.enableSsl', 'type': 'object'},
        'allow_self_signed_server_cert': {'key': 'typeProperties.allowSelfSignedServerCert', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MongoDbLinkedService, self).__init__(**kwargs)
        self.type = 'MongoDb'  # type: str
        self.server = kwargs['server']
        self.authentication_type = kwargs.get('authentication_type', None)
        self.database_name = kwargs['database_name']
        self.username = kwargs.get('username', None)
        self.password = kwargs.get('password', None)
        self.auth_source = kwargs.get('auth_source', None)
        self.port = kwargs.get('port', None)
        self.enable_ssl = kwargs.get('enable_ssl', None)
        self.allow_self_signed_server_cert = kwargs.get('allow_self_signed_server_cert', None)
        self.encrypted_credential = kwargs.get('encrypted_credential', None)


class MongoDbSource(CopySource):
    """A copy activity source for a MongoDB database.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: object
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param query: Database query. Should be a SQL-92 query expression. Type: string (or Expression
     with resultType string).
    :type query: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'query': {'key': 'query', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MongoDbSource, self).__init__(**kwargs)
        self.type = 'MongoDbSource'  # type: str
        self.query = kwargs.get('query', None)


class MongoDbV2CollectionDataset(Dataset):
    """The MongoDB database dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param collection: Required. The collection name of the MongoDB database. Type: string (or
     Expression with resultType string).
    :type collection: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
        'collection': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'collection': {'key': 'typeProperties.collection', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MongoDbV2CollectionDataset, self).__init__(**kwargs)
        self.type = 'MongoDbV2Collection'  # type: str
        self.collection = kwargs['collection']


class MongoDbV2LinkedService(LinkedService):
    """Linked service for MongoDB data source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param connection_string: Required. The MongoDB connection string. Type: string, SecureString
     or AzureKeyVaultSecretReference. Type: string, SecureString or AzureKeyVaultSecretReference.
    :type connection_string: object
    :param database: Required. The name of the MongoDB database that you want to access. Type:
     string (or Expression with resultType string).
    :type database: object
    """

    _validation = {
        'type': {'required': True},
        'connection_string': {'required': True},
        'database': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'connection_string': {'key': 'typeProperties.connectionString', 'type': 'object'},
        'database': {'key': 'typeProperties.database', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MongoDbV2LinkedService, self).__init__(**kwargs)
        self.type = 'MongoDbV2'  # type: str
        self.connection_string = kwargs['connection_string']
        self.database = kwargs['database']


class MongoDbV2Source(CopySource):
    """A copy activity source for a MongoDB database.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: object
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param filter: Specifies selection filter using query operators. To return all documents in a
     collection, omit this parameter or pass an empty document ({}). Type: string (or Expression
     with resultType string).
    :type filter: object
    :param cursor_methods: Cursor methods for Mongodb query.
    :type cursor_methods: ~azure.synapse.artifacts.models.MongoDbCursorMethodsProperties
    :param batch_size: Specifies the number of documents to return in each batch of the response
     from MongoDB instance. In most cases, modifying the batch size will not affect the user or the
     application. This property's main purpose is to avoid hit the limitation of response size.
     Type: integer (or Expression with resultType integer).
    :type batch_size: object
    :param query_timeout: Query timeout. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type query_timeout: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'filter': {'key': 'filter', 'type': 'object'},
        'cursor_methods': {'key': 'cursorMethods', 'type': 'MongoDbCursorMethodsProperties'},
        'batch_size': {'key': 'batchSize', 'type': 'object'},
        'query_timeout': {'key': 'queryTimeout', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MongoDbV2Source, self).__init__(**kwargs)
        self.type = 'MongoDbV2Source'  # type: str
        self.filter = kwargs.get('filter', None)
        self.cursor_methods = kwargs.get('cursor_methods', None)
        self.batch_size = kwargs.get('batch_size', None)
        self.query_timeout = kwargs.get('query_timeout', None)


class MySqlLinkedService(LinkedService):
    """Linked service for MySQL data source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param connection_string: Required. The connection string.
    :type connection_string: object
    :param password: The Azure key vault secret reference of password in connection string.
    :type password: ~azure.synapse.artifacts.models.AzureKeyVaultSecretReference
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'connection_string': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'connection_string': {'key': 'typeProperties.connectionString', 'type': 'object'},
        'password': {'key': 'typeProperties.password', 'type': 'AzureKeyVaultSecretReference'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MySqlLinkedService, self).__init__(**kwargs)
        self.type = 'MySql'  # type: str
        self.connection_string = kwargs['connection_string']
        self.password = kwargs.get('password', None)
        self.encrypted_credential = kwargs.get('encrypted_credential', None)


class MySqlSource(TabularSource):
    """A copy activity source for MySQL databases.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: object
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param query_timeout: Query timeout. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type query_timeout: object
    :param query: Database query. Type: string (or Expression with resultType string).
    :type query: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'query_timeout': {'key': 'queryTimeout', 'type': 'object'},
        'query': {'key': 'query', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MySqlSource, self).__init__(**kwargs)
        self.type = 'MySqlSource'  # type: str
        self.query = kwargs.get('query', None)


class MySqlTableDataset(Dataset):
    """The MySQL table dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param table_name: The MySQL table name. Type: string (or Expression with resultType string).
    :type table_name: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table_name': {'key': 'typeProperties.tableName', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MySqlTableDataset, self).__init__(**kwargs)
        self.type = 'MySqlTable'  # type: str
        self.table_name = kwargs.get('table_name', None)


class NetezzaLinkedService(LinkedService):
    """Netezza linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param connection_string: An ODBC connection string. Type: string, SecureString or
     AzureKeyVaultSecretReference.
    :type connection_string: object
    :param pwd: The Azure key vault secret reference of password in connection string.
    :type pwd: ~azure.synapse.artifacts.models.AzureKeyVaultSecretReference
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'connection_string': {'key': 'typeProperties.connectionString', 'type': 'object'},
        'pwd': {'key': 'typeProperties.pwd', 'type': 'AzureKeyVaultSecretReference'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NetezzaLinkedService, self).__init__(**kwargs)
        self.type = 'Netezza'  # type: str
        self.connection_string = kwargs.get('connection_string', None)
        self.pwd = kwargs.get('pwd', None)
        self.encrypted_credential = kwargs.get('encrypted_credential', None)


class NetezzaPartitionSettings(msrest.serialization.Model):
    """The settings that will be leveraged for Netezza source partitioning.

    :param partition_column_name: The name of the column in integer type that will be used for
     proceeding range partitioning. Type: string (or Expression with resultType string).
    :type partition_column_name: object
    :param partition_upper_bound: The maximum value of column specified in partitionColumnName that
     will be used for proceeding range partitioning. Type: string (or Expression with resultType
     string).
    :type partition_upper_bound: object
    :param partition_lower_bound: The minimum value of column specified in partitionColumnName that
     will be used for proceeding range partitioning. Type: string (or Expression with resultType
     string).
    :type partition_lower_bound: object
    """

    _attribute_map = {
        'partition_column_name': {'key': 'partitionColumnName', 'type': 'object'},
        'partition_upper_bound': {'key': 'partitionUpperBound', 'type': 'object'},
        'partition_lower_bound': {'key': 'partitionLowerBound', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NetezzaPartitionSettings, self).__init__(**kwargs)
        self.partition_column_name = kwargs.get('partition_column_name', None)
        self.partition_upper_bound = kwargs.get('partition_upper_bound', None)
        self.partition_lower_bound = kwargs.get('partition_lower_bound', None)


class NetezzaSource(TabularSource):
    """A copy activity Netezza source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: object
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param query_timeout: Query timeout. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type query_timeout: object
    :param query: A query to retrieve data from source. Type: string (or Expression with resultType
     string).
    :type query: object
    :param partition_option: The partition mechanism that will be used for Netezza read in
     parallel. Possible values include: "None", "DataSlice", "DynamicRange".
    :type partition_option: str or ~azure.synapse.artifacts.models.NetezzaPartitionOption
    :param partition_settings: The settings that will be leveraged for Netezza source partitioning.
    :type partition_settings: ~azure.synapse.artifacts.models.NetezzaPartitionSettings
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'query_timeout': {'key': 'queryTimeout', 'type': 'object'},
        'query': {'key': 'query', 'type': 'object'},
        'partition_option': {'key': 'partitionOption', 'type': 'str'},
        'partition_settings': {'key': 'partitionSettings', 'type': 'NetezzaPartitionSettings'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NetezzaSource, self).__init__(**kwargs)
        self.type = 'NetezzaSource'  # type: str
        self.query = kwargs.get('query', None)
        self.partition_option = kwargs.get('partition_option', None)
        self.partition_settings = kwargs.get('partition_settings', None)


class NetezzaTableDataset(Dataset):
    """Netezza dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param table_name: This property will be retired. Please consider using schema + table
     properties instead.
    :type table_name: object
    :param table: The table name of the Netezza. Type: string (or Expression with resultType
     string).
    :type table: object
    :param schema_type_properties_schema: The schema name of the Netezza. Type: string (or
     Expression with resultType string).
    :type schema_type_properties_schema: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table_name': {'key': 'typeProperties.tableName', 'type': 'object'},
        'table': {'key': 'typeProperties.table', 'type': 'object'},
        'schema_type_properties_schema': {'key': 'typeProperties.schema', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NetezzaTableDataset, self).__init__(**kwargs)
        self.type = 'NetezzaTable'  # type: str
        self.table_name = kwargs.get('table_name', None)
        self.table = kwargs.get('table', None)
        self.schema_type_properties_schema = kwargs.get('schema_type_properties_schema', None)


class Notebook(msrest.serialization.Model):
    """Notebook.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param description: The description of the notebook.
    :type description: str
    :param big_data_pool: Big data pool reference.
    :type big_data_pool: ~azure.synapse.artifacts.models.BigDataPoolReference
    :param session_properties: Session properties.
    :type session_properties: ~azure.synapse.artifacts.models.NotebookSessionProperties
    :param metadata: Required. Notebook root-level metadata.
    :type metadata: ~azure.synapse.artifacts.models.NotebookMetadata
    :param nbformat: Required. Notebook format (major number). Incremented between backwards
     incompatible changes to the notebook format.
    :type nbformat: int
    :param nbformat_minor: Required. Notebook format (minor number). Incremented for backward
     compatible changes to the notebook format.
    :type nbformat_minor: int
    :param cells: Required. Array of cells of the current notebook.
    :type cells: list[~azure.synapse.artifacts.models.NotebookCell]
    """

    _validation = {
        'metadata': {'required': True},
        'nbformat': {'required': True},
        'nbformat_minor': {'required': True},
        'cells': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'description': {'key': 'description', 'type': 'str'},
        'big_data_pool': {'key': 'bigDataPool', 'type': 'BigDataPoolReference'},
        'session_properties': {'key': 'sessionProperties', 'type': 'NotebookSessionProperties'},
        'metadata': {'key': 'metadata', 'type': 'NotebookMetadata'},
        'nbformat': {'key': 'nbformat', 'type': 'int'},
        'nbformat_minor': {'key': 'nbformat_minor', 'type': 'int'},
        'cells': {'key': 'cells', 'type': '[NotebookCell]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Notebook, self).__init__(**kwargs)
        self.additional_properties = kwargs.get('additional_properties', None)
        self.description = kwargs.get('description', None)
        self.big_data_pool = kwargs.get('big_data_pool', None)
        self.session_properties = kwargs.get('session_properties', None)
        self.metadata = kwargs['metadata']
        self.nbformat = kwargs['nbformat']
        self.nbformat_minor = kwargs['nbformat_minor']
        self.cells = kwargs['cells']


class NotebookCell(msrest.serialization.Model):
    """Notebook cell.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param cell_type: Required. String identifying the type of cell.
    :type cell_type: str
    :param metadata: Required. Cell-level metadata.
    :type metadata: object
    :param source: Required. Contents of the cell, represented as an array of lines.
    :type source: list[str]
    :param attachments: Attachments associated with the cell.
    :type attachments: object
    :param outputs: Cell-level output items.
    :type outputs: list[~azure.synapse.artifacts.models.NotebookCellOutputItem]
    """

    _validation = {
        'cell_type': {'required': True},
        'metadata': {'required': True},
        'source': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'cell_type': {'key': 'cell_type', 'type': 'str'},
        'metadata': {'key': 'metadata', 'type': 'object'},
        'source': {'key': 'source', 'type': '[str]'},
        'attachments': {'key': 'attachments', 'type': 'object'},
        'outputs': {'key': 'outputs', 'type': '[NotebookCellOutputItem]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NotebookCell, self).__init__(**kwargs)
        self.additional_properties = kwargs.get('additional_properties', None)
        self.cell_type = kwargs['cell_type']
        self.metadata = kwargs['metadata']
        self.source = kwargs['source']
        self.attachments = kwargs.get('attachments', None)
        self.outputs = kwargs.get('outputs', None)


class NotebookCellOutputItem(msrest.serialization.Model):
    """An item of the notebook cell execution output.

    All required parameters must be populated in order to send to Azure.

    :param name: For output_type=stream, determines the name of stream (stdout / stderr).
    :type name: str
    :param execution_count: Execution sequence number.
    :type execution_count: int
    :param output_type: Required. Execution, display, or stream outputs. Possible values include:
     "execute_result", "display_data", "stream", "error".
    :type output_type: str or ~azure.synapse.artifacts.models.CellOutputType
    :param text: For output_type=stream, the stream's text output, represented as a string or an
     array of strings.
    :type text: object
    :param data: Output data. Use MIME type as key, and content as value.
    :type data: object
    :param metadata: Metadata for the output item.
    :type metadata: object
    """

    _validation = {
        'output_type': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'execution_count': {'key': 'execution_count', 'type': 'int'},
        'output_type': {'key': 'output_type', 'type': 'str'},
        'text': {'key': 'text', 'type': 'object'},
        'data': {'key': 'data', 'type': 'object'},
        'metadata': {'key': 'metadata', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NotebookCellOutputItem, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.execution_count = kwargs.get('execution_count', None)
        self.output_type = kwargs['output_type']
        self.text = kwargs.get('text', None)
        self.data = kwargs.get('data', None)
        self.metadata = kwargs.get('metadata', None)


class NotebookKernelSpec(msrest.serialization.Model):
    """Kernel information.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param name: Required. Name of the kernel specification.
    :type name: str
    :param display_name: Required. Name to display in UI.
    :type display_name: str
    """

    _validation = {
        'name': {'required': True},
        'display_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
        'display_name': {'key': 'display_name', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NotebookKernelSpec, self).__init__(**kwargs)
        self.additional_properties = kwargs.get('additional_properties', None)
        self.name = kwargs['name']
        self.display_name = kwargs['display_name']


class NotebookLanguageInfo(msrest.serialization.Model):
    """Language info.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param name: Required. The programming language which this kernel runs.
    :type name: str
    :param codemirror_mode: The codemirror mode to use for code in this language.
    :type codemirror_mode: str
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
        'codemirror_mode': {'key': 'codemirror_mode', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NotebookLanguageInfo, self).__init__(**kwargs)
        self.additional_properties = kwargs.get('additional_properties', None)
        self.name = kwargs['name']
        self.codemirror_mode = kwargs.get('codemirror_mode', None)


class NotebookListResponse(msrest.serialization.Model):
    """A list of Notebook resources.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. List of Notebooks.
    :type value: list[~azure.synapse.artifacts.models.NotebookResource]
    :param next_link: The link to the next page of results, if any remaining results exist.
    :type next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[NotebookResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NotebookListResponse, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = kwargs.get('next_link', None)


class NotebookMetadata(msrest.serialization.Model):
    """Notebook root-level metadata.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param kernelspec: Kernel information.
    :type kernelspec: ~azure.synapse.artifacts.models.NotebookKernelSpec
    :param language_info: Language info.
    :type language_info: ~azure.synapse.artifacts.models.NotebookLanguageInfo
    """

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'kernelspec': {'key': 'kernelspec', 'type': 'NotebookKernelSpec'},
        'language_info': {'key': 'language_info', 'type': 'NotebookLanguageInfo'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NotebookMetadata, self).__init__(**kwargs)
        self.additional_properties = kwargs.get('additional_properties', None)
        self.kernelspec = kwargs.get('kernelspec', None)
        self.language_info = kwargs.get('language_info', None)


class NotebookResource(AzureEntityResource):
    """Notebook resource type.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. Ex- Microsoft.Compute/virtualMachines or
     Microsoft.Storage/storageAccounts.
    :vartype type: str
    :ivar etag: Resource Etag.
    :vartype etag: str
    :param properties: Required. Properties of Notebook.
    :type properties: ~azure.synapse.artifacts.models.Notebook
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'Notebook'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NotebookResource, self).__init__(**kwargs)
        self.properties = kwargs['properties']


class NotebookSessionProperties(msrest.serialization.Model):
    """Session properties.

    All required parameters must be populated in order to send to Azure.

    :param driver_memory: Required. Amount of memory to use for the driver process.
    :type driver_memory: str
    :param driver_cores: Required. Number of cores to use for the driver.
    :type driver_cores: int
    :param executor_memory: Required. Amount of memory to use per executor process.
    :type executor_memory: str
    :param executor_cores: Required. Number of cores to use for each executor.
    :type executor_cores: int
    :param num_executors: Required. Number of executors to launch for this session.
    :type num_executors: int
    """

    _validation = {
        'driver_memory': {'required': True},
        'driver_cores': {'required': True},
        'executor_memory': {'required': True},
        'executor_cores': {'required': True},
        'num_executors': {'required': True},
    }

    _attribute_map = {
        'driver_memory': {'key': 'driverMemory', 'type': 'str'},
        'driver_cores': {'key': 'driverCores', 'type': 'int'},
        'executor_memory': {'key': 'executorMemory', 'type': 'str'},
        'executor_cores': {'key': 'executorCores', 'type': 'int'},
        'num_executors': {'key': 'numExecutors', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NotebookSessionProperties, self).__init__(**kwargs)
        self.driver_memory = kwargs['driver_memory']
        self.driver_cores = kwargs['driver_cores']
        self.executor_memory = kwargs['executor_memory']
        self.executor_cores = kwargs['executor_cores']
        self.num_executors = kwargs['num_executors']


class ODataLinkedService(LinkedService):
    """Open Data Protocol (OData) linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param url: Required. The URL of the OData service endpoint. Type: string (or Expression with
     resultType string).
    :type url: object
    :param authentication_type: Type of authentication used to connect to the OData service.
     Possible values include: "Basic", "Anonymous", "Windows", "AadServicePrincipal",
     "ManagedServiceIdentity".
    :type authentication_type: str or ~azure.synapse.artifacts.models.ODataAuthenticationType
    :param user_name: User name of the OData service. Type: string (or Expression with resultType
     string).
    :type user_name: object
    :param password: Password of the OData service.
    :type password: ~azure.synapse.artifacts.models.SecretBase
    :param tenant: Specify the tenant information (domain name or tenant ID) under which your
     application resides. Type: string (or Expression with resultType string).
    :type tenant: object
    :param service_principal_id: Specify the application id of your application registered in Azure
     Active Directory. Type: string (or Expression with resultType string).
    :type service_principal_id: object
    :param aad_resource_id: Specify the resource you are requesting authorization to use Directory.
     Type: string (or Expression with resultType string).
    :type aad_resource_id: object
    :param aad_service_principal_credential_type: Specify the credential type (key or cert) is used
     for service principal. Possible values include: "ServicePrincipalKey", "ServicePrincipalCert".
    :type aad_service_principal_credential_type: str or
     ~azure.synapse.artifacts.models.ODataAadServicePrincipalCredentialType
    :param service_principal_key: Specify the secret of your application registered in Azure Active
     Directory. Type: string (or Expression with resultType string).
    :type service_principal_key: ~azure.synapse.artifacts.models.SecretBase
    :param service_principal_embedded_cert: Specify the base64 encoded certificate of your
     application registered in Azure Active Directory. Type: string (or Expression with resultType
     string).
    :type service_principal_embedded_cert: ~azure.synapse.artifacts.models.SecretBase
    :param service_principal_embedded_cert_password: Specify the password of your certificate if
     your certificate has a password and you are using AadServicePrincipal authentication. Type:
     string (or Expression with resultType string).
    :type service_principal_embedded_cert_password: ~azure.synapse.artifacts.models.SecretBase
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'url': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'url': {'key': 'typeProperties.url', 'type': 'object'},
        'authentication_type': {'key': 'typeProperties.authenticationType', 'type': 'str'},
        'user_name': {'key': 'typeProperties.userName', 'type': 'object'},
        'password': {'key': 'typeProperties.password', 'type': 'SecretBase'},
        'tenant': {'key': 'typeProperties.tenant', 'type': 'object'},
        'service_principal_id': {'key': 'typeProperties.servicePrincipalId', 'type': 'object'},
        'aad_resource_id': {'key': 'typeProperties.aadResourceId', 'type': 'object'},
        'aad_service_principal_credential_type': {'key': 'typeProperties.aadServicePrincipalCredentialType', 'type': 'str'},
        'service_principal_key': {'key': 'typeProperties.servicePrincipalKey', 'type': 'SecretBase'},
        'service_principal_embedded_cert': {'key': 'typeProperties.servicePrincipalEmbeddedCert', 'type': 'SecretBase'},
        'service_principal_embedded_cert_password': {'key': 'typeProperties.servicePrincipalEmbeddedCertPassword', 'type': 'SecretBase'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ODataLinkedService, self).__init__(**kwargs)
        self.type = 'OData'  # type: str
        self.url = kwargs['url']
        self.authentication_type = kwargs.get('authentication_type', None)
        self.user_name = kwargs.get('user_name', None)
        self.password = kwargs.get('password', None)
        self.tenant = kwargs.get('tenant', None)
        self.service_principal_id = kwargs.get('service_principal_id', None)
        self.aad_resource_id = kwargs.get('aad_resource_id', None)
        self.aad_service_principal_credential_type = kwargs.get('aad_service_principal_credential_type', None)
        self.service_principal_key = kwargs.get('service_principal_key', None)
        self.service_principal_embedded_cert = kwargs.get('service_principal_embedded_cert', None)
        self.service_principal_embedded_cert_password = kwargs.get('service_principal_embedded_cert_password', None)
        self.encrypted_credential = kwargs.get('encrypted_credential', None)


class ODataResourceDataset(Dataset):
    """The Open Data Protocol (OData) resource dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param path: The OData resource path. Type: string (or Expression with resultType string).
    :type path: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'path': {'key': 'typeProperties.path', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ODataResourceDataset, self).__init__(**kwargs)
        self.type = 'ODataResource'  # type: str
        self.path = kwargs.get('path', None)


class ODataSource(CopySource):
    """A copy activity source for OData source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: object
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param query: OData query. For example, "$top=1". Type: string (or Expression with resultType
     string).
    :type query: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'query': {'key': 'query', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ODataSource, self).__init__(**kwargs)
        self.type = 'ODataSource'  # type: str
        self.query = kwargs.get('query', None)


class OdbcLinkedService(LinkedService):
    """Open Database Connectivity (ODBC) linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param connection_string: Required. The non-access credential portion of the connection string
     as well as an optional encrypted credential. Type: string, SecureString or
     AzureKeyVaultSecretReference.
    :type connection_string: object
    :param authentication_type: Type of authentication used to connect to the ODBC data store.
     Possible values are: Anonymous and Basic. Type: string (or Expression with resultType string).
    :type authentication_type: object
    :param credential: The access credential portion of the connection string specified in driver-
     specific property-value format.
    :type credential: ~azure.synapse.artifacts.models.SecretBase
    :param user_name: User name for Basic authentication. Type: string (or Expression with
     resultType string).
    :type user_name: object
    :param password: Password for Basic authentication.
    :type password: ~azure.synapse.artifacts.models.SecretBase
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'connection_string': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'connection_string': {'key': 'typeProperties.connectionString', 'type': 'object'},
        'authentication_type': {'key': 'typeProperties.authenticationType', 'type': 'object'},
        'credential': {'key': 'typeProperties.credential', 'type': 'SecretBase'},
        'user_name': {'key': 'typeProperties.userName', 'type': 'object'},
        'password': {'key': 'typeProperties.password', 'type': 'SecretBase'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OdbcLinkedService, self).__init__(**kwargs)
        self.type = 'Odbc'  # type: str
        self.connection_string = kwargs['connection_string']
        self.authentication_type = kwargs.get('authentication_type', None)
        self.credential = kwargs.get('credential', None)
        self.user_name = kwargs.get('user_name', None)
        self.password = kwargs.get('password', None)
        self.encrypted_credential = kwargs.get('encrypted_credential', None)


class OdbcSink(CopySink):
    """A copy activity ODBC sink.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy sink type.Constant filled by server.
    :type type: str
    :param write_batch_size: Write batch size. Type: integer (or Expression with resultType
     integer), minimum: 0.
    :type write_batch_size: object
    :param write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type write_batch_timeout: object
    :param sink_retry_count: Sink retry count. Type: integer (or Expression with resultType
     integer).
    :type sink_retry_count: object
    :param sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type sink_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the sink data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param pre_copy_script: A query to execute before starting the copy. Type: string (or
     Expression with resultType string).
    :type pre_copy_script: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'write_batch_size': {'key': 'writeBatchSize', 'type': 'object'},
        'write_batch_timeout': {'key': 'writeBatchTimeout', 'type': 'object'},
        'sink_retry_count': {'key': 'sinkRetryCount', 'type': 'object'},
        'sink_retry_wait': {'key': 'sinkRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'pre_copy_script': {'key': 'preCopyScript', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OdbcSink, self).__init__(**kwargs)
        self.type = 'OdbcSink'  # type: str
        self.pre_copy_script = kwargs.get('pre_copy_script', None)


class OdbcSource(TabularSource):
    """A copy activity source for ODBC databases.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: object
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param query_timeout: Query timeout. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type query_timeout: object
    :param query: Database query. Type: string (or Expression with resultType string).
    :type query: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'query_timeout': {'key': 'queryTimeout', 'type': 'object'},
        'query': {'key': 'query', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OdbcSource, self).__init__(**kwargs)
        self.type = 'OdbcSource'  # type: str
        self.query = kwargs.get('query', None)


class OdbcTableDataset(Dataset):
    """The ODBC table dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param table_name: The ODBC table name. Type: string (or Expression with resultType string).
    :type table_name: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table_name': {'key': 'typeProperties.tableName', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OdbcTableDataset, self).__init__(**kwargs)
        self.type = 'OdbcTable'  # type: str
        self.table_name = kwargs.get('table_name', None)


class Office365Dataset(Dataset):
    """The Office365 account.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param table_name: Required. Name of the dataset to extract from Office 365. Type: string (or
     Expression with resultType string).
    :type table_name: object
    :param predicate: A predicate expression that can be used to filter the specific rows to
     extract from Office 365. Type: string (or Expression with resultType string).
    :type predicate: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
        'table_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table_name': {'key': 'typeProperties.tableName', 'type': 'object'},
        'predicate': {'key': 'typeProperties.predicate', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Office365Dataset, self).__init__(**kwargs)
        self.type = 'Office365Table'  # type: str
        self.table_name = kwargs['table_name']
        self.predicate = kwargs.get('predicate', None)


class Office365LinkedService(LinkedService):
    """Office365 linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param office365_tenant_id: Required. Azure tenant ID to which the Office 365 account belongs.
     Type: string (or Expression with resultType string).
    :type office365_tenant_id: object
    :param service_principal_tenant_id: Required. Specify the tenant information under which your
     Azure AD web application resides. Type: string (or Expression with resultType string).
    :type service_principal_tenant_id: object
    :param service_principal_id: Required. Specify the application's client ID. Type: string (or
     Expression with resultType string).
    :type service_principal_id: object
    :param service_principal_key: Required. Specify the application's key.
    :type service_principal_key: ~azure.synapse.artifacts.models.SecretBase
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'office365_tenant_id': {'required': True},
        'service_principal_tenant_id': {'required': True},
        'service_principal_id': {'required': True},
        'service_principal_key': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'office365_tenant_id': {'key': 'typeProperties.office365TenantId', 'type': 'object'},
        'service_principal_tenant_id': {'key': 'typeProperties.servicePrincipalTenantId', 'type': 'object'},
        'service_principal_id': {'key': 'typeProperties.servicePrincipalId', 'type': 'object'},
        'service_principal_key': {'key': 'typeProperties.servicePrincipalKey', 'type': 'SecretBase'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Office365LinkedService, self).__init__(**kwargs)
        self.type = 'Office365'  # type: str
        self.office365_tenant_id = kwargs['office365_tenant_id']
        self.service_principal_tenant_id = kwargs['service_principal_tenant_id']
        self.service_principal_id = kwargs['service_principal_id']
        self.service_principal_key = kwargs['service_principal_key']
        self.encrypted_credential = kwargs.get('encrypted_credential', None)


class Office365Source(CopySource):
    """A copy activity source for an Office 365 service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: object
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param allowed_groups: The groups containing all the users. Type: array of strings (or
     Expression with resultType array of strings).
    :type allowed_groups: object
    :param user_scope_filter_uri: The user scope uri. Type: string (or Expression with resultType
     string).
    :type user_scope_filter_uri: object
    :param date_filter_column: The Column to apply the :code:`<paramref name="StartTime"/>` and
     :code:`<paramref name="EndTime"/>`. Type: string (or Expression with resultType string).
    :type date_filter_column: object
    :param start_time: Start time of the requested range for this dataset. Type: string (or
     Expression with resultType string).
    :type start_time: object
    :param end_time: End time of the requested range for this dataset. Type: string (or Expression
     with resultType string).
    :type end_time: object
    :param output_columns: The columns to be read out from the Office 365 table. Type: array of
     objects (or Expression with resultType array of objects). Example: [ { "name": "Id" }, {
     "name": "CreatedDateTime" } ].
    :type output_columns: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'allowed_groups': {'key': 'allowedGroups', 'type': 'object'},
        'user_scope_filter_uri': {'key': 'userScopeFilterUri', 'type': 'object'},
        'date_filter_column': {'key': 'dateFilterColumn', 'type': 'object'},
        'start_time': {'key': 'startTime', 'type': 'object'},
        'end_time': {'key': 'endTime', 'type': 'object'},
        'output_columns': {'key': 'outputColumns', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Office365Source, self).__init__(**kwargs)
        self.type = 'Office365Source'  # type: str
        self.allowed_groups = kwargs.get('allowed_groups', None)
        self.user_scope_filter_uri = kwargs.get('user_scope_filter_uri', None)
        self.date_filter_column = kwargs.get('date_filter_column', None)
        self.start_time = kwargs.get('start_time', None)
        self.end_time = kwargs.get('end_time', None)
        self.output_columns = kwargs.get('output_columns', None)


class OracleLinkedService(LinkedService):
    """Oracle database.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param connection_string: Required. The connection string. Type: string, SecureString or
     AzureKeyVaultSecretReference.
    :type connection_string: object
    :param password: The Azure key vault secret reference of password in connection string.
    :type password: ~azure.synapse.artifacts.models.AzureKeyVaultSecretReference
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'connection_string': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'connection_string': {'key': 'typeProperties.connectionString', 'type': 'object'},
        'password': {'key': 'typeProperties.password', 'type': 'AzureKeyVaultSecretReference'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OracleLinkedService, self).__init__(**kwargs)
        self.type = 'Oracle'  # type: str
        self.connection_string = kwargs['connection_string']
        self.password = kwargs.get('password', None)
        self.encrypted_credential = kwargs.get('encrypted_credential', None)


class OraclePartitionSettings(msrest.serialization.Model):
    """The settings that will be leveraged for Oracle source partitioning.

    :param partition_names: Names of the physical partitions of Oracle table.
    :type partition_names: object
    :param partition_column_name: The name of the column in integer type that will be used for
     proceeding range partitioning. Type: string (or Expression with resultType string).
    :type partition_column_name: object
    :param partition_upper_bound: The maximum value of column specified in partitionColumnName that
     will be used for proceeding range partitioning. Type: string (or Expression with resultType
     string).
    :type partition_upper_bound: object
    :param partition_lower_bound: The minimum value of column specified in partitionColumnName that
     will be used for proceeding range partitioning. Type: string (or Expression with resultType
     string).
    :type partition_lower_bound: object
    """

    _attribute_map = {
        'partition_names': {'key': 'partitionNames', 'type': 'object'},
        'partition_column_name': {'key': 'partitionColumnName', 'type': 'object'},
        'partition_upper_bound': {'key': 'partitionUpperBound', 'type': 'object'},
        'partition_lower_bound': {'key': 'partitionLowerBound', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OraclePartitionSettings, self).__init__(**kwargs)
        self.partition_names = kwargs.get('partition_names', None)
        self.partition_column_name = kwargs.get('partition_column_name', None)
        self.partition_upper_bound = kwargs.get('partition_upper_bound', None)
        self.partition_lower_bound = kwargs.get('partition_lower_bound', None)


class OracleServiceCloudLinkedService(LinkedService):
    """Oracle Service Cloud linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param host: Required. The URL of the Oracle Service Cloud instance.
    :type host: object
    :param username: Required. The user name that you use to access Oracle Service Cloud server.
    :type username: object
    :param password: Required. The password corresponding to the user name that you provided in the
     username key.
    :type password: ~azure.synapse.artifacts.models.SecretBase
    :param use_encrypted_endpoints: Specifies whether the data source endpoints are encrypted using
     HTTPS. The default value is true. Type: boolean (or Expression with resultType boolean).
    :type use_encrypted_endpoints: object
    :param use_host_verification: Specifies whether to require the host name in the server's
     certificate to match the host name of the server when connecting over SSL. The default value is
     true. Type: boolean (or Expression with resultType boolean).
    :type use_host_verification: object
    :param use_peer_verification: Specifies whether to verify the identity of the server when
     connecting over SSL. The default value is true. Type: boolean (or Expression with resultType
     boolean).
    :type use_peer_verification: object
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'host': {'required': True},
        'username': {'required': True},
        'password': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'host': {'key': 'typeProperties.host', 'type': 'object'},
        'username': {'key': 'typeProperties.username', 'type': 'object'},
        'password': {'key': 'typeProperties.password', 'type': 'SecretBase'},
        'use_encrypted_endpoints': {'key': 'typeProperties.useEncryptedEndpoints', 'type': 'object'},
        'use_host_verification': {'key': 'typeProperties.useHostVerification', 'type': 'object'},
        'use_peer_verification': {'key': 'typeProperties.usePeerVerification', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OracleServiceCloudLinkedService, self).__init__(**kwargs)
        self.type = 'OracleServiceCloud'  # type: str
        self.host = kwargs['host']
        self.username = kwargs['username']
        self.password = kwargs['password']
        self.use_encrypted_endpoints = kwargs.get('use_encrypted_endpoints', None)
        self.use_host_verification = kwargs.get('use_host_verification', None)
        self.use_peer_verification = kwargs.get('use_peer_verification', None)
        self.encrypted_credential = kwargs.get('encrypted_credential', None)


class OracleServiceCloudObjectDataset(Dataset):
    """Oracle Service Cloud dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param table_name: The table name. Type: string (or Expression with resultType string).
    :type table_name: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table_name': {'key': 'typeProperties.tableName', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OracleServiceCloudObjectDataset, self).__init__(**kwargs)
        self.type = 'OracleServiceCloudObject'  # type: str
        self.table_name = kwargs.get('table_name', None)


class OracleServiceCloudSource(TabularSource):
    """A copy activity Oracle Service Cloud source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: object
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param query_timeout: Query timeout. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type query_timeout: object
    :param query: A query to retrieve data from source. Type: string (or Expression with resultType
     string).
    :type query: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'query_timeout': {'key': 'queryTimeout', 'type': 'object'},
        'query': {'key': 'query', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OracleServiceCloudSource, self).__init__(**kwargs)
        self.type = 'OracleServiceCloudSource'  # type: str
        self.query = kwargs.get('query', None)


class OracleSink(CopySink):
    """A copy activity Oracle sink.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy sink type.Constant filled by server.
    :type type: str
    :param write_batch_size: Write batch size. Type: integer (or Expression with resultType
     integer), minimum: 0.
    :type write_batch_size: object
    :param write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type write_batch_timeout: object
    :param sink_retry_count: Sink retry count. Type: integer (or Expression with resultType
     integer).
    :type sink_retry_count: object
    :param sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type sink_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the sink data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param pre_copy_script: SQL pre-copy script. Type: string (or Expression with resultType
     string).
    :type pre_copy_script: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'write_batch_size': {'key': 'writeBatchSize', 'type': 'object'},
        'write_batch_timeout': {'key': 'writeBatchTimeout', 'type': 'object'},
        'sink_retry_count': {'key': 'sinkRetryCount', 'type': 'object'},
        'sink_retry_wait': {'key': 'sinkRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'pre_copy_script': {'key': 'preCopyScript', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OracleSink, self).__init__(**kwargs)
        self.type = 'OracleSink'  # type: str
        self.pre_copy_script = kwargs.get('pre_copy_script', None)


class OracleSource(CopySource):
    """A copy activity Oracle source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: object
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param oracle_reader_query: Oracle reader query. Type: string (or Expression with resultType
     string).
    :type oracle_reader_query: object
    :param query_timeout: Query timeout. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type query_timeout: object
    :param partition_option: The partition mechanism that will be used for Oracle read in parallel.
     Possible values include: "None", "PhysicalPartitionsOfTable", "DynamicRange".
    :type partition_option: str or ~azure.synapse.artifacts.models.OraclePartitionOption
    :param partition_settings: The settings that will be leveraged for Oracle source partitioning.
    :type partition_settings: ~azure.synapse.artifacts.models.OraclePartitionSettings
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'oracle_reader_query': {'key': 'oracleReaderQuery', 'type': 'object'},
        'query_timeout': {'key': 'queryTimeout', 'type': 'object'},
        'partition_option': {'key': 'partitionOption', 'type': 'str'},
        'partition_settings': {'key': 'partitionSettings', 'type': 'OraclePartitionSettings'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OracleSource, self).__init__(**kwargs)
        self.type = 'OracleSource'  # type: str
        self.oracle_reader_query = kwargs.get('oracle_reader_query', None)
        self.query_timeout = kwargs.get('query_timeout', None)
        self.partition_option = kwargs.get('partition_option', None)
        self.partition_settings = kwargs.get('partition_settings', None)


class OracleTableDataset(Dataset):
    """The on-premises Oracle database dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param table_name: This property will be retired. Please consider using schema + table
     properties instead.
    :type table_name: object
    :param schema_type_properties_schema: The schema name of the on-premises Oracle database. Type:
     string (or Expression with resultType string).
    :type schema_type_properties_schema: object
    :param table: The table name of the on-premises Oracle database. Type: string (or Expression
     with resultType string).
    :type table: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table_name': {'key': 'typeProperties.tableName', 'type': 'object'},
        'schema_type_properties_schema': {'key': 'typeProperties.schema', 'type': 'object'},
        'table': {'key': 'typeProperties.table', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OracleTableDataset, self).__init__(**kwargs)
        self.type = 'OracleTable'  # type: str
        self.table_name = kwargs.get('table_name', None)
        self.schema_type_properties_schema = kwargs.get('schema_type_properties_schema', None)
        self.table = kwargs.get('table', None)


class OrcDataset(Dataset):
    """ORC dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param location: The location of the ORC data storage.
    :type location: ~azure.synapse.artifacts.models.DatasetLocation
    :param orc_compression_codec:  Possible values include: "none", "zlib", "snappy".
    :type orc_compression_codec: str or ~azure.synapse.artifacts.models.OrcCompressionCodec
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'location': {'key': 'typeProperties.location', 'type': 'DatasetLocation'},
        'orc_compression_codec': {'key': 'typeProperties.orcCompressionCodec', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OrcDataset, self).__init__(**kwargs)
        self.type = 'Orc'  # type: str
        self.location = kwargs.get('location', None)
        self.orc_compression_codec = kwargs.get('orc_compression_codec', None)


class OrcFormat(DatasetStorageFormat):
    """The data stored in Optimized Row Columnar (ORC) format.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset storage format.Constant filled by server.
    :type type: str
    :param serializer: Serializer. Type: string (or Expression with resultType string).
    :type serializer: object
    :param deserializer: Deserializer. Type: string (or Expression with resultType string).
    :type deserializer: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'serializer': {'key': 'serializer', 'type': 'object'},
        'deserializer': {'key': 'deserializer', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OrcFormat, self).__init__(**kwargs)
        self.type = 'OrcFormat'  # type: str


class OrcSink(CopySink):
    """A copy activity ORC sink.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy sink type.Constant filled by server.
    :type type: str
    :param write_batch_size: Write batch size. Type: integer (or Expression with resultType
     integer), minimum: 0.
    :type write_batch_size: object
    :param write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type write_batch_timeout: object
    :param sink_retry_count: Sink retry count. Type: integer (or Expression with resultType
     integer).
    :type sink_retry_count: object
    :param sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type sink_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the sink data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param store_settings: ORC store settings.
    :type store_settings: ~azure.synapse.artifacts.models.StoreWriteSettings
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'write_batch_size': {'key': 'writeBatchSize', 'type': 'object'},
        'write_batch_timeout': {'key': 'writeBatchTimeout', 'type': 'object'},
        'sink_retry_count': {'key': 'sinkRetryCount', 'type': 'object'},
        'sink_retry_wait': {'key': 'sinkRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'store_settings': {'key': 'storeSettings', 'type': 'StoreWriteSettings'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OrcSink, self).__init__(**kwargs)
        self.type = 'OrcSink'  # type: str
        self.store_settings = kwargs.get('store_settings', None)


class OrcSource(CopySource):
    """A copy activity ORC source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: object
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param store_settings: ORC store settings.
    :type store_settings: ~azure.synapse.artifacts.models.StoreReadSettings
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'store_settings': {'key': 'storeSettings', 'type': 'StoreReadSettings'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OrcSource, self).__init__(**kwargs)
        self.type = 'OrcSource'  # type: str
        self.store_settings = kwargs.get('store_settings', None)


class ParameterSpecification(msrest.serialization.Model):
    """Definition of a single parameter for an entity.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Parameter type. Possible values include: "Object", "String", "Int",
     "Float", "Bool", "Array", "SecureString".
    :type type: str or ~azure.synapse.artifacts.models.ParameterType
    :param default_value: Default value of parameter.
    :type default_value: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'default_value': {'key': 'defaultValue', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ParameterSpecification, self).__init__(**kwargs)
        self.type = kwargs['type']
        self.default_value = kwargs.get('default_value', None)


class ParquetDataset(Dataset):
    """Parquet dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param location: The location of the parquet storage.
    :type location: ~azure.synapse.artifacts.models.DatasetLocation
    :param compression_codec:  Possible values include: "none", "gzip", "snappy", "lzo".
    :type compression_codec: str or ~azure.synapse.artifacts.models.ParquetCompressionCodec
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'location': {'key': 'typeProperties.location', 'type': 'DatasetLocation'},
        'compression_codec': {'key': 'typeProperties.compressionCodec', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ParquetDataset, self).__init__(**kwargs)
        self.type = 'Parquet'  # type: str
        self.location = kwargs.get('location', None)
        self.compression_codec = kwargs.get('compression_codec', None)


class ParquetFormat(DatasetStorageFormat):
    """The data stored in Parquet format.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset storage format.Constant filled by server.
    :type type: str
    :param serializer: Serializer. Type: string (or Expression with resultType string).
    :type serializer: object
    :param deserializer: Deserializer. Type: string (or Expression with resultType string).
    :type deserializer: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'serializer': {'key': 'serializer', 'type': 'object'},
        'deserializer': {'key': 'deserializer', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ParquetFormat, self).__init__(**kwargs)
        self.type = 'ParquetFormat'  # type: str


class ParquetSink(CopySink):
    """A copy activity Parquet sink.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy sink type.Constant filled by server.
    :type type: str
    :param write_batch_size: Write batch size. Type: integer (or Expression with resultType
     integer), minimum: 0.
    :type write_batch_size: object
    :param write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type write_batch_timeout: object
    :param sink_retry_count: Sink retry count. Type: integer (or Expression with resultType
     integer).
    :type sink_retry_count: object
    :param sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type sink_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the sink data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param store_settings: Parquet store settings.
    :type store_settings: ~azure.synapse.artifacts.models.StoreWriteSettings
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'write_batch_size': {'key': 'writeBatchSize', 'type': 'object'},
        'write_batch_timeout': {'key': 'writeBatchTimeout', 'type': 'object'},
        'sink_retry_count': {'key': 'sinkRetryCount', 'type': 'object'},
        'sink_retry_wait': {'key': 'sinkRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'store_settings': {'key': 'storeSettings', 'type': 'StoreWriteSettings'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ParquetSink, self).__init__(**kwargs)
        self.type = 'ParquetSink'  # type: str
        self.store_settings = kwargs.get('store_settings', None)


class ParquetSource(CopySource):
    """A copy activity Parquet source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: object
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param store_settings: Parquet store settings.
    :type store_settings: ~azure.synapse.artifacts.models.StoreReadSettings
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'store_settings': {'key': 'storeSettings', 'type': 'StoreReadSettings'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ParquetSource, self).__init__(**kwargs)
        self.type = 'ParquetSource'  # type: str
        self.store_settings = kwargs.get('store_settings', None)


class PaypalLinkedService(LinkedService):
    """Paypal Service linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param host: Required. The URL of the PayPal instance. (i.e. api.sandbox.paypal.com).
    :type host: object
    :param client_id: Required. The client ID associated with your PayPal application.
    :type client_id: object
    :param client_secret: The client secret associated with your PayPal application.
    :type client_secret: ~azure.synapse.artifacts.models.SecretBase
    :param use_encrypted_endpoints: Specifies whether the data source endpoints are encrypted using
     HTTPS. The default value is true.
    :type use_encrypted_endpoints: object
    :param use_host_verification: Specifies whether to require the host name in the server's
     certificate to match the host name of the server when connecting over SSL. The default value is
     true.
    :type use_host_verification: object
    :param use_peer_verification: Specifies whether to verify the identity of the server when
     connecting over SSL. The default value is true.
    :type use_peer_verification: object
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'host': {'required': True},
        'client_id': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'host': {'key': 'typeProperties.host', 'type': 'object'},
        'client_id': {'key': 'typeProperties.clientId', 'type': 'object'},
        'client_secret': {'key': 'typeProperties.clientSecret', 'type': 'SecretBase'},
        'use_encrypted_endpoints': {'key': 'typeProperties.useEncryptedEndpoints', 'type': 'object'},
        'use_host_verification': {'key': 'typeProperties.useHostVerification', 'type': 'object'},
        'use_peer_verification': {'key': 'typeProperties.usePeerVerification', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PaypalLinkedService, self).__init__(**kwargs)
        self.type = 'Paypal'  # type: str
        self.host = kwargs['host']
        self.client_id = kwargs['client_id']
        self.client_secret = kwargs.get('client_secret', None)
        self.use_encrypted_endpoints = kwargs.get('use_encrypted_endpoints', None)
        self.use_host_verification = kwargs.get('use_host_verification', None)
        self.use_peer_verification = kwargs.get('use_peer_verification', None)
        self.encrypted_credential = kwargs.get('encrypted_credential', None)


class PaypalObjectDataset(Dataset):
    """Paypal Service dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param table_name: The table name. Type: string (or Expression with resultType string).
    :type table_name: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table_name': {'key': 'typeProperties.tableName', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PaypalObjectDataset, self).__init__(**kwargs)
        self.type = 'PaypalObject'  # type: str
        self.table_name = kwargs.get('table_name', None)


class PaypalSource(TabularSource):
    """A copy activity Paypal Service source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: object
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param query_timeout: Query timeout. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type query_timeout: object
    :param query: A query to retrieve data from source. Type: string (or Expression with resultType
     string).
    :type query: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'query_timeout': {'key': 'queryTimeout', 'type': 'object'},
        'query': {'key': 'query', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PaypalSource, self).__init__(**kwargs)
        self.type = 'PaypalSource'  # type: str
        self.query = kwargs.get('query', None)


class PhoenixLinkedService(LinkedService):
    """Phoenix server linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of linked service.Constant filled by server.
    :type type: str
    :param connect_via: The integration runtime reference.
    :type connect_via: ~azure.synapse.artifacts.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the linked service.
    :type annotations: list[object]
    :param host: Required. The IP address or host name of the Phoenix server. (i.e.
     192.168.222.160).
    :type host: object
    :param port: The TCP port that the Phoenix server uses to listen for client connections. The
     default value is 8765.
    :type port: object
    :param http_path: The partial URL corresponding to the Phoenix server. (i.e.
     /gateway/sandbox/phoenix/version). The default value is hbasephoenix if using
     WindowsAzureHDInsightService.
    :type http_path: object
    :param authentication_type: Required. The authentication mechanism used to connect to the
     Phoenix server. Possible values include: "Anonymous", "UsernameAndPassword",
     "WindowsAzureHDInsightService".
    :type authentication_type: str or ~azure.synapse.artifacts.models.PhoenixAuthenticationType
    :param username: The user name used to connect to the Phoenix server.
    :type username: object
    :param password: The password corresponding to the user name.
    :type password: ~azure.synapse.artifacts.models.SecretBase
    :param enable_ssl: Specifies whether the connections to the server are encrypted using SSL. The
     default value is false.
    :type enable_ssl: object
    :param trusted_cert_path: The full path of the .pem file containing trusted CA certificates for
     verifying the server when connecting over SSL. This property can only be set when using SSL on
     self-hosted IR. The default value is the cacerts.pem file installed with the IR.
    :type trusted_cert_path: object
    :param use_system_trust_store: Specifies whether to use a CA certificate from the system trust
     store or from a specified PEM file. The default value is false.
    :type use_system_trust_store: object
    :param allow_host_name_cn_mismatch: Specifies whether to require a CA-issued SSL certificate
     name to match the host name of the server when connecting over SSL. The default value is false.
    :type allow_host_name_cn_mismatch: object
    :param allow_self_signed_server_cert: Specifies whether to allow self-signed certificates from
     the server. The default value is false.
    :type allow_self_signed_server_cert: object
    :param encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'host': {'required': True},
        'authentication_type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'host': {'key': 'typeProperties.host', 'type': 'object'},
        'port': {'key': 'typeProperties.port', 'type': 'object'},
        'http_path': {'key': 'typeProperties.httpPath', 'type': 'object'},
        'authentication_type': {'key': 'typeProperties.authenticationType', 'type': 'str'},
        'username': {'key': 'typeProperties.username', 'type': 'object'},
        'password': {'key': 'typeProperties.password', 'type': 'SecretBase'},
        'enable_ssl': {'key': 'typeProperties.enableSsl', 'type': 'object'},
        'trusted_cert_path': {'key': 'typeProperties.trustedCertPath', 'type': 'object'},
        'use_system_trust_store': {'key': 'typeProperties.useSystemTrustStore', 'type': 'object'},
        'allow_host_name_cn_mismatch': {'key': 'typeProperties.allowHostNameCNMismatch', 'type': 'object'},
        'allow_self_signed_server_cert': {'key': 'typeProperties.allowSelfSignedServerCert', 'type': 'object'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PhoenixLinkedService, self).__init__(**kwargs)
        self.type = 'Phoenix'  # type: str
        self.host = kwargs['host']
        self.port = kwargs.get('port', None)
        self.http_path = kwargs.get('http_path', None)
        self.authentication_type = kwargs['authentication_type']
        self.username = kwargs.get('username', None)
        self.password = kwargs.get('password', None)
        self.enable_ssl = kwargs.get('enable_ssl', None)
        self.trusted_cert_path = kwargs.get('trusted_cert_path', None)
        self.use_system_trust_store = kwargs.get('use_system_trust_store', None)
        self.allow_host_name_cn_mismatch = kwargs.get('allow_host_name_cn_mismatch', None)
        self.allow_self_signed_server_cert = kwargs.get('allow_self_signed_server_cert', None)
        self.encrypted_credential = kwargs.get('encrypted_credential', None)


class PhoenixObjectDataset(Dataset):
    """Phoenix server dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset.Constant filled by server.
    :type type: str
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name: ~azure.synapse.artifacts.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :type folder: ~azure.synapse.artifacts.models.DatasetFolder
    :param table_name: This property will be retired. Please consider using schema + table
     properties instead.
    :type table_name: object
    :param table: The table name of the Phoenix. Type: string (or Expression with resultType
     string).
    :type table: object
    :param schema_type_properties_schema: The schema name of the Phoenix. Type: string (or
     Expression with resultType string).
    :type schema_type_properties_schema: object
    """

    _validation = {
        'type': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'table_name': {'key': 'typeProperties.tableName', 'type': 'object'},
        'table': {'key': 'typeProperties.table', 'type': 'object'},
        'schema_type_properties_schema': {'key': 'typeProperties.schema', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PhoenixObjectDataset, self).__init__(**kwargs)
        self.type = 'PhoenixObject'  # type: str
        self.table_name = kwargs.get('table_name', None)
        self.table = kwargs.get('table', None)
        self.schema_type_properties_schema = kwargs.get('schema_type_properties_schema', None)


class PhoenixSource(TabularSource):
    """A copy activity Phoenix server source.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Copy source type.Constant filled by server.
    :type type: str
    :param source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :type source_retry_count: object
    :param source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type source_retry_wait: object
    :param max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :type max_concurrent_connections: object
    :param query_timeout: Query timeout. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type query_timeout: object
    :param query: A query to retrieve data from source. Type: string (or Expression with resultType
     string).
    :type query: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'source_retry_count': {'key': 'sourceRetryCount', 'type': 'object'},
        'source_retry_wait': {'key': 'sourceRetryWait', 'type': 'object'},
        'max_concurrent_connections': {'key': 'maxConcurrentConnections', 'type': 'object'},
        'query_timeout': {'key': 'queryTimeout', 'type': 'object'},
        'query': {'key': 'query', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PhoenixSource, self).__init__(**kwargs)
        self.type = 'PhoenixSource'  # type: str
        self.query = kwargs.get('query', None)


class PipelineFolder(msrest.serialization.Model):
    """The folder that this Pipeline is in. If not specified, Pipeline will appear at the root level.

    :param name: The name of the folder that this Pipeline is in.
    :type name: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PipelineFolder, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)


class PipelineListResponse(msrest.serialization.Model):
    """A list of pipeline resources.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. List of pipelines.
    :type value: list[~azure.synapse.artifacts.models.PipelineResource]
    :param next_link: The link to the next page of results, if any remaining results exist.
    :type next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PipelineResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PipelineListResponse, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = kwargs.get('next_link', None)


class PipelineReference(msrest.serialization.Model):
    """Pipeline reference type.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Pipeline reference type. Possible values include: "PipelineReference".
    :type type: str or ~azure.synapse.artifacts.models.PipelineReferenceType
    :param reference_name: Required. Reference pipeline name.
    :type reference_name: str
    :param name: Reference name.
    :type name: str
    """

    _validation = {
        'type': {'required': True},
        'reference_name': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'reference_name': {'key': 'referenceName', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PipelineReference, self).__init__(**kwargs)
        self.type = kwargs['type']
        self.reference_name = kwargs['reference_name']
        self.name = kwargs.get('name', None)


class PipelineResource(AzureEntityResource):
    """Pipeline resource type.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. Ex- Microsoft.Compute/virtualMachines or
     Microsoft.Storage/storageAccounts.
    :vartype type: str
    :ivar etag: Resource Etag.
    :vartype etag: str
    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param description: The description of the pipeline.
    :type description: str
    :param activities: List of activities in pipeline.
    :type activities: list[~azure.synapse.artifacts.models.Activity]
    :param parameters: List of parameters for pipeline.
    :type parameters: dict[str, ~azure.synapse.artifacts.models.ParameterSpecification]
    :param variables: List of variables for pipeline.
    :type variables: dict[str, ~azure.synapse.artifacts.models.VariableSpecification]
    :param concurrency: The max number of concurrent runs for the pipeline.
    :type concurrency: i