import argparse
import numpy as np
from fair_dynamic_rec.core.config_cmd import ConfigCmd
from fair_dynamic_rec.core.data_cmd import DataCmd
from pathlib import Path
from fair_dynamic_rec.core import read_config_file
from fair_dynamic_rec.core.util.files import Files
from fair_dynamic_rec.core.util.utils import create_log_name
from fair_dynamic_rec.core.simulators.simulation import OnlineSimulator
from fair_dynamic_rec.core.visualization_cmd import VisualizationCmd
from fair_dynamic_rec.core.metric_cmd import MetricCmd
from datetime import datetime
from fair_dynamic_rec.core.util.ranker_utils import set_rankers

def read_args():
    '''
    Parse command line arguments.
    :return:
    '''
    parser = argparse.ArgumentParser(description= 'The FairDynamicRec tool for running recommender systems experiments in dynamic setting.', epilog='For documentation, refer to: ')

    # todo remove py-eval AS
    # parser.add_argument('action', choices=['run', 'split', 'eval', 'rerank', 'post', 'purge', 'status', 'describe', 'check', 'py-eval'], nargs='?')
    parser.add_argument('action', choices=['run', 'split', 'eval', 'rerank', 'post', 'purge', 'status', 'describe', 'check', 'py-eval'])

    parser.add_argument("-t", "--target", help="Path to experiment directory")#, default='demo01')

    # Optional with arguments
    parser.add_argument("-c", "--conf", help="Use the specified configuration file")

    # Flags
    # parser.add_argument("-dr", "--dry_run", help="Show sequence of command execution but do not execute commands", action="store_true")
    # parser.add_argument("-q", "--quiet", help="Skip confirmation when purging", action="store_true")
    # parser.add_argument("-np", "--no_parallel", help="Ignore thread-count directive and run all operations sequentially", action="store_true")
    # parser.add_argument("-p", "--purge", help="Purge results of step given in <option> and all subsequent steps", choices=['all', 'split', 'results', 'rerank', 'post'], default='all')
    # parser.add_argument("-dev", "--dev", help="Help with documentation, code formatting, and Docker", action="store_true")
    # parser.add_argument("-k", "--key_password", help="Password for the API keys used by post-processing scripts")
    # parser.add_argument("-nc", "--no_check", help="Don't run the check command", action="store_true")
    # parser.add_argument("-nj", "--no_java_check", help="Don't run the java check", action="store_true")

    input_args = parser.parse_args()
    # error_check(vars(input_args))
    return vars(input_args)

def load_config(args: dict) -> ConfigCmd:
    config_file = Files.DEFAULT_CONFIG_FILENAME

    if args['conf']:  # User requested a different configuration file from the default
        config_file = args['conf']

    target = ""
    if (args['target'] != None):
        target = args['target']

    log_file = args['log_name']

    # create a path:

    return read_config_file(config_file, target, log_file)

# DESCRIBE_TEXT = 'Librec-auto automates recommender systems experimentation using the LibRec Java library.\n' + \
#                 '\tA librec-auto experiment consist of five steps governed by the specifications in the configuration file:\n' + \
#                 '\t- split: Create training / test splits from a data set. (LibRec)\n' + \
#                 '\t- exp: Run an experiment generating recommendations for a test set (LibRec)\n' + \
#                 '\t- rerank (optional): Re-rank the results of the experiment (script)\n' + \
#                 '\t- eval: Evaluate the results of a recommendation experiment (LibRec)\n' + \
#                 '\t- post (optional): Perform post-processing computations (script)\n' + \
#                 'Steps labeled LibRec are performed by the LibRec library using configuration properties generated by librec-auto.\n' + \
#                 'Steps labeled script are performed by experimenter-defined scripts.\n' + \
#                 'Run librec_auto describe <step> for additional information about each option.'

# DESCRIBE_DICT = {
#     'run': 'Run a complete librec-auto experiment. Re-uses cached results if any. May result in no action if all computations are up-to-date and no purge option is specified.',
#     'split': 'Run the training / test split only',
#     'exp': 'Run the experiment, re-ranking, evaluation, and post-processing',
#     'rerank': 'Run the re-ranking, evaluation and post-processing',
#     'eval': 'Run the evaluation and post-processing',
#     'post': 'Run post-processing steps',
#     'purge': 'Purge cached computations. Uses -p flag to determine what to purge',
#     'status': 'Print out the status of the experiments'
# }

if __name__ == '__main__':
    print(str(datetime.now().strftime('%Y-%m-%d %H:%M:%S')) + ": Running experiment.")

    args = read_args()
    # args['action'] = 'eval'
    # args['target'] = '/Users/m.mansouryuva.nl/Research/FairDynamicRec/study'

    # purge_old_logs(args['target'] + "/*")
    log_name = create_log_name('FairDynamicRec_log{}.log')
    args['log_name'] = log_name

    config = load_config(args)

    dataObj = DataCmd(config)
    print("#users: " + str(dataObj.n_users) + ", #items: " + str(dataObj.n_items) + ", #train_ratings:" + str(np.count_nonzero(dataObj.train_data)) + ", #test_ratings:" + str(np.count_nonzero(dataObj.test_data)))

    rankers = set_rankers(config, dataObj)

    if args['action'] == 'run':
        sim = OnlineSimulator(config, dataObj)
        sim.run(config, dataObj, rankers)

    if args['action'] == 'run' or args['action'] == 'eval':
        viz = VisualizationCmd(config, dataObj, rankers)
        metric = MetricCmd(config, dataObj, rankers)
        metric.compute(config, dataObj, viz)