/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config;

import java.util.HashMap;
import java.util.Map;
import oracle.pgx.config.ClientConfig;
import oracle.pgx.config.InteractionMode;

public class ClientConfigBuilder {
    private final Map<ClientConfig.Field, Object> values = new HashMap<ClientConfig.Field, Object>();

    public static ClientConfigBuilder forBaseUrl(String baseUrl) {
        return new ClientConfigBuilder().setBaseUrl(baseUrl);
    }

    public ClientConfigBuilder setBaseUrl(String baseUrl) {
        this.values.put(ClientConfig.Field.BASE_URL, baseUrl);
        return this;
    }

    public ClientConfigBuilder setPrefetchSize(int prefetchSize) {
        this.values.put(ClientConfig.Field.PREFETCH_SIZE, prefetchSize);
        return this;
    }

    public ClientConfigBuilder setUploadBatchSize(int uploadBatchSize) {
        this.values.put(ClientConfig.Field.UPLOAD_BATCH_SIZE, uploadBatchSize);
        return this;
    }

    public ClientConfigBuilder setRemoteFutureTimeout(int remoteFutureTimeout) {
        this.values.put(ClientConfig.Field.REMOTE_FUTURE_TIMEOUT, remoteFutureTimeout);
        return this;
    }

    public ClientConfigBuilder setRemoteFuturePendingRetryInterval(int remoteFuturePendingRetryInterval) {
        this.values.put(ClientConfig.Field.REMOTE_FUTURE_PENDING_RETRY_INTERVAL, remoteFuturePendingRetryInterval);
        return this;
    }

    public ClientConfigBuilder setMaxClientHttpConnections(int maxClientHttpConnections) {
        this.values.put(ClientConfig.Field.MAX_CLIENT_HTTP_CONNECTIONS, maxClientHttpConnections);
        return this;
    }

    public ClientConfigBuilder setEnableCctrace(boolean enableCctrace) {
        this.values.put(ClientConfig.Field.ENABLE_CCTRACE, enableCctrace);
        return this;
    }

    public ClientConfigBuilder setClientServerInteractionMode(InteractionMode interactionMode) {
        this.values.put(ClientConfig.Field.CLIENT_SERVER_INTERACTION_MODE, interactionMode);
        return this;
    }

    public ClientConfigBuilder setAccessToken(String token) {
        this.values.put(ClientConfig.Field.ACCESS_TOKEN, token);
        return this;
    }

    public ClientConfigBuilder setCreatePartitionedGraphsWithGraphBuilder(boolean partitionedGraphsByDefault) {
        this.values.put(ClientConfig.Field.CREATE_PARTITIONED_GRAPHS_WITH_GRAPH_BUILDER, partitionedGraphsByDefault);
        return this;
    }

    public ClientConfigBuilder setRealmClientConfig(Map<String, Object> realmClientConfig) {
        this.values.put(ClientConfig.Field.REALM_CLIENT_CONFIG, realmClientConfig);
        return this;
    }

    public ClientConfigBuilder addRealmConfigValue(String key, Object value) {
        Map realmClientConfig = (Map)this.values.computeIfAbsent(ClientConfig.Field.REALM_CLIENT_CONFIG, x -> new HashMap());
        realmClientConfig.put(key, value);
        return this;
    }

    public ClientConfig build() {
        return ClientConfig.getInstance(this.values);
    }
}

