/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.common.marshalers;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import java.io.IOException;
import oracle.pgx.api.SessionContext;
import oracle.pgx.api.internal.PropertyProxy;
import oracle.pgx.common.marshalers.Marshaler;
import oracle.pgx.common.pojo.PropertyProxyResponse;
import oracle.pgx.common.types.PropertyType;
import oracle.pgx.common.util.JsonUtil;
import oracle.pgx.common.util.RemotePropertyProxyFactory;

public class PropertyProxyMarshaler<T>
implements Marshaler<PropertyProxy<T>> {
    private final SessionContext sessionContext;
    private final RemotePropertyProxyFactory propertyProxyFactory;
    private final PropertyType keyType;

    public PropertyProxyMarshaler(SessionContext sessionContext, RemotePropertyProxyFactory factory, PropertyType keyType) {
        this.sessionContext = sessionContext;
        this.propertyProxyFactory = factory;
        this.keyType = keyType;
    }

    public PropertyProxyMarshaler() {
        this(null, null, null);
    }

    @Override
    public PropertyProxy<T> unmarshal(String jsonString) throws JsonParseException, JsonMappingException, IOException {
        if (this.propertyProxyFactory == null) {
            throw new IllegalStateException("property proxy factory is not set");
        }
        if (this.sessionContext.getSessionId() == null) {
            throw new IllegalStateException("session is not set");
        }
        PropertyProxyResponse response = (PropertyProxyResponse)((Object)JsonUtil.readTopLevelJson((String)jsonString, PropertyProxyResponse.class));
        return this.propertyProxyFactory.createRemotePropertyProxy(this.sessionContext, response.proxyId, response.size, this.keyType, response.keyType, response.valueType, response.nodeEdgeValueType, response.dimension);
    }

    @Override
    public String marshal(PropertyProxy<T> proxy) throws JsonGenerationException, JsonMappingException, IOException {
        PropertyProxyResponse response = new PropertyProxyResponse(proxy.getId());
        response.proxyId = proxy.getId();
        response.size = proxy.size();
        response.keyType = proxy.getKeyNodeEdgeValueType();
        response.valueType = proxy.getPropertyType();
        response.nodeEdgeValueType = proxy.getNodeEdgeValueType();
        response.dimension = proxy.getDimension();
        String jsonString = JsonUtil.toJson((Object)((Object)response));
        return jsonString;
    }
}

