/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.mllib;

import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import oracle.pgx.api.PgxFuture;
import oracle.pgx.api.PgxGraph;
import oracle.pgx.api.PgxSession;
import oracle.pgx.api.internal.Core;
import oracle.pgx.api.internal.Graph;
import oracle.pgx.api.internal.mllib.SupervisedEdgeWiseModelMetadata;
import oracle.pgx.api.mllib.EdgeWiseModelBuilder;
import oracle.pgx.api.mllib.SupervisedEdgeWiseModel;
import oracle.pgx.common.types.PropertyType;
import oracle.pgx.common.util.ErrorMessages;
import oracle.pgx.config.mllib.GraphWisePredictionLayerConfig;
import oracle.pgx.config.mllib.SupervisedEdgeWiseModelConfig;
import oracle.pgx.config.mllib.batchgenerator.BatchGenerator;
import oracle.pgx.config.mllib.loss.LossFunction;

public class SupervisedEdgeWiseModelBuilder
extends EdgeWiseModelBuilder<SupervisedEdgeWiseModel, SupervisedEdgeWiseModelConfig, SupervisedEdgeWiseModelBuilder> {
    private final PgxSession session;
    private final Core core;
    private final Supplier<String> keystorePathSupplier;
    private final Supplier<char[]> keystorePasswordSupplier;
    private final BiFunction<PgxSession, Graph, PgxGraph> graphConstructor;

    public SupervisedEdgeWiseModelBuilder(PgxSession session, Core core, Supplier<String> keystorePathSupplier, Supplier<char[]> keystorePasswordSupplier, BiFunction<PgxSession, Graph, PgxGraph> graphConstructor) {
        this.session = session;
        this.core = core;
        this.keystorePathSupplier = keystorePathSupplier;
        this.keystorePasswordSupplier = keystorePasswordSupplier;
        this.modelConfig = new SupervisedEdgeWiseModelConfig();
        this.graphConstructor = graphConstructor;
    }

    public SupervisedEdgeWiseModelBuilder setEdgeTargetPropertyName(String propertyName) {
        ((SupervisedEdgeWiseModelConfig)this.modelConfig).setEdgeTargetPropertyName(propertyName);
        return this;
    }

    public SupervisedEdgeWiseModelBuilder setPredictionLayerConfigs(GraphWisePredictionLayerConfig ... layerConfigs) {
        ((SupervisedEdgeWiseModelConfig)this.modelConfig).setPredictionLayerConfigs(layerConfigs);
        return this;
    }

    public SupervisedEdgeWiseModelBuilder setClassWeights(Map<?, Float> classWeights) {
        ((SupervisedEdgeWiseModelConfig)this.modelConfig).setClassWeights(classWeights);
        return this;
    }

    public SupervisedEdgeWiseModelBuilder setLossFunction(LossFunction lossFunction) {
        ((SupervisedEdgeWiseModelConfig)this.modelConfig).setLossFunctionClass(lossFunction);
        return this;
    }

    public SupervisedEdgeWiseModelBuilder setBatchGenerator(BatchGenerator batchGenerator) {
        ((SupervisedEdgeWiseModelConfig)this.modelConfig).setBatchGenerator(batchGenerator);
        return this;
    }

    private void validatePredLayerConfigs() {
        if (((SupervisedEdgeWiseModelConfig)this.modelConfig).getPredictionLayerConfigs() != null && ((SupervisedEdgeWiseModelConfig)this.modelConfig).getPredictionLayerConfigs().length == 0) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"INVALID_PREDICTION_LAYERS", (Object[])new Object[0]));
        }
    }

    private void validateClassWeights() {
        if (((SupervisedEdgeWiseModelConfig)this.modelConfig).getClassWeights() != null) {
            if (((SupervisedEdgeWiseModelConfig)this.modelConfig).getClassWeights().size() == 0) {
                throw new IllegalArgumentException(ErrorMessages.getMessage((String)"EMPTY_CLASS_WEIGHTS", (Object[])new Object[0]));
            }
            Object firstKey = ((SupervisedEdgeWiseModelConfig)this.modelConfig).getClassWeights().keySet().iterator().next();
            if (firstKey instanceof String) {
                ((SupervisedEdgeWiseModelConfig)this.modelConfig).setLabelType(PropertyType.STRING);
            } else if (firstKey instanceof Integer) {
                ((SupervisedEdgeWiseModelConfig)this.modelConfig).setLabelType(PropertyType.INTEGER);
            } else if (firstKey instanceof Long) {
                ((SupervisedEdgeWiseModelConfig)this.modelConfig).setLabelType(PropertyType.LONG);
            } else if (firstKey instanceof Boolean) {
                ((SupervisedEdgeWiseModelConfig)this.modelConfig).setLabelType(PropertyType.BOOLEAN);
            } else {
                throw new IllegalArgumentException(ErrorMessages.getMessage((String)"UNSUPPORTED_CLASS_WEIGHTS_KEY_TYPE", (Object[])new Object[]{firstKey.getClass()}));
            }
            for (Map.Entry entry : ((SupervisedEdgeWiseModelConfig)this.modelConfig).getClassWeights().entrySet()) {
                if (entry.getKey().getClass() == firstKey.getClass()) continue;
                throw new IllegalArgumentException(ErrorMessages.getMessage((String)"INCONSISTENT_CLASS_WEIGHTS_KEY_TYPES", (Object[])new Object[0]));
            }
        }
    }

    @Override
    public SupervisedEdgeWiseModel build() throws InterruptedException, ExecutionException {
        super.validateAll();
        this.validateClassWeights();
        this.validatePredLayerConfigs();
        if (((SupervisedEdgeWiseModelConfig)this.modelConfig).getEdgeTargetPropertyName() == null) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"NO_TARGET_PROPERTY", (Object[])new Object[0]));
        }
        SupervisedEdgeWiseModelMetadata metadata = new SupervisedEdgeWiseModelMetadata(null, (SupervisedEdgeWiseModelConfig)this.modelConfig);
        return (SupervisedEdgeWiseModel)((PgxFuture)this.core.createSupervisedEdgeWiseModel(this.session.getSessionContext(), metadata).thenApply(metaData -> new SupervisedEdgeWiseModel(this.session, this.core, this.keystorePathSupplier, this.keystorePasswordSupplier, this.graphConstructor, (SupervisedEdgeWiseModelMetadata)((Object)metaData)))).get();
    }

    @Override
    protected SupervisedEdgeWiseModelBuilder getThis() {
        return this;
    }
}

