/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.internal.partitionedgraphbuilder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.pgx.api.internal.Changes;
import oracle.pgx.api.internal.EdgeChanges;
import oracle.pgx.api.internal.ElementChanges;
import oracle.pgx.api.internal.VertexChanges;
import oracle.pgx.api.internal.partitionedgraphbuilder.PartitionedGraphEdgeBuilderEntity;
import oracle.pgx.api.internal.partitionedgraphbuilder.PartitionedGraphVertexBuilderEntity;
import oracle.pgx.common.types.PropertyType;
import oracle.pgx.common.util.ChangeTrackingMap;
import oracle.pgx.utils.NameGenerator;

public class PartitionedGraphBuilderEntity {
    private String entityName;
    private Map<String, PropertyType> propertiesWithType;
    private final Map<String, Iterable<?>> columnData = new HashMap();
    protected Map<Object, String> vertexIdToEntityMap = new HashMap<Object, String>();
    private String idPropertyName;

    protected PartitionedGraphBuilderEntity(String entityName, Map<String, PropertyType> propertiesWithType, Map<Object, String> vertexIdToEntityMap) {
        this.entityName = entityName;
        this.propertiesWithType = propertiesWithType;
        this.vertexIdToEntityMap = vertexIdToEntityMap;
        this.idPropertyName = NameGenerator.getUniqueName((String[])propertiesWithType.keySet().toArray(new String[0])) + "_id";
    }

    public <ID> void initializeVertexIdToEntityMap(Collection<ChangeTrackingMap.ChangeSetEntry<ID, VertexChanges>> changes) {
        for (ChangeTrackingMap.ChangeSetEntry<ID, VertexChanges> changeSetEntry : changes) {
            if (changeSetEntry == null || changeSetEntry.getValue() == null) continue;
            String entityName = PartitionedGraphBuilderEntity.getEntityNameFor((ElementChanges)changeSetEntry.getValue(), null);
            this.vertexIdToEntityMap.putIfAbsent(changeSetEntry.getKey(), entityName);
        }
    }

    public PartitionedGraphBuilderEntity() {
    }

    public Map<String, PropertyType> getPropertiesWithType() {
        return this.propertiesWithType;
    }

    public Map<String, Iterable<?>> getcolumnData() {
        return this.columnData;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public String getIdPropertyName() {
        return this.idPropertyName;
    }

    private static <ID> String getEntityNameFor(ElementChanges elementChanges, Map<ID, String> vertexIdToEntityMapping) {
        if (elementChanges instanceof VertexChanges) {
            return PartitionedGraphVertexBuilderEntity.constructVertexEntityNameFromLabel((VertexChanges)elementChanges);
        }
        return PartitionedGraphEdgeBuilderEntity.constructEdgeEntityNameFromSrcDstAndEdgeLabel((EdgeChanges)elementChanges, vertexIdToEntityMapping);
    }

    private static void updatePropertiesForEntity(PartitionedGraphBuilderEntity entity, Map<String, PropertyType> propertiesWithType) {
        Map<String, PropertyType> entityProperties = entity.getPropertiesWithType();
        propertiesWithType.forEach(entityProperties::putIfAbsent);
    }

    private <ID, T extends ElementChanges> Map<String, PartitionedGraphBuilderEntity> getEntitiesWithPropertiesByName(Collection<ChangeTrackingMap.ChangeSetEntry<ID, T>> changes) {
        HashMap<String, PartitionedGraphBuilderEntity> entitiesByName = new HashMap<String, PartitionedGraphBuilderEntity>();
        for (ChangeTrackingMap.ChangeSetEntry<ID, T> changeSetEntry : changes) {
            if (changeSetEntry == null || changeSetEntry.getValue() == null) continue;
            HashMap<String, PropertyType> propertiesInChangeSet = new HashMap<String, PropertyType>();
            this.fillMapOfPropertiesWithTypes(changeSetEntry, propertiesInChangeSet);
            String entityName = PartitionedGraphBuilderEntity.getEntityNameFor((ElementChanges)changeSetEntry.getValue(), this.vertexIdToEntityMap);
            PartitionedGraphBuilderEntity entity = (PartitionedGraphBuilderEntity)entitiesByName.get(entityName);
            if (entity == null) {
                if (changeSetEntry.getValue() instanceof EdgeChanges) {
                    EdgeChanges edgeChanges = (EdgeChanges)changeSetEntry.getValue();
                    String sourceEntityName = this.vertexIdToEntityMap.get(edgeChanges.getSrcId());
                    String destinationEntityName = this.vertexIdToEntityMap.get(edgeChanges.getDstId());
                    entity = new PartitionedGraphEdgeBuilderEntity(entityName, propertiesInChangeSet, sourceEntityName, destinationEntityName, this.vertexIdToEntityMap);
                } else {
                    entity = new PartitionedGraphVertexBuilderEntity(entityName, propertiesInChangeSet, this.vertexIdToEntityMap);
                }
            }
            entitiesByName.put(entityName, entity);
            PartitionedGraphBuilderEntity.updatePropertiesForEntity(entity, propertiesInChangeSet);
        }
        return entitiesByName;
    }

    public <ID, T extends ElementChanges, V extends PartitionedGraphBuilderEntity> Map<String, V> initializeAndFillEntitiesData(Collection<ChangeTrackingMap.ChangeSetEntry<ID, T>> changes) {
        Map<String, PartitionedGraphBuilderEntity> entities = this.getEntitiesWithPropertiesByName(changes);
        for (ChangeTrackingMap.ChangeSetEntry<ID, T> changeSetEntry : changes) {
            if (changeSetEntry == null || changeSetEntry.getValue() == null) continue;
            String currentEntityName = PartitionedGraphBuilderEntity.getEntityNameFor((ElementChanges)changeSetEntry.getValue(), this.vertexIdToEntityMap);
            PartitionedGraphBuilderEntity entity = entities.get(currentEntityName);
            this.fillColumnsDataForEntity(entity, changeSetEntry);
        }
        return entities;
    }

    private <ID, T extends ElementChanges> void fillColumnsDataForEntity(PartitionedGraphBuilderEntity entity, ChangeTrackingMap.ChangeSetEntry<ID, T> changeSetEntry) {
        Map<String, PropertyType> propertyNameToPropertyType = entity.getPropertiesWithType();
        Map<String, Iterable<?>> columnData = entity.getcolumnData();
        propertyNameToPropertyType.forEach((key, value) -> {
            ((ElementChanges)changeSetEntry.getValue()).setPropertyValueIfAbsent((String)key, value.getDefaultValue());
            List propertyColumnData = columnData.getOrDefault(key, new ArrayList());
            propertyColumnData.add(((ElementChanges)changeSetEntry.getValue()).getPropertyUpdates().get(key));
            columnData.putIfAbsent((String)key, propertyColumnData);
        });
        String idPropertyName = entity.getIdPropertyName();
        List idColumnData = columnData.getOrDefault(idPropertyName, new ArrayList());
        idColumnData.add(changeSetEntry.getKey());
        columnData.putIfAbsent(idPropertyName, idColumnData);
        if (entity instanceof PartitionedGraphEdgeBuilderEntity) {
            PartitionedGraphEdgeBuilderEntity edgeEntity = (PartitionedGraphEdgeBuilderEntity)entity;
            EdgeChanges edgeChanges = (EdgeChanges)changeSetEntry.getValue();
            String srcIdPropertyName = edgeEntity.getSrcIdPropertyName();
            String dstIdPropertyName = edgeEntity.getDstIdPropertyName();
            List srcIdColumnData = columnData.getOrDefault(srcIdPropertyName, new ArrayList());
            List dstIdColumnData = columnData.getOrDefault(dstIdPropertyName, new ArrayList());
            Object srcVertex = edgeChanges.getSrcId();
            Object dstVertex = edgeChanges.getDstId();
            srcIdColumnData.add(srcVertex);
            dstIdColumnData.add(dstVertex);
            columnData.putIfAbsent(srcIdPropertyName, srcIdColumnData);
            columnData.putIfAbsent(dstIdPropertyName, dstIdColumnData);
        }
    }

    private void fillMapOfPropertiesWithTypes(ChangeTrackingMap.ChangeSetEntry<?, ? extends ElementChanges> entry, Map<String, PropertyType> entityProperties) {
        Map<String, Object> propertiesMap = ((ElementChanges)entry.getValue()).getPropertyUpdates();
        for (Map.Entry<String, Object> propertyChange : propertiesMap.entrySet()) {
            PropertyType type = Changes.getPropertyType(propertyChange.getValue());
            entityProperties.put(propertyChange.getKey(), type);
        }
    }
}

