/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.frames;

import oracle.pgx.api.PgxFuture;
import oracle.pgx.api.PgxSession;
import oracle.pgx.api.frames.PgxFrame;
import oracle.pgx.api.frames.PgxFrameStorer;
import oracle.pgx.api.internal.Core;
import oracle.pgx.common.types.PropertyType;
import oracle.pgx.common.util.ErrorMessages;
import oracle.pgx.config.EntityProviderConfig;
import oracle.pgx.config.FileEntityProviderConfig;
import oracle.pgx.config.FileEntityProviderConfigBuilder;
import oracle.pgx.config.FileGraphStoringConfig;
import oracle.pgx.config.FileGraphStoringConfigBuilder;
import oracle.pgx.config.ProviderFormat;

public class PgxCsvFrameStorer
extends PgxFrameStorer<PgxCsvFrameStorer> {
    protected final FileEntityProviderConfigBuilder configBuilder;
    protected char separator = (char)44;
    protected Integer numPartitions = null;
    protected String partitionExtension = "csv";

    public PgxCsvFrameStorer(PgxSession session, Core core, PgxFrame frame) {
        super(session, core, frame, null, null);
        this.configBuilder = new FileEntityProviderConfigBuilder(ProviderFormat.CSV);
        this.configBuilder.setHasKeys(false);
    }

    @Override
    protected PgxCsvFrameStorer getThis() {
        return this;
    }

    @Override
    public PgxCsvFrameStorer name(String frameName) {
        this.configBuilder.setName(frameName);
        return this;
    }

    public PgxCsvFrameStorer separator(char separator) {
        this.configBuilder.setSeparator(Character.toString(separator));
        this.separator = separator;
        return this;
    }

    public PgxCsvFrameStorer partitions(int numPartitions) {
        this.numPartitions = numPartitions;
        return this;
    }

    public PgxCsvFrameStorer partitionExtension(String fileExtension) {
        this.partitionExtension = fileExtension;
        return this;
    }

    @Override
    protected PgxCsvFrameStorer withVectorColumn(String columnName, PropertyType type, int dimension, Object defaultValue) {
        this.configBuilder.addVectorProperty(columnName, type, dimension, defaultValue);
        return this;
    }

    @Override
    public PgxFuture<Void> storeAsync(String ... uris) {
        this.configBuilder.setUris(uris).setName(this.frame.getMetaData().getFrameUid().toString());
        if (this.numPartitions != null) {
            if (this.numPartitions < 1) {
                throw new IllegalStateException(ErrorMessages.getMessage((String)"INVALID_STORE_NUM_PARTITIONS", (Object[])new Object[]{this.numPartitions}));
            }
            if (uris.length != 1) {
                throw new IllegalArgumentException(ErrorMessages.getMessage((String)"INVALID_STORE_BASE_PATH_MULTIPLE_PARTITIONS", (Object[])new Object[]{uris.length}));
            }
            FileGraphStoringConfig storingConfig = new FileGraphStoringConfigBuilder().setBasePath(uris[0]).setNumPartitions(this.numPartitions.intValue()).setRowExtension(this.partitionExtension).setDelimiter(this.separator).build();
            this.configBuilder.setStoring(storingConfig);
        }
        FileEntityProviderConfig config = (FileEntityProviderConfig)this.configBuilder.build();
        return this.triggerStoreAsync((EntityProviderConfig)config);
    }
}

