/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.executionenvironment;

import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import oracle.pgx.api.PgxFuture;
import oracle.pgx.api.PgxSession;
import oracle.pgx.api.PoolType;
import oracle.pgx.api.executionenvironment.AbstractEnvironment;
import oracle.pgx.api.executionenvironment.ExecutionEnvironmentField;
import oracle.pgx.api.internal.CoreSessionApi;
import oracle.pgx.config.TaskPriority;

public final class CpuEnvironment
extends AbstractEnvironment {
    private static final ExecutionEnvironmentField[] RELEVANT_FIELDS = new ExecutionEnvironmentField[]{ExecutionEnvironmentField.WEIGHT, ExecutionEnvironmentField.PRIORITY, ExecutionEnvironmentField.MAX_NUM_THREADS};

    CpuEnvironment(PgxSession session, CoreSessionApi coreSessionApi, PoolType poolType) {
        super(session, coreSessionApi, poolType);
    }

    public PgxFuture<Integer> getWeightAsync() {
        return this.getEnvironmentAsync(ExecutionEnvironmentField.WEIGHT, Integer.class);
    }

    public PgxFuture<TaskPriority> getPriorityAsync() {
        return this.getEnvironmentAsync(ExecutionEnvironmentField.PRIORITY, TaskPriority.class);
    }

    public PgxFuture<Integer> getMaxNumThreadsAsync() {
        return this.getEnvironmentAsync(ExecutionEnvironmentField.MAX_NUM_THREADS, Integer.class);
    }

    public PgxFuture<Void> setWeightAsync(Integer weight) {
        return this.setEnvironmentAsync(ExecutionEnvironmentField.WEIGHT, weight);
    }

    public PgxFuture<Void> setPriorityAsync(TaskPriority priority) {
        return this.setEnvironmentAsync(ExecutionEnvironmentField.PRIORITY, priority);
    }

    public PgxFuture<Void> setMaxNumThreadsAsync(Integer maxNumThreads) {
        return this.setEnvironmentAsync(ExecutionEnvironmentField.MAX_NUM_THREADS, maxNumThreads);
    }

    public <T> PgxFuture<T> withWeightAsync(int weight, Supplier<PgxFuture<T>> asyncRequest) {
        return CpuEnvironment.withValueAsync(weight, this::getWeightAsync, this::setWeightAsync, asyncRequest);
    }

    public <T> PgxFuture<T> withPriorityAsync(TaskPriority priority, Supplier<PgxFuture<T>> asyncRequest) {
        return CpuEnvironment.withValueAsync(priority, this::getPriorityAsync, this::setPriorityAsync, asyncRequest);
    }

    public <T> PgxFuture<T> withMaxNumThreadsAsync(int maxNumThreads, Supplier<PgxFuture<T>> asyncRequest) {
        return CpuEnvironment.withValueAsync(maxNumThreads, this::getMaxNumThreadsAsync, this::setMaxNumThreadsAsync, asyncRequest);
    }

    public int getWeight() throws ExecutionException, InterruptedException {
        return this.getWeightAsync().get();
    }

    public TaskPriority getPriority() throws ExecutionException, InterruptedException {
        return this.getPriorityAsync().get();
    }

    public int getMaxNumThreads() throws ExecutionException, InterruptedException {
        return this.getMaxNumThreadsAsync().get();
    }

    public void setWeight(Integer weight) throws ExecutionException, InterruptedException {
        this.setWeightAsync(weight).get();
    }

    public void setPriority(TaskPriority priority) throws ExecutionException, InterruptedException {
        this.setPriorityAsync(priority).get();
    }

    public void setMaxNumThreads(Integer maxNumThreads) throws ExecutionException, InterruptedException {
        this.setMaxNumThreadsAsync(maxNumThreads).get();
    }

    public <T> T withWeight(int weight, Supplier<PgxFuture<T>> asyncRequest) throws ExecutionException, InterruptedException {
        return this.withWeightAsync(weight, asyncRequest).get();
    }

    public <T> T withPriority(TaskPriority priority, Supplier<PgxFuture<T>> asyncRequest) throws ExecutionException, InterruptedException {
        return this.withPriorityAsync(priority, asyncRequest).get();
    }

    public <T> T withMaxNumThreads(int maxNumThreads, Supplier<PgxFuture<T>> asyncRequest) throws ExecutionException, InterruptedException {
        return this.withMaxNumThreadsAsync(maxNumThreads, asyncRequest).get();
    }

    @Override
    protected ExecutionEnvironmentField[] getRelevantFields() {
        return RELEVANT_FIELDS;
    }
}

