/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.graphviz.library.enhancer;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import javax.annotation.Nonnull;
import oracle.pgql.lang.ir.ExpAsVar;
import oracle.pgql.lang.ir.GraphQuery;
import oracle.pgql.lang.ir.PgqlUtils;
import oracle.pgql.lang.ir.QueryExpression;
import oracle.pgql.lang.ir.QueryExpressionVisitor;
import oracle.pgql.lang.ir.QueryPath;
import oracle.pgql.lang.ir.QueryType;
import oracle.pgql.lang.ir.QueryVariable;
import oracle.pgql.lang.ir.SelectQuery;
import oracle.pgql.lang.ir.unnest.RowsPerMatchType;
import oracle.pgql.lang.util.AbstractQueryExpressionVisitor;
import oracle.pgx.common.MutableBoolean;
import oracle.pgx.graphviz.formatter.Pair;

public class QueryChecker {
    private static final Collection<String> NON_VISUALIZABLE_FUNCTION_CALLS = new HashSet<String>(Arrays.asList("match_number", "match_element", "element_number"));

    private static boolean isNotVisualizableFunction(@Nonnull QueryExpression exp) {
        if (exp.getExpType() == QueryExpression.ExpressionType.FUNCTION_CALL) {
            QueryExpression.FunctionCall functionCall = (QueryExpression.FunctionCall)exp;
            String functionName = functionCall.getFunctionName().toLowerCase();
            return functionCall.getPackageName() == null && NON_VISUALIZABLE_FUNCTION_CALLS.contains(functionName);
        }
        return false;
    }

    private static boolean isCount(@Nonnull QueryExpression exp) {
        return exp.getExpType() == QueryExpression.ExpressionType.AGGR_COUNT;
    }

    private static boolean containsElementNumber(QueryExpression.FunctionCall functionCall) {
        String functionName = functionCall.getFunctionName();
        return functionName.equals("ELEMENT_NUMBER") || functionName.equals("element_number");
    }

    private static boolean containsNestedNonVisualizableFunction(@Nonnull QueryExpression exp) {
        final MutableBoolean result = new MutableBoolean();
        result.set(false);
        exp.accept((QueryExpressionVisitor)new AbstractQueryExpressionVisitor(){

            public void visit(QueryExpression.FunctionCall functionCall) {
                if (QueryChecker.isNotVisualizableFunction((QueryExpression)functionCall)) {
                    result.set(true);
                }
                if (functionCall.getPackageName() == null && QueryChecker.containsElementNumber(functionCall) && functionCall.getArgs().size() > 1) {
                    result.set(true);
                }
            }
        });
        return result.get();
    }

    private static boolean containsOneRowPerEdge(SelectQuery query) {
        final MutableBoolean result = new MutableBoolean();
        new AbstractQueryExpressionVisitor(){

            public void visit(QueryPath queryPath) {
                if (queryPath.getRowsPerMatch().getRowsPerMatchType() == RowsPerMatchType.ONE_ROW_PER_EDGE) {
                    result.set(true);
                }
            }
        }.visit(query);
        return result.get();
    }

    @Nonnull
    public static Pair<Boolean, String> checkIfVisualizable(@Nonnull GraphQuery graphQuery) {
        QueryType queryType = graphQuery.getQueryType();
        if (queryType == QueryType.MODIFY) {
            return new Pair((Object)false, (Object)"Cannot visualize modify queries");
        }
        if (queryType == QueryType.SELECT) {
            SelectQuery selectQuery = (SelectQuery)graphQuery;
            if (graphQuery.getGraphName() == null || graphQuery.getGraphName().getName() == null) {
                return new Pair((Object)false, (Object)"Cannot visualize query without FROM or ON clause");
            }
            if (QueryChecker.containsOneRowPerEdge((SelectQuery)graphQuery)) {
                return new Pair((Object)false, (Object)"Cannot visualize query with ONE ROW PER EDGE");
            }
            for (ExpAsVar expAsVar : selectQuery.getProjection().getElements()) {
                QueryExpression exp = expAsVar.getExp();
                if (QueryChecker.isNotVisualizableFunction(exp) || QueryChecker.isCount(exp)) {
                    return new Pair((Object)false, (Object)("Cannot visualize query with expression of type " + exp.getExpType() + " in SELECT"));
                }
                if (QueryChecker.containsNestedNonVisualizableFunction(exp)) {
                    return new Pair((Object)false, (Object)("Cannot visualize query with expression of type: " + NON_VISUALIZABLE_FUNCTION_CALLS.toString()));
                }
                if (PgqlUtils.getVariables((QueryExpression)exp).size() > 1) {
                    return new Pair((Object)false, (Object)"Cannot visualize query with expression that contains more than one variable.");
                }
                if (!PgqlUtils.getVariables((QueryExpression)exp).stream().anyMatch(v -> v.getVariableType() == QueryVariable.VariableType.PATH)) continue;
                return new Pair((Object)false, (Object)"Cannot visualize query with paths in SELECT clause");
            }
            if (graphQuery.getGroupBy() != null && !graphQuery.getGroupBy().getElements().isEmpty()) {
                return new Pair((Object)false, (Object)"Cannot visualize query with GROUP BY");
            }
            if (selectQuery.getProjection().isDistinct()) {
                return new Pair((Object)false, (Object)"Cannot visualize query with DISTINCT");
            }
            return new Pair((Object)true, null);
        }
        return new Pair((Object)false, (Object)("Unknown query type: " + queryType.toString()));
    }
}

